/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionsRecoveryChore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionsRecoveryConfigManager
implements ConfigurationObserver {
    private static final Logger LOG = LoggerFactory.getLogger(RegionsRecoveryConfigManager.class);
    private final HMaster hMaster;
    private int prevMaxStoreFileRefCount;
    private int prevRegionsRecoveryInterval;

    RegionsRecoveryConfigManager(HMaster hMaster) {
        this.hMaster = hMaster;
        Configuration conf = hMaster.getConfiguration();
        this.prevMaxStoreFileRefCount = this.getMaxStoreFileRefCount(conf);
        this.prevRegionsRecoveryInterval = this.getRegionsRecoveryChoreInterval(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConfigurationChange(Configuration conf) {
        int newMaxStoreFileRefCount = this.getMaxStoreFileRefCount(conf);
        int newRegionsRecoveryInterval = this.getRegionsRecoveryChoreInterval(conf);
        if (this.prevMaxStoreFileRefCount == newMaxStoreFileRefCount && this.prevRegionsRecoveryInterval == newRegionsRecoveryInterval) {
            return;
        }
        LOG.info("Config Reload for RegionsRecovery Chore. prevMaxStoreFileRefCount: {}, newMaxStoreFileRefCount: {}, prevRegionsRecoveryInterval: {}, newRegionsRecoveryInterval: {}", new Object[]{this.prevMaxStoreFileRefCount, newMaxStoreFileRefCount, this.prevRegionsRecoveryInterval, newRegionsRecoveryInterval});
        RegionsRecoveryChore regionsRecoveryChore = new RegionsRecoveryChore(this.hMaster, conf, this.hMaster);
        ChoreService choreService = this.hMaster.getChoreService();
        RegionsRecoveryConfigManager regionsRecoveryConfigManager = this;
        synchronized (regionsRecoveryConfigManager) {
            if (newMaxStoreFileRefCount > 0) {
                choreService.cancelChore(regionsRecoveryChore, false);
                choreService.scheduleChore(regionsRecoveryChore);
            } else {
                choreService.cancelChore(regionsRecoveryChore, false);
            }
            this.prevMaxStoreFileRefCount = newMaxStoreFileRefCount;
            this.prevRegionsRecoveryInterval = newRegionsRecoveryInterval;
        }
    }

    private int getMaxStoreFileRefCount(Configuration configuration) {
        return configuration.getInt("hbase.regions.recovery.store.file.ref.count", -1);
    }

    private int getRegionsRecoveryChoreInterval(Configuration configuration) {
        return configuration.getInt("hbase.master.regions.recovery.check.interval", 1200000);
    }
}

