/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CoordinatedStateException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.GeneralBulkAssigner;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;

@InterfaceAudience.Private
public class EnableTableHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(EnableTableHandler.class);
    private final TableName tableName;
    private final AssignmentManager assignmentManager;
    private final TableLockManager tableLockManager;
    private boolean skipTableStateCheck = false;
    private TableLockManager.TableLock tableLock;
    private MasterServices services;

    public EnableTableHandler(Server server, TableName tableName, AssignmentManager assignmentManager, TableLockManager tableLockManager, boolean skipTableStateCheck) {
        super(server, EventType.C_M_ENABLE_TABLE);
        this.tableName = tableName;
        this.assignmentManager = assignmentManager;
        this.tableLockManager = tableLockManager;
        this.skipTableStateCheck = skipTableStateCheck;
    }

    public EnableTableHandler(MasterServices services, TableName tableName, AssignmentManager assignmentManager, TableLockManager tableLockManager, boolean skipTableStateCheck) {
        this((Server)services, tableName, assignmentManager, tableLockManager, skipTableStateCheck);
        this.services = services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableTableHandler prepare() throws TableNotFoundException, TableNotDisabledException, IOException {
        this.tableLock = this.tableLockManager.writeLock(this.tableName, EventType.C_M_ENABLE_TABLE.toString());
        this.tableLock.acquire();
        boolean success = false;
        try {
            if (!MetaTableAccessor.tableExists(this.server.getConnection(), this.tableName)) {
                if (!this.skipTableStateCheck) {
                    throw new TableNotFoundException(this.tableName);
                }
                try {
                    this.assignmentManager.getTableStateManager().checkAndRemoveTableState(this.tableName, ZooKeeperProtos.Table.State.ENABLING, true);
                    throw new TableNotFoundException(this.tableName);
                }
                catch (CoordinatedStateException e) {
                    LOG.warn((Object)("Failed to delete the ENABLING node for the table " + this.tableName + ".  The table will remain unusable. Run HBCK to manually fix the problem."));
                }
            }
            if (!this.skipTableStateCheck) {
                try {
                    if (!this.assignmentManager.getTableStateManager().setTableStateIfInStates(this.tableName, ZooKeeperProtos.Table.State.ENABLING, ZooKeeperProtos.Table.State.DISABLED)) {
                        LOG.info((Object)("Table " + this.tableName + " isn't disabled; skipping enable"));
                        throw new TableNotDisabledException(this.tableName);
                    }
                }
                catch (CoordinatedStateException e) {
                    throw new IOException("Unable to ensure that the table will be enabling because of a coordination engine issue", e);
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                this.releaseTableLock();
            }
        }
        return this;
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid() + "-" + this.tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        try {
            LOG.info((Object)("Attempting to enable the table " + this.tableName));
            MasterCoprocessorHost cpHost = ((HMaster)this.server).getMasterCoprocessorHost();
            if (cpHost != null) {
                cpHost.preEnableTableHandler(this.tableName, null);
            }
            this.handleEnableTable();
            if (cpHost != null) {
                cpHost.postEnableTableHandler(this.tableName, null);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Error trying to enable the table " + this.tableName), (Throwable)e);
        }
        catch (CoordinatedStateException e) {
            LOG.error((Object)("Error trying to enable the table " + this.tableName), (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.error((Object)("Error trying to enable the table " + this.tableName), (Throwable)e);
        }
        finally {
            this.releaseTableLock();
        }
    }

    private void releaseTableLock() {
        if (this.tableLock != null) {
            try {
                this.tableLock.release();
            }
            catch (IOException ex) {
                LOG.warn((Object)"Could not release the table lock", (Throwable)ex);
            }
        }
    }

    private void handleEnableTable() throws IOException, CoordinatedStateException, InterruptedException {
        int regionsCount;
        this.assignmentManager.getTableStateManager().setTableState(this.tableName, ZooKeeperProtos.Table.State.ENABLING);
        boolean done = false;
        ServerManager serverManager = ((HMaster)this.server).getServerManager();
        List<Pair<HRegionInfo, ServerName>> tableRegionsAndLocations = TableName.META_TABLE_NAME.equals(this.tableName) ? new MetaTableLocator().getMetaRegionsAndLocations(this.server.getZooKeeper()) : MetaTableAccessor.getTableRegionsAndLocations(this.server.getZooKeeper(), this.server.getConnection(), this.tableName, true);
        int countOfRegionsInTable = tableRegionsAndLocations.size();
        Map<HRegionInfo, ServerName> regionsToAssign = this.regionsToAssignWithServerName(tableRegionsAndLocations);
        if (this.services != null) {
            List<HRegionInfo> unrecordedReplicas = AssignmentManager.replicaRegionsNotRecordedInMeta(new HashSet<HRegionInfo>(regionsToAssign.keySet()), this.services);
            Map<ServerName, List<HRegionInfo>> srvToUnassignedRegs = this.assignmentManager.getBalancer().roundRobinAssignment(unrecordedReplicas, serverManager.getOnlineServersList());
            if (srvToUnassignedRegs != null) {
                for (Map.Entry<ServerName, List<HRegionInfo>> entry : srvToUnassignedRegs.entrySet()) {
                    for (HRegionInfo h : entry.getValue()) {
                        regionsToAssign.put(h, entry.getKey());
                    }
                }
            }
        }
        if ((regionsCount = regionsToAssign.size()) == 0) {
            done = true;
        }
        LOG.info((Object)("Table '" + this.tableName + "' has " + countOfRegionsInTable + " regions, of which " + regionsCount + " are offline."));
        List<ServerName> onlineServers = serverManager.createDestinationServersList();
        Map<ServerName, List<HRegionInfo>> bulkPlan = this.assignmentManager.getBalancer().retainAssignment(regionsToAssign, onlineServers);
        if (bulkPlan != null) {
            LOG.info((Object)("Bulk assigning " + regionsCount + " region(s) across " + bulkPlan.size() + " server(s), retainAssignment=true"));
            GeneralBulkAssigner ba = new GeneralBulkAssigner(this.server, bulkPlan, this.assignmentManager, true);
            try {
                if (ba.bulkAssign()) {
                    done = true;
                }
            }
            catch (InterruptedException e) {
                LOG.warn((Object)("Enable operation was interrupted when enabling table '" + this.tableName + "'"));
                Thread.currentThread().interrupt();
            }
        } else {
            done = true;
            LOG.info((Object)("Balancer was unable to find suitable servers for table " + this.tableName + ", leaving unassigned"));
        }
        if (done) {
            this.assignmentManager.getTableStateManager().setTableState(this.tableName, ZooKeeperProtos.Table.State.ENABLED);
            LOG.info((Object)("Table '" + this.tableName + "' was successfully enabled. Status: done=" + done));
        } else {
            LOG.warn((Object)("Table '" + this.tableName + "' wasn't successfully enabled. Status: done=" + done));
        }
    }

    private Map<HRegionInfo, ServerName> regionsToAssignWithServerName(List<Pair<HRegionInfo, ServerName>> regionsInMeta) throws IOException {
        HashMap<HRegionInfo, ServerName> regionsToAssign = new HashMap<HRegionInfo, ServerName>(regionsInMeta.size());
        RegionStates regionStates = this.assignmentManager.getRegionStates();
        for (Pair<HRegionInfo, ServerName> regionLocation : regionsInMeta) {
            HRegionInfo hri = regionLocation.getFirst();
            ServerName sn = regionLocation.getSecond();
            if (regionStates.isRegionOffline(hri)) {
                regionsToAssign.put(hri, sn);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Skipping assign for the region " + hri + " during enable table " + hri.getTable() + " because its already in tranition or assigned."));
        }
        return regionsToAssign;
    }
}

