/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.TableNamespaceManager;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.MasterProcedureProtos;

@InterfaceAudience.Private
public class ModifyNamespaceProcedure
extends StateMachineProcedure<MasterProcedureEnv, MasterProcedureProtos.ModifyNamespaceState>
implements TableProcedureInterface {
    private static final Log LOG = LogFactory.getLog(ModifyNamespaceProcedure.class);
    private final AtomicBoolean aborted = new AtomicBoolean(false);
    private NamespaceDescriptor oldNsDescriptor = null;
    private NamespaceDescriptor newNsDescriptor;
    private Boolean traceEnabled;

    public ModifyNamespaceProcedure() {
        this.traceEnabled = null;
    }

    public ModifyNamespaceProcedure(MasterProcedureEnv env, NamespaceDescriptor newNsDescriptor) {
        this.newNsDescriptor = newNsDescriptor;
        this.traceEnabled = null;
        this.setOwner(env.getRequestUser().getUGI().getShortUserName());
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.ModifyNamespaceState state) throws InterruptedException {
        if (this.isTraceEnabled().booleanValue()) {
            LOG.trace((Object)(this + " execute state=" + state));
        }
        try {
            switch (state) {
                case MODIFY_NAMESPACE_PREPARE: {
                    this.prepareModify(env);
                    this.setNextState(MasterProcedureProtos.ModifyNamespaceState.MODIFY_NAMESPACE_UPDATE_NS_TABLE);
                    break;
                }
                case MODIFY_NAMESPACE_UPDATE_NS_TABLE: {
                    this.insertIntoNSTable(env);
                    this.setNextState(MasterProcedureProtos.ModifyNamespaceState.MODIFY_NAMESPACE_UPDATE_ZK);
                    break;
                }
                case MODIFY_NAMESPACE_UPDATE_ZK: {
                    this.updateZKNamespaceManager(env);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Error trying to modify the namespace" + this.newNsDescriptor.getName() + " (in state=" + state + ")"), (Throwable)e);
            this.setFailure("master-modify-namespace", e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.ModifyNamespaceState state) throws IOException {
        if (this.isTraceEnabled().booleanValue()) {
            LOG.trace((Object)(this + " rollback state=" + state));
        }
        try {
            switch (state) {
                case MODIFY_NAMESPACE_UPDATE_ZK: {
                    this.rollbackZKNamespaceManagerChange(env);
                    break;
                }
                case MODIFY_NAMESPACE_UPDATE_NS_TABLE: {
                    this.rollbackUpdateInNSTable(env);
                    break;
                }
                case MODIFY_NAMESPACE_PREPARE: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed rollback attempt step " + state + " for creating the namespace " + this.newNsDescriptor.getName()), (Throwable)e);
            throw e;
        }
    }

    @Override
    protected MasterProcedureProtos.ModifyNamespaceState getState(int stateId) {
        return MasterProcedureProtos.ModifyNamespaceState.valueOf(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.ModifyNamespaceState state) {
        return state.getNumber();
    }

    @Override
    protected MasterProcedureProtos.ModifyNamespaceState getInitialState() {
        return MasterProcedureProtos.ModifyNamespaceState.MODIFY_NAMESPACE_PREPARE;
    }

    @Override
    protected void setNextState(MasterProcedureProtos.ModifyNamespaceState state) {
        if (this.aborted.get()) {
            this.setAbortFailure("modify-namespace", "abort requested");
        } else {
            super.setNextState(state);
        }
    }

    @Override
    public boolean abort(MasterProcedureEnv env) {
        this.aborted.set(true);
        return true;
    }

    @Override
    public void serializeStateData(OutputStream stream) throws IOException {
        super.serializeStateData(stream);
        MasterProcedureProtos.ModifyNamespaceStateData.Builder modifyNamespaceMsg = MasterProcedureProtos.ModifyNamespaceStateData.newBuilder().setNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor(this.newNsDescriptor));
        if (this.oldNsDescriptor != null) {
            modifyNamespaceMsg.setUnmodifiedNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor(this.oldNsDescriptor));
        }
        modifyNamespaceMsg.build().writeDelimitedTo(stream);
    }

    @Override
    public void deserializeStateData(InputStream stream) throws IOException {
        super.deserializeStateData(stream);
        MasterProcedureProtos.ModifyNamespaceStateData modifyNamespaceMsg = MasterProcedureProtos.ModifyNamespaceStateData.parseDelimitedFrom(stream);
        this.newNsDescriptor = ProtobufUtil.toNamespaceDescriptor(modifyNamespaceMsg.getNamespaceDescriptor());
        if (modifyNamespaceMsg.hasUnmodifiedNamespaceDescriptor()) {
            this.oldNsDescriptor = ProtobufUtil.toNamespaceDescriptor(modifyNamespaceMsg.getUnmodifiedNamespaceDescriptor());
        }
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" (Namespace=");
        sb.append(this.newNsDescriptor.getName());
        sb.append(")");
    }

    @Override
    protected boolean acquireLock(MasterProcedureEnv env) {
        if (env.waitInitialized(this)) {
            return false;
        }
        return env.getProcedureQueue().tryAcquireNamespaceExclusiveLock(this, this.getNamespaceName());
    }

    @Override
    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureQueue().releaseNamespaceExclusiveLock(this, this.getNamespaceName());
    }

    @Override
    public TableName getTableName() {
        return TableName.NAMESPACE_TABLE_NAME;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.EDIT;
    }

    private String getNamespaceName() {
        return this.newNsDescriptor.getName();
    }

    private void prepareModify(MasterProcedureEnv env) throws IOException {
        if (!this.getTableNamespaceManager(env).doesNamespaceExist(this.newNsDescriptor.getName())) {
            throw new NamespaceNotFoundException(this.newNsDescriptor.getName());
        }
        this.getTableNamespaceManager(env).validateTableAndRegionCount(this.newNsDescriptor);
        this.oldNsDescriptor = this.getTableNamespaceManager(env).get(this.newNsDescriptor.getName());
    }

    private void insertIntoNSTable(MasterProcedureEnv env) throws IOException {
        this.getTableNamespaceManager(env).insertIntoNSTable(this.newNsDescriptor);
    }

    private void rollbackUpdateInNSTable(MasterProcedureEnv env) throws IOException {
        if (this.oldNsDescriptor != null) {
            this.getTableNamespaceManager(env).insertIntoNSTable(this.oldNsDescriptor);
        }
    }

    private void updateZKNamespaceManager(MasterProcedureEnv env) throws IOException {
        this.getTableNamespaceManager(env).updateZKNamespaceManager(this.newNsDescriptor);
    }

    private void rollbackZKNamespaceManagerChange(MasterProcedureEnv env) throws IOException {
        if (this.oldNsDescriptor != null) {
            this.getTableNamespaceManager(env).updateZKNamespaceManager(this.oldNsDescriptor);
        }
    }

    private TableNamespaceManager getTableNamespaceManager(MasterProcedureEnv env) {
        return env.getMasterServices().getTableNamespaceManager();
    }

    private Boolean isTraceEnabled() {
        if (this.traceEnabled == null) {
            this.traceEnabled = LOG.isTraceEnabled();
        }
        return this.traceEnabled;
    }
}

