/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.namequeues.DisruptorExceptionHandler;
import org.apache.hadoop.hbase.namequeues.LogEventHandler;
import org.apache.hadoop.hbase.namequeues.NamedQueuePayload;
import org.apache.hadoop.hbase.namequeues.RingBufferEnvelope;
import org.apache.hadoop.hbase.namequeues.request.NamedQueueGetRequest;
import org.apache.hadoop.hbase.namequeues.response.NamedQueueGetResponse;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.com.lmax.disruptor.BlockingWaitStrategy;
import org.apache.hadoop.hbase.shaded.com.lmax.disruptor.EventFactory;
import org.apache.hadoop.hbase.shaded.com.lmax.disruptor.RingBuffer;
import org.apache.hadoop.hbase.shaded.com.lmax.disruptor.TimeoutException;
import org.apache.hadoop.hbase.shaded.com.lmax.disruptor.WaitStrategy;
import org.apache.hadoop.hbase.shaded.com.lmax.disruptor.dsl.Disruptor;
import org.apache.hadoop.hbase.shaded.com.lmax.disruptor.dsl.ProducerType;
import org.apache.hadoop.hbase.util.Threads;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class NamedQueueRecorder
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(NamedQueueRecorder.class);
    private final Disruptor<RingBufferEnvelope> disruptor;
    private final LogEventHandler logEventHandler;
    private final ExecutorService executorService;
    private static NamedQueueRecorder namedQueueRecorder;
    private static boolean isInit;
    private static final Object LOCK;
    private volatile boolean closed = false;

    private NamedQueueRecorder(Configuration conf) {
        String hostingThreadName = Thread.currentThread().getName();
        int eventCount = conf.getInt("hbase.namedqueue.ringbuffer.size", 1024);
        this.executorService = Executors.newSingleThreadExecutor(Threads.getNamedThreadFactory(hostingThreadName + ".slowlog.append-pool"));
        this.disruptor = new Disruptor<RingBufferEnvelope>(this.getEventFactory(), this.getEventCount(eventCount), this.executorService, ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
        this.disruptor.handleExceptionsWith(new DisruptorExceptionHandler());
        this.logEventHandler = new LogEventHandler(conf);
        this.disruptor.handleEventsWith(this.logEventHandler);
        this.disruptor.start();
    }

    private EventFactory<RingBufferEnvelope> getEventFactory() {
        return new EventFactory<RingBufferEnvelope>(){

            @Override
            public RingBufferEnvelope newInstance() {
                return new RingBufferEnvelope();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NamedQueueRecorder getInstance(Configuration conf) {
        if (namedQueueRecorder != null) {
            return namedQueueRecorder;
        }
        Object object = LOCK;
        synchronized (object) {
            if (!isInit) {
                namedQueueRecorder = new NamedQueueRecorder(conf);
                isInit = true;
            }
        }
        return namedQueueRecorder;
    }

    private int getEventCount(int eventCount) {
        Preconditions.checkArgument(eventCount >= 0, "hbase.namedqueue.ringbuffer.size must be > 0");
        int floor = Integer.highestOneBit(eventCount);
        if (floor == eventCount) {
            return floor;
        }
        if (floor >= 0x20000000) {
            return 0x40000000;
        }
        return floor << 1;
    }

    public NamedQueueGetResponse getNamedQueueRecords(NamedQueueGetRequest request) {
        return this.logEventHandler.getNamedQueueRecords(request);
    }

    public boolean clearNamedQueue(NamedQueuePayload.NamedQueueEvent namedQueueEvent) {
        return this.logEventHandler.clearNamedQueue(namedQueueEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(NamedQueuePayload namedQueuePayload) {
        if (!this.closed) {
            RingBuffer<RingBufferEnvelope> ringBuffer = this.disruptor.getRingBuffer();
            long seqId = ringBuffer.next();
            try {
                ringBuffer.get(seqId).load(namedQueuePayload);
            }
            finally {
                ringBuffer.publish(seqId);
            }
        }
    }

    public void persistAll(NamedQueuePayload.NamedQueueEvent namedQueueEvent) {
        if (this.logEventHandler != null) {
            this.logEventHandler.persistAll(namedQueueEvent);
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        LOG.info("Closing NamedQueueRecorder");
        if (this.disruptor != null) {
            long timeoutms = 5000L;
            try {
                this.disruptor.shutdown(timeoutms, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                LOG.warn("Timed out bringing down disruptor after " + timeoutms + " ms; forcing halt", (Throwable)e);
                this.disruptor.halt();
                this.disruptor.shutdown();
            }
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    static {
        isInit = false;
        LOCK = new Object();
    }
}

