/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.management.MemoryUsage;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.util.HeapMemorySizeUtil;
import org.apache.hadoop.hbase.regionserver.HeapMemStoreLAB;
import org.apache.hadoop.hbase.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class MemStoreChunkPool {
    private static final Log LOG = LogFactory.getLog(MemStoreChunkPool.class);
    static final String CHUNK_POOL_MAXSIZE_KEY = "hbase.hregion.memstore.chunkpool.maxsize";
    static final String CHUNK_POOL_INITIALSIZE_KEY = "hbase.hregion.memstore.chunkpool.initialsize";
    static final float POOL_MAX_SIZE_DEFAULT = 0.0f;
    static final float POOL_INITIAL_SIZE_DEFAULT = 0.0f;
    private static MemStoreChunkPool GLOBAL_INSTANCE;
    static boolean chunkPoolDisabled;
    private final int maxCount;
    private final BlockingQueue<HeapMemStoreLAB.Chunk> reclaimedChunks;
    private final int chunkSize;
    private final ScheduledExecutorService scheduleThreadPool;
    private static final int statThreadPeriod = 300;
    private AtomicLong createdChunkCount = new AtomicLong();
    private AtomicLong reusedChunkCount = new AtomicLong();
    private AtomicLong requestedChunkCount = new AtomicLong();

    MemStoreChunkPool(Configuration conf, int chunkSize, int maxCount, int initialCount) {
        this.maxCount = maxCount;
        this.chunkSize = chunkSize;
        this.reclaimedChunks = new LinkedBlockingQueue<HeapMemStoreLAB.Chunk>();
        for (int i = 0; i < initialCount; ++i) {
            HeapMemStoreLAB.Chunk chunk = new HeapMemStoreLAB.Chunk(chunkSize);
            chunk.init();
            this.reclaimedChunks.add(chunk);
        }
        this.createdChunkCount.set(initialCount);
        this.scheduleThreadPool = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("MemStoreChunkPool Statistics").setDaemon(true).build());
        this.scheduleThreadPool.scheduleAtFixedRate(new StatisticsThread(this), 300L, 300L, TimeUnit.SECONDS);
    }

    HeapMemStoreLAB.Chunk getChunk() {
        this.requestedChunkCount.incrementAndGet();
        HeapMemStoreLAB.Chunk chunk = (HeapMemStoreLAB.Chunk)this.reclaimedChunks.poll();
        if (chunk == null) {
            chunk = new HeapMemStoreLAB.Chunk(this.chunkSize);
            this.createdChunkCount.incrementAndGet();
        } else {
            chunk.reset();
            this.reusedChunkCount.incrementAndGet();
        }
        return chunk;
    }

    void putbackChunks(BlockingQueue<HeapMemStoreLAB.Chunk> chunks) {
        int maxNumToPutback = this.maxCount - this.reclaimedChunks.size();
        if (maxNumToPutback <= 0) {
            return;
        }
        chunks.drainTo(this.reclaimedChunks, maxNumToPutback);
        if (chunks.size() > 0) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Left " + chunks.size() + " unreclaimable chunks, removing them from queue"));
            }
            chunks.clear();
        }
    }

    void putbackChunk(HeapMemStoreLAB.Chunk chunk) {
        if (this.reclaimedChunks.size() >= this.maxCount) {
            return;
        }
        this.reclaimedChunks.add(chunk);
    }

    int getPoolSize() {
        return this.reclaimedChunks.size();
    }

    void clearChunks() {
        this.reclaimedChunks.clear();
    }

    private void logStats() {
        long total = this.createdChunkCount.get();
        long reused = this.reusedChunkCount.get();
        long available = this.reclaimedChunks.size();
        long requested = this.requestedChunkCount.get();
        LOG.info((Object)("Stats: chunk in pool=" + available + ", chunk in use=" + (total - available) + ", total chunk=" + total + ", reused chunk=" + reused + ", reuse ratio=" + (requested == 0L ? "0" : StringUtils.formatPercent((float)reused / (float)requested, 2))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"DC_DOUBLECHECK"}, justification="Intentional")
    static MemStoreChunkPool getPool(Configuration conf) {
        if (GLOBAL_INSTANCE != null) {
            return GLOBAL_INSTANCE;
        }
        Class<MemStoreChunkPool> clazz = MemStoreChunkPool.class;
        synchronized (MemStoreChunkPool.class) {
            if (chunkPoolDisabled) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            if (GLOBAL_INSTANCE != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return GLOBAL_INSTANCE;
            }
            float poolSizePercentage = conf.getFloat(CHUNK_POOL_MAXSIZE_KEY, 0.0f);
            if (poolSizePercentage <= 0.0f) {
                chunkPoolDisabled = true;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            if ((double)poolSizePercentage > 1.0) {
                throw new IllegalArgumentException("hbase.hregion.memstore.chunkpool.maxsize must be between 0.0 and 1.0");
            }
            long heapMax = -1L;
            MemoryUsage usage = HeapMemorySizeUtil.safeGetHeapMemoryUsage();
            if (usage != null) {
                heapMax = usage.getMax();
            }
            long globalMemStoreLimit = (long)((float)heapMax * HeapMemorySizeUtil.getGlobalMemStorePercent(conf, false));
            int chunkSize = conf.getInt("hbase.hregion.memstore.mslab.chunksize", 0x200000);
            int maxCount = (int)((float)globalMemStoreLimit * poolSizePercentage / (float)chunkSize);
            float initialCountPercentage = conf.getFloat(CHUNK_POOL_INITIALSIZE_KEY, 0.0f);
            if ((double)initialCountPercentage > 1.0 || initialCountPercentage < 0.0f) {
                throw new IllegalArgumentException("hbase.hregion.memstore.chunkpool.initialsize must be between 0.0 and 1.0");
            }
            int initialCount = (int)(initialCountPercentage * (float)maxCount);
            LOG.info((Object)("Allocating MemStoreChunkPool with chunk size " + StringUtils.byteDesc(chunkSize) + ", max count " + maxCount + ", initial count " + initialCount));
            GLOBAL_INSTANCE = new MemStoreChunkPool(conf, chunkSize, maxCount, initialCount);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return GLOBAL_INSTANCE;
        }
    }

    int getMaxCount() {
        return this.maxCount;
    }

    static void clearDisableFlag() {
        chunkPoolDisabled = false;
    }

    static {
        chunkPoolDisabled = false;
    }

    private static class StatisticsThread
    extends Thread {
        MemStoreChunkPool mcp;

        public StatisticsThread(MemStoreChunkPool mcp) {
            super("MemStoreChunkPool.StatisticsThread");
            this.setDaemon(true);
            this.mcp = mcp;
        }

        @Override
        public void run() {
            this.mcp.logStats();
        }
    }
}

