/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Objects;
import org.apache.hadoop.hbase.util.ClassSize;

@InterfaceAudience.Private
public class MultiVersionConcurrencyControl {
    private static final Log LOG = LogFactory.getLog(MultiVersionConcurrencyControl.class);
    static final long NO_WRITE_NUMBER = 0L;
    private static final long READPOINT_ADVANCE_WAIT_TIME = 10L;
    final String regionName;
    final AtomicLong readPoint = new AtomicLong(0L);
    final AtomicLong writePoint = new AtomicLong(0L);
    private final Object readWaiters = new Object();
    public static final long NONE = -1L;
    private final LinkedList<WriteEntry> writeQueue = new LinkedList();
    public static final long FIXED_SIZE = ClassSize.align(ClassSize.OBJECT + 16 + 2 * ClassSize.REFERENCE);

    public MultiVersionConcurrencyControl() {
        this(null);
    }

    public MultiVersionConcurrencyControl(String regionName) {
        this.regionName = regionName;
    }

    public MultiVersionConcurrencyControl(long startPoint) {
        this(null);
        this.tryAdvanceTo(startPoint, -1L);
    }

    public void advanceTo(long newStartPoint) {
        long seqId;
        while ((seqId = this.getWritePoint()) < newStartPoint && !this.tryAdvanceTo(newStartPoint, seqId)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryAdvanceTo(long newStartPoint, long expected) {
        LinkedList<WriteEntry> linkedList = this.writeQueue;
        synchronized (linkedList) {
            long currentRead = this.readPoint.get();
            long currentWrite = this.writePoint.get();
            if (currentRead != currentWrite) {
                throw new RuntimeException("Already used this mvcc; currentRead=" + currentRead + ", currentWrite=" + currentWrite + "; too late to tryAdvanceTo");
            }
            if (expected != -1L && expected != currentRead) {
                return false;
            }
            if (newStartPoint < currentRead) {
                return false;
            }
            this.readPoint.set(newStartPoint);
            this.writePoint.set(newStartPoint);
        }
        return true;
    }

    public WriteEntry begin() {
        return this.begin(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteEntry begin(Runnable action) {
        LinkedList<WriteEntry> linkedList = this.writeQueue;
        synchronized (linkedList) {
            long nextWriteNumber = this.writePoint.incrementAndGet();
            WriteEntry e = new WriteEntry(nextWriteNumber);
            this.writeQueue.add(e);
            action.run();
            return e;
        }
    }

    public void await() {
        this.completeAndWait(this.begin());
    }

    public void completeAndWait(WriteEntry e) {
        if (!this.complete(e)) {
            this.waitForRead(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean complete(WriteEntry writeEntry) {
        LinkedList<WriteEntry> linkedList = this.writeQueue;
        synchronized (linkedList) {
            writeEntry.markCompleted();
            long nextReadValue = -1L;
            boolean ranOnce = false;
            while (!this.writeQueue.isEmpty()) {
                ranOnce = true;
                WriteEntry queueFirst = this.writeQueue.getFirst();
                if (nextReadValue > 0L && nextReadValue + 1L != queueFirst.getWriteNumber()) {
                    throw new RuntimeException("Invariant in complete violated, nextReadValue=" + nextReadValue + ", writeNumber=" + queueFirst.getWriteNumber());
                }
                if (!queueFirst.isCompleted()) break;
                nextReadValue = queueFirst.getWriteNumber();
                this.writeQueue.removeFirst();
            }
            if (!ranOnce) {
                throw new RuntimeException("There is no first!");
            }
            if (nextReadValue > 0L) {
                Object object = this.readWaiters;
                synchronized (object) {
                    this.readPoint.set(nextReadValue);
                    this.readWaiters.notifyAll();
                }
            }
            return this.readPoint.get() >= writeEntry.getWriteNumber();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForRead(WriteEntry e) {
        boolean interrupted = false;
        int count = 0;
        Object object = this.readWaiters;
        synchronized (object) {
            while (this.readPoint.get() < e.getWriteNumber()) {
                if (count % 100 == 0 && count > 0) {
                    long totalWaitTillNow = 10L * (long)count;
                    LOG.warn((Object)("STUCK for : " + totalWaitTillNow + " millis. " + this));
                }
                ++count;
                try {
                    this.readWaiters.wait(10L);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public String toString() {
        Objects.ToStringHelper helper = Objects.toStringHelper(this).add("readPoint", this.readPoint).add("writePoint", this.writePoint);
        if (this.regionName != null) {
            helper.add("regionName", this.regionName);
        }
        return helper.toString();
    }

    public long getReadPoint() {
        return this.readPoint.get();
    }

    public long getWritePoint() {
        return this.writePoint.get();
    }

    @InterfaceAudience.Private
    public static class WriteEntry {
        private final long writeNumber;
        private boolean completed = false;

        WriteEntry(long writeNumber) {
            this.writeNumber = writeNumber;
        }

        void markCompleted() {
            this.completed = true;
        }

        boolean isCompleted() {
            return this.completed;
        }

        public long getWriteNumber() {
            return this.writeNumber;
        }

        public String toString() {
            return this.writeNumber + ", " + this.completed;
        }
    }
}

