/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;

@InterfaceAudience.Private
public class TimeRangeTracker
implements Writable {
    static final long INITIAL_MIN_TIMESTAMP = Long.MAX_VALUE;
    static final long INITIAL_MAX_TIMESTAMP = -1L;
    AtomicLong minimumTimestamp = new AtomicLong(Long.MAX_VALUE);
    AtomicLong maximumTimestamp = new AtomicLong(-1L);

    public TimeRangeTracker() {
    }

    public TimeRangeTracker(TimeRangeTracker trt) {
        this.minimumTimestamp.set(trt.getMin());
        this.maximumTimestamp.set(trt.getMax());
    }

    public TimeRangeTracker(long minimumTimestamp, long maximumTimestamp) {
        this.minimumTimestamp.set(minimumTimestamp);
        this.maximumTimestamp.set(maximumTimestamp);
    }

    public void includeTimestamp(Cell cell) {
        this.includeTimestamp(cell.getTimestamp());
        if (CellUtil.isDeleteColumnOrFamily(cell)) {
            this.includeTimestamp(0L);
        }
    }

    @SuppressWarnings(value={"MT_CORRECTNESS"}, justification="Intentional")
    void includeTimestamp(long timestamp) {
        long curMaxTimestamp;
        long initialMinTimestamp = this.minimumTimestamp.get();
        if (timestamp < initialMinTimestamp) {
            long curMinTimestamp = initialMinTimestamp;
            while (timestamp < curMinTimestamp && !this.minimumTimestamp.compareAndSet(curMinTimestamp, timestamp)) {
                curMinTimestamp = this.minimumTimestamp.get();
            }
            if (initialMinTimestamp != Long.MAX_VALUE) {
                return;
            }
        }
        if (timestamp > (curMaxTimestamp = this.maximumTimestamp.get())) {
            while (timestamp > curMaxTimestamp && !this.maximumTimestamp.compareAndSet(curMaxTimestamp, timestamp)) {
                curMaxTimestamp = this.maximumTimestamp.get();
            }
        }
    }

    public boolean includesTimeRange(TimeRange tr) {
        return this.minimumTimestamp.get() < tr.getMax() && this.maximumTimestamp.get() >= tr.getMin();
    }

    public long getMin() {
        return this.minimumTimestamp.get();
    }

    public long getMax() {
        return this.maximumTimestamp.get();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.minimumTimestamp.get());
        out.writeLong(this.maximumTimestamp.get());
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.minimumTimestamp.set(in.readLong());
        this.maximumTimestamp.set(in.readLong());
    }

    public String toString() {
        return "[" + this.minimumTimestamp.get() + "," + this.maximumTimestamp.get() + "]";
    }

    public static TimeRangeTracker getTimeRangeTracker(byte[] timeRangeTrackerBytes) throws IOException {
        if (timeRangeTrackerBytes == null) {
            return null;
        }
        TimeRangeTracker trt = new TimeRangeTracker();
        Writables.copyWritable(timeRangeTrackerBytes, (Writable)trt);
        return trt;
    }

    static TimeRange getTimeRange(byte[] timeRangeTrackerBytes) throws IOException {
        TimeRangeTracker trt = TimeRangeTracker.getTimeRangeTracker(timeRangeTrackerBytes);
        return trt == null ? null : trt.toTimeRange();
    }

    TimeRange toTimeRange() throws IOException {
        long min = this.getMin();
        long max = this.getMax();
        if (min == Long.MAX_VALUE) {
            min = 0L;
        }
        if (max == -1L) {
            max = Long.MAX_VALUE;
        }
        return new TimeRange(min, max);
    }
}

