/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.ReaderBase;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix", "Configuration"})
public class SequenceFileLogReader
extends ReaderBase {
    private static final Log LOG = LogFactory.getLog(SequenceFileLogReader.class);
    private static final Text WAL_VERSION_KEY = new Text("version");
    private static final int COMPRESSION_VERSION = 1;
    private static final Text WAL_COMPRESSION_TYPE_KEY = new Text("compression.type");
    private static final Text DICTIONARY_COMPRESSION_TYPE = new Text("dictionary");
    protected SequenceFile.Reader reader;
    long entryStart = 0L;

    @Override
    public void close() throws IOException {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (IOException ioe) {
            throw this.addFileInfoToException(ioe);
        }
    }

    @Override
    public long getPosition() throws IOException {
        return this.reader != null ? this.reader.getPosition() : 0L;
    }

    @Override
    public void reset() throws IOException {
        this.reader = new WALReader(this.fs, this.path, this.conf);
    }

    @Override
    protected String initReader(FSDataInputStream stream) throws IOException {
        if (stream != null) {
            stream.close();
        }
        this.reset();
        return null;
    }

    @Override
    protected void initAfterCompression(String cellCodecClsName) throws IOException {
    }

    @Override
    protected void initAfterCompression() throws IOException {
    }

    @Override
    protected boolean hasCompression() {
        return SequenceFileLogReader.isWALCompressionEnabled(this.reader.getMetadata());
    }

    @Override
    protected boolean hasTagCompression() {
        return false;
    }

    static boolean isWALCompressionEnabled(SequenceFile.Metadata metadata) {
        Text txt = metadata.get(WAL_VERSION_KEY);
        if (txt == null || Integer.parseInt(txt.toString()) < 1) {
            return false;
        }
        txt = metadata.get(WAL_COMPRESSION_TYPE_KEY);
        return txt != null && txt.equals(DICTIONARY_COMPRESSION_TYPE);
    }

    @Override
    protected boolean readNext(WAL.Entry e) throws IOException {
        try {
            if (!(e.getKey() instanceof HLogKey)) {
                IllegalArgumentException exception = new IllegalArgumentException("SequenceFileLogReader only works when given entries that have HLogKey for keys. This one had '" + e.getKey().getClass() + "'");
                LOG.error((Object)"We need to use the legacy SequenceFileLogReader to handle a  pre-0.96 style WAL, but HBase internals failed to use the deprecated HLogKey class. This is a bug; please file an issue or email the developer mailing list. You will need the following exception details when seeking help from the HBase community.", (Throwable)exception);
                throw exception;
            }
            boolean hasNext = this.reader.next((HLogKey)e.getKey(), e.getEdit());
            if (!hasNext) {
                return false;
            }
            NavigableMap<byte[], Integer> scopes = e.getEdit().getAndRemoveScopes();
            if (scopes != null) {
                e.getKey().readOlderScopes(scopes);
            }
            return true;
        }
        catch (IOException ioe) {
            throw this.addFileInfoToException(ioe);
        }
    }

    @Override
    protected void seekOnFs(long pos) throws IOException {
        try {
            this.reader.seek(pos);
        }
        catch (IOException ioe) {
            throw this.addFileInfoToException(ioe);
        }
    }

    protected IOException addFileInfoToException(IOException ioe) throws IOException {
        long pos = -1L;
        try {
            pos = this.getPosition();
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed getting position to add to throw", (Throwable)e);
        }
        long end = Long.MAX_VALUE;
        try {
            Field fEnd = SequenceFile.Reader.class.getDeclaredField("end");
            fEnd.setAccessible(true);
            end = fEnd.getLong(this.reader);
        }
        catch (NoSuchFieldException nfe) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)nfe);
            }
        }
        catch (IllegalAccessException iae) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)iae);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Unexpected exception when accessing the end field", (Throwable)e);
        }
        String msg = (this.path == null ? "" : this.path.toString()) + ", entryStart=" + this.entryStart + ", pos=" + pos + (end == Long.MAX_VALUE ? "" : ", end=" + end) + ", edit=" + this.edit;
        try {
            return (IOException)((IOException)ioe.getClass().getConstructor(String.class).newInstance(msg)).initCause(ioe);
        }
        catch (NoSuchMethodException nfe) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)nfe);
            }
        }
        catch (IllegalAccessException iae) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)iae);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Unexpected exception when accessing the end field", (Throwable)e);
        }
        return ioe;
    }

    private static class WALReader
    extends SequenceFile.Reader {
        WALReader(FileSystem fs, Path p, Configuration c) throws IOException {
            super(fs, p, c);
        }

        @Override
        protected FSDataInputStream openFile(FileSystem fs, Path file, int bufferSize, long length) throws IOException {
            return new WALReaderFSDataInputStream(super.openFile(fs, file, bufferSize, length), length);
        }

        static class WALReaderFSDataInputStream
        extends FSDataInputStream {
            private boolean firstGetPosInvocation = true;
            private long length;

            WALReaderFSDataInputStream(FSDataInputStream is, long l) throws IOException {
                super(is);
                this.length = l;
            }

            @Override
            public long getPos() throws IOException {
                if (this.firstGetPosInvocation) {
                    this.firstGetPosInvocation = false;
                    long adjust = 0L;
                    HdfsDataInputStream hdfsDataInputStream = null;
                    try {
                        if (this.in.getClass().getName().endsWith("HdfsDataInputStream") || this.in.getClass().getName().endsWith("DFSInputStream")) {
                            hdfsDataInputStream = (HdfsDataInputStream)this.getWrappedStream();
                            long realLength = hdfsDataInputStream.getVisibleLength();
                            assert (realLength >= this.length);
                            adjust = realLength - this.length;
                        } else {
                            LOG.info((Object)("Input stream class: " + this.in.getClass().getName() + ", not adjusting length"));
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Error while trying to get accurate file length.  Truncation / data loss may occur if RegionServers die.", (Throwable)e);
                        throw new IOException(e);
                    }
                    return adjust + super.getPos();
                }
                return super.getPos();
            }
        }
    }
}

