/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.TextFormat;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALKey;

@InterfaceAudience.Private
public class WALUtil {
    private static final Log LOG = LogFactory.getLog(WALUtil.class);

    private WALUtil() {
    }

    public static long writeCompactionMarker(WAL wal, HTableDescriptor htd, HRegionInfo hri, WALProtos.CompactionDescriptor c, MultiVersionConcurrencyControl mvcc) throws IOException {
        long trx = WALUtil.writeMarker(wal, htd, hri, WALEdit.createCompaction(hri, c), mvcc, true, null);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Appended compaction marker " + TextFormat.shortDebugString(c)));
        }
        return trx;
    }

    public static long writeFlushMarker(WAL wal, HTableDescriptor htd, HRegionInfo hri, WALProtos.FlushDescriptor f, boolean sync, MultiVersionConcurrencyControl mvcc) throws IOException {
        long trx = WALUtil.writeMarker(wal, htd, hri, WALEdit.createFlushWALEdit(hri, f), mvcc, sync, null);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Appended flush marker " + TextFormat.shortDebugString(f)));
        }
        return trx;
    }

    public static long writeRegionEventMarker(WAL wal, HTableDescriptor htd, HRegionInfo hri, WALProtos.RegionEventDescriptor r, MultiVersionConcurrencyControl mvcc) throws IOException {
        long trx = WALUtil.writeMarker(wal, htd, hri, WALEdit.createRegionEventWALEdit(hri, r), mvcc, true, null);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Appended region event marker " + TextFormat.shortDebugString(r)));
        }
        return trx;
    }

    public static long writeBulkLoadMarkerAndSync(WAL wal, HTableDescriptor htd, HRegionInfo hri, WALProtos.BulkLoadDescriptor desc, MultiVersionConcurrencyControl mvcc) throws IOException {
        long trx = WALUtil.writeMarker(wal, htd, hri, WALEdit.createBulkLoadEvent(hri, desc), mvcc, true, null);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Appended Bulk Load marker " + TextFormat.shortDebugString(desc)));
        }
        return trx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long writeMarker(WAL wal, HTableDescriptor htd, HRegionInfo hri, WALEdit edit, MultiVersionConcurrencyControl mvcc, boolean sync, Map<String, byte[]> extendedAttributes) throws IOException {
        WALKey key = new WALKey(hri.getEncodedNameAsBytes(), hri.getTable(), System.currentTimeMillis(), mvcc, extendedAttributes);
        long trx = -1L;
        try {
            trx = wal.append(htd, hri, key, edit, false);
            if (sync) {
                wal.sync(trx);
            }
        }
        finally {
            MultiVersionConcurrencyControl.WriteEntry we = key.getWriteEntry();
            if (mvcc != null && we != null) {
                mvcc.complete(we);
            }
        }
        return trx;
    }

    public static long getWALBlockSize(Configuration conf, FileSystem fs, Path dir) throws IOException {
        return WALUtil.getWALBlockSize(conf, fs, dir, false);
    }

    public static long getWALBlockSize(Configuration conf, FileSystem fs, Path dir, boolean isRecoverEdits) throws IOException {
        long defaultBlockSize = FSUtils.getDefaultBlockSize(fs, dir) * 2L;
        if (isRecoverEdits) {
            return conf.getLong("hbase.regionserver.recoverededits.blocksize", defaultBlockSize);
        }
        return conf.getLong("hbase.regionserver.hlog.blocksize", defaultBlockSize);
    }
}

