/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapreduce.TaskID;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class YarnOutputFiles
extends MapOutputFile {
    private JobConf conf;
    private static final String JOB_OUTPUT_DIR = "output";
    private static final String SPILL_FILE_PATTERN = "%s_spill_%d.out";
    private static final String SPILL_INDEX_FILE_PATTERN = "%s_spill_%d.out.index";
    private LocalDirAllocator lDirAlloc = new LocalDirAllocator("mapreduce.cluster.local.dir");

    private Path getAttemptOutputDir() {
        return new Path(JOB_OUTPUT_DIR, this.conf.get("mapreduce.task.attempt.id"));
    }

    @Override
    public Path getOutputFile() throws IOException {
        Path attemptOutput = new Path(this.getAttemptOutputDir(), "file.out");
        return this.lDirAlloc.getLocalPathToRead(attemptOutput.toString(), this.conf);
    }

    @Override
    public Path getOutputFileForWrite(long size) throws IOException {
        Path attemptOutput = new Path(this.getAttemptOutputDir(), "file.out");
        return this.lDirAlloc.getLocalPathForWrite(attemptOutput.toString(), size, this.conf);
    }

    @Override
    public Path getOutputFileForWriteInVolume(Path existing) {
        Path outputDir = new Path(existing.getParent(), JOB_OUTPUT_DIR);
        Path attemptOutputDir = new Path(outputDir, this.conf.get("mapreduce.task.attempt.id"));
        return new Path(attemptOutputDir, "file.out");
    }

    @Override
    public Path getOutputIndexFile() throws IOException {
        Path attemptIndexOutput = new Path(this.getAttemptOutputDir(), "file.out.index");
        return this.lDirAlloc.getLocalPathToRead(attemptIndexOutput.toString(), this.conf);
    }

    @Override
    public Path getOutputIndexFileForWrite(long size) throws IOException {
        Path attemptIndexOutput = new Path(this.getAttemptOutputDir(), "file.out.index");
        return this.lDirAlloc.getLocalPathForWrite(attemptIndexOutput.toString(), size, this.conf);
    }

    @Override
    public Path getOutputIndexFileForWriteInVolume(Path existing) {
        Path outputDir = new Path(existing.getParent(), JOB_OUTPUT_DIR);
        Path attemptOutputDir = new Path(outputDir, this.conf.get("mapreduce.task.attempt.id"));
        return new Path(attemptOutputDir, "file.out.index");
    }

    @Override
    public Path getSpillFile(int spillNumber) throws IOException {
        return this.lDirAlloc.getLocalPathToRead(String.format(SPILL_FILE_PATTERN, this.conf.get("mapreduce.task.attempt.id"), spillNumber), this.conf);
    }

    @Override
    public Path getSpillFileForWrite(int spillNumber, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(String.format(SPILL_FILE_PATTERN, this.conf.get("mapreduce.task.attempt.id"), spillNumber), size, this.conf);
    }

    @Override
    public Path getSpillIndexFile(int spillNumber) throws IOException {
        return this.lDirAlloc.getLocalPathToRead(String.format(SPILL_INDEX_FILE_PATTERN, this.conf.get("mapreduce.task.attempt.id"), spillNumber), this.conf);
    }

    @Override
    public Path getSpillIndexFileForWrite(int spillNumber, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(String.format(SPILL_INDEX_FILE_PATTERN, this.conf.get("mapreduce.task.attempt.id"), spillNumber), size, this.conf);
    }

    @Override
    public Path getInputFile(int mapId) throws IOException {
        throw new UnsupportedOperationException("Incompatible with LocalRunner");
    }

    @Override
    public Path getInputFileForWrite(TaskID mapId, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(String.format("%s/map_%d.out", this.getAttemptOutputDir().toString(), mapId.getId()), size, this.conf);
    }

    @Override
    public void removeAll() throws IOException {
        throw new UnsupportedOperationException("Incompatible with LocalRunner");
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf);
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }
}

