/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.testing;

import java.io.Closeable;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testing.TestingHBaseCluster;
import org.apache.hadoop.hbase.testing.TestingHBaseClusterOption;
import org.apache.hadoop.hbase.util.DNS;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, LargeTests.class})
public class TestTestingHBaseCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTestingHBaseCluster.class);
    private static TestingHBaseCluster CLUSTER;
    private Connection conn;
    private Admin admin;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        CLUSTER = TestingHBaseCluster.create((TestingHBaseClusterOption)TestingHBaseClusterOption.builder().numMasters(2).numRegionServers(3).numDataNodes(3).build());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (CLUSTER.isClusterRunning()) {
            CLUSTER.stop();
        }
    }

    @Before
    public void setUp() throws Exception {
        if (!CLUSTER.isClusterRunning()) {
            CLUSTER.start();
        }
        if (!CLUSTER.isHBaseClusterRunning()) {
            CLUSTER.startHBaseCluster();
        }
        this.conn = ConnectionFactory.createConnection((Configuration)CLUSTER.getConf());
        this.admin = this.conn.getAdmin();
    }

    @After
    public void tearDown() throws Exception {
        Closeables.close((Closeable)this.admin, (boolean)true);
        Closeables.close((Closeable)this.conn, (boolean)true);
        if (CLUSTER.isHBaseClusterRunning()) {
            CLUSTER.stopHBaseCluster();
        }
    }

    @Test
    public void testStartStop() throws Exception {
        Assert.assertTrue((boolean)CLUSTER.isClusterRunning());
        Assert.assertTrue((boolean)CLUSTER.isHBaseClusterRunning());
        Assert.assertThrows(IllegalStateException.class, () -> CLUSTER.start());
        CLUSTER.stop();
        Assert.assertFalse((boolean)CLUSTER.isClusterRunning());
        Assert.assertFalse((boolean)CLUSTER.isHBaseClusterRunning());
        Assert.assertThrows(IllegalStateException.class, () -> CLUSTER.stop());
    }

    @Test
    public void testStartStopHBaseCluster() throws Exception {
        Assert.assertTrue((boolean)CLUSTER.isHBaseClusterRunning());
        Assert.assertThrows(IllegalStateException.class, () -> CLUSTER.startHBaseCluster());
        CLUSTER.stopHBaseCluster();
        Assert.assertTrue((boolean)CLUSTER.isClusterRunning());
        Assert.assertFalse((boolean)CLUSTER.isHBaseClusterRunning());
        Assert.assertThrows(IllegalStateException.class, () -> CLUSTER.stopHBaseCluster());
    }

    @Test
    public void testStartStopMaster() throws Exception {
        ServerName master = this.admin.getMaster();
        CLUSTER.stopMaster(master).join();
        Waiter.waitFor((Configuration)CLUSTER.getConf(), (long)30000L, () -> {
            try {
                return this.admin.getMaster() != null;
            }
            catch (Exception e) {
                return false;
            }
        });
        Assert.assertTrue((boolean)this.admin.getBackupMasters().isEmpty());
        CLUSTER.startMaster();
        Waiter.waitFor((Configuration)CLUSTER.getConf(), (long)30000L, () -> !this.admin.getBackupMasters().isEmpty());
        CLUSTER.startMaster(DNS.getHostname((Configuration)CLUSTER.getConf(), (DNS.ServerType)DNS.ServerType.MASTER), 0);
        Waiter.waitFor((Configuration)CLUSTER.getConf(), (long)30000L, () -> this.admin.getBackupMasters().size() == 2);
    }

    @Test
    public void testStartStopRegionServer() throws Exception {
        Collection regionServers = this.admin.getRegionServers();
        Assert.assertEquals((long)3L, (long)regionServers.size());
        CLUSTER.stopRegionServer((ServerName)Iterables.get((Iterable)regionServers, (int)0)).join();
        Waiter.waitFor((Configuration)CLUSTER.getConf(), (long)30000L, () -> this.admin.getRegionServers().size() == 2);
        CLUSTER.startRegionServer();
        Waiter.waitFor((Configuration)CLUSTER.getConf(), (long)30000L, () -> this.admin.getRegionServers().size() == 3);
        CLUSTER.startRegionServer(DNS.getHostname((Configuration)CLUSTER.getConf(), (DNS.ServerType)DNS.ServerType.REGIONSERVER), 0);
        Waiter.waitFor((Configuration)CLUSTER.getConf(), (long)30000L, () -> this.admin.getRegionServers().size() == 4);
    }

    @Test
    public void testGetAddresses() throws Exception {
        Assert.assertTrue((boolean)CLUSTER.getActiveMasterAddress().isPresent());
        Assert.assertEquals((long)1L, (long)CLUSTER.getBackupMasterAddresses().size());
        Assert.assertEquals((long)3L, (long)CLUSTER.getRegionServerAddresses().size());
    }
}

