/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.testing;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.OnlineRegions;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testing.TestingHBaseCluster;
import org.apache.hadoop.hbase.testing.TestingHBaseClusterOption;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class TestingHBaseClusterImpl
implements TestingHBaseCluster {
    private final HBaseTestingUtil util;
    private final StartTestingClusterOption option;
    private final String externalDfsUri;
    private final String externalZkConnectString;
    private final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat(this.getClass().getSuperclass() + "-%d").setDaemon(true).build());
    private boolean miniClusterRunning = false;
    private boolean miniHBaseClusterRunning = false;

    TestingHBaseClusterImpl(TestingHBaseClusterOption option) {
        this.util = new HBaseTestingUtil(option.conf());
        this.option = option.convert();
        this.externalDfsUri = option.getExternalDfsUri();
        this.externalZkConnectString = option.getExternalZkConnectString();
    }

    @Override
    public Configuration getConf() {
        return this.util.getConfiguration();
    }

    private int getRegionServerIndex(ServerName serverName) {
        List servers = this.util.getMiniHBaseCluster().getRegionServerThreads();
        for (int i = 0; i < servers.size(); ++i) {
            if (!((JVMClusterUtil.RegionServerThread)servers.get(i)).getRegionServer().getServerName().equals((Object)serverName)) continue;
            return i;
        }
        return -1;
    }

    private int getMasterIndex(ServerName serverName) {
        List masters = this.util.getMiniHBaseCluster().getMasterThreads();
        for (int i = 0; i < masters.size(); ++i) {
            if (!((JVMClusterUtil.MasterThread)masters.get(i)).getMaster().getServerName().equals((Object)serverName)) continue;
            return i;
        }
        return -1;
    }

    private void join(Thread thread, CompletableFuture<?> future) {
        this.executor.execute(() -> {
            try {
                thread.join();
                future.complete(null);
            }
            catch (InterruptedException e) {
                future.completeExceptionally(e);
            }
        });
    }

    @Override
    public CompletableFuture<Void> stopMaster(ServerName serverName) throws Exception {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        int index = this.getMasterIndex(serverName);
        if (index == -1) {
            future.completeExceptionally(new IllegalArgumentException("Unknown master " + serverName));
        }
        this.join((Thread)this.util.getMiniHBaseCluster().stopMaster(index), future);
        return future;
    }

    @Override
    public CompletableFuture<Void> stopRegionServer(ServerName serverName) throws Exception {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        int index = this.getRegionServerIndex(serverName);
        if (index == -1) {
            future.completeExceptionally(new IllegalArgumentException("Unknown region server " + serverName));
        }
        this.join((Thread)this.util.getMiniHBaseCluster().stopRegionServer(index), future);
        return future;
    }

    @Override
    public void stopHBaseCluster() throws Exception {
        Preconditions.checkState((boolean)this.miniClusterRunning, (Object)"Cluster has already been stopped");
        Preconditions.checkState((boolean)this.miniHBaseClusterRunning, (Object)"HBase cluster has already been started");
        this.util.shutdownMiniHBaseCluster();
        this.miniHBaseClusterRunning = false;
    }

    @Override
    public void startHBaseCluster() throws Exception {
        Preconditions.checkState((boolean)this.miniClusterRunning, (Object)"Cluster has already been stopped");
        Preconditions.checkState((!this.miniHBaseClusterRunning ? 1 : 0) != 0, (Object)"HBase cluster has already been started");
        this.util.startMiniHBaseCluster(this.option);
        this.miniHBaseClusterRunning = true;
    }

    @Override
    public void start() throws Exception {
        Configuration conf;
        Preconditions.checkState((!this.miniClusterRunning ? 1 : 0) != 0, (Object)"Cluster has already been started");
        if (this.externalZkConnectString == null) {
            this.util.startMiniZKCluster();
        } else {
            conf = this.util.getConfiguration();
            conf.set("hbase.zookeeper.quorum", this.externalZkConnectString);
            conf.set("zookeeper.znode.parent", "/" + UUID.randomUUID().toString());
        }
        if (this.externalDfsUri == null) {
            this.util.startMiniDFSCluster(this.option.getNumDataNodes(), this.option.getDataNodeHosts());
        } else {
            conf = this.util.getConfiguration();
            conf.set("fs.defaultFS", this.externalDfsUri);
        }
        this.util.startMiniHBaseCluster(this.option);
        this.miniClusterRunning = true;
        this.miniHBaseClusterRunning = true;
    }

    @Override
    public void stop() throws Exception {
        Preconditions.checkState((boolean)this.miniClusterRunning, (Object)"Cluster has already been stopped");
        this.util.shutdownMiniCluster();
        this.miniClusterRunning = false;
        this.miniHBaseClusterRunning = false;
    }

    @Override
    public boolean isHBaseClusterRunning() {
        return this.miniHBaseClusterRunning;
    }

    @Override
    public boolean isClusterRunning() {
        return this.miniClusterRunning;
    }

    @Override
    public void startMaster() throws Exception {
        this.util.getMiniHBaseCluster().startMaster();
    }

    @Override
    public void startMaster(String hostname, int port) throws Exception {
        this.util.getMiniHBaseCluster().startMaster(hostname, port);
    }

    @Override
    public void startRegionServer() throws Exception {
        this.util.getMiniHBaseCluster().startRegionServer();
    }

    @Override
    public void startRegionServer(String hostname, int port) throws Exception {
        this.util.getMiniHBaseCluster().startRegionServer(hostname, port);
    }

    @Override
    public Optional<ServerName> getActiveMasterAddress() {
        return Optional.ofNullable(this.util.getMiniHBaseCluster().getMaster()).map(HMaster::getServerName);
    }

    @Override
    public List<ServerName> getBackupMasterAddresses() {
        return this.util.getMiniHBaseCluster().getMasterThreads().stream().map(JVMClusterUtil.MasterThread::getMaster).filter(m -> !m.isActiveMaster()).map(HMaster::getServerName).collect(Collectors.toList());
    }

    @Override
    public List<ServerName> getRegionServerAddresses() {
        return this.util.getMiniHBaseCluster().getRegionServerThreads().stream().map(t -> t.getRegionServer().getServerName()).collect(Collectors.toList());
    }

    @Override
    public Optional<Region> getRegion(RegionInfo regionInfo) {
        for (JVMClusterUtil.RegionServerThread t : this.util.getMiniHBaseCluster().getRegionServerThreads()) {
            for (HRegion region : t.getRegionServer().getRegions()) {
                if (!region.getRegionInfo().equals(regionInfo)) continue;
                return Optional.of(region);
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<OnlineRegions> getOnlineRegionsInterface(ServerName serverName) {
        return Optional.ofNullable(this.util.getMiniHBaseCluster().getRegionServer(serverName));
    }
}

