/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
@Deprecated
public class HBaseZKTestingUtility
extends HBaseCommonTestingUtility {
    private MiniZooKeeperCluster zkCluster;
    private boolean passedZkCluster;
    protected ZKWatcher zooKeeperWatcher;
    protected File clusterTestDir;

    public HBaseZKTestingUtility() {
        this(HBaseConfiguration.create());
    }

    public HBaseZKTestingUtility(Configuration conf) {
        super(conf);
    }

    Path getClusterTestDir() {
        if (this.clusterTestDir == null) {
            this.setupClusterTestDir();
        }
        return new Path(this.clusterTestDir.getAbsolutePath());
    }

    protected void setupClusterTestDir() {
        if (this.clusterTestDir != null) {
            return;
        }
        Path testDir = this.getDataTestDir("cluster_" + HBaseZKTestingUtility.getRandomUUID().toString());
        this.clusterTestDir = new File(testDir.toString()).getAbsoluteFile();
        boolean b = this.deleteOnExit();
        if (b) {
            this.clusterTestDir.deleteOnExit();
        }
        LOG.info("Created new mini-cluster data directory: " + this.clusterTestDir + ", deleteOnExit=" + b);
    }

    public MiniZooKeeperCluster startMiniZKCluster() throws Exception {
        return this.startMiniZKCluster(1, new int[0]);
    }

    public MiniZooKeeperCluster startMiniZKCluster(int zooKeeperServerNum, int ... clientPortList) throws Exception {
        this.setupClusterTestDir();
        return this.startMiniZKCluster(this.clusterTestDir, zooKeeperServerNum, clientPortList);
    }

    private MiniZooKeeperCluster startMiniZKCluster(File dir, int zooKeeperServerNum, int[] clientPortList) throws Exception {
        if (this.zkCluster != null) {
            throw new IOException("Cluster already running at " + dir);
        }
        this.passedZkCluster = false;
        this.zkCluster = new MiniZooKeeperCluster(this.getConfiguration());
        int defPort = this.conf.getInt("test.hbase.zookeeper.property.clientPort", 0);
        if (defPort > 0) {
            this.zkCluster.setDefaultClientPort(defPort);
        }
        if (clientPortList != null) {
            int clientPortListSize = Math.min(clientPortList.length, zooKeeperServerNum);
            for (int i = 0; i < clientPortListSize; ++i) {
                this.zkCluster.addClientPort(clientPortList[i]);
            }
        }
        int clientPort = this.zkCluster.startup(dir, zooKeeperServerNum);
        this.conf.set("hbase.zookeeper.property.clientPort", Integer.toString(clientPort));
        return this.zkCluster;
    }

    public MiniZooKeeperCluster getZkCluster() {
        return this.zkCluster;
    }

    public void setZkCluster(MiniZooKeeperCluster zkCluster) {
        this.passedZkCluster = true;
        this.zkCluster = zkCluster;
        this.conf.setInt("hbase.zookeeper.property.clientPort", zkCluster.getClientPort());
    }

    public void shutdownMiniZKCluster() throws IOException {
        if (!this.passedZkCluster && this.zkCluster != null) {
            this.zkCluster.shutdown();
            this.zkCluster = null;
        }
    }

    public synchronized ZKWatcher getZooKeeperWatcher() throws IOException {
        if (this.zooKeeperWatcher == null) {
            this.zooKeeperWatcher = new ZKWatcher(this.conf, "testing utility", new Abortable(){

                public void abort(String why, Throwable e) {
                    throw new RuntimeException("Unexpected abort in HBaseZKTestingUtility:" + why, e);
                }

                public boolean isAborted() {
                    return false;
                }
            });
        }
        return this.zooKeeperWatcher;
    }

    public static ZKWatcher getZooKeeperWatcher(HBaseZKTestingUtility testUtil) throws IOException {
        return new ZKWatcher(testUtil.getConfiguration(), "unittest", new Abortable(){
            boolean aborted = false;

            public void abort(String why, Throwable e) {
                this.aborted = true;
                throw new RuntimeException("Fatal ZK error, why=" + why, e);
            }

            public boolean isAborted() {
                return this.aborted;
            }
        });
    }

    @Override
    public boolean cleanupTestDir() {
        boolean ret = super.cleanupTestDir();
        if (this.deleteDir(this.clusterTestDir)) {
            this.clusterTestDir = null;
            return ret;
        }
        return false;
    }
}

