/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.testing;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public final class TestingHBaseClusterOption {
    private final Configuration conf;
    private final int numMasters;
    private final int numAlwaysStandByMasters;
    private final int numRegionServers;
    private final List<Integer> rsPorts;
    private final int numDataNodes;
    private final String[] dataNodeHosts;
    private final int numZkServers;
    private final boolean createRootDir;
    private final boolean createWALDir;
    private final String externalDfsUri;
    private final String externalZkConnectString;

    private TestingHBaseClusterOption(Configuration conf, int numMasters, int numAlwaysStandByMasters, int numRegionServers, List<Integer> rsPorts, int numDataNodes, String[] dataNodeHosts, int numZkServers, boolean createRootDir, boolean createWALDir, String externalDfsUri, String externalZkConnectString) {
        this.conf = conf;
        this.numMasters = numMasters;
        this.numAlwaysStandByMasters = numAlwaysStandByMasters;
        this.numRegionServers = numRegionServers;
        this.rsPorts = rsPorts;
        this.numDataNodes = numDataNodes;
        this.dataNodeHosts = dataNodeHosts;
        this.numZkServers = numZkServers;
        this.createRootDir = createRootDir;
        this.createWALDir = createWALDir;
        this.externalDfsUri = externalDfsUri;
        this.externalZkConnectString = externalZkConnectString;
    }

    public Configuration conf() {
        return this.conf;
    }

    public int getNumMasters() {
        return this.numMasters;
    }

    public int getNumAlwaysStandByMasters() {
        return this.numAlwaysStandByMasters;
    }

    public int getNumRegionServers() {
        return this.numRegionServers;
    }

    public List<Integer> getRsPorts() {
        return this.rsPorts;
    }

    public int getNumDataNodes() {
        return this.numDataNodes;
    }

    public String[] getDataNodeHosts() {
        return this.dataNodeHosts;
    }

    public int getNumZkServers() {
        return this.numZkServers;
    }

    public boolean isCreateRootDir() {
        return this.createRootDir;
    }

    public boolean isCreateWALDir() {
        return this.createWALDir;
    }

    public String getExternalDfsUri() {
        return this.externalDfsUri;
    }

    public String getExternalZkConnectString() {
        return this.externalZkConnectString;
    }

    public String toString() {
        return "StartMiniClusterOption{numMasters=" + this.numMasters + ", numRegionServers=" + this.numRegionServers + ", rsPorts=" + StringUtils.join((Object[])new List[]{this.rsPorts}) + ", numDataNodes=" + this.numDataNodes + ", dataNodeHosts=" + Arrays.toString(this.dataNodeHosts) + ", numZkServers=" + this.numZkServers + ", createRootDir=" + this.createRootDir + ", createWALDir=" + this.createWALDir + '}';
    }

    StartTestingClusterOption convert() {
        return StartTestingClusterOption.builder().numMasters(this.numMasters).numAlwaysStandByMasters(this.numAlwaysStandByMasters).numRegionServers(this.numRegionServers).rsPorts(this.rsPorts).numDataNodes(this.numDataNodes).dataNodeHosts(this.dataNodeHosts).numZkServers(this.numZkServers).createRootDir(this.createRootDir).createWALDir(this.createWALDir).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Configuration conf;
        private int numMasters = 1;
        private int numAlwaysStandByMasters = 0;
        private int numRegionServers = 1;
        private List<Integer> rsPorts = null;
        private int numDataNodes = 1;
        private String[] dataNodeHosts = null;
        private int numZkServers = 1;
        private boolean createRootDir = false;
        private boolean createWALDir = false;
        private String externalDfsUri = null;
        private String externalZkConnectString = null;

        private Builder() {
        }

        public TestingHBaseClusterOption build() {
            if (this.dataNodeHosts != null && this.dataNodeHosts.length != 0) {
                this.numDataNodes = this.dataNodeHosts.length;
            }
            return new TestingHBaseClusterOption(this.conf, this.numMasters, this.numAlwaysStandByMasters, this.numRegionServers, this.rsPorts, this.numDataNodes, this.dataNodeHosts, this.numZkServers, this.createRootDir, this.createWALDir, this.externalDfsUri, this.externalZkConnectString);
        }

        public Builder conf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder numMasters(int numMasters) {
            this.numMasters = numMasters;
            return this;
        }

        public Builder numAlwaysStandByMasters(int numAlwaysStandByMasters) {
            this.numAlwaysStandByMasters = numAlwaysStandByMasters;
            return this;
        }

        public Builder numRegionServers(int numRegionServers) {
            this.numRegionServers = numRegionServers;
            return this;
        }

        public Builder rsPorts(List<Integer> rsPorts) {
            this.rsPorts = rsPorts;
            return this;
        }

        public Builder numDataNodes(int numDataNodes) {
            this.numDataNodes = numDataNodes;
            return this;
        }

        public Builder dataNodeHosts(String[] dataNodeHosts) {
            this.dataNodeHosts = dataNodeHosts;
            return this;
        }

        public Builder numZkServers(int numZkServers) {
            this.numZkServers = numZkServers;
            return this;
        }

        public Builder createRootDir(boolean createRootDir) {
            this.createRootDir = createRootDir;
            return this;
        }

        public Builder createWALDir(boolean createWALDir) {
            this.createWALDir = createWALDir;
            return this;
        }

        public Builder useExternalDfs(String uri) {
            this.externalDfsUri = uri;
            return this;
        }

        public Builder useExternalZooKeeper(String connectString) {
            this.externalZkConnectString = connectString;
            return this;
        }
    }
}

