/**
 * Autogenerated by Thrift Compiler (0.9.0)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.hadoop.hbase.thrift.generated;

import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hbase {

  public interface Iface {

    /**
     * Brings a table on-line (enables it)
     * 
     * @param tableName name of the table
     */
    public void enableTable(ByteBuffer tableName) throws IOError, org.apache.thrift.TException;

    /**
     * Disables a table (takes it off-line) If it is being served, the master
     * will tell the servers to stop serving it.
     * 
     * @param tableName name of the table
     */
    public void disableTable(ByteBuffer tableName) throws IOError, org.apache.thrift.TException;

    /**
     * @return true if table is on-line
     * 
     * @param tableName name of the table to check
     */
    public boolean isTableEnabled(ByteBuffer tableName) throws IOError, org.apache.thrift.TException;

    public void compact(ByteBuffer tableNameOrRegionName) throws IOError, org.apache.thrift.TException;

    public void majorCompact(ByteBuffer tableNameOrRegionName) throws IOError, org.apache.thrift.TException;

    /**
     * List all the userspace tables.
     * 
     * @return returns a list of names
     */
    public List<ByteBuffer> getTableNames() throws IOError, org.apache.thrift.TException;

    /**
     * List all the column families assoicated with a table.
     * 
     * @return list of column family descriptors
     * 
     * @param tableName table name
     */
    public Map<ByteBuffer,ColumnDescriptor> getColumnDescriptors(ByteBuffer tableName) throws IOError, org.apache.thrift.TException;

    /**
     * List the regions associated with a table.
     * 
     * @return list of region descriptors
     * 
     * @param tableName table name
     */
    public List<TRegionInfo> getTableRegions(ByteBuffer tableName) throws IOError, org.apache.thrift.TException;

    /**
     * Create a table with the specified column families.  The name
     * field for each ColumnDescriptor must be set and must end in a
     * colon (:). All other fields are optional and will get default
     * values if not explicitly specified.
     * 
     * @throws IllegalArgument if an input parameter is invalid
     * 
     * @throws AlreadyExists if the table name already exists
     * 
     * @param tableName name of table to create
     * 
     * @param columnFamilies list of column family descriptors
     */
    public void createTable(ByteBuffer tableName, List<ColumnDescriptor> columnFamilies) throws IOError, IllegalArgument, AlreadyExists, org.apache.thrift.TException;

    /**
     * Deletes a table
     * 
     * @throws IOError if table doesn't exist on server or there was some other
     * problem
     * 
     * @param tableName name of table to delete
     */
    public void deleteTable(ByteBuffer tableName) throws IOError, org.apache.thrift.TException;

    /**
     * Get a single TCell for the specified table, row, and column at the
     * latest timestamp. Returns an empty list if no such value exists.
     * 
     * @return value for specified row/column
     * 
     * @param tableName name of table
     * 
     * @param row row key
     * 
     * @param column column name
     * 
     * @param attributes Get attributes
     */
    public List<TCell> get(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get the specified number of versions for the specified table,
     * row, and column.
     * 
     * @return list of cells for specified row/column
     * 
     * @param tableName name of table
     * 
     * @param row row key
     * 
     * @param column column name
     * 
     * @param numVersions number of versions to retrieve
     * 
     * @param attributes Get attributes
     */
    public List<TCell> getVer(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, int numVersions, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get the specified number of versions for the specified table,
     * row, and column.  Only versions less than or equal to the specified
     * timestamp will be returned.
     * 
     * @return list of cells for specified row/column
     * 
     * @param tableName name of table
     * 
     * @param row row key
     * 
     * @param column column name
     * 
     * @param timestamp timestamp
     * 
     * @param numVersions number of versions to retrieve
     * 
     * @param attributes Get attributes
     */
    public List<TCell> getVerTs(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long timestamp, int numVersions, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get all the data for the specified table and row at the latest
     * timestamp. Returns an empty list if the row does not exist.
     * 
     * @return TRowResult containing the row and map of columns to TCells
     * 
     * @param tableName name of table
     * 
     * @param row row key
     * 
     * @param attributes Get attributes
     */
    public List<TRowResult> getRow(ByteBuffer tableName, ByteBuffer row, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get the specified columns for the specified table and row at the latest
     * timestamp. Returns an empty list if the row does not exist.
     * 
     * @return TRowResult containing the row and map of columns to TCells
     * 
     * @param tableName name of table
     * 
     * @param row row key
     * 
     * @param columns List of columns to return, null for all columns
     * 
     * @param attributes Get attributes
     */
    public List<TRowResult> getRowWithColumns(ByteBuffer tableName, ByteBuffer row, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get all the data for the specified table and row at the specified
     * timestamp. Returns an empty list if the row does not exist.
     * 
     * @return TRowResult containing the row and map of columns to TCells
     * 
     * @param tableName name of the table
     * 
     * @param row row key
     * 
     * @param timestamp timestamp
     * 
     * @param attributes Get attributes
     */
    public List<TRowResult> getRowTs(ByteBuffer tableName, ByteBuffer row, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get the specified columns for the specified table and row at the specified
     * timestamp. Returns an empty list if the row does not exist.
     * 
     * @return TRowResult containing the row and map of columns to TCells
     * 
     * @param tableName name of table
     * 
     * @param row row key
     * 
     * @param columns List of columns to return, null for all columns
     * 
     * @param timestamp
     * @param attributes Get attributes
     */
    public List<TRowResult> getRowWithColumnsTs(ByteBuffer tableName, ByteBuffer row, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get all the data for the specified table and rows at the latest
     * timestamp. Returns an empty list if no rows exist.
     * 
     * @return TRowResult containing the rows and map of columns to TCells
     * 
     * @param tableName name of table
     * 
     * @param rows row keys
     * 
     * @param attributes Get attributes
     */
    public List<TRowResult> getRows(ByteBuffer tableName, List<ByteBuffer> rows, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get the specified columns for the specified table and rows at the latest
     * timestamp. Returns an empty list if no rows exist.
     * 
     * @return TRowResult containing the rows and map of columns to TCells
     * 
     * @param tableName name of table
     * 
     * @param rows row keys
     * 
     * @param columns List of columns to return, null for all columns
     * 
     * @param attributes Get attributes
     */
    public List<TRowResult> getRowsWithColumns(ByteBuffer tableName, List<ByteBuffer> rows, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get all the data for the specified table and rows at the specified
     * timestamp. Returns an empty list if no rows exist.
     * 
     * @return TRowResult containing the rows and map of columns to TCells
     * 
     * @param tableName name of the table
     * 
     * @param rows row keys
     * 
     * @param timestamp timestamp
     * 
     * @param attributes Get attributes
     */
    public List<TRowResult> getRowsTs(ByteBuffer tableName, List<ByteBuffer> rows, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get the specified columns for the specified table and rows at the specified
     * timestamp. Returns an empty list if no rows exist.
     * 
     * @return TRowResult containing the rows and map of columns to TCells
     * 
     * @param tableName name of table
     * 
     * @param rows row keys
     * 
     * @param columns List of columns to return, null for all columns
     * 
     * @param timestamp
     * @param attributes Get attributes
     */
    public List<TRowResult> getRowsWithColumnsTs(ByteBuffer tableName, List<ByteBuffer> rows, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Apply a series of mutations (updates/deletes) to a row in a
     * single transaction.  If an exception is thrown, then the
     * transaction is aborted.  Default current timestamp is used, and
     * all entries will have an identical timestamp.
     * 
     * @param tableName name of table
     * 
     * @param row row key
     * 
     * @param mutations list of mutation commands
     * 
     * @param attributes Mutation attributes
     */
    public void mutateRow(ByteBuffer tableName, ByteBuffer row, List<Mutation> mutations, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, IllegalArgument, org.apache.thrift.TException;

    /**
     * Apply a series of mutations (updates/deletes) to a row in a
     * single transaction.  If an exception is thrown, then the
     * transaction is aborted.  The specified timestamp is used, and
     * all entries will have an identical timestamp.
     * 
     * @param tableName name of table
     * 
     * @param row row key
     * 
     * @param mutations list of mutation commands
     * 
     * @param timestamp timestamp
     * 
     * @param attributes Mutation attributes
     */
    public void mutateRowTs(ByteBuffer tableName, ByteBuffer row, List<Mutation> mutations, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, IllegalArgument, org.apache.thrift.TException;

    /**
     * Apply a series of batches (each a series of mutations on a single row)
     * in a single transaction.  If an exception is thrown, then the
     * transaction is aborted.  Default current timestamp is used, and
     * all entries will have an identical timestamp.
     * 
     * @param tableName name of table
     * 
     * @param rowBatches list of row batches
     * 
     * @param attributes Mutation attributes
     */
    public void mutateRows(ByteBuffer tableName, List<BatchMutation> rowBatches, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, IllegalArgument, org.apache.thrift.TException;

    /**
     * Apply a series of batches (each a series of mutations on a single row)
     * in a single transaction.  If an exception is thrown, then the
     * transaction is aborted.  The specified timestamp is used, and
     * all entries will have an identical timestamp.
     * 
     * @param tableName name of table
     * 
     * @param rowBatches list of row batches
     * 
     * @param timestamp timestamp
     * 
     * @param attributes Mutation attributes
     */
    public void mutateRowsTs(ByteBuffer tableName, List<BatchMutation> rowBatches, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, IllegalArgument, org.apache.thrift.TException;

    /**
     * Atomically increment the column value specified.  Returns the next value post increment.
     * 
     * @param tableName name of table
     * 
     * @param row row to increment
     * 
     * @param column name of column
     * 
     * @param value amount to increment by
     */
    public long atomicIncrement(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long value) throws IOError, IllegalArgument, org.apache.thrift.TException;

    /**
     * Delete all cells that match the passed row and column.
     * 
     * @param tableName name of table
     * 
     * @param row Row to update
     * 
     * @param column name of column whose value is to be deleted
     * 
     * @param attributes Delete attributes
     */
    public void deleteAll(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Delete all cells that match the passed row and column and whose
     * timestamp is equal-to or older than the passed timestamp.
     * 
     * @param tableName name of table
     * 
     * @param row Row to update
     * 
     * @param column name of column whose value is to be deleted
     * 
     * @param timestamp timestamp
     * 
     * @param attributes Delete attributes
     */
    public void deleteAllTs(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Completely delete the row's cells.
     * 
     * @param tableName name of table
     * 
     * @param row key of the row to be completely deleted.
     * 
     * @param attributes Delete attributes
     */
    public void deleteAllRow(ByteBuffer tableName, ByteBuffer row, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Increment a cell by the ammount.
     * Increments can be applied async if hbase.regionserver.thrift.coalesceIncrement is set to true.
     * False is the default.  Turn to true if you need the extra performance and can accept some
     * data loss if a thrift server dies with increments still in the queue.
     * 
     * @param increment The single increment to apply
     */
    public void increment(TIncrement increment) throws IOError, org.apache.thrift.TException;

    public void incrementRows(List<TIncrement> increments) throws IOError, org.apache.thrift.TException;

    /**
     * Completely delete the row's cells marked with a timestamp
     * equal-to or older than the passed timestamp.
     * 
     * @param tableName name of table
     * 
     * @param row key of the row to be completely deleted.
     * 
     * @param timestamp timestamp
     * 
     * @param attributes Delete attributes
     */
    public void deleteAllRowTs(ByteBuffer tableName, ByteBuffer row, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get a scanner on the current table, using the Scan instance
     * for the scan parameters.
     * 
     * @param tableName name of table
     * 
     * @param scan Scan instance
     * 
     * @param attributes Scan attributes
     */
    public int scannerOpenWithScan(ByteBuffer tableName, TScan scan, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get a scanner on the current table starting at the specified row and
     * ending at the last row in the table.  Return the specified columns.
     * 
     * @return scanner id to be used with other scanner procedures
     * 
     * @param tableName name of table
     * 
     * @param startRow Starting row in table to scan.
     * Send "" (empty string) to start at the first row.
     * 
     * @param columns columns to scan. If column name is a column family, all
     * columns of the specified column family are returned. It's also possible
     * to pass a regex in the column qualifier.
     * 
     * @param attributes Scan attributes
     */
    public int scannerOpen(ByteBuffer tableName, ByteBuffer startRow, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get a scanner on the current table starting and stopping at the
     * specified rows.  ending at the last row in the table.  Return the
     * specified columns.
     * 
     * @return scanner id to be used with other scanner procedures
     * 
     * @param tableName name of table
     * 
     * @param startRow Starting row in table to scan.
     * Send "" (empty string) to start at the first row.
     * 
     * @param stopRow row to stop scanning on. This row is *not* included in the
     * scanner's results
     * 
     * @param columns columns to scan. If column name is a column family, all
     * columns of the specified column family are returned. It's also possible
     * to pass a regex in the column qualifier.
     * 
     * @param attributes Scan attributes
     */
    public int scannerOpenWithStop(ByteBuffer tableName, ByteBuffer startRow, ByteBuffer stopRow, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Open a scanner for a given prefix.  That is all rows will have the specified
     * prefix. No other rows will be returned.
     * 
     * @return scanner id to use with other scanner calls
     * 
     * @param tableName name of table
     * 
     * @param startAndPrefix the prefix (and thus start row) of the keys you want
     * 
     * @param columns the columns you want returned
     * 
     * @param attributes Scan attributes
     */
    public int scannerOpenWithPrefix(ByteBuffer tableName, ByteBuffer startAndPrefix, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get a scanner on the current table starting at the specified row and
     * ending at the last row in the table.  Return the specified columns.
     * Only values with the specified timestamp are returned.
     * 
     * @return scanner id to be used with other scanner procedures
     * 
     * @param tableName name of table
     * 
     * @param startRow Starting row in table to scan.
     * Send "" (empty string) to start at the first row.
     * 
     * @param columns columns to scan. If column name is a column family, all
     * columns of the specified column family are returned. It's also possible
     * to pass a regex in the column qualifier.
     * 
     * @param timestamp timestamp
     * 
     * @param attributes Scan attributes
     */
    public int scannerOpenTs(ByteBuffer tableName, ByteBuffer startRow, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get a scanner on the current table starting and stopping at the
     * specified rows.  ending at the last row in the table.  Return the
     * specified columns.  Only values with the specified timestamp are
     * returned.
     * 
     * @return scanner id to be used with other scanner procedures
     * 
     * @param tableName name of table
     * 
     * @param startRow Starting row in table to scan.
     * Send "" (empty string) to start at the first row.
     * 
     * @param stopRow row to stop scanning on. This row is *not* included in the
     * scanner's results
     * 
     * @param columns columns to scan. If column name is a column family, all
     * columns of the specified column family are returned. It's also possible
     * to pass a regex in the column qualifier.
     * 
     * @param timestamp timestamp
     * 
     * @param attributes Scan attributes
     */
    public int scannerOpenWithStopTs(ByteBuffer tableName, ByteBuffer startRow, ByteBuffer stopRow, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Returns the scanner's current row value and advances to the next
     * row in the table.  When there are no more rows in the table, or a key
     * greater-than-or-equal-to the scanner's specified stopRow is reached,
     * an empty list is returned.
     * 
     * @return a TRowResult containing the current row and a map of the columns to TCells.
     * 
     * @throws IllegalArgument if ScannerID is invalid
     * 
     * @throws NotFound when the scanner reaches the end
     * 
     * @param id id of a scanner returned by scannerOpen
     */
    public List<TRowResult> scannerGet(int id) throws IOError, IllegalArgument, org.apache.thrift.TException;

    /**
     * Returns, starting at the scanner's current row value nbRows worth of
     * rows and advances to the next row in the table.  When there are no more
     * rows in the table, or a key greater-than-or-equal-to the scanner's
     * specified stopRow is reached,  an empty list is returned.
     * 
     * @return a TRowResult containing the current row and a map of the columns to TCells.
     * 
     * @throws IllegalArgument if ScannerID is invalid
     * 
     * @throws NotFound when the scanner reaches the end
     * 
     * @param id id of a scanner returned by scannerOpen
     * 
     * @param nbRows number of results to return
     */
    public List<TRowResult> scannerGetList(int id, int nbRows) throws IOError, IllegalArgument, org.apache.thrift.TException;

    /**
     * Closes the server-state associated with an open scanner.
     * 
     * @throws IllegalArgument if ScannerID is invalid
     * 
     * @param id id of a scanner returned by scannerOpen
     */
    public void scannerClose(int id) throws IOError, IllegalArgument, org.apache.thrift.TException;

    /**
     * Get the row just before the specified one.
     * 
     * @return value for specified row/column
     * 
     * @param tableName name of table
     * 
     * @param row row key
     * 
     * @param family column name
     */
    public List<TCell> getRowOrBefore(ByteBuffer tableName, ByteBuffer row, ByteBuffer family) throws IOError, org.apache.thrift.TException;

    /**
     * Get the regininfo for the specified row. It scans
     * the metatable to find region's start and end keys.
     * 
     * @return value for specified row/column
     * 
     * @param row row key
     */
    public TRegionInfo getRegionInfo(ByteBuffer row) throws IOError, org.apache.thrift.TException;

    /**
     * Appends values to one or more columns within a single row.
     * 
     * @return values of columns after the append operation.
     * 
     * @param append The single append operation to apply
     */
    public List<TCell> append(TAppend append) throws IOError, org.apache.thrift.TException;

    /**
     * Atomically checks if a row/family/qualifier value matches the expected
     * value. If it does, it adds the corresponding mutation operation for put.
     * 
     * @return true if the new put was executed, false otherwise
     * 
     * @param tableName name of table
     * 
     * @param row row key
     * 
     * @param column column name
     * 
     * @param value the expected value for the column parameter, if not
     * provided the check is for the non-existence of the
     * column in question
     * 
     * @param mput mutation for the put
     * 
     * @param attributes Mutation attributes
     */
    public boolean checkAndPut(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, ByteBuffer value, Mutation mput, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, IllegalArgument, org.apache.thrift.TException;

  }

  public interface AsyncIface {

    public void enableTable(ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.enableTable_call> resultHandler) throws org.apache.thrift.TException;

    public void disableTable(ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.disableTable_call> resultHandler) throws org.apache.thrift.TException;

    public void isTableEnabled(ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.isTableEnabled_call> resultHandler) throws org.apache.thrift.TException;

    public void compact(ByteBuffer tableNameOrRegionName, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.compact_call> resultHandler) throws org.apache.thrift.TException;

    public void majorCompact(ByteBuffer tableNameOrRegionName, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.majorCompact_call> resultHandler) throws org.apache.thrift.TException;

    public void getTableNames(org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getTableNames_call> resultHandler) throws org.apache.thrift.TException;

    public void getColumnDescriptors(ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getColumnDescriptors_call> resultHandler) throws org.apache.thrift.TException;

    public void getTableRegions(ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getTableRegions_call> resultHandler) throws org.apache.thrift.TException;

    public void createTable(ByteBuffer tableName, List<ColumnDescriptor> columnFamilies, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.createTable_call> resultHandler) throws org.apache.thrift.TException;

    public void deleteTable(ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.deleteTable_call> resultHandler) throws org.apache.thrift.TException;

    public void get(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.get_call> resultHandler) throws org.apache.thrift.TException;

    public void getVer(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, int numVersions, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getVer_call> resultHandler) throws org.apache.thrift.TException;

    public void getVerTs(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long timestamp, int numVersions, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getVerTs_call> resultHandler) throws org.apache.thrift.TException;

    public void getRow(ByteBuffer tableName, ByteBuffer row, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getRow_call> resultHandler) throws org.apache.thrift.TException;

    public void getRowWithColumns(ByteBuffer tableName, ByteBuffer row, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getRowWithColumns_call> resultHandler) throws org.apache.thrift.TException;

    public void getRowTs(ByteBuffer tableName, ByteBuffer row, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getRowTs_call> resultHandler) throws org.apache.thrift.TException;

    public void getRowWithColumnsTs(ByteBuffer tableName, ByteBuffer row, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getRowWithColumnsTs_call> resultHandler) throws org.apache.thrift.TException;

    public void getRows(ByteBuffer tableName, List<ByteBuffer> rows, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getRows_call> resultHandler) throws org.apache.thrift.TException;

    public void getRowsWithColumns(ByteBuffer tableName, List<ByteBuffer> rows, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getRowsWithColumns_call> resultHandler) throws org.apache.thrift.TException;

    public void getRowsTs(ByteBuffer tableName, List<ByteBuffer> rows, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getRowsTs_call> resultHandler) throws org.apache.thrift.TException;

    public void getRowsWithColumnsTs(ByteBuffer tableName, List<ByteBuffer> rows, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getRowsWithColumnsTs_call> resultHandler) throws org.apache.thrift.TException;

    public void mutateRow(ByteBuffer tableName, ByteBuffer row, List<Mutation> mutations, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.mutateRow_call> resultHandler) throws org.apache.thrift.TException;

    public void mutateRowTs(ByteBuffer tableName, ByteBuffer row, List<Mutation> mutations, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.mutateRowTs_call> resultHandler) throws org.apache.thrift.TException;

    public void mutateRows(ByteBuffer tableName, List<BatchMutation> rowBatches, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.mutateRows_call> resultHandler) throws org.apache.thrift.TException;

    public void mutateRowsTs(ByteBuffer tableName, List<BatchMutation> rowBatches, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.mutateRowsTs_call> resultHandler) throws org.apache.thrift.TException;

    public void atomicIncrement(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long value, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.atomicIncrement_call> resultHandler) throws org.apache.thrift.TException;

    public void deleteAll(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.deleteAll_call> resultHandler) throws org.apache.thrift.TException;

    public void deleteAllTs(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.deleteAllTs_call> resultHandler) throws org.apache.thrift.TException;

    public void deleteAllRow(ByteBuffer tableName, ByteBuffer row, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.deleteAllRow_call> resultHandler) throws org.apache.thrift.TException;

    public void increment(TIncrement increment, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.increment_call> resultHandler) throws org.apache.thrift.TException;

    public void incrementRows(List<TIncrement> increments, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.incrementRows_call> resultHandler) throws org.apache.thrift.TException;

    public void deleteAllRowTs(ByteBuffer tableName, ByteBuffer row, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.deleteAllRowTs_call> resultHandler) throws org.apache.thrift.TException;

    public void scannerOpenWithScan(ByteBuffer tableName, TScan scan, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.scannerOpenWithScan_call> resultHandler) throws org.apache.thrift.TException;

    public void scannerOpen(ByteBuffer tableName, ByteBuffer startRow, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.scannerOpen_call> resultHandler) throws org.apache.thrift.TException;

    public void scannerOpenWithStop(ByteBuffer tableName, ByteBuffer startRow, ByteBuffer stopRow, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.scannerOpenWithStop_call> resultHandler) throws org.apache.thrift.TException;

    public void scannerOpenWithPrefix(ByteBuffer tableName, ByteBuffer startAndPrefix, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.scannerOpenWithPrefix_call> resultHandler) throws org.apache.thrift.TException;

    public void scannerOpenTs(ByteBuffer tableName, ByteBuffer startRow, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.scannerOpenTs_call> resultHandler) throws org.apache.thrift.TException;

    public void scannerOpenWithStopTs(ByteBuffer tableName, ByteBuffer startRow, ByteBuffer stopRow, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.scannerOpenWithStopTs_call> resultHandler) throws org.apache.thrift.TException;

    public void scannerGet(int id, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.scannerGet_call> resultHandler) throws org.apache.thrift.TException;

    public void scannerGetList(int id, int nbRows, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.scannerGetList_call> resultHandler) throws org.apache.thrift.TException;

    public void scannerClose(int id, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.scannerClose_call> resultHandler) throws org.apache.thrift.TException;

    public void getRowOrBefore(ByteBuffer tableName, ByteBuffer row, ByteBuffer family, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getRowOrBefore_call> resultHandler) throws org.apache.thrift.TException;

    public void getRegionInfo(ByteBuffer row, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.getRegionInfo_call> resultHandler) throws org.apache.thrift.TException;

    public void append(TAppend append, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.append_call> resultHandler) throws org.apache.thrift.TException;

    public void checkAndPut(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, ByteBuffer value, Mutation mput, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.checkAndPut_call> resultHandler) throws org.apache.thrift.TException;

  }

  public static class Client extends org.apache.thrift.TServiceClient implements Iface {
    public static class Factory implements org.apache.thrift.TServiceClientFactory<Client> {
      public Factory() {}
      public Client getClient(org.apache.thrift.protocol.TProtocol prot) {
        return new Client(prot);
      }
      public Client getClient(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
        return new Client(iprot, oprot);
      }
    }

    public Client(org.apache.thrift.protocol.TProtocol prot)
    {
      super(prot, prot);
    }

    public Client(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
      super(iprot, oprot);
    }

    public void enableTable(ByteBuffer tableName) throws IOError, org.apache.thrift.TException
    {
      send_enableTable(tableName);
      recv_enableTable();
    }

    public void send_enableTable(ByteBuffer tableName) throws org.apache.thrift.TException
    {
      enableTable_args args = new enableTable_args();
      args.setTableName(tableName);
      sendBase("enableTable", args);
    }

    public void recv_enableTable() throws IOError, org.apache.thrift.TException
    {
      enableTable_result result = new enableTable_result();
      receiveBase(result, "enableTable");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void disableTable(ByteBuffer tableName) throws IOError, org.apache.thrift.TException
    {
      send_disableTable(tableName);
      recv_disableTable();
    }

    public void send_disableTable(ByteBuffer tableName) throws org.apache.thrift.TException
    {
      disableTable_args args = new disableTable_args();
      args.setTableName(tableName);
      sendBase("disableTable", args);
    }

    public void recv_disableTable() throws IOError, org.apache.thrift.TException
    {
      disableTable_result result = new disableTable_result();
      receiveBase(result, "disableTable");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public boolean isTableEnabled(ByteBuffer tableName) throws IOError, org.apache.thrift.TException
    {
      send_isTableEnabled(tableName);
      return recv_isTableEnabled();
    }

    public void send_isTableEnabled(ByteBuffer tableName) throws org.apache.thrift.TException
    {
      isTableEnabled_args args = new isTableEnabled_args();
      args.setTableName(tableName);
      sendBase("isTableEnabled", args);
    }

    public boolean recv_isTableEnabled() throws IOError, org.apache.thrift.TException
    {
      isTableEnabled_result result = new isTableEnabled_result();
      receiveBase(result, "isTableEnabled");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "isTableEnabled failed: unknown result");
    }

    public void compact(ByteBuffer tableNameOrRegionName) throws IOError, org.apache.thrift.TException
    {
      send_compact(tableNameOrRegionName);
      recv_compact();
    }

    public void send_compact(ByteBuffer tableNameOrRegionName) throws org.apache.thrift.TException
    {
      compact_args args = new compact_args();
      args.setTableNameOrRegionName(tableNameOrRegionName);
      sendBase("compact", args);
    }

    public void recv_compact() throws IOError, org.apache.thrift.TException
    {
      compact_result result = new compact_result();
      receiveBase(result, "compact");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void majorCompact(ByteBuffer tableNameOrRegionName) throws IOError, org.apache.thrift.TException
    {
      send_majorCompact(tableNameOrRegionName);
      recv_majorCompact();
    }

    public void send_majorCompact(ByteBuffer tableNameOrRegionName) throws org.apache.thrift.TException
    {
      majorCompact_args args = new majorCompact_args();
      args.setTableNameOrRegionName(tableNameOrRegionName);
      sendBase("majorCompact", args);
    }

    public void recv_majorCompact() throws IOError, org.apache.thrift.TException
    {
      majorCompact_result result = new majorCompact_result();
      receiveBase(result, "majorCompact");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public List<ByteBuffer> getTableNames() throws IOError, org.apache.thrift.TException
    {
      send_getTableNames();
      return recv_getTableNames();
    }

    public void send_getTableNames() throws org.apache.thrift.TException
    {
      getTableNames_args args = new getTableNames_args();
      sendBase("getTableNames", args);
    }

    public List<ByteBuffer> recv_getTableNames() throws IOError, org.apache.thrift.TException
    {
      getTableNames_result result = new getTableNames_result();
      receiveBase(result, "getTableNames");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTableNames failed: unknown result");
    }

    public Map<ByteBuffer,ColumnDescriptor> getColumnDescriptors(ByteBuffer tableName) throws IOError, org.apache.thrift.TException
    {
      send_getColumnDescriptors(tableName);
      return recv_getColumnDescriptors();
    }

    public void send_getColumnDescriptors(ByteBuffer tableName) throws org.apache.thrift.TException
    {
      getColumnDescriptors_args args = new getColumnDescriptors_args();
      args.setTableName(tableName);
      sendBase("getColumnDescriptors", args);
    }

    public Map<ByteBuffer,ColumnDescriptor> recv_getColumnDescriptors() throws IOError, org.apache.thrift.TException
    {
      getColumnDescriptors_result result = new getColumnDescriptors_result();
      receiveBase(result, "getColumnDescriptors");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getColumnDescriptors failed: unknown result");
    }

    public List<TRegionInfo> getTableRegions(ByteBuffer tableName) throws IOError, org.apache.thrift.TException
    {
      send_getTableRegions(tableName);
      return recv_getTableRegions();
    }

    public void send_getTableRegions(ByteBuffer tableName) throws org.apache.thrift.TException
    {
      getTableRegions_args args = new getTableRegions_args();
      args.setTableName(tableName);
      sendBase("getTableRegions", args);
    }

    public List<TRegionInfo> recv_getTableRegions() throws IOError, org.apache.thrift.TException
    {
      getTableRegions_result result = new getTableRegions_result();
      receiveBase(result, "getTableRegions");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTableRegions failed: unknown result");
    }

    public void createTable(ByteBuffer tableName, List<ColumnDescriptor> columnFamilies) throws IOError, IllegalArgument, AlreadyExists, org.apache.thrift.TException
    {
      send_createTable(tableName, columnFamilies);
      recv_createTable();
    }

    public void send_createTable(ByteBuffer tableName, List<ColumnDescriptor> columnFamilies) throws org.apache.thrift.TException
    {
      createTable_args args = new createTable_args();
      args.setTableName(tableName);
      args.setColumnFamilies(columnFamilies);
      sendBase("createTable", args);
    }

    public void recv_createTable() throws IOError, IllegalArgument, AlreadyExists, org.apache.thrift.TException
    {
      createTable_result result = new createTable_result();
      receiveBase(result, "createTable");
      if (result.io != null) {
        throw result.io;
      }
      if (result.ia != null) {
        throw result.ia;
      }
      if (result.exist != null) {
        throw result.exist;
      }
      return;
    }

    public void deleteTable(ByteBuffer tableName) throws IOError, org.apache.thrift.TException
    {
      send_deleteTable(tableName);
      recv_deleteTable();
    }

    public void send_deleteTable(ByteBuffer tableName) throws org.apache.thrift.TException
    {
      deleteTable_args args = new deleteTable_args();
      args.setTableName(tableName);
      sendBase("deleteTable", args);
    }

    public void recv_deleteTable() throws IOError, org.apache.thrift.TException
    {
      deleteTable_result result = new deleteTable_result();
      receiveBase(result, "deleteTable");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public List<TCell> get(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_get(tableName, row, column, attributes);
      return recv_get();
    }

    public void send_get(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      get_args args = new get_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setColumn(column);
      args.setAttributes(attributes);
      sendBase("get", args);
    }

    public List<TCell> recv_get() throws IOError, org.apache.thrift.TException
    {
      get_result result = new get_result();
      receiveBase(result, "get");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "get failed: unknown result");
    }

    public List<TCell> getVer(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, int numVersions, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_getVer(tableName, row, column, numVersions, attributes);
      return recv_getVer();
    }

    public void send_getVer(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, int numVersions, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      getVer_args args = new getVer_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setColumn(column);
      args.setNumVersions(numVersions);
      args.setAttributes(attributes);
      sendBase("getVer", args);
    }

    public List<TCell> recv_getVer() throws IOError, org.apache.thrift.TException
    {
      getVer_result result = new getVer_result();
      receiveBase(result, "getVer");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getVer failed: unknown result");
    }

    public List<TCell> getVerTs(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long timestamp, int numVersions, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_getVerTs(tableName, row, column, timestamp, numVersions, attributes);
      return recv_getVerTs();
    }

    public void send_getVerTs(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long timestamp, int numVersions, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      getVerTs_args args = new getVerTs_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setColumn(column);
      args.setTimestamp(timestamp);
      args.setNumVersions(numVersions);
      args.setAttributes(attributes);
      sendBase("getVerTs", args);
    }

    public List<TCell> recv_getVerTs() throws IOError, org.apache.thrift.TException
    {
      getVerTs_result result = new getVerTs_result();
      receiveBase(result, "getVerTs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getVerTs failed: unknown result");
    }

    public List<TRowResult> getRow(ByteBuffer tableName, ByteBuffer row, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_getRow(tableName, row, attributes);
      return recv_getRow();
    }

    public void send_getRow(ByteBuffer tableName, ByteBuffer row, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      getRow_args args = new getRow_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setAttributes(attributes);
      sendBase("getRow", args);
    }

    public List<TRowResult> recv_getRow() throws IOError, org.apache.thrift.TException
    {
      getRow_result result = new getRow_result();
      receiveBase(result, "getRow");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRow failed: unknown result");
    }

    public List<TRowResult> getRowWithColumns(ByteBuffer tableName, ByteBuffer row, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_getRowWithColumns(tableName, row, columns, attributes);
      return recv_getRowWithColumns();
    }

    public void send_getRowWithColumns(ByteBuffer tableName, ByteBuffer row, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      getRowWithColumns_args args = new getRowWithColumns_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setColumns(columns);
      args.setAttributes(attributes);
      sendBase("getRowWithColumns", args);
    }

    public List<TRowResult> recv_getRowWithColumns() throws IOError, org.apache.thrift.TException
    {
      getRowWithColumns_result result = new getRowWithColumns_result();
      receiveBase(result, "getRowWithColumns");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRowWithColumns failed: unknown result");
    }

    public List<TRowResult> getRowTs(ByteBuffer tableName, ByteBuffer row, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_getRowTs(tableName, row, timestamp, attributes);
      return recv_getRowTs();
    }

    public void send_getRowTs(ByteBuffer tableName, ByteBuffer row, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      getRowTs_args args = new getRowTs_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setTimestamp(timestamp);
      args.setAttributes(attributes);
      sendBase("getRowTs", args);
    }

    public List<TRowResult> recv_getRowTs() throws IOError, org.apache.thrift.TException
    {
      getRowTs_result result = new getRowTs_result();
      receiveBase(result, "getRowTs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRowTs failed: unknown result");
    }

    public List<TRowResult> getRowWithColumnsTs(ByteBuffer tableName, ByteBuffer row, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_getRowWithColumnsTs(tableName, row, columns, timestamp, attributes);
      return recv_getRowWithColumnsTs();
    }

    public void send_getRowWithColumnsTs(ByteBuffer tableName, ByteBuffer row, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      getRowWithColumnsTs_args args = new getRowWithColumnsTs_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setColumns(columns);
      args.setTimestamp(timestamp);
      args.setAttributes(attributes);
      sendBase("getRowWithColumnsTs", args);
    }

    public List<TRowResult> recv_getRowWithColumnsTs() throws IOError, org.apache.thrift.TException
    {
      getRowWithColumnsTs_result result = new getRowWithColumnsTs_result();
      receiveBase(result, "getRowWithColumnsTs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRowWithColumnsTs failed: unknown result");
    }

    public List<TRowResult> getRows(ByteBuffer tableName, List<ByteBuffer> rows, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_getRows(tableName, rows, attributes);
      return recv_getRows();
    }

    public void send_getRows(ByteBuffer tableName, List<ByteBuffer> rows, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      getRows_args args = new getRows_args();
      args.setTableName(tableName);
      args.setRows(rows);
      args.setAttributes(attributes);
      sendBase("getRows", args);
    }

    public List<TRowResult> recv_getRows() throws IOError, org.apache.thrift.TException
    {
      getRows_result result = new getRows_result();
      receiveBase(result, "getRows");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRows failed: unknown result");
    }

    public List<TRowResult> getRowsWithColumns(ByteBuffer tableName, List<ByteBuffer> rows, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_getRowsWithColumns(tableName, rows, columns, attributes);
      return recv_getRowsWithColumns();
    }

    public void send_getRowsWithColumns(ByteBuffer tableName, List<ByteBuffer> rows, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      getRowsWithColumns_args args = new getRowsWithColumns_args();
      args.setTableName(tableName);
      args.setRows(rows);
      args.setColumns(columns);
      args.setAttributes(attributes);
      sendBase("getRowsWithColumns", args);
    }

    public List<TRowResult> recv_getRowsWithColumns() throws IOError, org.apache.thrift.TException
    {
      getRowsWithColumns_result result = new getRowsWithColumns_result();
      receiveBase(result, "getRowsWithColumns");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRowsWithColumns failed: unknown result");
    }

    public List<TRowResult> getRowsTs(ByteBuffer tableName, List<ByteBuffer> rows, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_getRowsTs(tableName, rows, timestamp, attributes);
      return recv_getRowsTs();
    }

    public void send_getRowsTs(ByteBuffer tableName, List<ByteBuffer> rows, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      getRowsTs_args args = new getRowsTs_args();
      args.setTableName(tableName);
      args.setRows(rows);
      args.setTimestamp(timestamp);
      args.setAttributes(attributes);
      sendBase("getRowsTs", args);
    }

    public List<TRowResult> recv_getRowsTs() throws IOError, org.apache.thrift.TException
    {
      getRowsTs_result result = new getRowsTs_result();
      receiveBase(result, "getRowsTs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRowsTs failed: unknown result");
    }

    public List<TRowResult> getRowsWithColumnsTs(ByteBuffer tableName, List<ByteBuffer> rows, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_getRowsWithColumnsTs(tableName, rows, columns, timestamp, attributes);
      return recv_getRowsWithColumnsTs();
    }

    public void send_getRowsWithColumnsTs(ByteBuffer tableName, List<ByteBuffer> rows, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      getRowsWithColumnsTs_args args = new getRowsWithColumnsTs_args();
      args.setTableName(tableName);
      args.setRows(rows);
      args.setColumns(columns);
      args.setTimestamp(timestamp);
      args.setAttributes(attributes);
      sendBase("getRowsWithColumnsTs", args);
    }

    public List<TRowResult> recv_getRowsWithColumnsTs() throws IOError, org.apache.thrift.TException
    {
      getRowsWithColumnsTs_result result = new getRowsWithColumnsTs_result();
      receiveBase(result, "getRowsWithColumnsTs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRowsWithColumnsTs failed: unknown result");
    }

    public void mutateRow(ByteBuffer tableName, ByteBuffer row, List<Mutation> mutations, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      send_mutateRow(tableName, row, mutations, attributes);
      recv_mutateRow();
    }

    public void send_mutateRow(ByteBuffer tableName, ByteBuffer row, List<Mutation> mutations, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      mutateRow_args args = new mutateRow_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setMutations(mutations);
      args.setAttributes(attributes);
      sendBase("mutateRow", args);
    }

    public void recv_mutateRow() throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      mutateRow_result result = new mutateRow_result();
      receiveBase(result, "mutateRow");
      if (result.io != null) {
        throw result.io;
      }
      if (result.ia != null) {
        throw result.ia;
      }
      return;
    }

    public void mutateRowTs(ByteBuffer tableName, ByteBuffer row, List<Mutation> mutations, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      send_mutateRowTs(tableName, row, mutations, timestamp, attributes);
      recv_mutateRowTs();
    }

    public void send_mutateRowTs(ByteBuffer tableName, ByteBuffer row, List<Mutation> mutations, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      mutateRowTs_args args = new mutateRowTs_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setMutations(mutations);
      args.setTimestamp(timestamp);
      args.setAttributes(attributes);
      sendBase("mutateRowTs", args);
    }

    public void recv_mutateRowTs() throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      mutateRowTs_result result = new mutateRowTs_result();
      receiveBase(result, "mutateRowTs");
      if (result.io != null) {
        throw result.io;
      }
      if (result.ia != null) {
        throw result.ia;
      }
      return;
    }

    public void mutateRows(ByteBuffer tableName, List<BatchMutation> rowBatches, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      send_mutateRows(tableName, rowBatches, attributes);
      recv_mutateRows();
    }

    public void send_mutateRows(ByteBuffer tableName, List<BatchMutation> rowBatches, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      mutateRows_args args = new mutateRows_args();
      args.setTableName(tableName);
      args.setRowBatches(rowBatches);
      args.setAttributes(attributes);
      sendBase("mutateRows", args);
    }

    public void recv_mutateRows() throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      mutateRows_result result = new mutateRows_result();
      receiveBase(result, "mutateRows");
      if (result.io != null) {
        throw result.io;
      }
      if (result.ia != null) {
        throw result.ia;
      }
      return;
    }

    public void mutateRowsTs(ByteBuffer tableName, List<BatchMutation> rowBatches, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      send_mutateRowsTs(tableName, rowBatches, timestamp, attributes);
      recv_mutateRowsTs();
    }

    public void send_mutateRowsTs(ByteBuffer tableName, List<BatchMutation> rowBatches, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      mutateRowsTs_args args = new mutateRowsTs_args();
      args.setTableName(tableName);
      args.setRowBatches(rowBatches);
      args.setTimestamp(timestamp);
      args.setAttributes(attributes);
      sendBase("mutateRowsTs", args);
    }

    public void recv_mutateRowsTs() throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      mutateRowsTs_result result = new mutateRowsTs_result();
      receiveBase(result, "mutateRowsTs");
      if (result.io != null) {
        throw result.io;
      }
      if (result.ia != null) {
        throw result.ia;
      }
      return;
    }

    public long atomicIncrement(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long value) throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      send_atomicIncrement(tableName, row, column, value);
      return recv_atomicIncrement();
    }

    public void send_atomicIncrement(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long value) throws org.apache.thrift.TException
    {
      atomicIncrement_args args = new atomicIncrement_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setColumn(column);
      args.setValue(value);
      sendBase("atomicIncrement", args);
    }

    public long recv_atomicIncrement() throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      atomicIncrement_result result = new atomicIncrement_result();
      receiveBase(result, "atomicIncrement");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      if (result.ia != null) {
        throw result.ia;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "atomicIncrement failed: unknown result");
    }

    public void deleteAll(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_deleteAll(tableName, row, column, attributes);
      recv_deleteAll();
    }

    public void send_deleteAll(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      deleteAll_args args = new deleteAll_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setColumn(column);
      args.setAttributes(attributes);
      sendBase("deleteAll", args);
    }

    public void recv_deleteAll() throws IOError, org.apache.thrift.TException
    {
      deleteAll_result result = new deleteAll_result();
      receiveBase(result, "deleteAll");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void deleteAllTs(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_deleteAllTs(tableName, row, column, timestamp, attributes);
      recv_deleteAllTs();
    }

    public void send_deleteAllTs(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      deleteAllTs_args args = new deleteAllTs_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setColumn(column);
      args.setTimestamp(timestamp);
      args.setAttributes(attributes);
      sendBase("deleteAllTs", args);
    }

    public void recv_deleteAllTs() throws IOError, org.apache.thrift.TException
    {
      deleteAllTs_result result = new deleteAllTs_result();
      receiveBase(result, "deleteAllTs");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void deleteAllRow(ByteBuffer tableName, ByteBuffer row, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_deleteAllRow(tableName, row, attributes);
      recv_deleteAllRow();
    }

    public void send_deleteAllRow(ByteBuffer tableName, ByteBuffer row, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      deleteAllRow_args args = new deleteAllRow_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setAttributes(attributes);
      sendBase("deleteAllRow", args);
    }

    public void recv_deleteAllRow() throws IOError, org.apache.thrift.TException
    {
      deleteAllRow_result result = new deleteAllRow_result();
      receiveBase(result, "deleteAllRow");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void increment(TIncrement increment) throws IOError, org.apache.thrift.TException
    {
      send_increment(increment);
      recv_increment();
    }

    public void send_increment(TIncrement increment) throws org.apache.thrift.TException
    {
      increment_args args = new increment_args();
      args.setIncrement(increment);
      sendBase("increment", args);
    }

    public void recv_increment() throws IOError, org.apache.thrift.TException
    {
      increment_result result = new increment_result();
      receiveBase(result, "increment");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void incrementRows(List<TIncrement> increments) throws IOError, org.apache.thrift.TException
    {
      send_incrementRows(increments);
      recv_incrementRows();
    }

    public void send_incrementRows(List<TIncrement> increments) throws org.apache.thrift.TException
    {
      incrementRows_args args = new incrementRows_args();
      args.setIncrements(increments);
      sendBase("incrementRows", args);
    }

    public void recv_incrementRows() throws IOError, org.apache.thrift.TException
    {
      incrementRows_result result = new incrementRows_result();
      receiveBase(result, "incrementRows");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void deleteAllRowTs(ByteBuffer tableName, ByteBuffer row, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_deleteAllRowTs(tableName, row, timestamp, attributes);
      recv_deleteAllRowTs();
    }

    public void send_deleteAllRowTs(ByteBuffer tableName, ByteBuffer row, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      deleteAllRowTs_args args = new deleteAllRowTs_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setTimestamp(timestamp);
      args.setAttributes(attributes);
      sendBase("deleteAllRowTs", args);
    }

    public void recv_deleteAllRowTs() throws IOError, org.apache.thrift.TException
    {
      deleteAllRowTs_result result = new deleteAllRowTs_result();
      receiveBase(result, "deleteAllRowTs");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public int scannerOpenWithScan(ByteBuffer tableName, TScan scan, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_scannerOpenWithScan(tableName, scan, attributes);
      return recv_scannerOpenWithScan();
    }

    public void send_scannerOpenWithScan(ByteBuffer tableName, TScan scan, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      scannerOpenWithScan_args args = new scannerOpenWithScan_args();
      args.setTableName(tableName);
      args.setScan(scan);
      args.setAttributes(attributes);
      sendBase("scannerOpenWithScan", args);
    }

    public int recv_scannerOpenWithScan() throws IOError, org.apache.thrift.TException
    {
      scannerOpenWithScan_result result = new scannerOpenWithScan_result();
      receiveBase(result, "scannerOpenWithScan");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "scannerOpenWithScan failed: unknown result");
    }

    public int scannerOpen(ByteBuffer tableName, ByteBuffer startRow, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_scannerOpen(tableName, startRow, columns, attributes);
      return recv_scannerOpen();
    }

    public void send_scannerOpen(ByteBuffer tableName, ByteBuffer startRow, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      scannerOpen_args args = new scannerOpen_args();
      args.setTableName(tableName);
      args.setStartRow(startRow);
      args.setColumns(columns);
      args.setAttributes(attributes);
      sendBase("scannerOpen", args);
    }

    public int recv_scannerOpen() throws IOError, org.apache.thrift.TException
    {
      scannerOpen_result result = new scannerOpen_result();
      receiveBase(result, "scannerOpen");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "scannerOpen failed: unknown result");
    }

    public int scannerOpenWithStop(ByteBuffer tableName, ByteBuffer startRow, ByteBuffer stopRow, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_scannerOpenWithStop(tableName, startRow, stopRow, columns, attributes);
      return recv_scannerOpenWithStop();
    }

    public void send_scannerOpenWithStop(ByteBuffer tableName, ByteBuffer startRow, ByteBuffer stopRow, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      scannerOpenWithStop_args args = new scannerOpenWithStop_args();
      args.setTableName(tableName);
      args.setStartRow(startRow);
      args.setStopRow(stopRow);
      args.setColumns(columns);
      args.setAttributes(attributes);
      sendBase("scannerOpenWithStop", args);
    }

    public int recv_scannerOpenWithStop() throws IOError, org.apache.thrift.TException
    {
      scannerOpenWithStop_result result = new scannerOpenWithStop_result();
      receiveBase(result, "scannerOpenWithStop");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "scannerOpenWithStop failed: unknown result");
    }

    public int scannerOpenWithPrefix(ByteBuffer tableName, ByteBuffer startAndPrefix, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_scannerOpenWithPrefix(tableName, startAndPrefix, columns, attributes);
      return recv_scannerOpenWithPrefix();
    }

    public void send_scannerOpenWithPrefix(ByteBuffer tableName, ByteBuffer startAndPrefix, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      scannerOpenWithPrefix_args args = new scannerOpenWithPrefix_args();
      args.setTableName(tableName);
      args.setStartAndPrefix(startAndPrefix);
      args.setColumns(columns);
      args.setAttributes(attributes);
      sendBase("scannerOpenWithPrefix", args);
    }

    public int recv_scannerOpenWithPrefix() throws IOError, org.apache.thrift.TException
    {
      scannerOpenWithPrefix_result result = new scannerOpenWithPrefix_result();
      receiveBase(result, "scannerOpenWithPrefix");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "scannerOpenWithPrefix failed: unknown result");
    }

    public int scannerOpenTs(ByteBuffer tableName, ByteBuffer startRow, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_scannerOpenTs(tableName, startRow, columns, timestamp, attributes);
      return recv_scannerOpenTs();
    }

    public void send_scannerOpenTs(ByteBuffer tableName, ByteBuffer startRow, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      scannerOpenTs_args args = new scannerOpenTs_args();
      args.setTableName(tableName);
      args.setStartRow(startRow);
      args.setColumns(columns);
      args.setTimestamp(timestamp);
      args.setAttributes(attributes);
      sendBase("scannerOpenTs", args);
    }

    public int recv_scannerOpenTs() throws IOError, org.apache.thrift.TException
    {
      scannerOpenTs_result result = new scannerOpenTs_result();
      receiveBase(result, "scannerOpenTs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "scannerOpenTs failed: unknown result");
    }

    public int scannerOpenWithStopTs(ByteBuffer tableName, ByteBuffer startRow, ByteBuffer stopRow, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_scannerOpenWithStopTs(tableName, startRow, stopRow, columns, timestamp, attributes);
      return recv_scannerOpenWithStopTs();
    }

    public void send_scannerOpenWithStopTs(ByteBuffer tableName, ByteBuffer startRow, ByteBuffer stopRow, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      scannerOpenWithStopTs_args args = new scannerOpenWithStopTs_args();
      args.setTableName(tableName);
      args.setStartRow(startRow);
      args.setStopRow(stopRow);
      args.setColumns(columns);
      args.setTimestamp(timestamp);
      args.setAttributes(attributes);
      sendBase("scannerOpenWithStopTs", args);
    }

    public int recv_scannerOpenWithStopTs() throws IOError, org.apache.thrift.TException
    {
      scannerOpenWithStopTs_result result = new scannerOpenWithStopTs_result();
      receiveBase(result, "scannerOpenWithStopTs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "scannerOpenWithStopTs failed: unknown result");
    }

    public List<TRowResult> scannerGet(int id) throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      send_scannerGet(id);
      return recv_scannerGet();
    }

    public void send_scannerGet(int id) throws org.apache.thrift.TException
    {
      scannerGet_args args = new scannerGet_args();
      args.setId(id);
      sendBase("scannerGet", args);
    }

    public List<TRowResult> recv_scannerGet() throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      scannerGet_result result = new scannerGet_result();
      receiveBase(result, "scannerGet");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      if (result.ia != null) {
        throw result.ia;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "scannerGet failed: unknown result");
    }

    public List<TRowResult> scannerGetList(int id, int nbRows) throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      send_scannerGetList(id, nbRows);
      return recv_scannerGetList();
    }

    public void send_scannerGetList(int id, int nbRows) throws org.apache.thrift.TException
    {
      scannerGetList_args args = new scannerGetList_args();
      args.setId(id);
      args.setNbRows(nbRows);
      sendBase("scannerGetList", args);
    }

    public List<TRowResult> recv_scannerGetList() throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      scannerGetList_result result = new scannerGetList_result();
      receiveBase(result, "scannerGetList");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      if (result.ia != null) {
        throw result.ia;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "scannerGetList failed: unknown result");
    }

    public void scannerClose(int id) throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      send_scannerClose(id);
      recv_scannerClose();
    }

    public void send_scannerClose(int id) throws org.apache.thrift.TException
    {
      scannerClose_args args = new scannerClose_args();
      args.setId(id);
      sendBase("scannerClose", args);
    }

    public void recv_scannerClose() throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      scannerClose_result result = new scannerClose_result();
      receiveBase(result, "scannerClose");
      if (result.io != null) {
        throw result.io;
      }
      if (result.ia != null) {
        throw result.ia;
      }
      return;
    }

    public List<TCell> getRowOrBefore(ByteBuffer tableName, ByteBuffer row, ByteBuffer family) throws IOError, org.apache.thrift.TException
    {
      send_getRowOrBefore(tableName, row, family);
      return recv_getRowOrBefore();
    }

    public void send_getRowOrBefore(ByteBuffer tableName, ByteBuffer row, ByteBuffer family) throws org.apache.thrift.TException
    {
      getRowOrBefore_args args = new getRowOrBefore_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setFamily(family);
      sendBase("getRowOrBefore", args);
    }

    public List<TCell> recv_getRowOrBefore() throws IOError, org.apache.thrift.TException
    {
      getRowOrBefore_result result = new getRowOrBefore_result();
      receiveBase(result, "getRowOrBefore");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRowOrBefore failed: unknown result");
    }

    public TRegionInfo getRegionInfo(ByteBuffer row) throws IOError, org.apache.thrift.TException
    {
      send_getRegionInfo(row);
      return recv_getRegionInfo();
    }

    public void send_getRegionInfo(ByteBuffer row) throws org.apache.thrift.TException
    {
      getRegionInfo_args args = new getRegionInfo_args();
      args.setRow(row);
      sendBase("getRegionInfo", args);
    }

    public TRegionInfo recv_getRegionInfo() throws IOError, org.apache.thrift.TException
    {
      getRegionInfo_result result = new getRegionInfo_result();
      receiveBase(result, "getRegionInfo");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRegionInfo failed: unknown result");
    }

    public List<TCell> append(TAppend append) throws IOError, org.apache.thrift.TException
    {
      send_append(append);
      return recv_append();
    }

    public void send_append(TAppend append) throws org.apache.thrift.TException
    {
      append_args args = new append_args();
      args.setAppend(append);
      sendBase("append", args);
    }

    public List<TCell> recv_append() throws IOError, org.apache.thrift.TException
    {
      append_result result = new append_result();
      receiveBase(result, "append");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "append failed: unknown result");
    }

    public boolean checkAndPut(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, ByteBuffer value, Mutation mput, Map<ByteBuffer,ByteBuffer> attributes) throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      send_checkAndPut(tableName, row, column, value, mput, attributes);
      return recv_checkAndPut();
    }

    public void send_checkAndPut(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, ByteBuffer value, Mutation mput, Map<ByteBuffer,ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      checkAndPut_args args = new checkAndPut_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setColumn(column);
      args.setValue(value);
      args.setMput(mput);
      args.setAttributes(attributes);
      sendBase("checkAndPut", args);
    }

    public boolean recv_checkAndPut() throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      checkAndPut_result result = new checkAndPut_result();
      receiveBase(result, "checkAndPut");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      if (result.ia != null) {
        throw result.ia;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "checkAndPut failed: unknown result");
    }

  }
  public static class AsyncClient extends org.apache.thrift.async.TAsyncClient implements AsyncIface {
    public static class Factory implements org.apache.thrift.async.TAsyncClientFactory<AsyncClient> {
      private org.apache.thrift.async.TAsyncClientManager clientManager;
      private org.apache.thrift.protocol.TProtocolFactory protocolFactory;
      public Factory(org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.protocol.TProtocolFactory protocolFactory) {
        this.clientManager = clientManager;
        this.protocolFactory = protocolFactory;
      }
      public AsyncClient getAsyncClient(org.apache.thrift.transport.TNonblockingTransport transport) {
        return new AsyncClient(protocolFactory, clientManager, transport);
      }
    }

    public AsyncClient(org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.transport.TNonblockingTransport transport) {
      super(protocolFactory, clientManager, transport);
    }

    public void enableTable(ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<enableTable_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      enableTable_call method_call = new enableTable_call(tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class enableTable_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      public enableTable_call(ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<enableTable_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("enableTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        enableTable_args args = new enableTable_args();
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_enableTable();
      }
    }

    public void disableTable(ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<disableTable_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      disableTable_call method_call = new disableTable_call(tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class disableTable_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      public disableTable_call(ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<disableTable_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("disableTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        disableTable_args args = new disableTable_args();
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_disableTable();
      }
    }

    public void isTableEnabled(ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<isTableEnabled_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      isTableEnabled_call method_call = new isTableEnabled_call(tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class isTableEnabled_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      public isTableEnabled_call(ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<isTableEnabled_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("isTableEnabled", org.apache.thrift.protocol.TMessageType.CALL, 0));
        isTableEnabled_args args = new isTableEnabled_args();
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_isTableEnabled();
      }
    }

    public void compact(ByteBuffer tableNameOrRegionName, org.apache.thrift.async.AsyncMethodCallback<compact_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      compact_call method_call = new compact_call(tableNameOrRegionName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class compact_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableNameOrRegionName;
      public compact_call(ByteBuffer tableNameOrRegionName, org.apache.thrift.async.AsyncMethodCallback<compact_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableNameOrRegionName = tableNameOrRegionName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("compact", org.apache.thrift.protocol.TMessageType.CALL, 0));
        compact_args args = new compact_args();
        args.setTableNameOrRegionName(tableNameOrRegionName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_compact();
      }
    }

    public void majorCompact(ByteBuffer tableNameOrRegionName, org.apache.thrift.async.AsyncMethodCallback<majorCompact_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      majorCompact_call method_call = new majorCompact_call(tableNameOrRegionName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class majorCompact_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableNameOrRegionName;
      public majorCompact_call(ByteBuffer tableNameOrRegionName, org.apache.thrift.async.AsyncMethodCallback<majorCompact_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableNameOrRegionName = tableNameOrRegionName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("majorCompact", org.apache.thrift.protocol.TMessageType.CALL, 0));
        majorCompact_args args = new majorCompact_args();
        args.setTableNameOrRegionName(tableNameOrRegionName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_majorCompact();
      }
    }

    public void getTableNames(org.apache.thrift.async.AsyncMethodCallback<getTableNames_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTableNames_call method_call = new getTableNames_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTableNames_call extends org.apache.thrift.async.TAsyncMethodCall {
      public getTableNames_call(org.apache.thrift.async.AsyncMethodCallback<getTableNames_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTableNames", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTableNames_args args = new getTableNames_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<ByteBuffer> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTableNames();
      }
    }

    public void getColumnDescriptors(ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<getColumnDescriptors_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getColumnDescriptors_call method_call = new getColumnDescriptors_call(tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getColumnDescriptors_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      public getColumnDescriptors_call(ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<getColumnDescriptors_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getColumnDescriptors", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getColumnDescriptors_args args = new getColumnDescriptors_args();
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<ByteBuffer,ColumnDescriptor> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getColumnDescriptors();
      }
    }

    public void getTableRegions(ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<getTableRegions_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTableRegions_call method_call = new getTableRegions_call(tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTableRegions_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      public getTableRegions_call(ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<getTableRegions_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTableRegions", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTableRegions_args args = new getTableRegions_args();
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<TRegionInfo> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTableRegions();
      }
    }

    public void createTable(ByteBuffer tableName, List<ColumnDescriptor> columnFamilies, org.apache.thrift.async.AsyncMethodCallback<createTable_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createTable_call method_call = new createTable_call(tableName, columnFamilies, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createTable_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private List<ColumnDescriptor> columnFamilies;
      public createTable_call(ByteBuffer tableName, List<ColumnDescriptor> columnFamilies, org.apache.thrift.async.AsyncMethodCallback<createTable_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.columnFamilies = columnFamilies;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createTable_args args = new createTable_args();
        args.setTableName(tableName);
        args.setColumnFamilies(columnFamilies);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws IOError, IllegalArgument, AlreadyExists, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_createTable();
      }
    }

    public void deleteTable(ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<deleteTable_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteTable_call method_call = new deleteTable_call(tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteTable_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      public deleteTable_call(ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<deleteTable_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteTable_args args = new deleteTable_args();
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_deleteTable();
      }
    }

    public void get(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<get_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      get_call method_call = new get_call(tableName, row, column, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class get_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private ByteBuffer row;
      private ByteBuffer column;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public get_call(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<get_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.column = column;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("get", org.apache.thrift.protocol.TMessageType.CALL, 0));
        get_args args = new get_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setColumn(column);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<TCell> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_get();
      }
    }

    public void getVer(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, int numVersions, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<getVer_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getVer_call method_call = new getVer_call(tableName, row, column, numVersions, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getVer_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private ByteBuffer row;
      private ByteBuffer column;
      private int numVersions;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public getVer_call(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, int numVersions, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<getVer_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.column = column;
        this.numVersions = numVersions;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getVer", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getVer_args args = new getVer_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setColumn(column);
        args.setNumVersions(numVersions);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<TCell> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getVer();
      }
    }

    public void getVerTs(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long timestamp, int numVersions, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<getVerTs_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getVerTs_call method_call = new getVerTs_call(tableName, row, column, timestamp, numVersions, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getVerTs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private ByteBuffer row;
      private ByteBuffer column;
      private long timestamp;
      private int numVersions;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public getVerTs_call(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long timestamp, int numVersions, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<getVerTs_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.column = column;
        this.timestamp = timestamp;
        this.numVersions = numVersions;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getVerTs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getVerTs_args args = new getVerTs_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setColumn(column);
        args.setTimestamp(timestamp);
        args.setNumVersions(numVersions);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<TCell> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getVerTs();
      }
    }

    public void getRow(ByteBuffer tableName, ByteBuffer row, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<getRow_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRow_call method_call = new getRow_call(tableName, row, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRow_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private ByteBuffer row;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public getRow_call(ByteBuffer tableName, ByteBuffer row, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<getRow_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRow", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRow_args args = new getRow_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<TRowResult> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRow();
      }
    }

    public void getRowWithColumns(ByteBuffer tableName, ByteBuffer row, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<getRowWithColumns_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRowWithColumns_call method_call = new getRowWithColumns_call(tableName, row, columns, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRowWithColumns_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private ByteBuffer row;
      private List<ByteBuffer> columns;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public getRowWithColumns_call(ByteBuffer tableName, ByteBuffer row, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<getRowWithColumns_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.columns = columns;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRowWithColumns", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRowWithColumns_args args = new getRowWithColumns_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setColumns(columns);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<TRowResult> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRowWithColumns();
      }
    }

    public void getRowTs(ByteBuffer tableName, ByteBuffer row, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<getRowTs_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRowTs_call method_call = new getRowTs_call(tableName, row, timestamp, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRowTs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private ByteBuffer row;
      private long timestamp;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public getRowTs_call(ByteBuffer tableName, ByteBuffer row, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<getRowTs_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.timestamp = timestamp;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRowTs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRowTs_args args = new getRowTs_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setTimestamp(timestamp);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<TRowResult> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRowTs();
      }
    }

    public void getRowWithColumnsTs(ByteBuffer tableName, ByteBuffer row, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<getRowWithColumnsTs_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRowWithColumnsTs_call method_call = new getRowWithColumnsTs_call(tableName, row, columns, timestamp, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRowWithColumnsTs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private ByteBuffer row;
      private List<ByteBuffer> columns;
      private long timestamp;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public getRowWithColumnsTs_call(ByteBuffer tableName, ByteBuffer row, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<getRowWithColumnsTs_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.columns = columns;
        this.timestamp = timestamp;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRowWithColumnsTs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRowWithColumnsTs_args args = new getRowWithColumnsTs_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setColumns(columns);
        args.setTimestamp(timestamp);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<TRowResult> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRowWithColumnsTs();
      }
    }

    public void getRows(ByteBuffer tableName, List<ByteBuffer> rows, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<getRows_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRows_call method_call = new getRows_call(tableName, rows, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRows_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private List<ByteBuffer> rows;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public getRows_call(ByteBuffer tableName, List<ByteBuffer> rows, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<getRows_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.rows = rows;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRows", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRows_args args = new getRows_args();
        args.setTableName(tableName);
        args.setRows(rows);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<TRowResult> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRows();
      }
    }

    public void getRowsWithColumns(ByteBuffer tableName, List<ByteBuffer> rows, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<getRowsWithColumns_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRowsWithColumns_call method_call = new getRowsWithColumns_call(tableName, rows, columns, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRowsWithColumns_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private List<ByteBuffer> rows;
      private List<ByteBuffer> columns;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public getRowsWithColumns_call(ByteBuffer tableName, List<ByteBuffer> rows, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<getRowsWithColumns_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.rows = rows;
        this.columns = columns;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRowsWithColumns", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRowsWithColumns_args args = new getRowsWithColumns_args();
        args.setTableName(tableName);
        args.setRows(rows);
        args.setColumns(columns);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<TRowResult> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRowsWithColumns();
      }
    }

    public void getRowsTs(ByteBuffer tableName, List<ByteBuffer> rows, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<getRowsTs_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRowsTs_call method_call = new getRowsTs_call(tableName, rows, timestamp, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRowsTs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private List<ByteBuffer> rows;
      private long timestamp;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public getRowsTs_call(ByteBuffer tableName, List<ByteBuffer> rows, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<getRowsTs_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.rows = rows;
        this.timestamp = timestamp;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRowsTs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRowsTs_args args = new getRowsTs_args();
        args.setTableName(tableName);
        args.setRows(rows);
        args.setTimestamp(timestamp);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<TRowResult> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRowsTs();
      }
    }

    public void getRowsWithColumnsTs(ByteBuffer tableName, List<ByteBuffer> rows, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<getRowsWithColumnsTs_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRowsWithColumnsTs_call method_call = new getRowsWithColumnsTs_call(tableName, rows, columns, timestamp, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRowsWithColumnsTs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private List<ByteBuffer> rows;
      private List<ByteBuffer> columns;
      private long timestamp;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public getRowsWithColumnsTs_call(ByteBuffer tableName, List<ByteBuffer> rows, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<getRowsWithColumnsTs_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.rows = rows;
        this.columns = columns;
        this.timestamp = timestamp;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRowsWithColumnsTs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRowsWithColumnsTs_args args = new getRowsWithColumnsTs_args();
        args.setTableName(tableName);
        args.setRows(rows);
        args.setColumns(columns);
        args.setTimestamp(timestamp);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<TRowResult> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRowsWithColumnsTs();
      }
    }

    public void mutateRow(ByteBuffer tableName, ByteBuffer row, List<Mutation> mutations, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<mutateRow_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      mutateRow_call method_call = new mutateRow_call(tableName, row, mutations, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class mutateRow_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private ByteBuffer row;
      private List<Mutation> mutations;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public mutateRow_call(ByteBuffer tableName, ByteBuffer row, List<Mutation> mutations, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<mutateRow_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.mutations = mutations;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("mutateRow", org.apache.thrift.protocol.TMessageType.CALL, 0));
        mutateRow_args args = new mutateRow_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setMutations(mutations);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws IOError, IllegalArgument, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_mutateRow();
      }
    }

    public void mutateRowTs(ByteBuffer tableName, ByteBuffer row, List<Mutation> mutations, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<mutateRowTs_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      mutateRowTs_call method_call = new mutateRowTs_call(tableName, row, mutations, timestamp, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class mutateRowTs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private ByteBuffer row;
      private List<Mutation> mutations;
      private long timestamp;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public mutateRowTs_call(ByteBuffer tableName, ByteBuffer row, List<Mutation> mutations, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<mutateRowTs_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.mutations = mutations;
        this.timestamp = timestamp;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("mutateRowTs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        mutateRowTs_args args = new mutateRowTs_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setMutations(mutations);
        args.setTimestamp(timestamp);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws IOError, IllegalArgument, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_mutateRowTs();
      }
    }

    public void mutateRows(ByteBuffer tableName, List<BatchMutation> rowBatches, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<mutateRows_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      mutateRows_call method_call = new mutateRows_call(tableName, rowBatches, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class mutateRows_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private List<BatchMutation> rowBatches;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public mutateRows_call(ByteBuffer tableName, List<BatchMutation> rowBatches, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<mutateRows_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.rowBatches = rowBatches;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("mutateRows", org.apache.thrift.protocol.TMessageType.CALL, 0));
        mutateRows_args args = new mutateRows_args();
        args.setTableName(tableName);
        args.setRowBatches(rowBatches);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws IOError, IllegalArgument, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_mutateRows();
      }
    }

    public void mutateRowsTs(ByteBuffer tableName, List<BatchMutation> rowBatches, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<mutateRowsTs_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      mutateRowsTs_call method_call = new mutateRowsTs_call(tableName, rowBatches, timestamp, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class mutateRowsTs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private List<BatchMutation> rowBatches;
      private long timestamp;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public mutateRowsTs_call(ByteBuffer tableName, List<BatchMutation> rowBatches, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<mutateRowsTs_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.rowBatches = rowBatches;
        this.timestamp = timestamp;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("mutateRowsTs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        mutateRowsTs_args args = new mutateRowsTs_args();
        args.setTableName(tableName);
        args.setRowBatches(rowBatches);
        args.setTimestamp(timestamp);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws IOError, IllegalArgument, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_mutateRowsTs();
      }
    }

    public void atomicIncrement(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long value, org.apache.thrift.async.AsyncMethodCallback<atomicIncrement_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      atomicIncrement_call method_call = new atomicIncrement_call(tableName, row, column, value, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class atomicIncrement_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private ByteBuffer row;
      private ByteBuffer column;
      private long value;
      public atomicIncrement_call(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long value, org.apache.thrift.async.AsyncMethodCallback<atomicIncrement_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.column = column;
        this.value = value;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("atomicIncrement", org.apache.thrift.protocol.TMessageType.CALL, 0));
        atomicIncrement_args args = new atomicIncrement_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setColumn(column);
        args.setValue(value);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public long getResult() throws IOError, IllegalArgument, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_atomicIncrement();
      }
    }

    public void deleteAll(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<deleteAll_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteAll_call method_call = new deleteAll_call(tableName, row, column, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteAll_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private ByteBuffer row;
      private ByteBuffer column;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public deleteAll_call(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<deleteAll_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.column = column;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteAll", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteAll_args args = new deleteAll_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setColumn(column);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_deleteAll();
      }
    }

    public void deleteAllTs(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<deleteAllTs_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteAllTs_call method_call = new deleteAllTs_call(tableName, row, column, timestamp, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteAllTs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private ByteBuffer row;
      private ByteBuffer column;
      private long timestamp;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public deleteAllTs_call(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<deleteAllTs_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.column = column;
        this.timestamp = timestamp;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteAllTs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteAllTs_args args = new deleteAllTs_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setColumn(column);
        args.setTimestamp(timestamp);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_deleteAllTs();
      }
    }

    public void deleteAllRow(ByteBuffer tableName, ByteBuffer row, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<deleteAllRow_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteAllRow_call method_call = new deleteAllRow_call(tableName, row, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteAllRow_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private ByteBuffer row;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public deleteAllRow_call(ByteBuffer tableName, ByteBuffer row, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<deleteAllRow_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteAllRow", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteAllRow_args args = new deleteAllRow_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_deleteAllRow();
      }
    }

    public void increment(TIncrement increment, org.apache.thrift.async.AsyncMethodCallback<increment_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      increment_call method_call = new increment_call(increment, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class increment_call extends org.apache.thrift.async.TAsyncMethodCall {
      private TIncrement increment;
      public increment_call(TIncrement increment, org.apache.thrift.async.AsyncMethodCallback<increment_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.increment = increment;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("increment", org.apache.thrift.protocol.TMessageType.CALL, 0));
        increment_args args = new increment_args();
        args.setIncrement(increment);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_increment();
      }
    }

    public void incrementRows(List<TIncrement> increments, org.apache.thrift.async.AsyncMethodCallback<incrementRows_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      incrementRows_call method_call = new incrementRows_call(increments, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class incrementRows_call extends org.apache.thrift.async.TAsyncMethodCall {
      private List<TIncrement> increments;
      public incrementRows_call(List<TIncrement> increments, org.apache.thrift.async.AsyncMethodCallback<incrementRows_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.increments = increments;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("incrementRows", org.apache.thrift.protocol.TMessageType.CALL, 0));
        incrementRows_args args = new incrementRows_args();
        args.setIncrements(increments);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_incrementRows();
      }
    }

    public void deleteAllRowTs(ByteBuffer tableName, ByteBuffer row, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<deleteAllRowTs_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteAllRowTs_call method_call = new deleteAllRowTs_call(tableName, row, timestamp, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteAllRowTs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private ByteBuffer row;
      private long timestamp;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public deleteAllRowTs_call(ByteBuffer tableName, ByteBuffer row, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<deleteAllRowTs_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.timestamp = timestamp;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteAllRowTs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteAllRowTs_args args = new deleteAllRowTs_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setTimestamp(timestamp);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_deleteAllRowTs();
      }
    }

    public void scannerOpenWithScan(ByteBuffer tableName, TScan scan, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<scannerOpenWithScan_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      scannerOpenWithScan_call method_call = new scannerOpenWithScan_call(tableName, scan, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class scannerOpenWithScan_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private TScan scan;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public scannerOpenWithScan_call(ByteBuffer tableName, TScan scan, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<scannerOpenWithScan_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.scan = scan;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("scannerOpenWithScan", org.apache.thrift.protocol.TMessageType.CALL, 0));
        scannerOpenWithScan_args args = new scannerOpenWithScan_args();
        args.setTableName(tableName);
        args.setScan(scan);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public int getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_scannerOpenWithScan();
      }
    }

    public void scannerOpen(ByteBuffer tableName, ByteBuffer startRow, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<scannerOpen_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      scannerOpen_call method_call = new scannerOpen_call(tableName, startRow, columns, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class scannerOpen_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private ByteBuffer startRow;
      private List<ByteBuffer> columns;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public scannerOpen_call(ByteBuffer tableName, ByteBuffer startRow, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<scannerOpen_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.startRow = startRow;
        this.columns = columns;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("scannerOpen", org.apache.thrift.protocol.TMessageType.CALL, 0));
        scannerOpen_args args = new scannerOpen_args();
        args.setTableName(tableName);
        args.setStartRow(startRow);
        args.setColumns(columns);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public int getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_scannerOpen();
      }
    }

    public void scannerOpenWithStop(ByteBuffer tableName, ByteBuffer startRow, ByteBuffer stopRow, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<scannerOpenWithStop_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      scannerOpenWithStop_call method_call = new scannerOpenWithStop_call(tableName, startRow, stopRow, columns, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class scannerOpenWithStop_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private ByteBuffer startRow;
      private ByteBuffer stopRow;
      private List<ByteBuffer> columns;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public scannerOpenWithStop_call(ByteBuffer tableName, ByteBuffer startRow, ByteBuffer stopRow, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<scannerOpenWithStop_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.startRow = startRow;
        this.stopRow = stopRow;
        this.columns = columns;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("scannerOpenWithStop", org.apache.thrift.protocol.TMessageType.CALL, 0));
        scannerOpenWithStop_args args = new scannerOpenWithStop_args();
        args.setTableName(tableName);
        args.setStartRow(startRow);
        args.setStopRow(stopRow);
        args.setColumns(columns);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public int getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_scannerOpenWithStop();
      }
    }

    public void scannerOpenWithPrefix(ByteBuffer tableName, ByteBuffer startAndPrefix, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<scannerOpenWithPrefix_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      scannerOpenWithPrefix_call method_call = new scannerOpenWithPrefix_call(tableName, startAndPrefix, columns, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class scannerOpenWithPrefix_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private ByteBuffer startAndPrefix;
      private List<ByteBuffer> columns;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public scannerOpenWithPrefix_call(ByteBuffer tableName, ByteBuffer startAndPrefix, List<ByteBuffer> columns, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<scannerOpenWithPrefix_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.startAndPrefix = startAndPrefix;
        this.columns = columns;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("scannerOpenWithPrefix", org.apache.thrift.protocol.TMessageType.CALL, 0));
        scannerOpenWithPrefix_args args = new scannerOpenWithPrefix_args();
        args.setTableName(tableName);
        args.setStartAndPrefix(startAndPrefix);
        args.setColumns(columns);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public int getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_scannerOpenWithPrefix();
      }
    }

    public void scannerOpenTs(ByteBuffer tableName, ByteBuffer startRow, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<scannerOpenTs_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      scannerOpenTs_call method_call = new scannerOpenTs_call(tableName, startRow, columns, timestamp, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class scannerOpenTs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private ByteBuffer startRow;
      private List<ByteBuffer> columns;
      private long timestamp;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public scannerOpenTs_call(ByteBuffer tableName, ByteBuffer startRow, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<scannerOpenTs_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.startRow = startRow;
        this.columns = columns;
        this.timestamp = timestamp;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("scannerOpenTs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        scannerOpenTs_args args = new scannerOpenTs_args();
        args.setTableName(tableName);
        args.setStartRow(startRow);
        args.setColumns(columns);
        args.setTimestamp(timestamp);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public int getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_scannerOpenTs();
      }
    }

    public void scannerOpenWithStopTs(ByteBuffer tableName, ByteBuffer startRow, ByteBuffer stopRow, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<scannerOpenWithStopTs_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      scannerOpenWithStopTs_call method_call = new scannerOpenWithStopTs_call(tableName, startRow, stopRow, columns, timestamp, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class scannerOpenWithStopTs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private ByteBuffer startRow;
      private ByteBuffer stopRow;
      private List<ByteBuffer> columns;
      private long timestamp;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public scannerOpenWithStopTs_call(ByteBuffer tableName, ByteBuffer startRow, ByteBuffer stopRow, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<scannerOpenWithStopTs_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.startRow = startRow;
        this.stopRow = stopRow;
        this.columns = columns;
        this.timestamp = timestamp;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("scannerOpenWithStopTs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        scannerOpenWithStopTs_args args = new scannerOpenWithStopTs_args();
        args.setTableName(tableName);
        args.setStartRow(startRow);
        args.setStopRow(stopRow);
        args.setColumns(columns);
        args.setTimestamp(timestamp);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public int getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_scannerOpenWithStopTs();
      }
    }

    public void scannerGet(int id, org.apache.thrift.async.AsyncMethodCallback<scannerGet_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      scannerGet_call method_call = new scannerGet_call(id, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class scannerGet_call extends org.apache.thrift.async.TAsyncMethodCall {
      private int id;
      public scannerGet_call(int id, org.apache.thrift.async.AsyncMethodCallback<scannerGet_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.id = id;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("scannerGet", org.apache.thrift.protocol.TMessageType.CALL, 0));
        scannerGet_args args = new scannerGet_args();
        args.setId(id);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<TRowResult> getResult() throws IOError, IllegalArgument, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_scannerGet();
      }
    }

    public void scannerGetList(int id, int nbRows, org.apache.thrift.async.AsyncMethodCallback<scannerGetList_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      scannerGetList_call method_call = new scannerGetList_call(id, nbRows, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class scannerGetList_call extends org.apache.thrift.async.TAsyncMethodCall {
      private int id;
      private int nbRows;
      public scannerGetList_call(int id, int nbRows, org.apache.thrift.async.AsyncMethodCallback<scannerGetList_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.id = id;
        this.nbRows = nbRows;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("scannerGetList", org.apache.thrift.protocol.TMessageType.CALL, 0));
        scannerGetList_args args = new scannerGetList_args();
        args.setId(id);
        args.setNbRows(nbRows);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<TRowResult> getResult() throws IOError, IllegalArgument, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_scannerGetList();
      }
    }

    public void scannerClose(int id, org.apache.thrift.async.AsyncMethodCallback<scannerClose_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      scannerClose_call method_call = new scannerClose_call(id, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class scannerClose_call extends org.apache.thrift.async.TAsyncMethodCall {
      private int id;
      public scannerClose_call(int id, org.apache.thrift.async.AsyncMethodCallback<scannerClose_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.id = id;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("scannerClose", org.apache.thrift.protocol.TMessageType.CALL, 0));
        scannerClose_args args = new scannerClose_args();
        args.setId(id);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws IOError, IllegalArgument, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_scannerClose();
      }
    }

    public void getRowOrBefore(ByteBuffer tableName, ByteBuffer row, ByteBuffer family, org.apache.thrift.async.AsyncMethodCallback<getRowOrBefore_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRowOrBefore_call method_call = new getRowOrBefore_call(tableName, row, family, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRowOrBefore_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private ByteBuffer row;
      private ByteBuffer family;
      public getRowOrBefore_call(ByteBuffer tableName, ByteBuffer row, ByteBuffer family, org.apache.thrift.async.AsyncMethodCallback<getRowOrBefore_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.family = family;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRowOrBefore", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRowOrBefore_args args = new getRowOrBefore_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setFamily(family);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<TCell> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRowOrBefore();
      }
    }

    public void getRegionInfo(ByteBuffer row, org.apache.thrift.async.AsyncMethodCallback<getRegionInfo_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRegionInfo_call method_call = new getRegionInfo_call(row, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRegionInfo_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer row;
      public getRegionInfo_call(ByteBuffer row, org.apache.thrift.async.AsyncMethodCallback<getRegionInfo_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.row = row;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRegionInfo", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRegionInfo_args args = new getRegionInfo_args();
        args.setRow(row);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TRegionInfo getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRegionInfo();
      }
    }

    public void append(TAppend append, org.apache.thrift.async.AsyncMethodCallback<append_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      append_call method_call = new append_call(append, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class append_call extends org.apache.thrift.async.TAsyncMethodCall {
      private TAppend append;
      public append_call(TAppend append, org.apache.thrift.async.AsyncMethodCallback<append_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.append = append;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("append", org.apache.thrift.protocol.TMessageType.CALL, 0));
        append_args args = new append_args();
        args.setAppend(append);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<TCell> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_append();
      }
    }

    public void checkAndPut(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, ByteBuffer value, Mutation mput, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<checkAndPut_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      checkAndPut_call method_call = new checkAndPut_call(tableName, row, column, value, mput, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class checkAndPut_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer tableName;
      private ByteBuffer row;
      private ByteBuffer column;
      private ByteBuffer value;
      private Mutation mput;
      private Map<ByteBuffer,ByteBuffer> attributes;
      public checkAndPut_call(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, ByteBuffer value, Mutation mput, Map<ByteBuffer,ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<checkAndPut_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.column = column;
        this.value = value;
        this.mput = mput;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("checkAndPut", org.apache.thrift.protocol.TMessageType.CALL, 0));
        checkAndPut_args args = new checkAndPut_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setColumn(column);
        args.setValue(value);
        args.setMput(mput);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws IOError, IllegalArgument, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_checkAndPut();
      }
    }

  }

  public static class Processor<I extends Iface> extends org.apache.thrift.TBaseProcessor<I> implements org.apache.thrift.TProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Processor.class.getName());
    public Processor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>>()));
    }

    protected Processor(I iface, Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends Iface> Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> getProcessMap(Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      processMap.put("enableTable", new enableTable());
      processMap.put("disableTable", new disableTable());
      processMap.put("isTableEnabled", new isTableEnabled());
      processMap.put("compact", new compact());
      processMap.put("majorCompact", new majorCompact());
      processMap.put("getTableNames", new getTableNames());
      processMap.put("getColumnDescriptors", new getColumnDescriptors());
      processMap.put("getTableRegions", new getTableRegions());
      processMap.put("createTable", new createTable());
      processMap.put("deleteTable", new deleteTable());
      processMap.put("get", new get());
      processMap.put("getVer", new getVer());
      processMap.put("getVerTs", new getVerTs());
      processMap.put("getRow", new getRow());
      processMap.put("getRowWithColumns", new getRowWithColumns());
      processMap.put("getRowTs", new getRowTs());
      processMap.put("getRowWithColumnsTs", new getRowWithColumnsTs());
      processMap.put("getRows", new getRows());
      processMap.put("getRowsWithColumns", new getRowsWithColumns());
      processMap.put("getRowsTs", new getRowsTs());
      processMap.put("getRowsWithColumnsTs", new getRowsWithColumnsTs());
      processMap.put("mutateRow", new mutateRow());
      processMap.put("mutateRowTs", new mutateRowTs());
      processMap.put("mutateRows", new mutateRows());
      processMap.put("mutateRowsTs", new mutateRowsTs());
      processMap.put("atomicIncrement", new atomicIncrement());
      processMap.put("deleteAll", new deleteAll());
      processMap.put("deleteAllTs", new deleteAllTs());
      processMap.put("deleteAllRow", new deleteAllRow());
      processMap.put("increment", new increment());
      processMap.put("incrementRows", new incrementRows());
      processMap.put("deleteAllRowTs", new deleteAllRowTs());
      processMap.put("scannerOpenWithScan", new scannerOpenWithScan());
      processMap.put("scannerOpen", new scannerOpen());
      processMap.put("scannerOpenWithStop", new scannerOpenWithStop());
      processMap.put("scannerOpenWithPrefix", new scannerOpenWithPrefix());
      processMap.put("scannerOpenTs", new scannerOpenTs());
      processMap.put("scannerOpenWithStopTs", new scannerOpenWithStopTs());
      processMap.put("scannerGet", new scannerGet());
      processMap.put("scannerGetList", new scannerGetList());
      processMap.put("scannerClose", new scannerClose());
      processMap.put("getRowOrBefore", new getRowOrBefore());
      processMap.put("getRegionInfo", new getRegionInfo());
      processMap.put("append", new append());
      processMap.put("checkAndPut", new checkAndPut());
      return processMap;
    }

    public static class enableTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, enableTable_args> {
      public enableTable() {
        super("enableTable");
      }

      public enableTable_args getEmptyArgsInstance() {
        return new enableTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public enableTable_result getResult(I iface, enableTable_args args) throws org.apache.thrift.TException {
        enableTable_result result = new enableTable_result();
        try {
          iface.enableTable(args.tableName);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class disableTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, disableTable_args> {
      public disableTable() {
        super("disableTable");
      }

      public disableTable_args getEmptyArgsInstance() {
        return new disableTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public disableTable_result getResult(I iface, disableTable_args args) throws org.apache.thrift.TException {
        disableTable_result result = new disableTable_result();
        try {
          iface.disableTable(args.tableName);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class isTableEnabled<I extends Iface> extends org.apache.thrift.ProcessFunction<I, isTableEnabled_args> {
      public isTableEnabled() {
        super("isTableEnabled");
      }

      public isTableEnabled_args getEmptyArgsInstance() {
        return new isTableEnabled_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public isTableEnabled_result getResult(I iface, isTableEnabled_args args) throws org.apache.thrift.TException {
        isTableEnabled_result result = new isTableEnabled_result();
        try {
          result.success = iface.isTableEnabled(args.tableName);
          result.setSuccessIsSet(true);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class compact<I extends Iface> extends org.apache.thrift.ProcessFunction<I, compact_args> {
      public compact() {
        super("compact");
      }

      public compact_args getEmptyArgsInstance() {
        return new compact_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public compact_result getResult(I iface, compact_args args) throws org.apache.thrift.TException {
        compact_result result = new compact_result();
        try {
          iface.compact(args.tableNameOrRegionName);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class majorCompact<I extends Iface> extends org.apache.thrift.ProcessFunction<I, majorCompact_args> {
      public majorCompact() {
        super("majorCompact");
      }

      public majorCompact_args getEmptyArgsInstance() {
        return new majorCompact_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public majorCompact_result getResult(I iface, majorCompact_args args) throws org.apache.thrift.TException {
        majorCompact_result result = new majorCompact_result();
        try {
          iface.majorCompact(args.tableNameOrRegionName);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getTableNames<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTableNames_args> {
      public getTableNames() {
        super("getTableNames");
      }

      public getTableNames_args getEmptyArgsInstance() {
        return new getTableNames_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getTableNames_result getResult(I iface, getTableNames_args args) throws org.apache.thrift.TException {
        getTableNames_result result = new getTableNames_result();
        try {
          result.success = iface.getTableNames();
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getColumnDescriptors<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getColumnDescriptors_args> {
      public getColumnDescriptors() {
        super("getColumnDescriptors");
      }

      public getColumnDescriptors_args getEmptyArgsInstance() {
        return new getColumnDescriptors_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getColumnDescriptors_result getResult(I iface, getColumnDescriptors_args args) throws org.apache.thrift.TException {
        getColumnDescriptors_result result = new getColumnDescriptors_result();
        try {
          result.success = iface.getColumnDescriptors(args.tableName);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getTableRegions<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTableRegions_args> {
      public getTableRegions() {
        super("getTableRegions");
      }

      public getTableRegions_args getEmptyArgsInstance() {
        return new getTableRegions_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getTableRegions_result getResult(I iface, getTableRegions_args args) throws org.apache.thrift.TException {
        getTableRegions_result result = new getTableRegions_result();
        try {
          result.success = iface.getTableRegions(args.tableName);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class createTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, createTable_args> {
      public createTable() {
        super("createTable");
      }

      public createTable_args getEmptyArgsInstance() {
        return new createTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public createTable_result getResult(I iface, createTable_args args) throws org.apache.thrift.TException {
        createTable_result result = new createTable_result();
        try {
          iface.createTable(args.tableName, args.columnFamilies);
        } catch (IOError io) {
          result.io = io;
        } catch (IllegalArgument ia) {
          result.ia = ia;
        } catch (AlreadyExists exist) {
          result.exist = exist;
        }
        return result;
      }
    }

    public static class deleteTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteTable_args> {
      public deleteTable() {
        super("deleteTable");
      }

      public deleteTable_args getEmptyArgsInstance() {
        return new deleteTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteTable_result getResult(I iface, deleteTable_args args) throws org.apache.thrift.TException {
        deleteTable_result result = new deleteTable_result();
        try {
          iface.deleteTable(args.tableName);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class get<I extends Iface> extends org.apache.thrift.ProcessFunction<I, get_args> {
      public get() {
        super("get");
      }

      public get_args getEmptyArgsInstance() {
        return new get_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public get_result getResult(I iface, get_args args) throws org.apache.thrift.TException {
        get_result result = new get_result();
        try {
          result.success = iface.get(args.tableName, args.row, args.column, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getVer<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getVer_args> {
      public getVer() {
        super("getVer");
      }

      public getVer_args getEmptyArgsInstance() {
        return new getVer_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getVer_result getResult(I iface, getVer_args args) throws org.apache.thrift.TException {
        getVer_result result = new getVer_result();
        try {
          result.success = iface.getVer(args.tableName, args.row, args.column, args.numVersions, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getVerTs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getVerTs_args> {
      public getVerTs() {
        super("getVerTs");
      }

      public getVerTs_args getEmptyArgsInstance() {
        return new getVerTs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getVerTs_result getResult(I iface, getVerTs_args args) throws org.apache.thrift.TException {
        getVerTs_result result = new getVerTs_result();
        try {
          result.success = iface.getVerTs(args.tableName, args.row, args.column, args.timestamp, args.numVersions, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getRow<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRow_args> {
      public getRow() {
        super("getRow");
      }

      public getRow_args getEmptyArgsInstance() {
        return new getRow_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getRow_result getResult(I iface, getRow_args args) throws org.apache.thrift.TException {
        getRow_result result = new getRow_result();
        try {
          result.success = iface.getRow(args.tableName, args.row, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getRowWithColumns<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRowWithColumns_args> {
      public getRowWithColumns() {
        super("getRowWithColumns");
      }

      public getRowWithColumns_args getEmptyArgsInstance() {
        return new getRowWithColumns_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getRowWithColumns_result getResult(I iface, getRowWithColumns_args args) throws org.apache.thrift.TException {
        getRowWithColumns_result result = new getRowWithColumns_result();
        try {
          result.success = iface.getRowWithColumns(args.tableName, args.row, args.columns, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getRowTs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRowTs_args> {
      public getRowTs() {
        super("getRowTs");
      }

      public getRowTs_args getEmptyArgsInstance() {
        return new getRowTs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getRowTs_result getResult(I iface, getRowTs_args args) throws org.apache.thrift.TException {
        getRowTs_result result = new getRowTs_result();
        try {
          result.success = iface.getRowTs(args.tableName, args.row, args.timestamp, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getRowWithColumnsTs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRowWithColumnsTs_args> {
      public getRowWithColumnsTs() {
        super("getRowWithColumnsTs");
      }

      public getRowWithColumnsTs_args getEmptyArgsInstance() {
        return new getRowWithColumnsTs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getRowWithColumnsTs_result getResult(I iface, getRowWithColumnsTs_args args) throws org.apache.thrift.TException {
        getRowWithColumnsTs_result result = new getRowWithColumnsTs_result();
        try {
          result.success = iface.getRowWithColumnsTs(args.tableName, args.row, args.columns, args.timestamp, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getRows<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRows_args> {
      public getRows() {
        super("getRows");
      }

      public getRows_args getEmptyArgsInstance() {
        return new getRows_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getRows_result getResult(I iface, getRows_args args) throws org.apache.thrift.TException {
        getRows_result result = new getRows_result();
        try {
          result.success = iface.getRows(args.tableName, args.rows, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getRowsWithColumns<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRowsWithColumns_args> {
      public getRowsWithColumns() {
        super("getRowsWithColumns");
      }

      public getRowsWithColumns_args getEmptyArgsInstance() {
        return new getRowsWithColumns_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getRowsWithColumns_result getResult(I iface, getRowsWithColumns_args args) throws org.apache.thrift.TException {
        getRowsWithColumns_result result = new getRowsWithColumns_result();
        try {
          result.success = iface.getRowsWithColumns(args.tableName, args.rows, args.columns, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getRowsTs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRowsTs_args> {
      public getRowsTs() {
        super("getRowsTs");
      }

      public getRowsTs_args getEmptyArgsInstance() {
        return new getRowsTs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getRowsTs_result getResult(I iface, getRowsTs_args args) throws org.apache.thrift.TException {
        getRowsTs_result result = new getRowsTs_result();
        try {
          result.success = iface.getRowsTs(args.tableName, args.rows, args.timestamp, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getRowsWithColumnsTs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRowsWithColumnsTs_args> {
      public getRowsWithColumnsTs() {
        super("getRowsWithColumnsTs");
      }

      public getRowsWithColumnsTs_args getEmptyArgsInstance() {
        return new getRowsWithColumnsTs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getRowsWithColumnsTs_result getResult(I iface, getRowsWithColumnsTs_args args) throws org.apache.thrift.TException {
        getRowsWithColumnsTs_result result = new getRowsWithColumnsTs_result();
        try {
          result.success = iface.getRowsWithColumnsTs(args.tableName, args.rows, args.columns, args.timestamp, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class mutateRow<I extends Iface> extends org.apache.thrift.ProcessFunction<I, mutateRow_args> {
      public mutateRow() {
        super("mutateRow");
      }

      public mutateRow_args getEmptyArgsInstance() {
        return new mutateRow_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public mutateRow_result getResult(I iface, mutateRow_args args) throws org.apache.thrift.TException {
        mutateRow_result result = new mutateRow_result();
        try {
          iface.mutateRow(args.tableName, args.row, args.mutations, args.attributes);
        } catch (IOError io) {
          result.io = io;
        } catch (IllegalArgument ia) {
          result.ia = ia;
        }
        return result;
      }
    }

    public static class mutateRowTs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, mutateRowTs_args> {
      public mutateRowTs() {
        super("mutateRowTs");
      }

      public mutateRowTs_args getEmptyArgsInstance() {
        return new mutateRowTs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public mutateRowTs_result getResult(I iface, mutateRowTs_args args) throws org.apache.thrift.TException {
        mutateRowTs_result result = new mutateRowTs_result();
        try {
          iface.mutateRowTs(args.tableName, args.row, args.mutations, args.timestamp, args.attributes);
        } catch (IOError io) {
          result.io = io;
        } catch (IllegalArgument ia) {
          result.ia = ia;
        }
        return result;
      }
    }

    public static class mutateRows<I extends Iface> extends org.apache.thrift.ProcessFunction<I, mutateRows_args> {
      public mutateRows() {
        super("mutateRows");
      }

      public mutateRows_args getEmptyArgsInstance() {
        return new mutateRows_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public mutateRows_result getResult(I iface, mutateRows_args args) throws org.apache.thrift.TException {
        mutateRows_result result = new mutateRows_result();
        try {
          iface.mutateRows(args.tableName, args.rowBatches, args.attributes);
        } catch (IOError io) {
          result.io = io;
        } catch (IllegalArgument ia) {
          result.ia = ia;
        }
        return result;
      }
    }

    public static class mutateRowsTs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, mutateRowsTs_args> {
      public mutateRowsTs() {
        super("mutateRowsTs");
      }

      public mutateRowsTs_args getEmptyArgsInstance() {
        return new mutateRowsTs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public mutateRowsTs_result getResult(I iface, mutateRowsTs_args args) throws org.apache.thrift.TException {
        mutateRowsTs_result result = new mutateRowsTs_result();
        try {
          iface.mutateRowsTs(args.tableName, args.rowBatches, args.timestamp, args.attributes);
        } catch (IOError io) {
          result.io = io;
        } catch (IllegalArgument ia) {
          result.ia = ia;
        }
        return result;
      }
    }

    public static class atomicIncrement<I extends Iface> extends org.apache.thrift.ProcessFunction<I, atomicIncrement_args> {
      public atomicIncrement() {
        super("atomicIncrement");
      }

      public atomicIncrement_args getEmptyArgsInstance() {
        return new atomicIncrement_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public atomicIncrement_result getResult(I iface, atomicIncrement_args args) throws org.apache.thrift.TException {
        atomicIncrement_result result = new atomicIncrement_result();
        try {
          result.success = iface.atomicIncrement(args.tableName, args.row, args.column, args.value);
          result.setSuccessIsSet(true);
        } catch (IOError io) {
          result.io = io;
        } catch (IllegalArgument ia) {
          result.ia = ia;
        }
        return result;
      }
    }

    public static class deleteAll<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteAll_args> {
      public deleteAll() {
        super("deleteAll");
      }

      public deleteAll_args getEmptyArgsInstance() {
        return new deleteAll_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteAll_result getResult(I iface, deleteAll_args args) throws org.apache.thrift.TException {
        deleteAll_result result = new deleteAll_result();
        try {
          iface.deleteAll(args.tableName, args.row, args.column, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class deleteAllTs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteAllTs_args> {
      public deleteAllTs() {
        super("deleteAllTs");
      }

      public deleteAllTs_args getEmptyArgsInstance() {
        return new deleteAllTs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteAllTs_result getResult(I iface, deleteAllTs_args args) throws org.apache.thrift.TException {
        deleteAllTs_result result = new deleteAllTs_result();
        try {
          iface.deleteAllTs(args.tableName, args.row, args.column, args.timestamp, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class deleteAllRow<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteAllRow_args> {
      public deleteAllRow() {
        super("deleteAllRow");
      }

      public deleteAllRow_args getEmptyArgsInstance() {
        return new deleteAllRow_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteAllRow_result getResult(I iface, deleteAllRow_args args) throws org.apache.thrift.TException {
        deleteAllRow_result result = new deleteAllRow_result();
        try {
          iface.deleteAllRow(args.tableName, args.row, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class increment<I extends Iface> extends org.apache.thrift.ProcessFunction<I, increment_args> {
      public increment() {
        super("increment");
      }

      public increment_args getEmptyArgsInstance() {
        return new increment_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public increment_result getResult(I iface, increment_args args) throws org.apache.thrift.TException {
        increment_result result = new increment_result();
        try {
          iface.increment(args.increment);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class incrementRows<I extends Iface> extends org.apache.thrift.ProcessFunction<I, incrementRows_args> {
      public incrementRows() {
        super("incrementRows");
      }

      public incrementRows_args getEmptyArgsInstance() {
        return new incrementRows_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public incrementRows_result getResult(I iface, incrementRows_args args) throws org.apache.thrift.TException {
        incrementRows_result result = new incrementRows_result();
        try {
          iface.incrementRows(args.increments);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class deleteAllRowTs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteAllRowTs_args> {
      public deleteAllRowTs() {
        super("deleteAllRowTs");
      }

      public deleteAllRowTs_args getEmptyArgsInstance() {
        return new deleteAllRowTs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteAllRowTs_result getResult(I iface, deleteAllRowTs_args args) throws org.apache.thrift.TException {
        deleteAllRowTs_result result = new deleteAllRowTs_result();
        try {
          iface.deleteAllRowTs(args.tableName, args.row, args.timestamp, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class scannerOpenWithScan<I extends Iface> extends org.apache.thrift.ProcessFunction<I, scannerOpenWithScan_args> {
      public scannerOpenWithScan() {
        super("scannerOpenWithScan");
      }

      public scannerOpenWithScan_args getEmptyArgsInstance() {
        return new scannerOpenWithScan_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public scannerOpenWithScan_result getResult(I iface, scannerOpenWithScan_args args) throws org.apache.thrift.TException {
        scannerOpenWithScan_result result = new scannerOpenWithScan_result();
        try {
          result.success = iface.scannerOpenWithScan(args.tableName, args.scan, args.attributes);
          result.setSuccessIsSet(true);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class scannerOpen<I extends Iface> extends org.apache.thrift.ProcessFunction<I, scannerOpen_args> {
      public scannerOpen() {
        super("scannerOpen");
      }

      public scannerOpen_args getEmptyArgsInstance() {
        return new scannerOpen_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public scannerOpen_result getResult(I iface, scannerOpen_args args) throws org.apache.thrift.TException {
        scannerOpen_result result = new scannerOpen_result();
        try {
          result.success = iface.scannerOpen(args.tableName, args.startRow, args.columns, args.attributes);
          result.setSuccessIsSet(true);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class scannerOpenWithStop<I extends Iface> extends org.apache.thrift.ProcessFunction<I, scannerOpenWithStop_args> {
      public scannerOpenWithStop() {
        super("scannerOpenWithStop");
      }

      public scannerOpenWithStop_args getEmptyArgsInstance() {
        return new scannerOpenWithStop_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public scannerOpenWithStop_result getResult(I iface, scannerOpenWithStop_args args) throws org.apache.thrift.TException {
        scannerOpenWithStop_result result = new scannerOpenWithStop_result();
        try {
          result.success = iface.scannerOpenWithStop(args.tableName, args.startRow, args.stopRow, args.columns, args.attributes);
          result.setSuccessIsSet(true);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class scannerOpenWithPrefix<I extends Iface> extends org.apache.thrift.ProcessFunction<I, scannerOpenWithPrefix_args> {
      public scannerOpenWithPrefix() {
        super("scannerOpenWithPrefix");
      }

      public scannerOpenWithPrefix_args getEmptyArgsInstance() {
        return new scannerOpenWithPrefix_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public scannerOpenWithPrefix_result getResult(I iface, scannerOpenWithPrefix_args args) throws org.apache.thrift.TException {
        scannerOpenWithPrefix_result result = new scannerOpenWithPrefix_result();
        try {
          result.success = iface.scannerOpenWithPrefix(args.tableName, args.startAndPrefix, args.columns, args.attributes);
          result.setSuccessIsSet(true);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class scannerOpenTs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, scannerOpenTs_args> {
      public scannerOpenTs() {
        super("scannerOpenTs");
      }

      public scannerOpenTs_args getEmptyArgsInstance() {
        return new scannerOpenTs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public scannerOpenTs_result getResult(I iface, scannerOpenTs_args args) throws org.apache.thrift.TException {
        scannerOpenTs_result result = new scannerOpenTs_result();
        try {
          result.success = iface.scannerOpenTs(args.tableName, args.startRow, args.columns, args.timestamp, args.attributes);
          result.setSuccessIsSet(true);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class scannerOpenWithStopTs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, scannerOpenWithStopTs_args> {
      public scannerOpenWithStopTs() {
        super("scannerOpenWithStopTs");
      }

      public scannerOpenWithStopTs_args getEmptyArgsInstance() {
        return new scannerOpenWithStopTs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public scannerOpenWithStopTs_result getResult(I iface, scannerOpenWithStopTs_args args) throws org.apache.thrift.TException {
        scannerOpenWithStopTs_result result = new scannerOpenWithStopTs_result();
        try {
          result.success = iface.scannerOpenWithStopTs(args.tableName, args.startRow, args.stopRow, args.columns, args.timestamp, args.attributes);
          result.setSuccessIsSet(true);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class scannerGet<I extends Iface> extends org.apache.thrift.ProcessFunction<I, scannerGet_args> {
      public scannerGet() {
        super("scannerGet");
      }

      public scannerGet_args getEmptyArgsInstance() {
        return new scannerGet_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public scannerGet_result getResult(I iface, scannerGet_args args) throws org.apache.thrift.TException {
        scannerGet_result result = new scannerGet_result();
        try {
          result.success = iface.scannerGet(args.id);
        } catch (IOError io) {
          result.io = io;
        } catch (IllegalArgument ia) {
          result.ia = ia;
        }
        return result;
      }
    }

    public static class scannerGetList<I extends Iface> extends org.apache.thrift.ProcessFunction<I, scannerGetList_args> {
      public scannerGetList() {
        super("scannerGetList");
      }

      public scannerGetList_args getEmptyArgsInstance() {
        return new scannerGetList_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public scannerGetList_result getResult(I iface, scannerGetList_args args) throws org.apache.thrift.TException {
        scannerGetList_result result = new scannerGetList_result();
        try {
          result.success = iface.scannerGetList(args.id, args.nbRows);
        } catch (IOError io) {
          result.io = io;
        } catch (IllegalArgument ia) {
          result.ia = ia;
        }
        return result;
      }
    }

    public static class scannerClose<I extends Iface> extends org.apache.thrift.ProcessFunction<I, scannerClose_args> {
      public scannerClose() {
        super("scannerClose");
      }

      public scannerClose_args getEmptyArgsInstance() {
        return new scannerClose_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public scannerClose_result getResult(I iface, scannerClose_args args) throws org.apache.thrift.TException {
        scannerClose_result result = new scannerClose_result();
        try {
          iface.scannerClose(args.id);
        } catch (IOError io) {
          result.io = io;
        } catch (IllegalArgument ia) {
          result.ia = ia;
        }
        return result;
      }
    }

    public static class getRowOrBefore<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRowOrBefore_args> {
      public getRowOrBefore() {
        super("getRowOrBefore");
      }

      public getRowOrBefore_args getEmptyArgsInstance() {
        return new getRowOrBefore_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getRowOrBefore_result getResult(I iface, getRowOrBefore_args args) throws org.apache.thrift.TException {
        getRowOrBefore_result result = new getRowOrBefore_result();
        try {
          result.success = iface.getRowOrBefore(args.tableName, args.row, args.family);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getRegionInfo<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRegionInfo_args> {
      public getRegionInfo() {
        super("getRegionInfo");
      }

      public getRegionInfo_args getEmptyArgsInstance() {
        return new getRegionInfo_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getRegionInfo_result getResult(I iface, getRegionInfo_args args) throws org.apache.thrift.TException {
        getRegionInfo_result result = new getRegionInfo_result();
        try {
          result.success = iface.getRegionInfo(args.row);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class append<I extends Iface> extends org.apache.thrift.ProcessFunction<I, append_args> {
      public append() {
        super("append");
      }

      public append_args getEmptyArgsInstance() {
        return new append_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public append_result getResult(I iface, append_args args) throws org.apache.thrift.TException {
        append_result result = new append_result();
        try {
          result.success = iface.append(args.append);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class checkAndPut<I extends Iface> extends org.apache.thrift.ProcessFunction<I, checkAndPut_args> {
      public checkAndPut() {
        super("checkAndPut");
      }

      public checkAndPut_args getEmptyArgsInstance() {
        return new checkAndPut_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public checkAndPut_result getResult(I iface, checkAndPut_args args) throws org.apache.thrift.TException {
        checkAndPut_result result = new checkAndPut_result();
        try {
          result.success = iface.checkAndPut(args.tableName, args.row, args.column, args.value, args.mput, args.attributes);
          result.setSuccessIsSet(true);
        } catch (IOError io) {
          result.io = io;
        } catch (IllegalArgument ia) {
          result.ia = ia;
        }
        return result;
      }
    }

  }

  public static class enableTable_args implements org.apache.thrift.TBase<enableTable_args, enableTable_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("enableTable_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new enableTable_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new enableTable_argsTupleSchemeFactory());
    }

    /**
     * name of the table
     */
    public ByteBuffer tableName; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of the table
       */
      TABLE_NAME((short)1, "tableName");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Bytes")));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(enableTable_args.class, metaDataMap);
    }

    public enableTable_args() {
    }

    public enableTable_args(
      ByteBuffer tableName)
    {
      this();
      this.tableName = tableName;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public enableTable_args(enableTable_args other) {
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
    }

    public enableTable_args deepCopy() {
      return new enableTable_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
    }

    /**
     * name of the table
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public ByteBuffer bufferForTableName() {
      return tableName;
    }

    /**
     * name of the table
     */
    public enableTable_args setTableName(byte[] tableName) {
      setTableName(tableName == null ? (ByteBuffer)null : ByteBuffer.wrap(tableName));
      return this;
    }

    public enableTable_args setTableName(ByteBuffer tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((ByteBuffer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof enableTable_args)
        return this.equals((enableTable_args)that);
      return false;
    }

    public boolean equals(enableTable_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_tableName = true && (isSetTableName());
      builder.append(present_tableName);
      if (present_tableName)
        builder.append(tableName);

      return builder.toHashCode();
    }

    public int compareTo(enableTable_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      enableTable_args typedOther = (enableTable_args)other;

      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(typedOther.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, typedOther.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("enableTable_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class enableTable_argsStandardSchemeFactory implements SchemeFactory {
      public enableTable_argsStandardScheme getScheme() {
        return new enableTable_argsStandardScheme();
      }
    }

    private static class enableTable_argsStandardScheme extends StandardScheme<enableTable_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, enableTable_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, enableTable_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class enableTable_argsTupleSchemeFactory implements SchemeFactory {
      public enableTable_argsTupleScheme getScheme() {
        return new enableTable_argsTupleScheme();
      }
    }

    private static class enableTable_argsTupleScheme extends TupleScheme<enableTable_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, enableTable_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, enableTable_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
      }
    }

  }

  public static class enableTable_result implements org.apache.thrift.TBase<enableTable_result, enableTable_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("enableTable_result");

    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new enableTable_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new enableTable_resultTupleSchemeFactory());
    }

    public IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IO((short)1, "io");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(enableTable_result.class, metaDataMap);
    }

    public enableTable_result() {
    }

    public enableTable_result(
      IOError io)
    {
      this();
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public enableTable_result(enableTable_result other) {
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public enableTable_result deepCopy() {
      return new enableTable_result(this);
    }

    @Override
    public void clear() {
      this.io = null;
    }

    public IOError getIo() {
      return this.io;
    }

    public enableTable_result setIo(IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case IO:
        return getIo();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case IO:
        return isSetIo();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof enableTable_result)
        return this.equals((enableTable_result)that);
      return false;
    }

    public boolean equals(enableTable_result that) {
      if (that == null)
        return false;

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_io = true && (isSetIo());
      builder.append(present_io);
      if (present_io)
        builder.append(io);

      return builder.toHashCode();
    }

    public int compareTo(enableTable_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      enableTable_result typedOther = (enableTable_result)other;

      lastComparison = Boolean.valueOf(isSetIo()).compareTo(typedOther.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, typedOther.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("enableTable_result(");
      boolean first = true;

      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class enableTable_resultStandardSchemeFactory implements SchemeFactory {
      public enableTable_resultStandardScheme getScheme() {
        return new enableTable_resultStandardScheme();
      }
    }

    private static class enableTable_resultStandardScheme extends StandardScheme<enableTable_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, enableTable_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, enableTable_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class enableTable_resultTupleSchemeFactory implements SchemeFactory {
      public enableTable_resultTupleScheme getScheme() {
        return new enableTable_resultTupleScheme();
      }
    }

    private static class enableTable_resultTupleScheme extends TupleScheme<enableTable_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, enableTable_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetIo()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, enableTable_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

  }

  public static class disableTable_args implements org.apache.thrift.TBase<disableTable_args, disableTable_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("disableTable_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new disableTable_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new disableTable_argsTupleSchemeFactory());
    }

    /**
     * name of the table
     */
    public ByteBuffer tableName; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of the table
       */
      TABLE_NAME((short)1, "tableName");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Bytes")));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(disableTable_args.class, metaDataMap);
    }

    public disableTable_args() {
    }

    public disableTable_args(
      ByteBuffer tableName)
    {
      this();
      this.tableName = tableName;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public disableTable_args(disableTable_args other) {
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
    }

    public disableTable_args deepCopy() {
      return new disableTable_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
    }

    /**
     * name of the table
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public ByteBuffer bufferForTableName() {
      return tableName;
    }

    /**
     * name of the table
     */
    public disableTable_args setTableName(byte[] tableName) {
      setTableName(tableName == null ? (ByteBuffer)null : ByteBuffer.wrap(tableName));
      return this;
    }

    public disableTable_args setTableName(ByteBuffer tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((ByteBuffer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof disableTable_args)
        return this.equals((disableTable_args)that);
      return false;
    }

    public boolean equals(disableTable_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_tableName = true && (isSetTableName());
      builder.append(present_tableName);
      if (present_tableName)
        builder.append(tableName);

      return builder.toHashCode();
    }

    public int compareTo(disableTable_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      disableTable_args typedOther = (disableTable_args)other;

      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(typedOther.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, typedOther.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("disableTable_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class disableTable_argsStandardSchemeFactory implements SchemeFactory {
      public disableTable_argsStandardScheme getScheme() {
        return new disableTable_argsStandardScheme();
      }
    }

    private static class disableTable_argsStandardScheme extends StandardScheme<disableTable_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, disableTable_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, disableTable_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class disableTable_argsTupleSchemeFactory implements SchemeFactory {
      public disableTable_argsTupleScheme getScheme() {
        return new disableTable_argsTupleScheme();
      }
    }

    private static class disableTable_argsTupleScheme extends TupleScheme<disableTable_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, disableTable_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, disableTable_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
      }
    }

  }

  public static class disableTable_result implements org.apache.thrift.TBase<disableTable_result, disableTable_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("disableTable_result");

    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new disableTable_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new disableTable_resultTupleSchemeFactory());
    }

    public IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IO((short)1, "io");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(disableTable_result.class, metaDataMap);
    }

    public disableTable_result() {
    }

    public disableTable_result(
      IOError io)
    {
      this();
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public disableTable_result(disableTable_result other) {
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public disableTable_result deepCopy() {
      return new disableTable_result(this);
    }

    @Override
    public void clear() {
      this.io = null;
    }

    public IOError getIo() {
      return this.io;
    }

    public disableTable_result setIo(IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case IO:
        return getIo();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case IO:
        return isSetIo();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof disableTable_result)
        return this.equals((disableTable_result)that);
      return false;
    }

    public boolean equals(disableTable_result that) {
      if (that == null)
        return false;

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_io = true && (isSetIo());
      builder.append(present_io);
      if (present_io)
        builder.append(io);

      return builder.toHashCode();
    }

    public int compareTo(disableTable_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      disableTable_result typedOther = (disableTable_result)other;

      lastComparison = Boolean.valueOf(isSetIo()).compareTo(typedOther.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, typedOther.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("disableTable_result(");
      boolean first = true;

      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class disableTable_resultStandardSchemeFactory implements SchemeFactory {
      public disableTable_resultStandardScheme getScheme() {
        return new disableTable_resultStandardScheme();
      }
    }

    private static class disableTable_resultStandardScheme extends StandardScheme<disableTable_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, disableTable_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, disableTable_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class disableTable_resultTupleSchemeFactory implements SchemeFactory {
      public disableTable_resultTupleScheme getScheme() {
        return new disableTable_resultTupleScheme();
      }
    }

    private static class disableTable_resultTupleScheme extends TupleScheme<disableTable_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, disableTable_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetIo()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, disableTable_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

  }

  public static class isTableEnabled_args implements org.apache.thrift.TBase<isTableEnabled_args, isTableEnabled_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("isTableEnabled_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new isTableEnabled_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new isTableEnabled_argsTupleSchemeFactory());
    }

    /**
     * name of the table to check
     */
    public ByteBuffer tableName; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of the table to check
       */
      TABLE_NAME((short)1, "tableName");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Bytes")));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(isTableEnabled_args.class, metaDataMap);
    }

    public isTableEnabled_args() {
    }

    public isTableEnabled_args(
      ByteBuffer tableName)
    {
      this();
      this.tableName = tableName;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public isTableEnabled_args(isTableEnabled_args other) {
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
    }

    public isTableEnabled_args deepCopy() {
      return new isTableEnabled_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
    }

    /**
     * name of the table to check
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public ByteBuffer bufferForTableName() {
      return tableName;
    }

    /**
     * name of the table to check
     */
    public isTableEnabled_args setTableName(byte[] tableName) {
      setTableName(tableName == null ? (ByteBuffer)null : ByteBuffer.wrap(tableName));
      return this;
    }

    public isTableEnabled_args setTableName(ByteBuffer tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((ByteBuffer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof isTableEnabled_args)
        return this.equals((isTableEnabled_args)that);
      return false;
    }

    public boolean equals(isTableEnabled_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_tableName = true && (isSetTableName());
      builder.append(present_tableName);
      if (present_tableName)
        builder.append(tableName);

      return builder.toHashCode();
    }

    public int compareTo(isTableEnabled_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      isTableEnabled_args typedOther = (isTableEnabled_args)other;

      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(typedOther.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, typedOther.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("isTableEnabled_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class isTableEnabled_argsStandardSchemeFactory implements SchemeFactory {
      public isTableEnabled_argsStandardScheme getScheme() {
        return new isTableEnabled_argsStandardScheme();
      }
    }

    private static class isTableEnabled_argsStandardScheme extends StandardScheme<isTableEnabled_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, isTableEnabled_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, isTableEnabled_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class isTableEnabled_argsTupleSchemeFactory implements SchemeFactory {
      public isTableEnabled_argsTupleScheme getScheme() {
        return new isTableEnabled_argsTupleScheme();
      }
    }

    private static class isTableEnabled_argsTupleScheme extends TupleScheme<isTableEnabled_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, isTableEnabled_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, isTableEnabled_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
      }
    }

  }

  public static class isTableEnabled_result implements org.apache.thrift.TBase<isTableEnabled_result, isTableEnabled_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("isTableEnabled_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new isTableEnabled_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new isTableEnabled_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(isTableEnabled_result.class, metaDataMap);
    }

    public isTableEnabled_result() {
    }

    public isTableEnabled_result(
      boolean success,
      IOError io)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public isTableEnabled_result(isTableEnabled_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public isTableEnabled_result deepCopy() {
      return new isTableEnabled_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.io = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public isTableEnabled_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public IOError getIo() {
      return this.io;
    }

    public isTableEnabled_result setIo(IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Boolean.valueOf(isSuccess());

      case IO:
        return getIo();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof isTableEnabled_result)
        return this.equals((isTableEnabled_result)that);
      return false;
    }

    public boolean equals(isTableEnabled_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true;
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_io = true && (isSetIo());
      builder.append(present_io);
      if (present_io)
        builder.append(io);

      return builder.toHashCode();
    }

    public int compareTo(isTableEnabled_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      isTableEnabled_result typedOther = (isTableEnabled_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIo()).compareTo(typedOther.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, typedOther.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("isTableEnabled_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class isTableEnabled_resultStandardSchemeFactory implements SchemeFactory {
      public isTableEnabled_resultStandardScheme getScheme() {
        return new isTableEnabled_resultStandardScheme();
      }
    }

    private static class isTableEnabled_resultStandardScheme extends StandardScheme<isTableEnabled_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, isTableEnabled_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, isTableEnabled_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class isTableEnabled_resultTupleSchemeFactory implements SchemeFactory {
      public isTableEnabled_resultTupleScheme getScheme() {
        return new isTableEnabled_resultTupleScheme();
      }
    }

    private static class isTableEnabled_resultTupleScheme extends TupleScheme<isTableEnabled_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, isTableEnabled_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, isTableEnabled_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

  }

  public static class compact_args implements org.apache.thrift.TBase<compact_args, compact_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("compact_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_OR_REGION_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableNameOrRegionName", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new compact_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new compact_argsTupleSchemeFactory());
    }

    public ByteBuffer tableNameOrRegionName; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TABLE_NAME_OR_REGION_NAME((short)1, "tableNameOrRegionName");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME_OR_REGION_NAME
            return TABLE_NAME_OR_REGION_NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME_OR_REGION_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableNameOrRegionName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Bytes")));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(compact_args.class, metaDataMap);
    }

    public compact_args() {
    }

    public compact_args(
      ByteBuffer tableNameOrRegionName)
    {
      this();
      this.tableNameOrRegionName = tableNameOrRegionName;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public compact_args(compact_args other) {
      if (other.isSetTableNameOrRegionName()) {
        this.tableNameOrRegionName = other.tableNameOrRegionName;
      }
    }

    public compact_args deepCopy() {
      return new compact_args(this);
    }

    @Override
    public void clear() {
      this.tableNameOrRegionName = null;
    }

    public byte[] getTableNameOrRegionName() {
      setTableNameOrRegionName(org.apache.thrift.TBaseHelper.rightSize(tableNameOrRegionName));
      return tableNameOrRegionName == null ? null : tableNameOrRegionName.array();
    }

    public ByteBuffer bufferForTableNameOrRegionName() {
      return tableNameOrRegionName;
    }

    public compact_args setTableNameOrRegionName(byte[] tableNameOrRegionName) {
      setTableNameOrRegionName(tableNameOrRegionName == null ? (ByteBuffer)null : ByteBuffer.wrap(tableNameOrRegionName));
      return this;
    }

    public compact_args setTableNameOrRegionName(ByteBuffer tableNameOrRegionName) {
      this.tableNameOrRegionName = tableNameOrRegionName;
      return this;
    }

    public void unsetTableNameOrRegionName() {
      this.tableNameOrRegionName = null;
    }

    /** Returns true if field tableNameOrRegionName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableNameOrRegionName() {
      return this.tableNameOrRegionName != null;
    }

    public void setTableNameOrRegionNameIsSet(boolean value) {
      if (!value) {
        this.tableNameOrRegionName = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TABLE_NAME_OR_REGION_NAME:
        if (value == null) {
          unsetTableNameOrRegionName();
        } else {
          setTableNameOrRegionName((ByteBuffer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME_OR_REGION_NAME:
        return getTableNameOrRegionName();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME_OR_REGION_NAME:
        return isSetTableNameOrRegionName();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof compact_args)
        return this.equals((compact_args)that);
      return false;
    }

    public boolean equals(compact_args that) {
      if (that == null)
        return false;

      boolean this_present_tableNameOrRegionName = true && this.isSetTableNameOrRegionName();
      boolean that_present_tableNameOrRegionName = true && that.isSetTableNameOrRegionName();
      if (this_present_tableNameOrRegionName || that_present_tableNameOrRegionName) {
        if (!(this_present_tableNameOrRegionName && that_present_tableNameOrRegionName))
          return false;
        if (!this.tableNameOrRegionName.equals(that.tableNameOrRegionName))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_tableNameOrRegionName = true && (isSetTableNameOrRegionName());
      builder.append(present_tableNameOrRegionName);
      if (present_tableNameOrRegionName)
        builder.append(tableNameOrRegionName);

      return builder.toHashCode();
    }

    public int compareTo(compact_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      compact_args typedOther = (compact_args)other;

      lastComparison = Boolean.valueOf(isSetTableNameOrRegionName()).compareTo(typedOther.isSetTableNameOrRegionName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableNameOrRegionName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableNameOrRegionName, typedOther.tableNameOrRegionName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("compact_args(");
      boolean first = true;

      sb.append("tableNameOrRegionName:");
      if (this.tableNameOrRegionName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableNameOrRegionName);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class compact_argsStandardSchemeFactory implements SchemeFactory {
      public compact_argsStandardScheme getScheme() {
        return new compact_argsStandardScheme();
      }
    }

    private static class compact_argsStandardScheme extends StandardScheme<compact_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, compact_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME_OR_REGION_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableNameOrRegionName = iprot.readBinary();
                struct.setTableNameOrRegionNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, compact_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableNameOrRegionName != null) {
          oprot.writeFieldBegin(TABLE_NAME_OR_REGION_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableNameOrRegionName);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class compact_argsTupleSchemeFactory implements SchemeFactory {
      public compact_argsTupleScheme getScheme() {
        return new compact_argsTupleScheme();
      }
    }

    private static class compact_argsTupleScheme extends TupleScheme<compact_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, compact_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTableNameOrRegionName()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetTableNameOrRegionName()) {
          oprot.writeBinary(struct.tableNameOrRegionName);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, compact_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.tableNameOrRegionName = iprot.readBinary();
          struct.setTableNameOrRegionNameIsSet(true);
        }
      }
    }

  }

  public static class compact_result implements org.apache.thrift.TBase<compact_result, compact_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("compact_result");

    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new compact_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new compact_resultTupleSchemeFactory());
    }

    public IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IO((short)1, "io");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(compact_result.class, metaDataMap);
    }

    public compact_result() {
    }

    public compact_result(
      IOError io)
    {
      this();
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public compact_result(compact_result other) {
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public compact_result deepCopy() {
      return new compact_result(this);
    }

    @Override
    public void clear() {
      this.io = null;
    }

    public IOError getIo() {
      return this.io;
    }

    public compact_result setIo(IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case IO:
        return getIo();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case IO:
        return isSetIo();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof compact_result)
        return this.equals((compact_result)that);
      return false;
    }

    public boolean equals(compact_result that) {
      if (that == null)
        return false;

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_io = true && (isSetIo());
      builder.append(present_io);
      if (present_io)
        builder.append(io);

      return builder.toHashCode();
    }

    public int compareTo(compact_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      compact_result typedOther = (compact_result)other;

      lastComparison = Boolean.valueOf(isSetIo()).compareTo(typedOther.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, typedOther.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("compact_result(");
      boolean first = true;

      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class compact_resultStandardSchemeFactory implements SchemeFactory {
      public compact_resultStandardScheme getScheme() {
        return new compact_resultStandardScheme();
      }
    }

    private static class compact_resultStandardScheme extends StandardScheme<compact_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, compact_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, compact_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class compact_resultTupleSchemeFactory implements SchemeFactory {
      public compact_resultTupleScheme getScheme() {
        return new compact_resultTupleScheme();
      }
    }

    private static class compact_resultTupleScheme extends TupleScheme<compact_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, compact_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetIo()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, compact_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

  }

  public static class majorCompact_args implements org.apache.thrift.TBase<majorCompact_args, majorCompact_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("majorCompact_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_OR_REGION_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableNameOrRegionName", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new majorCompact_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new majorCompact_argsTupleSchemeFactory());
    }

    public ByteBuffer tableNameOrRegionName; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TABLE_NAME_OR_REGION_NAME((short)1, "tableNameOrRegionName");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME_OR_REGION_NAME
            return TABLE_NAME_OR_REGION_NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME_OR_REGION_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableNameOrRegionName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Bytes")));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(majorCompact_args.class, metaDataMap);
    }

    public majorCompact_args() {
    }

    public majorCompact_args(
      ByteBuffer tableNameOrRegionName)
    {
      this();
      this.tableNameOrRegionName = tableNameOrRegionName;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public majorCompact_args(majorCompact_args other) {
      if (other.isSetTableNameOrRegionName()) {
        this.tableNameOrRegionName = other.tableNameOrRegionName;
      }
    }

    public majorCompact_args deepCopy() {
      return new majorCompact_args(this);
    }

    @Override
    public void clear() {
      this.tableNameOrRegionName = null;
    }

    public byte[] getTableNameOrRegionName() {
      setTableNameOrRegionName(org.apache.thrift.TBaseHelper.rightSize(tableNameOrRegionName));
      return tableNameOrRegionName == null ? null : tableNameOrRegionName.array();
    }

    public ByteBuffer bufferForTableNameOrRegionName() {
      return tableNameOrRegionName;
    }

    public majorCompact_args setTableNameOrRegionName(byte[] tableNameOrRegionName) {
      setTableNameOrRegionName(tableNameOrRegionName == null ? (ByteBuffer)null : ByteBuffer.wrap(tableNameOrRegionName));
      return this;
    }

    public majorCompact_args setTableNameOrRegionName(ByteBuffer tableNameOrRegionName) {
      this.tableNameOrRegionName = tableNameOrRegionName;
      return this;
    }

    public void unsetTableNameOrRegionName() {
      this.tableNameOrRegionName = null;
    }

    /** Returns true if field tableNameOrRegionName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableNameOrRegionName() {
      return this.tableNameOrRegionName != null;
    }

    public void setTableNameOrRegionNameIsSet(boolean value) {
      if (!value) {
        this.tableNameOrRegionName = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TABLE_NAME_OR_REGION_NAME:
        if (value == null) {
          unsetTableNameOrRegionName();
        } else {
          setTableNameOrRegionName((ByteBuffer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME_OR_REGION_NAME:
        return getTableNameOrRegionName();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME_OR_REGION_NAME:
        return isSetTableNameOrRegionName();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof majorCompact_args)
        return this.equals((majorCompact_args)that);
      return false;
    }

    public boolean equals(majorCompact_args that) {
      if (that == null)
        return false;

      boolean this_present_tableNameOrRegionName = true && this.isSetTableNameOrRegionName();
      boolean that_present_tableNameOrRegionName = true && that.isSetTableNameOrRegionName();
      if (this_present_tableNameOrRegionName || that_present_tableNameOrRegionName) {
        if (!(this_present_tableNameOrRegionName && that_present_tableNameOrRegionName))
          return false;
        if (!this.tableNameOrRegionName.equals(that.tableNameOrRegionName))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_tableNameOrRegionName = true && (isSetTableNameOrRegionName());
      builder.append(present_tableNameOrRegionName);
      if (present_tableNameOrRegionName)
        builder.append(tableNameOrRegionName);

      return builder.toHashCode();
    }

    public int compareTo(majorCompact_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      majorCompact_args typedOther = (majorCompact_args)other;

      lastComparison = Boolean.valueOf(isSetTableNameOrRegionName()).compareTo(typedOther.isSetTableNameOrRegionName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableNameOrRegionName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableNameOrRegionName, typedOther.tableNameOrRegionName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("majorCompact_args(");
      boolean first = true;

      sb.append("tableNameOrRegionName:");
      if (this.tableNameOrRegionName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableNameOrRegionName);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class majorCompact_argsStandardSchemeFactory implements SchemeFactory {
      public majorCompact_argsStandardScheme getScheme() {
        return new majorCompact_argsStandardScheme();
      }
    }

    private static class majorCompact_argsStandardScheme extends StandardScheme<majorCompact_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, majorCompact_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME_OR_REGION_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableNameOrRegionName = iprot.readBinary();
                struct.setTableNameOrRegionNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, majorCompact_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableNameOrRegionName != null) {
          oprot.writeFieldBegin(TABLE_NAME_OR_REGION_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableNameOrRegionName);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class majorCompact_argsTupleSchemeFactory implements SchemeFactory {
      public majorCompact_argsTupleScheme getScheme() {
        return new majorCompact_argsTupleScheme();
      }
    }

    private static class majorCompact_argsTupleScheme extends TupleScheme<majorCompact_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, majorCompact_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTableNameOrRegionName()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetTableNameOrRegionName()) {
          oprot.writeBinary(struct.tableNameOrRegionName);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, majorCompact_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.tableNameOrRegionName = iprot.readBinary();
          struct.setTableNameOrRegionNameIsSet(true);
        }
      }
    }

  }

  public static class majorCompact_result implements org.apache.thrift.TBase<majorCompact_result, majorCompact_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("majorCompact_result");

    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new majorCompact_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new majorCompact_resultTupleSchemeFactory());
    }

    public IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IO((short)1, "io");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(majorCompact_result.class, metaDataMap);
    }

    public majorCompact_result() {
    }

    public majorCompact_result(
      IOError io)
    {
      this();
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public majorCompact_result(majorCompact_result other) {
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public majorCompact_result deepCopy() {
      return new majorCompact_result(this);
    }

    @Override
    public void clear() {
      this.io = null;
    }

    public IOError getIo() {
      return this.io;
    }

    public majorCompact_result setIo(IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case IO:
        return getIo();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case IO:
        return isSetIo();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof majorCompact_result)
        return this.equals((majorCompact_result)that);
      return false;
    }

    public boolean equals(majorCompact_result that) {
      if (that == null)
        return false;

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_io = true && (isSetIo());
      builder.append(present_io);
      if (present_io)
        builder.append(io);

      return builder.toHashCode();
    }

    public int compareTo(majorCompact_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      majorCompact_result typedOther = (majorCompact_result)other;

      lastComparison = Boolean.valueOf(isSetIo()).compareTo(typedOther.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, typedOther.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("majorCompact_result(");
      boolean first = true;

      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class majorCompact_resultStandardSchemeFactory implements SchemeFactory {
      public majorCompact_resultStandardScheme getScheme() {
        return new majorCompact_resultStandardScheme();
      }
    }

    private static class majorCompact_resultStandardScheme extends StandardScheme<majorCompact_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, majorCompact_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, majorCompact_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class majorCompact_resultTupleSchemeFactory implements SchemeFactory {
      public majorCompact_resultTupleScheme getScheme() {
        return new majorCompact_resultTupleScheme();
      }
    }

    private static class majorCompact_resultTupleScheme extends TupleScheme<majorCompact_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, majorCompact_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetIo()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, majorCompact_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

  }

  public static class getTableNames_args implements org.apache.thrift.TBase<getTableNames_args, getTableNames_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getTableNames_args");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getTableNames_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getTableNames_argsTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getTableNames_args.class, metaDataMap);
    }

    public getTableNames_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getTableNames_args(getTableNames_args other) {
    }

    public getTableNames_args deepCopy() {
      return new getTableNames_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getTableNames_args)
        return this.equals((getTableNames_args)that);
      return false;
    }

    public boolean equals(getTableNames_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      return builder.toHashCode();
    }

    public int compareTo(getTableNames_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getTableNames_args typedOther = (getTableNames_args)other;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getTableNames_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getTableNames_argsStandardSchemeFactory implements SchemeFactory {
      public getTableNames_argsStandardScheme getScheme() {
        return new getTableNames_argsStandardScheme();
      }
    }

    private static class getTableNames_argsStandardScheme extends StandardScheme<getTableNames_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getTableNames_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getTableNames_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getTableNames_argsTupleSchemeFactory implements SchemeFactory {
      public getTableNames_argsTupleScheme getScheme() {
        return new getTableNames_argsTupleScheme();
      }
    }

    private static class getTableNames_argsTupleScheme extends TupleScheme<getTableNames_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getTableNames_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getTableNames_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class getTableNames_result implements org.apache.thrift.TBase<getTableNames_result, getTableNames_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getTableNames_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getTableNames_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getTableNames_resultTupleSchemeFactory());
    }

    public List<ByteBuffer> success; // required
    public IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getTableNames_result.class, metaDataMap);
    }

    public getTableNames_result() {
    }

    public getTableNames_result(
      List<ByteBuffer> success,
      IOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getTableNames_result(getTableNames_result other) {
      if (other.isSetSuccess()) {
        List<ByteBuffer> __this__success = new ArrayList<ByteBuffer>();
        for (ByteBuffer other_element : other.success) {
          __this__success.add(other_element);
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public getTableNames_result deepCopy() {
      return new getTableNames_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<ByteBuffer> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(ByteBuffer elem) {
      if (this.success == null) {
        this.success = new ArrayList<ByteBuffer>();
      }
      this.success.add(elem);
    }

    public List<ByteBuffer> getSuccess() {
      return this.success;
    }

    public getTableNames_result setSuccess(List<ByteBuffer> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public IOError getIo() {
      return this.io;
    }

    public getTableNames_result setIo(IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<ByteBuffer>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getTableNames_result)
        return this.equals((getTableNames_result)that);
      return false;
    }

    public boolean equals(getTableNames_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_io = true && (isSetIo());
      builder.append(present_io);
      if (present_io)
        builder.append(io);

      return builder.toHashCode();
    }

    public int compareTo(getTableNames_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getTableNames_result typedOther = (getTableNames_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIo()).compareTo(typedOther.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, typedOther.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getTableNames_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getTableNames_resultStandardSchemeFactory implements SchemeFactory {
      public getTableNames_resultStandardScheme getScheme() {
        return new getTableNames_resultStandardScheme();
      }
    }

    private static class getTableNames_resultStandardScheme extends StandardScheme<getTableNames_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getTableNames_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list50 = iprot.readListBegin();
                  struct.success = new ArrayList<ByteBuffer>(_list50.size);
                  for (int _i51 = 0; _i51 < _list50.size; ++_i51)
                  {
                    ByteBuffer _elem52; // required
                    _elem52 = iprot.readBinary();
                    struct.success.add(_elem52);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getTableNames_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.success.size()));
            for (ByteBuffer _iter53 : struct.success)
            {
              oprot.writeBinary(_iter53);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getTableNames_resultTupleSchemeFactory implements SchemeFactory {
      public getTableNames_resultTupleScheme getScheme() {
        return new getTableNames_resultTupleScheme();
      }
    }

    private static class getTableNames_resultTupleScheme extends TupleScheme<getTableNames_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getTableNames_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (ByteBuffer _iter54 : struct.success)
            {
              oprot.writeBinary(_iter54);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getTableNames_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list55 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.success = new ArrayList<ByteBuffer>(_list55.size);
            for (int _i56 = 0; _i56 < _list55.size; ++_i56)
            {
              ByteBuffer _elem57; // required
              _elem57 = iprot.readBinary();
              struct.success.add(_elem57);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

  }

  public static class getColumnDescriptors_args implements org.apache.thrift.TBase<getColumnDescriptors_args, getColumnDescriptors_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getColumnDescriptors_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getColumnDescriptors_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getColumnDescriptors_argsTupleSchemeFactory());
    }

    /**
     * table name
     */
    public ByteBuffer tableName; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * table name
       */
      TABLE_NAME((short)1, "tableName");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getColumnDescriptors_args.class, metaDataMap);
    }

    public getColumnDescriptors_args() {
    }

    public getColumnDescriptors_args(
      ByteBuffer tableName)
    {
      this();
      this.tableName = tableName;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getColumnDescriptors_args(getColumnDescriptors_args other) {
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
    }

    public getColumnDescriptors_args deepCopy() {
      return new getColumnDescriptors_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
    }

    /**
     * table name
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public ByteBuffer bufferForTableName() {
      return tableName;
    }

    /**
     * table name
     */
    public getColumnDescriptors_args setTableName(byte[] tableName) {
      setTableName(tableName == null ? (ByteBuffer)null : ByteBuffer.wrap(tableName));
      return this;
    }

    public getColumnDescriptors_args setTableName(ByteBuffer tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((ByteBuffer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getColumnDescriptors_args)
        return this.equals((getColumnDescriptors_args)that);
      return false;
    }

    public boolean equals(getColumnDescriptors_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_tableName = true && (isSetTableName());
      builder.append(present_tableName);
      if (present_tableName)
        builder.append(tableName);

      return builder.toHashCode();
    }

    public int compareTo(getColumnDescriptors_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getColumnDescriptors_args typedOther = (getColumnDescriptors_args)other;

      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(typedOther.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, typedOther.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getColumnDescriptors_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getColumnDescriptors_argsStandardSchemeFactory implements SchemeFactory {
      public getColumnDescriptors_argsStandardScheme getScheme() {
        return new getColumnDescriptors_argsStandardScheme();
      }
    }

    private static class getColumnDescriptors_argsStandardScheme extends StandardScheme<getColumnDescriptors_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getColumnDescriptors_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getColumnDescriptors_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getColumnDescriptors_argsTupleSchemeFactory implements SchemeFactory {
      public getColumnDescriptors_argsTupleScheme getScheme() {
        return new getColumnDescriptors_argsTupleScheme();
      }
    }

    private static class getColumnDescriptors_argsTupleScheme extends TupleScheme<getColumnDescriptors_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getColumnDescriptors_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getColumnDescriptors_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
      }
    }

  }

  public static class getColumnDescriptors_result implements org.apache.thrift.TBase<getColumnDescriptors_result, getColumnDescriptors_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getColumnDescriptors_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.MAP, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getColumnDescriptors_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getColumnDescriptors_resultTupleSchemeFactory());
    }

    public Map<ByteBuffer,ColumnDescriptor> success; // required
    public IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"), 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ColumnDescriptor.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getColumnDescriptors_result.class, metaDataMap);
    }

    public getColumnDescriptors_result() {
    }

    public getColumnDescriptors_result(
      Map<ByteBuffer,ColumnDescriptor> success,
      IOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getColumnDescriptors_result(getColumnDescriptors_result other) {
      if (other.isSetSuccess()) {
        Map<ByteBuffer,ColumnDescriptor> __this__success = new HashMap<ByteBuffer,ColumnDescriptor>();
        for (Map.Entry<ByteBuffer, ColumnDescriptor> other_element : other.success.entrySet()) {

          ByteBuffer other_element_key = other_element.getKey();
          ColumnDescriptor other_element_value = other_element.getValue();

          ByteBuffer __this__success_copy_key = other_element_key;

          ColumnDescriptor __this__success_copy_value = new ColumnDescriptor(other_element_value);

          __this__success.put(__this__success_copy_key, __this__success_copy_value);
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public getColumnDescriptors_result deepCopy() {
      return new getColumnDescriptors_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public void putToSuccess(ByteBuffer key, ColumnDescriptor val) {
      if (this.success == null) {
        this.success = new HashMap<ByteBuffer,ColumnDescriptor>();
      }
      this.success.put(key, val);
    }

    public Map<ByteBuffer,ColumnDescriptor> getSuccess() {
      return this.success;
    }

    public getColumnDescriptors_result setSuccess(Map<ByteBuffer,ColumnDescriptor> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public IOError getIo() {
      return this.io;
    }

    public getColumnDescriptors_result setIo(IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Map<ByteBuffer,ColumnDescriptor>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getColumnDescriptors_result)
        return this.equals((getColumnDescriptors_result)that);
      return false;
    }

    public boolean equals(getColumnDescriptors_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_io = true && (isSetIo());
      builder.append(present_io);
      if (present_io)
        builder.append(io);

      return builder.toHashCode();
    }

    public int compareTo(getColumnDescriptors_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getColumnDescriptors_result typedOther = (getColumnDescriptors_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIo()).compareTo(typedOther.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, typedOther.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getColumnDescriptors_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getColumnDescriptors_resultStandardSchemeFactory implements SchemeFactory {
      public getColumnDescriptors_resultStandardScheme getScheme() {
        return new getColumnDescriptors_resultStandardScheme();
      }
    }

    private static class getColumnDescriptors_resultStandardScheme extends StandardScheme<getColumnDescriptors_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getColumnDescriptors_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map58 = iprot.readMapBegin();
                  struct.success = new HashMap<ByteBuffer,ColumnDescriptor>(2*_map58.size);
                  for (int _i59 = 0; _i59 < _map58.size; ++_i59)
                  {
                    ByteBuffer _key60; // required
                    ColumnDescriptor _val61; // required
                    _key60 = iprot.readBinary();
                    _val61 = new ColumnDescriptor();
                    _val61.read(iprot);
                    struct.success.put(_key60, _val61);
                  }
                  iprot.readMapEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getColumnDescriptors_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (Map.Entry<ByteBuffer, ColumnDescriptor> _iter62 : struct.success.entrySet())
            {
              oprot.writeBinary(_iter62.getKey());
              _iter62.getValue().write(oprot);
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getColumnDescriptors_resultTupleSchemeFactory implements SchemeFactory {
      public getColumnDescriptors_resultTupleScheme getScheme() {
        return new getColumnDescriptors_resultTupleScheme();
      }
    }

    private static class getColumnDescriptors_resultTupleScheme extends TupleScheme<getColumnDescriptors_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getColumnDescriptors_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (Map.Entry<ByteBuffer, ColumnDescriptor> _iter63 : struct.success.entrySet())
            {
              oprot.writeBinary(_iter63.getKey());
              _iter63.getValue().write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getColumnDescriptors_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TMap _map64 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new HashMap<ByteBuffer,ColumnDescriptor>(2*_map64.size);
            for (int _i65 = 0; _i65 < _map64.size; ++_i65)
            {
              ByteBuffer _key66; // required
              ColumnDescriptor _val67; // required
              _key66 = iprot.readBinary();
              _val67 = new ColumnDescriptor();
              _val67.read(iprot);
              struct.success.put(_key66, _val67);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

  }

  public static class getTableRegions_args implements org.apache.thrift.TBase<getTableRegions_args, getTableRegions_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getTableRegions_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getTableRegions_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getTableRegions_argsTupleSchemeFactory());
    }

    /**
     * table name
     */
    public ByteBuffer tableName; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * table name
       */
      TABLE_NAME((short)1, "tableName");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getTableRegions_args.class, metaDataMap);
    }

    public getTableRegions_args() {
    }

    public getTableRegions_args(
      ByteBuffer tableName)
    {
      this();
      this.tableName = tableName;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getTableRegions_args(getTableRegions_args other) {
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
    }

    public getTableRegions_args deepCopy() {
      return new getTableRegions_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
    }

    /**
     * table name
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public ByteBuffer bufferForTableName() {
      return tableName;
    }

    /**
     * table name
     */
    public getTableRegions_args setTableName(byte[] tableName) {
      setTableName(tableName == null ? (ByteBuffer)null : ByteBuffer.wrap(tableName));
      return this;
    }

    public getTableRegions_args setTableName(ByteBuffer tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((ByteBuffer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getTableRegions_args)
        return this.equals((getTableRegions_args)that);
      return false;
    }

    public boolean equals(getTableRegions_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_tableName = true && (isSetTableName());
      builder.append(present_tableName);
      if (present_tableName)
        builder.append(tableName);

      return builder.toHashCode();
    }

    public int compareTo(getTableRegions_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getTableRegions_args typedOther = (getTableRegions_args)other;

      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(typedOther.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, typedOther.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getTableRegions_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getTableRegions_argsStandardSchemeFactory implements SchemeFactory {
      public getTableRegions_argsStandardScheme getScheme() {
        return new getTableRegions_argsStandardScheme();
      }
    }

    private static class getTableRegions_argsStandardScheme extends StandardScheme<getTableRegions_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getTableRegions_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getTableRegions_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getTableRegions_argsTupleSchemeFactory implements SchemeFactory {
      public getTableRegions_argsTupleScheme getScheme() {
        return new getTableRegions_argsTupleScheme();
      }
    }

    private static class getTableRegions_argsTupleScheme extends TupleScheme<getTableRegions_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getTableRegions_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getTableRegions_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
      }
    }

  }

  public static class getTableRegions_result implements org.apache.thrift.TBase<getTableRegions_result, getTableRegions_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getTableRegions_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getTableRegions_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getTableRegions_resultTupleSchemeFactory());
    }

    public List<TRegionInfo> success; // required
    public IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TRegionInfo.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getTableRegions_result.class, metaDataMap);
    }

    public getTableRegions_result() {
    }

    public getTableRegions_result(
      List<TRegionInfo> success,
      IOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getTableRegions_result(getTableRegions_result other) {
      if (other.isSetSuccess()) {
        List<TRegionInfo> __this__success = new ArrayList<TRegionInfo>();
        for (TRegionInfo other_element : other.success) {
          __this__success.add(new TRegionInfo(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public getTableRegions_result deepCopy() {
      return new getTableRegions_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<TRegionInfo> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TRegionInfo elem) {
      if (this.success == null) {
        this.success = new ArrayList<TRegionInfo>();
      }
      this.success.add(elem);
    }

    public List<TRegionInfo> getSuccess() {
      return this.success;
    }

    public getTableRegions_result setSuccess(List<TRegionInfo> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public IOError getIo() {
      return this.io;
    }

    public getTableRegions_result setIo(IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<TRegionInfo>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getTableRegions_result)
        return this.equals((getTableRegions_result)that);
      return false;
    }

    public boolean equals(getTableRegions_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_io = true && (isSetIo());
      builder.append(present_io);
      if (present_io)
        builder.append(io);

      return builder.toHashCode();
    }

    public int compareTo(getTableRegions_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getTableRegions_result typedOther = (getTableRegions_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIo()).compareTo(typedOther.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, typedOther.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getTableRegions_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getTableRegions_resultStandardSchemeFactory implements SchemeFactory {
      public getTableRegions_resultStandardScheme getScheme() {
        return new getTableRegions_resultStandardScheme();
      }
    }

    private static class getTableRegions_resultStandardScheme extends StandardScheme<getTableRegions_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getTableRegions_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list68 = iprot.readListBegin();
                  struct.success = new ArrayList<TRegionInfo>(_list68.size);
                  for (int _i69 = 0; _i69 < _list68.size; ++_i69)
                  {
                    TRegionInfo _elem70; // required
                    _elem70 = new TRegionInfo();
                    _elem70.read(iprot);
                    struct.success.add(_elem70);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getTableRegions_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (TRegionInfo _iter71 : struct.success)
            {
              _iter71.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getTableRegions_resultTupleSchemeFactory implements SchemeFactory {
      public getTableRegions_resultTupleScheme getScheme() {
        return new getTableRegions_resultTupleScheme();
      }
    }

    private static class getTableRegions_resultTupleScheme extends TupleScheme<getTableRegions_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getTableRegions_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (TRegionInfo _iter72 : struct.success)
            {
              _iter72.write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getTableRegions_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list73 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<TRegionInfo>(_list73.size);
            for (int _i74 = 0; _i74 < _list73.size; ++_i74)
            {
              TRegionInfo _elem75; // required
              _elem75 = new TRegionInfo();
              _elem75.read(iprot);
              struct.success.add(_elem75);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

  }

  public static class createTable_args implements org.apache.thrift.TBase<createTable_args, createTable_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("createTable_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField COLUMN_FAMILIES_FIELD_DESC = new org.apache.thrift.protocol.TField("columnFamilies", org.apache.thrift.protocol.TType.LIST, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new createTable_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new createTable_argsTupleSchemeFactory());
    }

    /**
     * name of table to create
     */
    public ByteBuffer tableName; // required
    /**
     * list of column family descriptors
     */
    public List<ColumnDescriptor> columnFamilies; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of table to create
       */
      TABLE_NAME((short)1, "tableName"),
      /**
       * list of column family descriptors
       */
      COLUMN_FAMILIES((short)2, "columnFamilies");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          case 2: // COLUMN_FAMILIES
            return COLUMN_FAMILIES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.COLUMN_FAMILIES, new org.apache.thrift.meta_data.FieldMetaData("columnFamilies", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ColumnDescriptor.class))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(createTable_args.class, metaDataMap);
    }

    public createTable_args() {
    }

    public createTable_args(
      ByteBuffer tableName,
      List<ColumnDescriptor> columnFamilies)
    {
      this();
      this.tableName = tableName;
      this.columnFamilies = columnFamilies;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public createTable_args(createTable_args other) {
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
      if (other.isSetColumnFamilies()) {
        List<ColumnDescriptor> __this__columnFamilies = new ArrayList<ColumnDescriptor>();
        for (ColumnDescriptor other_element : other.columnFamilies) {
          __this__columnFamilies.add(new ColumnDescriptor(other_element));
        }
        this.columnFamilies = __this__columnFamilies;
      }
    }

    public createTable_args deepCopy() {
      return new createTable_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
      this.columnFamilies = null;
    }

    /**
     * name of table to create
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public ByteBuffer bufferForTableName() {
      return tableName;
    }

    /**
     * name of table to create
     */
    public createTable_args setTableName(byte[] tableName) {
      setTableName(tableName == null ? (ByteBuffer)null : ByteBuffer.wrap(tableName));
      return this;
    }

    public createTable_args setTableName(ByteBuffer tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public int getColumnFamiliesSize() {
      return (this.columnFamilies == null) ? 0 : this.columnFamilies.size();
    }

    public java.util.Iterator<ColumnDescriptor> getColumnFamiliesIterator() {
      return (this.columnFamilies == null) ? null : this.columnFamilies.iterator();
    }

    public void addToColumnFamilies(ColumnDescriptor elem) {
      if (this.columnFamilies == null) {
        this.columnFamilies = new ArrayList<ColumnDescriptor>();
      }
      this.columnFamilies.add(elem);
    }

    /**
     * list of column family descriptors
     */
    public List<ColumnDescriptor> getColumnFamilies() {
      return this.columnFamilies;
    }

    /**
     * list of column family descriptors
     */
    public createTable_args setColumnFamilies(List<ColumnDescriptor> columnFamilies) {
      this.columnFamilies = columnFamilies;
      return this;
    }

    public void unsetColumnFamilies() {
      this.columnFamilies = null;
    }

    /** Returns true if field columnFamilies is set (has been assigned a value) and false otherwise */
    public boolean isSetColumnFamilies() {
      return this.columnFamilies != null;
    }

    public void setColumnFamiliesIsSet(boolean value) {
      if (!value) {
        this.columnFamilies = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((ByteBuffer)value);
        }
        break;

      case COLUMN_FAMILIES:
        if (value == null) {
          unsetColumnFamilies();
        } else {
          setColumnFamilies((List<ColumnDescriptor>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      case COLUMN_FAMILIES:
        return getColumnFamilies();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      case COLUMN_FAMILIES:
        return isSetColumnFamilies();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof createTable_args)
        return this.equals((createTable_args)that);
      return false;
    }

    public boolean equals(createTable_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_columnFamilies = true && this.isSetColumnFamilies();
      boolean that_present_columnFamilies = true && that.isSetColumnFamilies();
      if (this_present_columnFamilies || that_present_columnFamilies) {
        if (!(this_present_columnFamilies && that_present_columnFamilies))
          return false;
        if (!this.columnFamilies.equals(that.columnFamilies))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_tableName = true && (isSetTableName());
      builder.append(present_tableName);
      if (present_tableName)
        builder.append(tableName);

      boolean present_columnFamilies = true && (isSetColumnFamilies());
      builder.append(present_columnFamilies);
      if (present_columnFamilies)
        builder.append(columnFamilies);

      return builder.toHashCode();
    }

    public int compareTo(createTable_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      createTable_args typedOther = (createTable_args)other;

      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(typedOther.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, typedOther.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetColumnFamilies()).compareTo(typedOther.isSetColumnFamilies());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumnFamilies()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.columnFamilies, typedOther.columnFamilies);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("createTable_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("columnFamilies:");
      if (this.columnFamilies == null) {
        sb.append("null");
      } else {
        sb.append(this.columnFamilies);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class createTable_argsStandardSchemeFactory implements SchemeFactory {
      public createTable_argsStandardScheme getScheme() {
        return new createTable_argsStandardScheme();
      }
    }

    private static class createTable_argsStandardScheme extends StandardScheme<createTable_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, createTable_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // COLUMN_FAMILIES
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list76 = iprot.readListBegin();
                  struct.columnFamilies = new ArrayList<ColumnDescriptor>(_list76.size);
                  for (int _i77 = 0; _i77 < _list76.size; ++_i77)
                  {
                    ColumnDescriptor _elem78; // required
                    _elem78 = new ColumnDescriptor();
                    _elem78.read(iprot);
                    struct.columnFamilies.add(_elem78);
                  }
                  iprot.readListEnd();
                }
                struct.setColumnFamiliesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, createTable_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        if (struct.columnFamilies != null) {
          oprot.writeFieldBegin(COLUMN_FAMILIES_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.columnFamilies.size()));
            for (ColumnDescriptor _iter79 : struct.columnFamilies)
            {
              _iter79.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class createTable_argsTupleSchemeFactory implements SchemeFactory {
      public createTable_argsTupleScheme getScheme() {
        return new createTable_argsTupleScheme();
      }
    }

    private static class createTable_argsTupleScheme extends TupleScheme<createTable_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, createTable_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        if (struct.isSetColumnFamilies()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
        if (struct.isSetColumnFamilies()) {
          {
            oprot.writeI32(struct.columnFamilies.size());
            for (ColumnDescriptor _iter80 : struct.columnFamilies)
            {
              _iter80.write(oprot);
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, createTable_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(1)) {
          {
            org.apache.thrift.protocol.TList _list81 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.columnFamilies = new ArrayList<ColumnDescriptor>(_list81.size);
            for (int _i82 = 0; _i82 < _list81.size; ++_i82)
            {
              ColumnDescriptor _elem83; // required
              _elem83 = new ColumnDescriptor();
              _elem83.read(iprot);
              struct.columnFamilies.add(_elem83);
            }
          }
          struct.setColumnFamiliesIsSet(true);
        }
      }
    }

  }

  public static class createTable_result implements org.apache.thrift.TBase<createTable_result, createTable_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("createTable_result");

    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField IA_FIELD_DESC = new org.apache.thrift.protocol.TField("ia", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField EXIST_FIELD_DESC = new org.apache.thrift.protocol.TField("exist", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new createTable_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new createTable_resultTupleSchemeFactory());
    }

    public IOError io; // required
    public IllegalArgument ia; // required
    public AlreadyExists exist; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IO((short)1, "io"),
      IA((short)2, "ia"),
      EXIST((short)3, "exist");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IO
            return IO;
          case 2: // IA
            return IA;
          case 3: // EXIST
            return EXIST;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.IA, new org.apache.thrift.meta_data.FieldMetaData("ia", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.EXIST, new org.apache.thrift.meta_data.FieldMetaData("exist", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(createTable_result.class, metaDataMap);
    }

    public createTable_result() {
    }

    public createTable_result(
      IOError io,
      IllegalArgument ia,
      AlreadyExists exist)
    {
      this();
      this.io = io;
      this.ia = ia;
      this.exist = exist;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public createTable_result(createTable_result other) {
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
      if (other.isSetIa()) {
        this.ia = new IllegalArgument(other.ia);
      }
      if (other.isSetExist()) {
        this.exist = new AlreadyExists(other.exist);
      }
    }

    public createTable_result deepCopy() {
      return new createTable_result(this);
    }

    @Override
    public void clear() {
      this.io = null;
      this.ia = null;
      this.exist = null;
    }

    public IOError getIo() {
      return this.io;
    }

    public createTable_result setIo(IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public IllegalArgument getIa() {
      return this.ia;
    }

    public createTable_result setIa(IllegalArgument ia) {
      this.ia = ia;
      return this;
    }

    public void unsetIa() {
      this.ia = null;
    }

    /** Returns true if field ia is set (has been assigned a value) and false otherwise */
    public boolean isSetIa() {
      return this.ia != null;
    }

    public void setIaIsSet(boolean value) {
      if (!value) {
        this.ia = null;
      }
    }

    public AlreadyExists getExist() {
      return this.exist;
    }

    public createTable_result setExist(AlreadyExists exist) {
      this.exist = exist;
      return this;
    }

    public void unsetExist() {
      this.exist = null;
    }

    /** Returns true if field exist is set (has been assigned a value) and false otherwise */
    public boolean isSetExist() {
      return this.exist != null;
    }

    public void setExistIsSet(boolean value) {
      if (!value) {
        this.exist = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      case IA:
        if (value == null) {
          unsetIa();
        } else {
          setIa((IllegalArgument)value);
        }
        break;

      case EXIST:
        if (value == null) {
          unsetExist();
        } else {
          setExist((AlreadyExists)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case IO:
        return getIo();

      case IA:
        return getIa();

      case EXIST:
        return getExist();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case IO:
        return isSetIo();
      case IA:
        return isSetIa();
      case EXIST:
        return isSetExist();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof createTable_result)
        return this.equals((createTable_result)that);
      return false;
    }

    public boolean equals(createTable_result that) {
      if (that == null)
        return false;

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      boolean this_present_ia = true && this.isSetIa();
      boolean that_present_ia = true && that.isSetIa();
      if (this_present_ia || that_present_ia) {
        if (!(this_present_ia && that_present_ia))
          return false;
        if (!this.ia.equals(that.ia))
          return false;
      }

      boolean this_present_exist = true && this.isSetExist();
      boolean that_present_exist = true && that.isSetExist();
      if (this_present_exist || that_present_exist) {
        if (!(this_present_exist && that_present_exist))
          return false;
        if (!this.exist.equals(that.exist))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_io = true && (isSetIo());
      builder.append(present_io);
      if (present_io)
        builder.append(io);

      boolean present_ia = true && (isSetIa());
      builder.append(present_ia);
      if (present_ia)
        builder.append(ia);

      boolean present_exist = true && (isSetExist());
      builder.append(present_exist);
      if (present_exist)
        builder.append(exist);

      return builder.toHashCode();
    }

    public int compareTo(createTable_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      createTable_result typedOther = (createTable_result)other;

      lastComparison = Boolean.valueOf(isSetIo()).compareTo(typedOther.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, typedOther.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIa()).compareTo(typedOther.isSetIa());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIa()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ia, typedOther.ia);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetExist()).compareTo(typedOther.isSetExist());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetExist()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.exist, typedOther.exist);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("createTable_result(");
      boolean first = true;

      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ia:");
      if (this.ia == null) {
        sb.append("null");
      } else {
        sb.append(this.ia);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("exist:");
      if (this.exist == null) {
        sb.append("null");
      } else {
        sb.append(this.exist);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class createTable_resultStandardSchemeFactory implements SchemeFactory {
      public createTable_resultStandardScheme getScheme() {
        return new createTable_resultStandardScheme();
      }
    }

    private static class createTable_resultStandardScheme extends StandardScheme<createTable_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, createTable_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // IA
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ia = new IllegalArgument();
                struct.ia.read(iprot);
                struct.setIaIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // EXIST
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.exist = new AlreadyExists();
                struct.exist.read(iprot);
                struct.setExistIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, createTable_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.ia != null) {
          oprot.writeFieldBegin(IA_FIELD_DESC);
          struct.ia.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.exist != null) {
          oprot.writeFieldBegin(EXIST_FIELD_DESC);
          struct.exist.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class createTable_resultTupleSchemeFactory implements SchemeFactory {
      public createTable_resultTupleScheme getScheme() {
        return new createTable_resultTupleScheme();
      }
    }

    private static class createTable_resultTupleScheme extends TupleScheme<createTable_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, createTable_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetIo()) {
          optionals.set(0);
        }
        if (struct.isSetIa()) {
          optionals.set(1);
        }
        if (struct.isSetExist()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
        if (struct.isSetIa()) {
          struct.ia.write(oprot);
        }
        if (struct.isSetExist()) {
          struct.exist.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, createTable_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.ia = new IllegalArgument();
          struct.ia.read(iprot);
          struct.setIaIsSet(true);
        }
        if (incoming.get(2)) {
          struct.exist = new AlreadyExists();
          struct.exist.read(iprot);
          struct.setExistIsSet(true);
        }
      }
    }

  }

  public static class deleteTable_args implements org.apache.thrift.TBase<deleteTable_args, deleteTable_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("deleteTable_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new deleteTable_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new deleteTable_argsTupleSchemeFactory());
    }

    /**
     * name of table to delete
     */
    public ByteBuffer tableName; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of table to delete
       */
      TABLE_NAME((short)1, "tableName");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(deleteTable_args.class, metaDataMap);
    }

    public deleteTable_args() {
    }

    public deleteTable_args(
      ByteBuffer tableName)
    {
      this();
      this.tableName = tableName;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public deleteTable_args(deleteTable_args other) {
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
    }

    public deleteTable_args deepCopy() {
      return new deleteTable_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
    }

    /**
     * name of table to delete
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public ByteBuffer bufferForTableName() {
      return tableName;
    }

    /**
     * name of table to delete
     */
    public deleteTable_args setTableName(byte[] tableName) {
      setTableName(tableName == null ? (ByteBuffer)null : ByteBuffer.wrap(tableName));
      return this;
    }

    public deleteTable_args setTableName(ByteBuffer tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((ByteBuffer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof deleteTable_args)
        return this.equals((deleteTable_args)that);
      return false;
    }

    public boolean equals(deleteTable_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_tableName = true && (isSetTableName());
      builder.append(present_tableName);
      if (present_tableName)
        builder.append(tableName);

      return builder.toHashCode();
    }

    public int compareTo(deleteTable_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      deleteTable_args typedOther = (deleteTable_args)other;

      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(typedOther.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, typedOther.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("deleteTable_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class deleteTable_argsStandardSchemeFactory implements SchemeFactory {
      public deleteTable_argsStandardScheme getScheme() {
        return new deleteTable_argsStandardScheme();
      }
    }

    private static class deleteTable_argsStandardScheme extends StandardScheme<deleteTable_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, deleteTable_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, deleteTable_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class deleteTable_argsTupleSchemeFactory implements SchemeFactory {
      public deleteTable_argsTupleScheme getScheme() {
        return new deleteTable_argsTupleScheme();
      }
    }

    private static class deleteTable_argsTupleScheme extends TupleScheme<deleteTable_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, deleteTable_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, deleteTable_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
      }
    }

  }

  public static class deleteTable_result implements org.apache.thrift.TBase<deleteTable_result, deleteTable_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("deleteTable_result");

    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new deleteTable_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new deleteTable_resultTupleSchemeFactory());
    }

    public IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IO((short)1, "io");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(deleteTable_result.class, metaDataMap);
    }

    public deleteTable_result() {
    }

    public deleteTable_result(
      IOError io)
    {
      this();
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public deleteTable_result(deleteTable_result other) {
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public deleteTable_result deepCopy() {
      return new deleteTable_result(this);
    }

    @Override
    public void clear() {
      this.io = null;
    }

    public IOError getIo() {
      return this.io;
    }

    public deleteTable_result setIo(IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case IO:
        return getIo();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case IO:
        return isSetIo();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof deleteTable_result)
        return this.equals((deleteTable_result)that);
      return false;
    }

    public boolean equals(deleteTable_result that) {
      if (that == null)
        return false;

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_io = true && (isSetIo());
      builder.append(present_io);
      if (present_io)
        builder.append(io);

      return builder.toHashCode();
    }

    public int compareTo(deleteTable_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      deleteTable_result typedOther = (deleteTable_result)other;

      lastComparison = Boolean.valueOf(isSetIo()).compareTo(typedOther.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, typedOther.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("deleteTable_result(");
      boolean first = true;

      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class deleteTable_resultStandardSchemeFactory implements SchemeFactory {
      public deleteTable_resultStandardScheme getScheme() {
        return new deleteTable_resultStandardScheme();
      }
    }

    private static class deleteTable_resultStandardScheme extends StandardScheme<deleteTable_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, deleteTable_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, deleteTable_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class deleteTable_resultTupleSchemeFactory implements SchemeFactory {
      public deleteTable_resultTupleScheme getScheme() {
        return new deleteTable_resultTupleScheme();
      }
    }

    private static class deleteTable_resultTupleScheme extends TupleScheme<deleteTable_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, deleteTable_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetIo()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, deleteTable_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

  }

  public static class get_args implements org.apache.thrift.TBase<get_args, get_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField ROW_FIELD_DESC = new org.apache.thrift.protocol.TField("row", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField COLUMN_FIELD_DESC = new org.apache.thrift.protocol.TField("column", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField ATTRIBUTES_FIELD_DESC = new org.apache.thrift.protocol.TField("attributes", org.apache.thrift.protocol.TType.MAP, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new get_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new get_argsTupleSchemeFactory());
    }

    /**
     * name of table
     */
    public ByteBuffer tableName; // required
    /**
     * row key
     */
    public ByteBuffer row; // required
    /**
     * column name
     */
    public ByteBuffer column; // required
    /**
     * Get attributes
     */
    public Map<ByteBuffer,ByteBuffer> attributes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of table
       */
      TABLE_NAME((short)1, "tableName"),
      /**
       * row key
       */
      ROW((short)2, "row"),
      /**
       * column name
       */
      COLUMN((short)3, "column"),
      /**
       * Get attributes
       */
      ATTRIBUTES((short)4, "attributes");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          case 2: // ROW
            return ROW;
          case 3: // COLUMN
            return COLUMN;
          case 4: // ATTRIBUTES
            return ATTRIBUTES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.ROW, new org.apache.thrift.meta_data.FieldMetaData("row", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.COLUMN, new org.apache.thrift.meta_data.FieldMetaData("column", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.ATTRIBUTES, new org.apache.thrift.meta_data.FieldMetaData("attributes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"), 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_args.class, metaDataMap);
    }

    public get_args() {
    }

    public get_args(
      ByteBuffer tableName,
      ByteBuffer row,
      ByteBuffer column,
      Map<ByteBuffer,ByteBuffer> attributes)
    {
      this();
      this.tableName = tableName;
      this.row = row;
      this.column = column;
      this.attributes = attributes;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_args(get_args other) {
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
      if (other.isSetRow()) {
        this.row = other.row;
      }
      if (other.isSetColumn()) {
        this.column = other.column;
      }
      if (other.isSetAttributes()) {
        Map<ByteBuffer,ByteBuffer> __this__attributes = new HashMap<ByteBuffer,ByteBuffer>();
        for (Map.Entry<ByteBuffer, ByteBuffer> other_element : other.attributes.entrySet()) {

          ByteBuffer other_element_key = other_element.getKey();
          ByteBuffer other_element_value = other_element.getValue();

          ByteBuffer __this__attributes_copy_key = other_element_key;

          ByteBuffer __this__attributes_copy_value = other_element_value;

          __this__attributes.put(__this__attributes_copy_key, __this__attributes_copy_value);
        }
        this.attributes = __this__attributes;
      }
    }

    public get_args deepCopy() {
      return new get_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
      this.row = null;
      this.column = null;
      this.attributes = null;
    }

    /**
     * name of table
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public ByteBuffer bufferForTableName() {
      return tableName;
    }

    /**
     * name of table
     */
    public get_args setTableName(byte[] tableName) {
      setTableName(tableName == null ? (ByteBuffer)null : ByteBuffer.wrap(tableName));
      return this;
    }

    public get_args setTableName(ByteBuffer tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    /**
     * row key
     */
    public byte[] getRow() {
      setRow(org.apache.thrift.TBaseHelper.rightSize(row));
      return row == null ? null : row.array();
    }

    public ByteBuffer bufferForRow() {
      return row;
    }

    /**
     * row key
     */
    public get_args setRow(byte[] row) {
      setRow(row == null ? (ByteBuffer)null : ByteBuffer.wrap(row));
      return this;
    }

    public get_args setRow(ByteBuffer row) {
      this.row = row;
      return this;
    }

    public void unsetRow() {
      this.row = null;
    }

    /** Returns true if field row is set (has been assigned a value) and false otherwise */
    public boolean isSetRow() {
      return this.row != null;
    }

    public void setRowIsSet(boolean value) {
      if (!value) {
        this.row = null;
      }
    }

    /**
     * column name
     */
    public byte[] getColumn() {
      setColumn(org.apache.thrift.TBaseHelper.rightSize(column));
      return column == null ? null : column.array();
    }

    public ByteBuffer bufferForColumn() {
      return column;
    }

    /**
     * column name
     */
    public get_args setColumn(byte[] column) {
      setColumn(column == null ? (ByteBuffer)null : ByteBuffer.wrap(column));
      return this;
    }

    public get_args setColumn(ByteBuffer column) {
      this.column = column;
      return this;
    }

    public void unsetColumn() {
      this.column = null;
    }

    /** Returns true if field column is set (has been assigned a value) and false otherwise */
    public boolean isSetColumn() {
      return this.column != null;
    }

    public void setColumnIsSet(boolean value) {
      if (!value) {
        this.column = null;
      }
    }

    public int getAttributesSize() {
      return (this.attributes == null) ? 0 : this.attributes.size();
    }

    public void putToAttributes(ByteBuffer key, ByteBuffer val) {
      if (this.attributes == null) {
        this.attributes = new HashMap<ByteBuffer,ByteBuffer>();
      }
      this.attributes.put(key, val);
    }

    /**
     * Get attributes
     */
    public Map<ByteBuffer,ByteBuffer> getAttributes() {
      return this.attributes;
    }

    /**
     * Get attributes
     */
    public get_args setAttributes(Map<ByteBuffer,ByteBuffer> attributes) {
      this.attributes = attributes;
      return this;
    }

    public void unsetAttributes() {
      this.attributes = null;
    }

    /** Returns true if field attributes is set (has been assigned a value) and false otherwise */
    public boolean isSetAttributes() {
      return this.attributes != null;
    }

    public void setAttributesIsSet(boolean value) {
      if (!value) {
        this.attributes = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((ByteBuffer)value);
        }
        break;

      case ROW:
        if (value == null) {
          unsetRow();
        } else {
          setRow((ByteBuffer)value);
        }
        break;

      case COLUMN:
        if (value == null) {
          unsetColumn();
        } else {
          setColumn((ByteBuffer)value);
        }
        break;

      case ATTRIBUTES:
        if (value == null) {
          unsetAttributes();
        } else {
          setAttributes((Map<ByteBuffer,ByteBuffer>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      case ROW:
        return getRow();

      case COLUMN:
        return getColumn();

      case ATTRIBUTES:
        return getAttributes();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      case ROW:
        return isSetRow();
      case COLUMN:
        return isSetColumn();
      case ATTRIBUTES:
        return isSetAttributes();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof get_args)
        return this.equals((get_args)that);
      return false;
    }

    public boolean equals(get_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_row = true && this.isSetRow();
      boolean that_present_row = true && that.isSetRow();
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!this.row.equals(that.row))
          return false;
      }

      boolean this_present_column = true && this.isSetColumn();
      boolean that_present_column = true && that.isSetColumn();
      if (this_present_column || that_present_column) {
        if (!(this_present_column && that_present_column))
          return false;
        if (!this.column.equals(that.column))
          return false;
      }

      boolean this_present_attributes = true && this.isSetAttributes();
      boolean that_present_attributes = true && that.isSetAttributes();
      if (this_present_attributes || that_present_attributes) {
        if (!(this_present_attributes && that_present_attributes))
          return false;
        if (!this.attributes.equals(that.attributes))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_tableName = true && (isSetTableName());
      builder.append(present_tableName);
      if (present_tableName)
        builder.append(tableName);

      boolean present_row = true && (isSetRow());
      builder.append(present_row);
      if (present_row)
        builder.append(row);

      boolean present_column = true && (isSetColumn());
      builder.append(present_column);
      if (present_column)
        builder.append(column);

      boolean present_attributes = true && (isSetAttributes());
      builder.append(present_attributes);
      if (present_attributes)
        builder.append(attributes);

      return builder.toHashCode();
    }

    public int compareTo(get_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      get_args typedOther = (get_args)other;

      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(typedOther.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, typedOther.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetRow()).compareTo(typedOther.isSetRow());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRow()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.row, typedOther.row);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetColumn()).compareTo(typedOther.isSetColumn());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumn()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.column, typedOther.column);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetAttributes()).compareTo(typedOther.isSetAttributes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAttributes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.attributes, typedOther.attributes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("get_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("row:");
      if (this.row == null) {
        sb.append("null");
      } else {
        sb.append(this.row);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("column:");
      if (this.column == null) {
        sb.append("null");
      } else {
        sb.append(this.column);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("attributes:");
      if (this.attributes == null) {
        sb.append("null");
      } else {
        sb.append(this.attributes);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class get_argsStandardSchemeFactory implements SchemeFactory {
      public get_argsStandardScheme getScheme() {
        return new get_argsStandardScheme();
      }
    }

    private static class get_argsStandardScheme extends StandardScheme<get_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, get_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ROW
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.row = iprot.readBinary();
                struct.setRowIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // COLUMN
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.column = iprot.readBinary();
                struct.setColumnIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // ATTRIBUTES
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map84 = iprot.readMapBegin();
                  struct.attributes = new HashMap<ByteBuffer,ByteBuffer>(2*_map84.size);
                  for (int _i85 = 0; _i85 < _map84.size; ++_i85)
                  {
                    ByteBuffer _key86; // required
                    ByteBuffer _val87; // required
                    _key86 = iprot.readBinary();
                    _val87 = iprot.readBinary();
                    struct.attributes.put(_key86, _val87);
                  }
                  iprot.readMapEnd();
                }
                struct.setAttributesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, get_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        if (struct.row != null) {
          oprot.writeFieldBegin(ROW_FIELD_DESC);
          oprot.writeBinary(struct.row);
          oprot.writeFieldEnd();
        }
        if (struct.column != null) {
          oprot.writeFieldBegin(COLUMN_FIELD_DESC);
          oprot.writeBinary(struct.column);
          oprot.writeFieldEnd();
        }
        if (struct.attributes != null) {
          oprot.writeFieldBegin(ATTRIBUTES_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, struct.attributes.size()));
            for (Map.Entry<ByteBuffer, ByteBuffer> _iter88 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter88.getKey());
              oprot.writeBinary(_iter88.getValue());
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class get_argsTupleSchemeFactory implements SchemeFactory {
      public get_argsTupleScheme getScheme() {
        return new get_argsTupleScheme();
      }
    }

    private static class get_argsTupleScheme extends TupleScheme<get_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, get_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        if (struct.isSetRow()) {
          optionals.set(1);
        }
        if (struct.isSetColumn()) {
          optionals.set(2);
        }
        if (struct.isSetAttributes()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
        if (struct.isSetRow()) {
          oprot.writeBinary(struct.row);
        }
        if (struct.isSetColumn()) {
          oprot.writeBinary(struct.column);
        }
        if (struct.isSetAttributes()) {
          {
            oprot.writeI32(struct.attributes.size());
            for (Map.Entry<ByteBuffer, ByteBuffer> _iter89 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter89.getKey());
              oprot.writeBinary(_iter89.getValue());
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, get_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(1)) {
          struct.row = iprot.readBinary();
          struct.setRowIsSet(true);
        }
        if (incoming.get(2)) {
          struct.column = iprot.readBinary();
          struct.setColumnIsSet(true);
        }
        if (incoming.get(3)) {
          {
            org.apache.thrift.protocol.TMap _map90 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.attributes = new HashMap<ByteBuffer,ByteBuffer>(2*_map90.size);
            for (int _i91 = 0; _i91 < _map90.size; ++_i91)
            {
              ByteBuffer _key92; // required
              ByteBuffer _val93; // required
              _key92 = iprot.readBinary();
              _val93 = iprot.readBinary();
              struct.attributes.put(_key92, _val93);
            }
          }
          struct.setAttributesIsSet(true);
        }
      }
    }

  }

  public static class get_result implements org.apache.thrift.TBase<get_result, get_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new get_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new get_resultTupleSchemeFactory());
    }

    public List<TCell> success; // required
    public IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TCell.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_result.class, metaDataMap);
    }

    public get_result() {
    }

    public get_result(
      List<TCell> success,
      IOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_result(get_result other) {
      if (other.isSetSuccess()) {
        List<TCell> __this__success = new ArrayList<TCell>();
        for (TCell other_element : other.success) {
          __this__success.add(new TCell(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public get_result deepCopy() {
      return new get_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<TCell> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TCell elem) {
      if (this.success == null) {
        this.success = new ArrayList<TCell>();
      }
      this.success.add(elem);
    }

    public List<TCell> getSuccess() {
      return this.success;
    }

    public get_result setSuccess(List<TCell> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public IOError getIo() {
      return this.io;
    }

    public get_result setIo(IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<TCell>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof get_result)
        return this.equals((get_result)that);
      return false;
    }

    public boolean equals(get_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_io = true && (isSetIo());
      builder.append(present_io);
      if (present_io)
        builder.append(io);

      return builder.toHashCode();
    }

    public int compareTo(get_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      get_result typedOther = (get_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIo()).compareTo(typedOther.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, typedOther.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("get_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class get_resultStandardSchemeFactory implements SchemeFactory {
      public get_resultStandardScheme getScheme() {
        return new get_resultStandardScheme();
      }
    }

    private static class get_resultStandardScheme extends StandardScheme<get_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, get_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list94 = iprot.readListBegin();
                  struct.success = new ArrayList<TCell>(_list94.size);
                  for (int _i95 = 0; _i95 < _list94.size; ++_i95)
                  {
                    TCell _elem96; // required
                    _elem96 = new TCell();
                    _elem96.read(iprot);
                    struct.success.add(_elem96);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, get_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (TCell _iter97 : struct.success)
            {
              _iter97.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class get_resultTupleSchemeFactory implements SchemeFactory {
      public get_resultTupleScheme getScheme() {
        return new get_resultTupleScheme();
      }
    }

    private static class get_resultTupleScheme extends TupleScheme<get_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, get_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (TCell _iter98 : struct.success)
            {
              _iter98.write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, get_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list99 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<TCell>(_list99.size);
            for (int _i100 = 0; _i100 < _list99.size; ++_i100)
            {
              TCell _elem101; // required
              _elem101 = new TCell();
              _elem101.read(iprot);
              struct.success.add(_elem101);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

  }

  public static class getVer_args implements org.apache.thrift.TBase<getVer_args, getVer_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getVer_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField ROW_FIELD_DESC = new org.apache.thrift.protocol.TField("row", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField COLUMN_FIELD_DESC = new org.apache.thrift.protocol.TField("column", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField NUM_VERSIONS_FIELD_DESC = new org.apache.thrift.protocol.TField("numVersions", org.apache.thrift.protocol.TType.I32, (short)4);
    private static final org.apache.thrift.protocol.TField ATTRIBUTES_FIELD_DESC = new org.apache.thrift.protocol.TField("attributes", org.apache.thrift.protocol.TType.MAP, (short)5);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getVer_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getVer_argsTupleSchemeFactory());
    }

    /**
     * name of table
     */
    public ByteBuffer tableName; // required
    /**
     * row key
     */
    public ByteBuffer row; // required
    /**
     * column name
     */
    public ByteBuffer column; // required
    /**
     * number of versions to retrieve
     */
    public int numVersions; // required
    /**
     * Get attributes
     */
    public Map<ByteBuffer,ByteBuffer> attributes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of table
       */
      TABLE_NAME((short)1, "tableName"),
      /**
       * row key
       */
      ROW((short)2, "row"),
      /**
       * column name
       */
      COLUMN((short)3, "column"),
      /**
       * number of versions to retrieve
       */
      NUM_VERSIONS((short)4, "numVersions"),
      /**
       * Get attributes
       */
      ATTRIBUTES((short)5, "attributes");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          case 2: // ROW
            return ROW;
          case 3: // COLUMN
            return COLUMN;
          case 4: // NUM_VERSIONS
            return NUM_VERSIONS;
          case 5: // ATTRIBUTES
            return ATTRIBUTES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __NUMVERSIONS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.ROW, new org.apache.thrift.meta_data.FieldMetaData("row", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.COLUMN, new org.apache.thrift.meta_data.FieldMetaData("column", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.NUM_VERSIONS, new org.apache.thrift.meta_data.FieldMetaData("numVersions", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.ATTRIBUTES, new org.apache.thrift.meta_data.FieldMetaData("attributes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"), 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getVer_args.class, metaDataMap);
    }

    public getVer_args() {
    }

    public getVer_args(
      ByteBuffer tableName,
      ByteBuffer row,
      ByteBuffer column,
      int numVersions,
      Map<ByteBuffer,ByteBuffer> attributes)
    {
      this();
      this.tableName = tableName;
      this.row = row;
      this.column = column;
      this.numVersions = numVersions;
      setNumVersionsIsSet(true);
      this.attributes = attributes;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getVer_args(getVer_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
      if (other.isSetRow()) {
        this.row = other.row;
      }
      if (other.isSetColumn()) {
        this.column = other.column;
      }
      this.numVersions = other.numVersions;
      if (other.isSetAttributes()) {
        Map<ByteBuffer,ByteBuffer> __this__attributes = new HashMap<ByteBuffer,ByteBuffer>();
        for (Map.Entry<ByteBuffer, ByteBuffer> other_element : other.attributes.entrySet()) {

          ByteBuffer other_element_key = other_element.getKey();
          ByteBuffer other_element_value = other_element.getValue();

          ByteBuffer __this__attributes_copy_key = other_element_key;

          ByteBuffer __this__attributes_copy_value = other_element_value;

          __this__attributes.put(__this__attributes_copy_key, __this__attributes_copy_value);
        }
        this.attributes = __this__attributes;
      }
    }

    public getVer_args deepCopy() {
      return new getVer_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
      this.row = null;
      this.column = null;
      setNumVersionsIsSet(false);
      this.numVersions = 0;
      this.attributes = null;
    }

    /**
     * name of table
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public ByteBuffer bufferForTableName() {
      return tableName;
    }

    /**
     * name of table
     */
    public getVer_args setTableName(byte[] tableName) {
      setTableName(tableName == null ? (ByteBuffer)null : ByteBuffer.wrap(tableName));
      return this;
    }

    public getVer_args setTableName(ByteBuffer tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    /**
     * row key
     */
    public byte[] getRow() {
      setRow(org.apache.thrift.TBaseHelper.rightSize(row));
      return row == null ? null : row.array();
    }

    public ByteBuffer bufferForRow() {
      return row;
    }

    /**
     * row key
     */
    public getVer_args setRow(byte[] row) {
      setRow(row == null ? (ByteBuffer)null : ByteBuffer.wrap(row));
      return this;
    }

    public getVer_args setRow(ByteBuffer row) {
      this.row = row;
      return this;
    }

    public void unsetRow() {
      this.row = null;
    }

    /** Returns true if field row is set (has been assigned a value) and false otherwise */
    public boolean isSetRow() {
      return this.row != null;
    }

    public void setRowIsSet(boolean value) {
      if (!value) {
        this.row = null;
      }
    }

    /**
     * column name
     */
    public byte[] getColumn() {
      setColumn(org.apache.thrift.TBaseHelper.rightSize(column));
      return column == null ? null : column.array();
    }

    public ByteBuffer bufferForColumn() {
      return column;
    }

    /**
     * column name
     */
    public getVer_args setColumn(byte[] column) {
      setColumn(column == null ? (ByteBuffer)null : ByteBuffer.wrap(column));
      return this;
    }

    public getVer_args setColumn(ByteBuffer column) {
      this.column = column;
      return this;
    }

    public void unsetColumn() {
      this.column = null;
    }

    /** Returns true if field column is set (has been assigned a value) and false otherwise */
    public boolean isSetColumn() {
      return this.column != null;
    }

    public void setColumnIsSet(boolean value) {
      if (!value) {
        this.column = null;
      }
    }

    /**
     * number of versions to retrieve
     */
    public int getNumVersions() {
      return this.numVersions;
    }

    /**
     * number of versions to retrieve
     */
    public getVer_args setNumVersions(int numVersions) {
      this.numVersions = numVersions;
      setNumVersionsIsSet(true);
      return this;
    }

    public void unsetNumVersions() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __NUMVERSIONS_ISSET_ID);
    }

    /** Returns true if field numVersions is set (has been assigned a value) and false otherwise */
    public boolean isSetNumVersions() {
      return EncodingUtils.testBit(__isset_bitfield, __NUMVERSIONS_ISSET_ID);
    }

    public void setNumVersionsIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __NUMVERSIONS_ISSET_ID, value);
    }

    public int getAttributesSize() {
      return (this.attributes == null) ? 0 : this.attributes.size();
    }

    public void putToAttributes(ByteBuffer key, ByteBuffer val) {
      if (this.attributes == null) {
        this.attributes = new HashMap<ByteBuffer,ByteBuffer>();
      }
      this.attributes.put(key, val);
    }

    /**
     * Get attributes
     */
    public Map<ByteBuffer,ByteBuffer> getAttributes() {
      return this.attributes;
    }

    /**
     * Get attributes
     */
    public getVer_args setAttributes(Map<ByteBuffer,ByteBuffer> attributes) {
      this.attributes = attributes;
      return this;
    }

    public void unsetAttributes() {
      this.attributes = null;
    }

    /** Returns true if field attributes is set (has been assigned a value) and false otherwise */
    public boolean isSetAttributes() {
      return this.attributes != null;
    }

    public void setAttributesIsSet(boolean value) {
      if (!value) {
        this.attributes = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((ByteBuffer)value);
        }
        break;

      case ROW:
        if (value == null) {
          unsetRow();
        } else {
          setRow((ByteBuffer)value);
        }
        break;

      case COLUMN:
        if (value == null) {
          unsetColumn();
        } else {
          setColumn((ByteBuffer)value);
        }
        break;

      case NUM_VERSIONS:
        if (value == null) {
          unsetNumVersions();
        } else {
          setNumVersions((Integer)value);
        }
        break;

      case ATTRIBUTES:
        if (value == null) {
          unsetAttributes();
        } else {
          setAttributes((Map<ByteBuffer,ByteBuffer>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      case ROW:
        return getRow();

      case COLUMN:
        return getColumn();

      case NUM_VERSIONS:
        return Integer.valueOf(getNumVersions());

      case ATTRIBUTES:
        return getAttributes();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      case ROW:
        return isSetRow();
      case COLUMN:
        return isSetColumn();
      case NUM_VERSIONS:
        return isSetNumVersions();
      case ATTRIBUTES:
        return isSetAttributes();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getVer_args)
        return this.equals((getVer_args)that);
      return false;
    }

    public boolean equals(getVer_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_row = true && this.isSetRow();
      boolean that_present_row = true && that.isSetRow();
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!this.row.equals(that.row))
          return false;
      }

      boolean this_present_column = true && this.isSetColumn();
      boolean that_present_column = true && that.isSetColumn();
      if (this_present_column || that_present_column) {
        if (!(this_present_column && that_present_column))
          return false;
        if (!this.column.equals(that.column))
          return false;
      }

      boolean this_present_numVersions = true;
      boolean that_present_numVersions = true;
      if (this_present_numVersions || that_present_numVersions) {
        if (!(this_present_numVersions && that_present_numVersions))
          return false;
        if (this.numVersions != that.numVersions)
          return false;
      }

      boolean this_present_attributes = true && this.isSetAttributes();
      boolean that_present_attributes = true && that.isSetAttributes();
      if (this_present_attributes || that_present_attributes) {
        if (!(this_present_attributes && that_present_attributes))
          return false;
        if (!this.attributes.equals(that.attributes))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_tableName = true && (isSetTableName());
      builder.append(present_tableName);
      if (present_tableName)
        builder.append(tableName);

      boolean present_row = true && (isSetRow());
      builder.append(present_row);
      if (present_row)
        builder.append(row);

      boolean present_column = true && (isSetColumn());
      builder.append(present_column);
      if (present_column)
        builder.append(column);

      boolean present_numVersions = true;
      builder.append(present_numVersions);
      if (present_numVersions)
        builder.append(numVersions);

      boolean present_attributes = true && (isSetAttributes());
      builder.append(present_attributes);
      if (present_attributes)
        builder.append(attributes);

      return builder.toHashCode();
    }

    public int compareTo(getVer_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getVer_args typedOther = (getVer_args)other;

      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(typedOther.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, typedOther.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetRow()).compareTo(typedOther.isSetRow());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRow()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.row, typedOther.row);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetColumn()).compareTo(typedOther.isSetColumn());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumn()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.column, typedOther.column);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetNumVersions()).compareTo(typedOther.isSetNumVersions());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNumVersions()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.numVersions, typedOther.numVersions);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetAttributes()).compareTo(typedOther.isSetAttributes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAttributes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.attributes, typedOther.attributes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getVer_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("row:");
      if (this.row == null) {
        sb.append("null");
      } else {
        sb.append(this.row);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("column:");
      if (this.column == null) {
        sb.append("null");
      } else {
        sb.append(this.column);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("numVersions:");
      sb.append(this.numVersions);
      first = false;
      if (!first) sb.append(", ");
      sb.append("attributes:");
      if (this.attributes == null) {
        sb.append("null");
      } else {
        sb.append(this.attributes);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getVer_argsStandardSchemeFactory implements SchemeFactory {
      public getVer_argsStandardScheme getScheme() {
        return new getVer_argsStandardScheme();
      }
    }

    private static class getVer_argsStandardScheme extends StandardScheme<getVer_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getVer_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ROW
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.row = iprot.readBinary();
                struct.setRowIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // COLUMN
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.column = iprot.readBinary();
                struct.setColumnIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // NUM_VERSIONS
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.numVersions = iprot.readI32();
                struct.setNumVersionsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // ATTRIBUTES
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map102 = iprot.readMapBegin();
                  struct.attributes = new HashMap<ByteBuffer,ByteBuffer>(2*_map102.size);
                  for (int _i103 = 0; _i103 < _map102.size; ++_i103)
                  {
                    ByteBuffer _key104; // required
                    ByteBuffer _val105; // required
                    _key104 = iprot.readBinary();
                    _val105 = iprot.readBinary();
                    struct.attributes.put(_key104, _val105);
                  }
                  iprot.readMapEnd();
                }
                struct.setAttributesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getVer_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        if (struct.row != null) {
          oprot.writeFieldBegin(ROW_FIELD_DESC);
          oprot.writeBinary(struct.row);
          oprot.writeFieldEnd();
        }
        if (struct.column != null) {
          oprot.writeFieldBegin(COLUMN_FIELD_DESC);
          oprot.writeBinary(struct.column);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(NUM_VERSIONS_FIELD_DESC);
        oprot.writeI32(struct.numVersions);
        oprot.writeFieldEnd();
        if (struct.attributes != null) {
          oprot.writeFieldBegin(ATTRIBUTES_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, struct.attributes.size()));
            for (Map.Entry<ByteBuffer, ByteBuffer> _iter106 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter106.getKey());
              oprot.writeBinary(_iter106.getValue());
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getVer_argsTupleSchemeFactory implements SchemeFactory {
      public getVer_argsTupleScheme getScheme() {
        return new getVer_argsTupleScheme();
      }
    }

    private static class getVer_argsTupleScheme extends TupleScheme<getVer_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getVer_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        if (struct.isSetRow()) {
          optionals.set(1);
        }
        if (struct.isSetColumn()) {
          optionals.set(2);
        }
        if (struct.isSetNumVersions()) {
          optionals.set(3);
        }
        if (struct.isSetAttributes()) {
          optionals.set(4);
        }
        oprot.writeBitSet(optionals, 5);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
        if (struct.isSetRow()) {
          oprot.writeBinary(struct.row);
        }
        if (struct.isSetColumn()) {
          oprot.writeBinary(struct.column);
        }
        if (struct.isSetNumVersions()) {
          oprot.writeI32(struct.numVersions);
        }
        if (struct.isSetAttributes()) {
          {
            oprot.writeI32(struct.attributes.size());
            for (Map.Entry<ByteBuffer, ByteBuffer> _iter107 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter107.getKey());
              oprot.writeBinary(_iter107.getValue());
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getVer_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(5);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(1)) {
          struct.row = iprot.readBinary();
          struct.setRowIsSet(true);
        }
        if (incoming.get(2)) {
          struct.column = iprot.readBinary();
          struct.setColumnIsSet(true);
        }
        if (incoming.get(3)) {
          struct.numVersions = iprot.readI32();
          struct.setNumVersionsIsSet(true);
        }
        if (incoming.get(4)) {
          {
            org.apache.thrift.protocol.TMap _map108 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.attributes = new HashMap<ByteBuffer,ByteBuffer>(2*_map108.size);
            for (int _i109 = 0; _i109 < _map108.size; ++_i109)
            {
              ByteBuffer _key110; // required
              ByteBuffer _val111; // required
              _key110 = iprot.readBinary();
              _val111 = iprot.readBinary();
              struct.attributes.put(_key110, _val111);
            }
          }
          struct.setAttributesIsSet(true);
        }
      }
    }

  }

  public static class getVer_result implements org.apache.thrift.TBase<getVer_result, getVer_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getVer_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getVer_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getVer_resultTupleSchemeFactory());
    }

    public List<TCell> success; // required
    public IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TCell.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getVer_result.class, metaDataMap);
    }

    public getVer_result() {
    }

    public getVer_result(
      List<TCell> success,
      IOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getVer_result(getVer_result other) {
      if (other.isSetSuccess()) {
        List<TCell> __this__success = new ArrayList<TCell>();
        for (TCell other_element : other.success) {
          __this__success.add(new TCell(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public getVer_result deepCopy() {
      return new getVer_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<TCell> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TCell elem) {
      if (this.success == null) {
        this.success = new ArrayList<TCell>();
      }
      this.success.add(elem);
    }

    public List<TCell> getSuccess() {
      return this.success;
    }

    public getVer_result setSuccess(List<TCell> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public IOError getIo() {
      return this.io;
    }

    public getVer_result setIo(IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<TCell>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getVer_result)
        return this.equals((getVer_result)that);
      return false;
    }

    public boolean equals(getVer_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_io = true && (isSetIo());
      builder.append(present_io);
      if (present_io)
        builder.append(io);

      return builder.toHashCode();
    }

    public int compareTo(getVer_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getVer_result typedOther = (getVer_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIo()).compareTo(typedOther.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, typedOther.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getVer_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getVer_resultStandardSchemeFactory implements SchemeFactory {
      public getVer_resultStandardScheme getScheme() {
        return new getVer_resultStandardScheme();
      }
    }

    private static class getVer_resultStandardScheme extends StandardScheme<getVer_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getVer_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list112 = iprot.readListBegin();
                  struct.success = new ArrayList<TCell>(_list112.size);
                  for (int _i113 = 0; _i113 < _list112.size; ++_i113)
                  {
                    TCell _elem114; // required
                    _elem114 = new TCell();
                    _elem114.read(iprot);
                    struct.success.add(_elem114);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getVer_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (TCell _iter115 : struct.success)
            {
              _iter115.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getVer_resultTupleSchemeFactory implements SchemeFactory {
      public getVer_resultTupleScheme getScheme() {
        return new getVer_resultTupleScheme();
      }
    }

    private static class getVer_resultTupleScheme extends TupleScheme<getVer_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getVer_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (TCell _iter116 : struct.success)
            {
              _iter116.write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getVer_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list117 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<TCell>(_list117.size);
            for (int _i118 = 0; _i118 < _list117.size; ++_i118)
            {
              TCell _elem119; // required
              _elem119 = new TCell();
              _elem119.read(iprot);
              struct.success.add(_elem119);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

  }

  public static class getVerTs_args implements org.apache.thrift.TBase<getVerTs_args, getVerTs_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getVerTs_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField ROW_FIELD_DESC = new org.apache.thrift.protocol.TField("row", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField COLUMN_FIELD_DESC = new org.apache.thrift.protocol.TField("column", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField TIMESTAMP_FIELD_DESC = new org.apache.thrift.protocol.TField("timestamp", org.apache.thrift.protocol.TType.I64, (short)4);
    private static final org.apache.thrift.protocol.TField NUM_VERSIONS_FIELD_DESC = new org.apache.thrift.protocol.TField("numVersions", org.apache.thrift.protocol.TType.I32, (short)5);
    private static final org.apache.thrift.protocol.TField ATTRIBUTES_FIELD_DESC = new org.apache.thrift.protocol.TField("attributes", org.apache.thrift.protocol.TType.MAP, (short)6);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getVerTs_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getVerTs_argsTupleSchemeFactory());
    }

    /**
     * name of table
     */
    public ByteBuffer tableName; // required
    /**
     * row key
     */
    public ByteBuffer row; // required
    /**
     * column name
     */
    public ByteBuffer column; // required
    /**
     * timestamp
     */
    public long timestamp; // required
    /**
     * number of versions to retrieve
     */
    public int numVersions; // required
    /**
     * Get attributes
     */
    public Map<ByteBuffer,ByteBuffer> attributes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of table
       */
      TABLE_NAME((short)1, "tableName"),
      /**
       * row key
       */
      ROW((short)2, "row"),
      /**
       * column name
       */
      COLUMN((short)3, "column"),
      /**
       * timestamp
       */
      TIMESTAMP((short)4, "timestamp"),
      /**
       * number of versions to retrieve
       */
      NUM_VERSIONS((short)5, "numVersions"),
      /**
       * Get attributes
       */
      ATTRIBUTES((short)6, "attributes");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          case 2: // ROW
            return ROW;
          case 3: // COLUMN
            return COLUMN;
          case 4: // TIMESTAMP
            return TIMESTAMP;
          case 5: // NUM_VERSIONS
            return NUM_VERSIONS;
          case 6: // ATTRIBUTES
            return ATTRIBUTES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TIMESTAMP_ISSET_ID = 0;
    private static final int __NUMVERSIONS_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.ROW, new org.apache.thrift.meta_data.FieldMetaData("row", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.COLUMN, new org.apache.thrift.meta_data.FieldMetaData("column", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.TIMESTAMP, new org.apache.thrift.meta_data.FieldMetaData("timestamp", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.NUM_VERSIONS, new org.apache.thrift.meta_data.FieldMetaData("numVersions", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.ATTRIBUTES, new org.apache.thrift.meta_data.FieldMetaData("attributes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"), 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getVerTs_args.class, metaDataMap);
    }

    public getVerTs_args() {
    }

    public getVerTs_args(
      ByteBuffer tableName,
      ByteBuffer row,
      ByteBuffer column,
      long timestamp,
      int numVersions,
      Map<ByteBuffer,ByteBuffer> attributes)
    {
      this();
      this.tableName = tableName;
      this.row = row;
      this.column = column;
      this.timestamp = timestamp;
      setTimestampIsSet(true);
      this.numVersions = numVersions;
      setNumVersionsIsSet(true);
      this.attributes = attributes;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getVerTs_args(getVerTs_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
      if (other.isSetRow()) {
        this.row = other.row;
      }
      if (other.isSetColumn()) {
        this.column = other.column;
      }
      this.timestamp = other.timestamp;
      this.numVersions = other.numVersions;
      if (other.isSetAttributes()) {
        Map<ByteBuffer,ByteBuffer> __this__attributes = new HashMap<ByteBuffer,ByteBuffer>();
        for (Map.Entry<ByteBuffer, ByteBuffer> other_element : other.attributes.entrySet()) {

          ByteBuffer other_element_key = other_element.getKey();
          ByteBuffer other_element_value = other_element.getValue();

          ByteBuffer __this__attributes_copy_key = other_element_key;

          ByteBuffer __this__attributes_copy_value = other_element_value;

          __this__attributes.put(__this__attributes_copy_key, __this__attributes_copy_value);
        }
        this.attributes = __this__attributes;
      }
    }

    public getVerTs_args deepCopy() {
      return new getVerTs_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
      this.row = null;
      this.column = null;
      setTimestampIsSet(false);
      this.timestamp = 0;
      setNumVersionsIsSet(false);
      this.numVersions = 0;
      this.attributes = null;
    }

    /**
     * name of table
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public ByteBuffer bufferForTableName() {
      return tableName;
    }

    /**
     * name of table
     */
    public getVerTs_args setTableName(byte[] tableName) {
      setTableName(tableName == null ? (ByteBuffer)null : ByteBuffer.wrap(tableName));
      return this;
    }

    public getVerTs_args setTableName(ByteBuffer tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    /**
     * row key
     */
    public byte[] getRow() {
      setRow(org.apache.thrift.TBaseHelper.rightSize(row));
      return row == null ? null : row.array();
    }

    public ByteBuffer bufferForRow() {
      return row;
    }

    /**
     * row key
     */
    public getVerTs_args setRow(byte[] row) {
      setRow(row == null ? (ByteBuffer)null : ByteBuffer.wrap(row));
      return this;
    }

    public getVerTs_args setRow(ByteBuffer row) {
      this.row = row;
      return this;
    }

    public void unsetRow() {
      this.row = null;
    }

    /** Returns true if field row is set (has been assigned a value) and false otherwise */
    public boolean isSetRow() {
      return this.row != null;
    }

    public void setRowIsSet(boolean value) {
      if (!value) {
        this.row = null;
      }
    }

    /**
     * column name
     */
    public byte[] getColumn() {
      setColumn(org.apache.thrift.TBaseHelper.rightSize(column));
      return column == null ? null : column.array();
    }

    public ByteBuffer bufferForColumn() {
      return column;
    }

    /**
     * column name
     */
    public getVerTs_args setColumn(byte[] column) {
      setColumn(column == null ? (ByteBuffer)null : ByteBuffer.wrap(column));
      return this;
    }

    public getVerTs_args setColumn(ByteBuffer column) {
      this.column = column;
      return this;
    }

    public void unsetColumn() {
      this.column = null;
    }

    /** Returns true if field column is set (has been assigned a value) and false otherwise */
    public boolean isSetColumn() {
      return this.column != null;
    }

    public void setColumnIsSet(boolean value) {
      if (!value) {
        this.column = null;
      }
    }

    /**
     * timestamp
     */
    public long getTimestamp() {
      return this.timestamp;
    }

    /**
     * timestamp
     */
    public getVerTs_args setTimestamp(long timestamp) {
      this.timestamp = timestamp;
      setTimestampIsSet(true);
      return this;
    }

    public void unsetTimestamp() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __TIMESTAMP_ISSET_ID);
    }

    /** Returns true if field timestamp is set (has been assigned a value) and false otherwise */
    public boolean isSetTimestamp() {
      return EncodingUtils.testBit(__isset_bitfield, __TIMESTAMP_ISSET_ID);
    }

    public void setTimestampIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __TIMESTAMP_ISSET_ID, value);
    }

    /**
     * number of versions to retrieve
     */
    public int getNumVersions() {
      return this.numVersions;
    }

    /**
     * number of versions to retrieve
     */
    public getVerTs_args setNumVersions(int numVersions) {
      this.numVersions = numVersions;
      setNumVersionsIsSet(true);
      return this;
    }

    public void unsetNumVersions() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __NUMVERSIONS_ISSET_ID);
    }

    /** Returns true if field numVersions is set (has been assigned a value) and false otherwise */
    public boolean isSetNumVersions() {
      return EncodingUtils.testBit(__isset_bitfield, __NUMVERSIONS_ISSET_ID);
    }

    public void setNumVersionsIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __NUMVERSIONS_ISSET_ID, value);
    }

    public int getAttributesSize() {
      return (this.attributes == null) ? 0 : this.attributes.size();
    }

    public void putToAttributes(ByteBuffer key, ByteBuffer val) {
      if (this.attributes == null) {
        this.attributes = new HashMap<ByteBuffer,ByteBuffer>();
      }
      this.attributes.put(key, val);
    }

    /**
     * Get attributes
     */
    public Map<ByteBuffer,ByteBuffer> getAttributes() {
      return this.attributes;
    }

    /**
     * Get attributes
     */
    public getVerTs_args setAttributes(Map<ByteBuffer,ByteBuffer> attributes) {
      this.attributes = attributes;
      return this;
    }

    public void unsetAttributes() {
      this.attributes = null;
    }

    /** Returns true if field attributes is set (has been assigned a value) and false otherwise */
    public boolean isSetAttributes() {
      return this.attributes != null;
    }

    public void setAttributesIsSet(boolean value) {
      if (!value) {
        this.attributes = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((ByteBuffer)value);
        }
        break;

      case ROW:
        if (value == null) {
          unsetRow();
        } else {
          setRow((ByteBuffer)value);
        }
        break;

      case COLUMN:
        if (value == null) {
          unsetColumn();
        } else {
          setColumn((ByteBuffer)value);
        }
        break;

      case TIMESTAMP:
        if (value == null) {
          unsetTimestamp();
        } else {
          setTimestamp((Long)value);
        }
        break;

      case NUM_VERSIONS:
        if (value == null) {
          unsetNumVersions();
        } else {
          setNumVersions((Integer)value);
        }
        break;

      case ATTRIBUTES:
        if (value == null) {
          unsetAttributes();
        } else {
          setAttributes((Map<ByteBuffer,ByteBuffer>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      case ROW:
        return getRow();

      case COLUMN:
        return getColumn();

      case TIMESTAMP:
        return Long.valueOf(getTimestamp());

      case NUM_VERSIONS:
        return Integer.valueOf(getNumVersions());

      case ATTRIBUTES:
        return getAttributes();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      case ROW:
        return isSetRow();
      case COLUMN:
        return isSetColumn();
      case TIMESTAMP:
        return isSetTimestamp();
      case NUM_VERSIONS:
        return isSetNumVersions();
      case ATTRIBUTES:
        return isSetAttributes();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getVerTs_args)
        return this.equals((getVerTs_args)that);
      return false;
    }

    public boolean equals(getVerTs_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_row = true && this.isSetRow();
      boolean that_present_row = true && that.isSetRow();
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!this.row.equals(that.row))
          return false;
      }

      boolean this_present_column = true && this.isSetColumn();
      boolean that_present_column = true && that.isSetColumn();
      if (this_present_column || that_present_column) {
        if (!(this_present_column && that_present_column))
          return false;
        if (!this.column.equals(that.column))
          return false;
      }

      boolean this_present_timestamp = true;
      boolean that_present_timestamp = true;
      if (this_present_timestamp || that_present_timestamp) {
        if (!(this_present_timestamp && that_present_timestamp))
          return false;
        if (this.timestamp != that.timestamp)
          return false;
      }

      boolean this_present_numVersions = true;
      boolean that_present_numVersions = true;
      if (this_present_numVersions || that_present_numVersions) {
        if (!(this_present_numVersions && that_present_numVersions))
          return false;
        if (this.numVersions != that.numVersions)
          return false;
      }

      boolean this_present_attributes = true && this.isSetAttributes();
      boolean that_present_attributes = true && that.isSetAttributes();
      if (this_present_attributes || that_present_attributes) {
        if (!(this_present_attributes && that_present_attributes))
          return false;
        if (!this.attributes.equals(that.attributes))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_tableName = true && (isSetTableName());
      builder.append(present_tableName);
      if (present_tableName)
        builder.append(tableName);

      boolean present_row = true && (isSetRow());
      builder.append(present_row);
      if (present_row)
        builder.append(row);

      boolean present_column = true && (isSetColumn());
      builder.append(present_column);
      if (present_column)
        builder.append(column);

      boolean present_timestamp = true;
      builder.append(present_timestamp);
      if (present_timestamp)
        builder.append(timestamp);

      boolean present_numVersions = true;
      builder.append(present_numVersions);
      if (present_numVersions)
        builder.append(numVersions);

      boolean present_attributes = true && (isSetAttributes());
      builder.append(present_attributes);
      if (present_attributes)
        builder.append(attributes);

      return builder.toHashCode();
    }

    public int compareTo(getVerTs_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getVerTs_args typedOther = (getVerTs_args)other;

      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(typedOther.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, typedOther.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetRow()).compareTo(typedOther.isSetRow());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRow()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.row, typedOther.row);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetColumn()).compareTo(typedOther.isSetColumn());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumn()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.column, typedOther.column);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTimestamp()).compareTo(typedOther.isSetTimestamp());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTimestamp()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.timestamp, typedOther.timestamp);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetNumVersions()).compareTo(typedOther.isSetNumVersions());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNumVersions()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.numVersions, typedOther.numVersions);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetAttributes()).compareTo(typedOther.isSetAttributes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAttributes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.attributes, typedOther.attributes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getVerTs_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("row:");
      if (this.row == null) {
        sb.append("null");
      } else {
        sb.append(this.row);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("column:");
      if (this.column == null) {
        sb.append("null");
      } else {
        sb.append(this.column);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("timestamp:");
      sb.append(this.timestamp);
      first = false;
      if (!first) sb.append(", ");
      sb.append("numVersions:");
      sb.append(this.numVersions);
      first = false;
      if (!first) sb.append(", ");
      sb.append("attributes:");
      if (this.attributes == null) {
        sb.append("null");
      } else {
        sb.append(this.attributes);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getVerTs_argsStandardSchemeFactory implements SchemeFactory {
      public getVerTs_argsStandardScheme getScheme() {
        return new getVerTs_argsStandardScheme();
      }
    }

    private static class getVerTs_argsStandardScheme extends StandardScheme<getVerTs_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getVerTs_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ROW
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.row = iprot.readBinary();
                struct.setRowIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // COLUMN
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.column = iprot.readBinary();
                struct.setColumnIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // TIMESTAMP
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.timestamp = iprot.readI64();
                struct.setTimestampIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // NUM_VERSIONS
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.numVersions = iprot.readI32();
                struct.setNumVersionsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 6: // ATTRIBUTES
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map120 = iprot.readMapBegin();
                  struct.attributes = new HashMap<ByteBuffer,ByteBuffer>(2*_map120.size);
                  for (int _i121 = 0; _i121 < _map120.size; ++_i121)
                  {
                    ByteBuffer _key122; // required
                    ByteBuffer _val123; // required
                    _key122 = iprot.readBinary();
                    _val123 = iprot.readBinary();
                    struct.attributes.put(_key122, _val123);
                  }
                  iprot.readMapEnd();
                }
                struct.setAttributesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getVerTs_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        if (struct.row != null) {
          oprot.writeFieldBegin(ROW_FIELD_DESC);
          oprot.writeBinary(struct.row);
          oprot.writeFieldEnd();
        }
        if (struct.column != null) {
          oprot.writeFieldBegin(COLUMN_FIELD_DESC);
          oprot.writeBinary(struct.column);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(TIMESTAMP_FIELD_DESC);
        oprot.writeI64(struct.timestamp);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(NUM_VERSIONS_FIELD_DESC);
        oprot.writeI32(struct.numVersions);
        oprot.writeFieldEnd();
        if (struct.attributes != null) {
          oprot.writeFieldBegin(ATTRIBUTES_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, struct.attributes.size()));
            for (Map.Entry<ByteBuffer, ByteBuffer> _iter124 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter124.getKey());
              oprot.writeBinary(_iter124.getValue());
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getVerTs_argsTupleSchemeFactory implements SchemeFactory {
      public getVerTs_argsTupleScheme getScheme() {
        return new getVerTs_argsTupleScheme();
      }
    }

    private static class getVerTs_argsTupleScheme extends TupleScheme<getVerTs_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getVerTs_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        if (struct.isSetRow()) {
          optionals.set(1);
        }
        if (struct.isSetColumn()) {
          optionals.set(2);
        }
        if (struct.isSetTimestamp()) {
          optionals.set(3);
        }
        if (struct.isSetNumVersions()) {
          optionals.set(4);
        }
        if (struct.isSetAttributes()) {
          optionals.set(5);
        }
        oprot.writeBitSet(optionals, 6);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
        if (struct.isSetRow()) {
          oprot.writeBinary(struct.row);
        }
        if (struct.isSetColumn()) {
          oprot.writeBinary(struct.column);
        }
        if (struct.isSetTimestamp()) {
          oprot.writeI64(struct.timestamp);
        }
        if (struct.isSetNumVersions()) {
          oprot.writeI32(struct.numVersions);
        }
        if (struct.isSetAttributes()) {
          {
            oprot.writeI32(struct.attributes.size());
            for (Map.Entry<ByteBuffer, ByteBuffer> _iter125 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter125.getKey());
              oprot.writeBinary(_iter125.getValue());
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getVerTs_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(6);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(1)) {
          struct.row = iprot.readBinary();
          struct.setRowIsSet(true);
        }
        if (incoming.get(2)) {
          struct.column = iprot.readBinary();
          struct.setColumnIsSet(true);
        }
        if (incoming.get(3)) {
          struct.timestamp = iprot.readI64();
          struct.setTimestampIsSet(true);
        }
        if (incoming.get(4)) {
          struct.numVersions = iprot.readI32();
          struct.setNumVersionsIsSet(true);
        }
        if (incoming.get(5)) {
          {
            org.apache.thrift.protocol.TMap _map126 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.attributes = new HashMap<ByteBuffer,ByteBuffer>(2*_map126.size);
            for (int _i127 = 0; _i127 < _map126.size; ++_i127)
            {
              ByteBuffer _key128; // required
              ByteBuffer _val129; // required
              _key128 = iprot.readBinary();
              _val129 = iprot.readBinary();
              struct.attributes.put(_key128, _val129);
            }
          }
          struct.setAttributesIsSet(true);
        }
      }
    }

  }

  public static class getVerTs_result implements org.apache.thrift.TBase<getVerTs_result, getVerTs_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getVerTs_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getVerTs_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getVerTs_resultTupleSchemeFactory());
    }

    public List<TCell> success; // required
    public IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TCell.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getVerTs_result.class, metaDataMap);
    }

    public getVerTs_result() {
    }

    public getVerTs_result(
      List<TCell> success,
      IOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getVerTs_result(getVerTs_result other) {
      if (other.isSetSuccess()) {
        List<TCell> __this__success = new ArrayList<TCell>();
        for (TCell other_element : other.success) {
          __this__success.add(new TCell(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public getVerTs_result deepCopy() {
      return new getVerTs_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<TCell> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TCell elem) {
      if (this.success == null) {
        this.success = new ArrayList<TCell>();
      }
      this.success.add(elem);
    }

    public List<TCell> getSuccess() {
      return this.success;
    }

    public getVerTs_result setSuccess(List<TCell> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public IOError getIo() {
      return this.io;
    }

    public getVerTs_result setIo(IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<TCell>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getVerTs_result)
        return this.equals((getVerTs_result)that);
      return false;
    }

    public boolean equals(getVerTs_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_io = true && (isSetIo());
      builder.append(present_io);
      if (present_io)
        builder.append(io);

      return builder.toHashCode();
    }

    public int compareTo(getVerTs_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getVerTs_result typedOther = (getVerTs_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIo()).compareTo(typedOther.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, typedOther.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getVerTs_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getVerTs_resultStandardSchemeFactory implements SchemeFactory {
      public getVerTs_resultStandardScheme getScheme() {
        return new getVerTs_resultStandardScheme();
      }
    }

    private static class getVerTs_resultStandardScheme extends StandardScheme<getVerTs_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getVerTs_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list130 = iprot.readListBegin();
                  struct.success = new ArrayList<TCell>(_list130.size);
                  for (int _i131 = 0; _i131 < _list130.size; ++_i131)
                  {
                    TCell _elem132; // required
                    _elem132 = new TCell();
                    _elem132.read(iprot);
                    struct.success.add(_elem132);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getVerTs_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (TCell _iter133 : struct.success)
            {
              _iter133.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getVerTs_resultTupleSchemeFactory implements SchemeFactory {
      public getVerTs_resultTupleScheme getScheme() {
        return new getVerTs_resultTupleScheme();
      }
    }

    private static class getVerTs_resultTupleScheme extends TupleScheme<getVerTs_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getVerTs_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (TCell _iter134 : struct.success)
            {
              _iter134.write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getVerTs_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list135 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<TCell>(_list135.size);
            for (int _i136 = 0; _i136 < _list135.size; ++_i136)
            {
              TCell _elem137; // required
              _elem137 = new TCell();
              _elem137.read(iprot);
              struct.success.add(_elem137);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

  }

  public static class getRow_args implements org.apache.thrift.TBase<getRow_args, getRow_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRow_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField ROW_FIELD_DESC = new org.apache.thrift.protocol.TField("row", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField ATTRIBUTES_FIELD_DESC = new org.apache.thrift.protocol.TField("attributes", org.apache.thrift.protocol.TType.MAP, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getRow_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getRow_argsTupleSchemeFactory());
    }

    /**
     * name of table
     */
    public ByteBuffer tableName; // required
    /**
     * row key
     */
    public ByteBuffer row; // required
    /**
     * Get attributes
     */
    public Map<ByteBuffer,ByteBuffer> attributes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of table
       */
      TABLE_NAME((short)1, "tableName"),
      /**
       * row key
       */
      ROW((short)2, "row"),
      /**
       * Get attributes
       */
      ATTRIBUTES((short)3, "attributes");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          case 2: // ROW
            return ROW;
          case 3: // ATTRIBUTES
            return ATTRIBUTES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.ROW, new org.apache.thrift.meta_data.FieldMetaData("row", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.ATTRIBUTES, new org.apache.thrift.meta_data.FieldMetaData("attributes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"), 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRow_args.class, metaDataMap);
    }

    public getRow_args() {
    }

    public getRow_args(
      ByteBuffer tableName,
      ByteBuffer row,
      Map<ByteBuffer,ByteBuffer> attributes)
    {
      this();
      this.tableName = tableName;
      this.row = row;
      this.attributes = attributes;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRow_args(getRow_args other) {
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
      if (other.isSetRow()) {
        this.row = other.row;
      }
      if (other.isSetAttributes()) {
        Map<ByteBuffer,ByteBuffer> __this__attributes = new HashMap<ByteBuffer,ByteBuffer>();
        for (Map.Entry<ByteBuffer, ByteBuffer> other_element : other.attributes.entrySet()) {

          ByteBuffer other_element_key = other_element.getKey();
          ByteBuffer other_element_value = other_element.getValue();

          ByteBuffer __this__attributes_copy_key = other_element_key;

          ByteBuffer __this__attributes_copy_value = other_element_value;

          __this__attributes.put(__this__attributes_copy_key, __this__attributes_copy_value);
        }
        this.attributes = __this__attributes;
      }
    }

    public getRow_args deepCopy() {
      return new getRow_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
      this.row = null;
      this.attributes = null;
    }

    /**
     * name of table
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public ByteBuffer bufferForTableName() {
      return tableName;
    }

    /**
     * name of table
     */
    public getRow_args setTableName(byte[] tableName) {
      setTableName(tableName == null ? (ByteBuffer)null : ByteBuffer.wrap(tableName));
      return this;
    }

    public getRow_args setTableName(ByteBuffer tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    /**
     * row key
     */
    public byte[] getRow() {
      setRow(org.apache.thrift.TBaseHelper.rightSize(row));
      return row == null ? null : row.array();
    }

    public ByteBuffer bufferForRow() {
      return row;
    }

    /**
     * row key
     */
    public getRow_args setRow(byte[] row) {
      setRow(row == null ? (ByteBuffer)null : ByteBuffer.wrap(row));
      return this;
    }

    public getRow_args setRow(ByteBuffer row) {
      this.row = row;
      return this;
    }

    public void unsetRow() {
      this.row = null;
    }

    /** Returns true if field row is set (has been assigned a value) and false otherwise */
    public boolean isSetRow() {
      return this.row != null;
    }

    public void setRowIsSet(boolean value) {
      if (!value) {
        this.row = null;
      }
    }

    public int getAttributesSize() {
      return (this.attributes == null) ? 0 : this.attributes.size();
    }

    public void putToAttributes(ByteBuffer key, ByteBuffer val) {
      if (this.attributes == null) {
        this.attributes = new HashMap<ByteBuffer,ByteBuffer>();
      }
      this.attributes.put(key, val);
    }

    /**
     * Get attributes
     */
    public Map<ByteBuffer,ByteBuffer> getAttributes() {
      return this.attributes;
    }

    /**
     * Get attributes
     */
    public getRow_args setAttributes(Map<ByteBuffer,ByteBuffer> attributes) {
      this.attributes = attributes;
      return this;
    }

    public void unsetAttributes() {
      this.attributes = null;
    }

    /** Returns true if field attributes is set (has been assigned a value) and false otherwise */
    public boolean isSetAttributes() {
      return this.attributes != null;
    }

    public void setAttributesIsSet(boolean value) {
      if (!value) {
        this.attributes = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((ByteBuffer)value);
        }
        break;

      case ROW:
        if (value == null) {
          unsetRow();
        } else {
          setRow((ByteBuffer)value);
        }
        break;

      case ATTRIBUTES:
        if (value == null) {
          unsetAttributes();
        } else {
          setAttributes((Map<ByteBuffer,ByteBuffer>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      case ROW:
        return getRow();

      case ATTRIBUTES:
        return getAttributes();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      case ROW:
        return isSetRow();
      case ATTRIBUTES:
        return isSetAttributes();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRow_args)
        return this.equals((getRow_args)that);
      return false;
    }

    public boolean equals(getRow_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_row = true && this.isSetRow();
      boolean that_present_row = true && that.isSetRow();
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!this.row.equals(that.row))
          return false;
      }

      boolean this_present_attributes = true && this.isSetAttributes();
      boolean that_present_attributes = true && that.isSetAttributes();
      if (this_present_attributes || that_present_attributes) {
        if (!(this_present_attributes && that_present_attributes))
          return false;
        if (!this.attributes.equals(that.attributes))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_tableName = true && (isSetTableName());
      builder.append(present_tableName);
      if (present_tableName)
        builder.append(tableName);

      boolean present_row = true && (isSetRow());
      builder.append(present_row);
      if (present_row)
        builder.append(row);

      boolean present_attributes = true && (isSetAttributes());
      builder.append(present_attributes);
      if (present_attributes)
        builder.append(attributes);

      return builder.toHashCode();
    }

    public int compareTo(getRow_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getRow_args typedOther = (getRow_args)other;

      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(typedOther.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, typedOther.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetRow()).compareTo(typedOther.isSetRow());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRow()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.row, typedOther.row);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetAttributes()).compareTo(typedOther.isSetAttributes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAttributes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.attributes, typedOther.attributes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getRow_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("row:");
      if (this.row == null) {
        sb.append("null");
      } else {
        sb.append(this.row);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("attributes:");
      if (this.attributes == null) {
        sb.append("null");
      } else {
        sb.append(this.attributes);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRow_argsStandardSchemeFactory implements SchemeFactory {
      public getRow_argsStandardScheme getScheme() {
        return new getRow_argsStandardScheme();
      }
    }

    private static class getRow_argsStandardScheme extends StandardScheme<getRow_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRow_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ROW
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.row = iprot.readBinary();
                struct.setRowIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // ATTRIBUTES
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map138 = iprot.readMapBegin();
                  struct.attributes = new HashMap<ByteBuffer,ByteBuffer>(2*_map138.size);
                  for (int _i139 = 0; _i139 < _map138.size; ++_i139)
                  {
                    ByteBuffer _key140; // required
                    ByteBuffer _val141; // required
                    _key140 = iprot.readBinary();
                    _val141 = iprot.readBinary();
                    struct.attributes.put(_key140, _val141);
                  }
                  iprot.readMapEnd();
                }
                struct.setAttributesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRow_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        if (struct.row != null) {
          oprot.writeFieldBegin(ROW_FIELD_DESC);
          oprot.writeBinary(struct.row);
          oprot.writeFieldEnd();
        }
        if (struct.attributes != null) {
          oprot.writeFieldBegin(ATTRIBUTES_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, struct.attributes.size()));
            for (Map.Entry<ByteBuffer, ByteBuffer> _iter142 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter142.getKey());
              oprot.writeBinary(_iter142.getValue());
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRow_argsTupleSchemeFactory implements SchemeFactory {
      public getRow_argsTupleScheme getScheme() {
        return new getRow_argsTupleScheme();
      }
    }

    private static class getRow_argsTupleScheme extends TupleScheme<getRow_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRow_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        if (struct.isSetRow()) {
          optionals.set(1);
        }
        if (struct.isSetAttributes()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
        if (struct.isSetRow()) {
          oprot.writeBinary(struct.row);
        }
        if (struct.isSetAttributes()) {
          {
            oprot.writeI32(struct.attributes.size());
            for (Map.Entry<ByteBuffer, ByteBuffer> _iter143 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter143.getKey());
              oprot.writeBinary(_iter143.getValue());
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRow_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(1)) {
          struct.row = iprot.readBinary();
          struct.setRowIsSet(true);
        }
        if (incoming.get(2)) {
          {
            org.apache.thrift.protocol.TMap _map144 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.attributes = new HashMap<ByteBuffer,ByteBuffer>(2*_map144.size);
            for (int _i145 = 0; _i145 < _map144.size; ++_i145)
            {
              ByteBuffer _key146; // required
              ByteBuffer _val147; // required
              _key146 = iprot.readBinary();
              _val147 = iprot.readBinary();
              struct.attributes.put(_key146, _val147);
            }
          }
          struct.setAttributesIsSet(true);
        }
      }
    }

  }

  public static class getRow_result implements org.apache.thrift.TBase<getRow_result, getRow_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRow_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getRow_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getRow_resultTupleSchemeFactory());
    }

    public List<TRowResult> success; // required
    public IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TRowResult.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRow_result.class, metaDataMap);
    }

    public getRow_result() {
    }

    public getRow_result(
      List<TRowResult> success,
      IOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRow_result(getRow_result other) {
      if (other.isSetSuccess()) {
        List<TRowResult> __this__success = new ArrayList<TRowResult>();
        for (TRowResult other_element : other.success) {
          __this__success.add(new TRowResult(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public getRow_result deepCopy() {
      return new getRow_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<TRowResult> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TRowResult elem) {
      if (this.success == null) {
        this.success = new ArrayList<TRowResult>();
      }
      this.success.add(elem);
    }

    public List<TRowResult> getSuccess() {
      return this.success;
    }

    public getRow_result setSuccess(List<TRowResult> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public IOError getIo() {
      return this.io;
    }

    public getRow_result setIo(IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<TRowResult>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRow_result)
        return this.equals((getRow_result)that);
      return false;
    }

    public boolean equals(getRow_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_io = true && (isSetIo());
      builder.append(present_io);
      if (present_io)
        builder.append(io);

      return builder.toHashCode();
    }

    public int compareTo(getRow_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getRow_result typedOther = (getRow_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIo()).compareTo(typedOther.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, typedOther.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getRow_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRow_resultStandardSchemeFactory implements SchemeFactory {
      public getRow_resultStandardScheme getScheme() {
        return new getRow_resultStandardScheme();
      }
    }

    private static class getRow_resultStandardScheme extends StandardScheme<getRow_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRow_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list148 = iprot.readListBegin();
                  struct.success = new ArrayList<TRowResult>(_list148.size);
                  for (int _i149 = 0; _i149 < _list148.size; ++_i149)
                  {
                    TRowResult _elem150; // required
                    _elem150 = new TRowResult();
                    _elem150.read(iprot);
                    struct.success.add(_elem150);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRow_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (TRowResult _iter151 : struct.success)
            {
              _iter151.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRow_resultTupleSchemeFactory implements SchemeFactory {
      public getRow_resultTupleScheme getScheme() {
        return new getRow_resultTupleScheme();
      }
    }

    private static class getRow_resultTupleScheme extends TupleScheme<getRow_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRow_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (TRowResult _iter152 : struct.success)
            {
              _iter152.write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRow_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list153 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<TRowResult>(_list153.size);
            for (int _i154 = 0; _i154 < _list153.size; ++_i154)
            {
              TRowResult _elem155; // required
              _elem155 = new TRowResult();
              _elem155.read(iprot);
              struct.success.add(_elem155);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

  }

  public static class getRowWithColumns_args implements org.apache.thrift.TBase<getRowWithColumns_args, getRowWithColumns_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRowWithColumns_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField ROW_FIELD_DESC = new org.apache.thrift.protocol.TField("row", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField COLUMNS_FIELD_DESC = new org.apache.thrift.protocol.TField("columns", org.apache.thrift.protocol.TType.LIST, (short)3);
    private static final org.apache.thrift.protocol.TField ATTRIBUTES_FIELD_DESC = new org.apache.thrift.protocol.TField("attributes", org.apache.thrift.protocol.TType.MAP, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getRowWithColumns_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getRowWithColumns_argsTupleSchemeFactory());
    }

    /**
     * name of table
     */
    public ByteBuffer tableName; // required
    /**
     * row key
     */
    public ByteBuffer row; // required
    /**
     * List of columns to return, null for all columns
     */
    public List<ByteBuffer> columns; // required
    /**
     * Get attributes
     */
    public Map<ByteBuffer,ByteBuffer> attributes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of table
       */
      TABLE_NAME((short)1, "tableName"),
      /**
       * row key
       */
      ROW((short)2, "row"),
      /**
       * List of columns to return, null for all columns
       */
      COLUMNS((short)3, "columns"),
      /**
       * Get attributes
       */
      ATTRIBUTES((short)4, "attributes");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          case 2: // ROW
            return ROW;
          case 3: // COLUMNS
            return COLUMNS;
          case 4: // ATTRIBUTES
            return ATTRIBUTES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.ROW, new org.apache.thrift.meta_data.FieldMetaData("row", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.COLUMNS, new org.apache.thrift.meta_data.FieldMetaData("columns", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      tmpMap.put(_Fields.ATTRIBUTES, new org.apache.thrift.meta_data.FieldMetaData("attributes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"), 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRowWithColumns_args.class, metaDataMap);
    }

    public getRowWithColumns_args() {
    }

    public getRowWithColumns_args(
      ByteBuffer tableName,
      ByteBuffer row,
      List<ByteBuffer> columns,
      Map<ByteBuffer,ByteBuffer> attributes)
    {
      this();
      this.tableName = tableName;
      this.row = row;
      this.columns = columns;
      this.attributes = attributes;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRowWithColumns_args(getRowWithColumns_args other) {
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
      if (other.isSetRow()) {
        this.row = other.row;
      }
      if (other.isSetColumns()) {
        List<ByteBuffer> __this__columns = new ArrayList<ByteBuffer>();
        for (ByteBuffer other_element : other.columns) {
          __this__columns.add(other_element);
        }
        this.columns = __this__columns;
      }
      if (other.isSetAttributes()) {
        Map<ByteBuffer,ByteBuffer> __this__attributes = new HashMap<ByteBuffer,ByteBuffer>();
        for (Map.Entry<ByteBuffer, ByteBuffer> other_element : other.attributes.entrySet()) {

          ByteBuffer other_element_key = other_element.getKey();
          ByteBuffer other_element_value = other_element.getValue();

          ByteBuffer __this__attributes_copy_key = other_element_key;

          ByteBuffer __this__attributes_copy_value = other_element_value;

          __this__attributes.put(__this__attributes_copy_key, __this__attributes_copy_value);
        }
        this.attributes = __this__attributes;
      }
    }

    public getRowWithColumns_args deepCopy() {
      return new getRowWithColumns_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
      this.row = null;
      this.columns = null;
      this.attributes = null;
    }

    /**
     * name of table
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public ByteBuffer bufferForTableName() {
      return tableName;
    }

    /**
     * name of table
     */
    public getRowWithColumns_args setTableName(byte[] tableName) {
      setTableName(tableName == null ? (ByteBuffer)null : ByteBuffer.wrap(tableName));
      return this;
    }

    public getRowWithColumns_args setTableName(ByteBuffer tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    /**
     * row key
     */
    public byte[] getRow() {
      setRow(org.apache.thrift.TBaseHelper.rightSize(row));
      return row == null ? null : row.array();
    }

    public ByteBuffer bufferForRow() {
      return row;
    }

    /**
     * row key
     */
    public getRowWithColumns_args setRow(byte[] row) {
      setRow(row == null ? (ByteBuffer)null : ByteBuffer.wrap(row));
      return this;
    }

    public getRowWithColumns_args setRow(ByteBuffer row) {
      this.row = row;
      return this;
    }

    public void unsetRow() {
      this.row = null;
    }

    /** Returns true if field row is set (has been assigned a value) and false otherwise */
    public boolean isSetRow() {
      return this.row != null;
    }

    public void setRowIsSet(boolean value) {
      if (!value) {
        this.row = null;
      }
    }

    public int getColumnsSize() {
      return (this.columns == null) ? 0 : this.columns.size();
    }

    public java.util.Iterator<ByteBuffer> getColumnsIterator() {
      return (this.columns == null) ? null : this.columns.iterator();
    }

    public void addToColumns(ByteBuffer elem) {
      if (this.columns == null) {
        this.columns = new ArrayList<ByteBuffer>();
      }
      this.columns.add(elem);
    }

    /**
     * List of columns to return, null for all columns
     */
    public List<ByteBuffer> getColumns() {
      return this.columns;
    }

    /**
     * List of columns to return, null for all columns
     */
    public getRowWithColumns_args setColumns(List<ByteBuffer> columns) {
      this.columns = columns;
      return this;
    }

    public void unsetColumns() {
      this.columns = null;
    }

    /** Returns true if field columns is set (has been assigned a value) and false otherwise */
    public boolean isSetColumns() {
      return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
      if (!value) {
        this.columns = null;
      }
    }

    public int getAttributesSize() {
      return (this.attributes == null) ? 0 : this.attributes.size();
    }

    public void putToAttributes(ByteBuffer key, ByteBuffer val) {
      if (this.attributes == null) {
        this.attributes = new HashMap<ByteBuffer,ByteBuffer>();
      }
      this.attributes.put(key, val);
    }

    /**
     * Get attributes
     */
    public Map<ByteBuffer,ByteBuffer> getAttributes() {
      return this.attributes;
    }

    /**
     * Get attributes
     */
    public getRowWithColumns_args setAttributes(Map<ByteBuffer,ByteBuffer> attributes) {
      this.attributes = attributes;
      return this;
    }

    public void unsetAttributes() {
      this.attributes = null;
    }

    /** Returns true if field attributes is set (has been assigned a value) and false otherwise */
    public boolean isSetAttributes() {
      return this.attributes != null;
    }

    public void setAttributesIsSet(boolean value) {
      if (!value) {
        this.attributes = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((ByteBuffer)value);
        }
        break;

      case ROW:
        if (value == null) {
          unsetRow();
        } else {
          setRow((ByteBuffer)value);
        }
        break;

      case COLUMNS:
        if (value == null) {
          unsetColumns();
        } else {
          setColumns((List<ByteBuffer>)value);
        }
        break;

      case ATTRIBUTES:
        if (value == null) {
          unsetAttributes();
        } else {
          setAttributes((Map<ByteBuffer,ByteBuffer>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      case ROW:
        return getRow();

      case COLUMNS:
        return getColumns();

      case ATTRIBUTES:
        return getAttributes();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      case ROW:
        return isSetRow();
      case COLUMNS:
        return isSetColumns();
      case ATTRIBUTES:
        return isSetAttributes();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRowWithColumns_args)
        return this.equals((getRowWithColumns_args)that);
      return false;
    }

    public boolean equals(getRowWithColumns_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_row = true && this.isSetRow();
      boolean that_present_row = true && that.isSetRow();
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!this.row.equals(that.row))
          return false;
      }

      boolean this_present_columns = true && this.isSetColumns();
      boolean that_present_columns = true && that.isSetColumns();
      if (this_present_columns || that_present_columns) {
        if (!(this_present_columns && that_present_columns))
          return false;
        if (!this.columns.equals(that.columns))
          return false;
      }

      boolean this_present_attributes = true && this.isSetAttributes();
      boolean that_present_attributes = true && that.isSetAttributes();
      if (this_present_attributes || that_present_attributes) {
        if (!(this_present_attributes && that_present_attributes))
          return false;
        if (!this.attributes.equals(that.attributes))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_tableName = true && (isSetTableName());
      builder.append(present_tableName);
      if (present_tableName)
        builder.append(tableName);

      boolean present_row = true && (isSetRow());
      builder.append(present_row);
      if (present_row)
        builder.append(row);

      boolean present_columns = true && (isSetColumns());
      builder.append(present_columns);
      if (present_columns)
        builder.append(columns);

      boolean present_attributes = true && (isSetAttributes());
      builder.append(present_attributes);
      if (present_attributes)
        builder.append(attributes);

      return builder.toHashCode();
    }

    public int compareTo(getRowWithColumns_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getRowWithColumns_args typedOther = (getRowWithColumns_args)other;

      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(typedOther.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, typedOther.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetRow()).compareTo(typedOther.isSetRow());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRow()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.row, typedOther.row);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetColumns()).compareTo(typedOther.isSetColumns());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumns()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.columns, typedOther.columns);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetAttributes()).compareTo(typedOther.isSetAttributes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAttributes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.attributes, typedOther.attributes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getRowWithColumns_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("row:");
      if (this.row == null) {
        sb.append("null");
      } else {
        sb.append(this.row);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("columns:");
      if (this.columns == null) {
        sb.append("null");
      } else {
        sb.append(this.columns);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("attributes:");
      if (this.attributes == null) {
        sb.append("null");
      } else {
        sb.append(this.attributes);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRowWithColumns_argsStandardSchemeFactory implements SchemeFactory {
      public getRowWithColumns_argsStandardScheme getScheme() {
        return new getRowWithColumns_argsStandardScheme();
      }
    }

    private static class getRowWithColumns_argsStandardScheme extends StandardScheme<getRowWithColumns_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRowWithColumns_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ROW
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.row = iprot.readBinary();
                struct.setRowIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // COLUMNS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list156 = iprot.readListBegin();
                  struct.columns = new ArrayList<ByteBuffer>(_list156.size);
                  for (int _i157 = 0; _i157 < _list156.size; ++_i157)
                  {
                    ByteBuffer _elem158; // required
                    _elem158 = iprot.readBinary();
                    struct.columns.add(_elem158);
                  }
                  iprot.readListEnd();
                }
                struct.setColumnsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // ATTRIBUTES
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map159 = iprot.readMapBegin();
                  struct.attributes = new HashMap<ByteBuffer,ByteBuffer>(2*_map159.size);
                  for (int _i160 = 0; _i160 < _map159.size; ++_i160)
                  {
                    ByteBuffer _key161; // required
                    ByteBuffer _val162; // required
                    _key161 = iprot.readBinary();
                    _val162 = iprot.readBinary();
                    struct.attributes.put(_key161, _val162);
                  }
                  iprot.readMapEnd();
                }
                struct.setAttributesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRowWithColumns_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        if (struct.row != null) {
          oprot.writeFieldBegin(ROW_FIELD_DESC);
          oprot.writeBinary(struct.row);
          oprot.writeFieldEnd();
        }
        if (struct.columns != null) {
          oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.columns.size()));
            for (ByteBuffer _iter163 : struct.columns)
            {
              oprot.writeBinary(_iter163);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.attributes != null) {
          oprot.writeFieldBegin(ATTRIBUTES_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, struct.attributes.size()));
            for (Map.Entry<ByteBuffer, ByteBuffer> _iter164 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter164.getKey());
              oprot.writeBinary(_iter164.getValue());
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRowWithColumns_argsTupleSchemeFactory implements SchemeFactory {
      public getRowWithColumns_argsTupleScheme getScheme() {
        return new getRowWithColumns_argsTupleScheme();
      }
    }

    private static class getRowWithColumns_argsTupleScheme extends TupleScheme<getRowWithColumns_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRowWithColumns_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        if (struct.isSetRow()) {
          optionals.set(1);
        }
        if (struct.isSetColumns()) {
          optionals.set(2);
        }
        if (struct.isSetAttributes()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
        if (struct.isSetRow()) {
          oprot.writeBinary(struct.row);
        }
        if (struct.isSetColumns()) {
          {
            oprot.writeI32(struct.columns.size());
            for (ByteBuffer _iter165 : struct.columns)
            {
              oprot.writeBinary(_iter165);
            }
          }
        }
        if (struct.isSetAttributes()) {
          {
            oprot.writeI32(struct.attributes.size());
            for (Map.Entry<ByteBuffer, ByteBuffer> _iter166 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter166.getKey());
              oprot.writeBinary(_iter166.getValue());
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRowWithColumns_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(1)) {
          struct.row = iprot.readBinary();
          struct.setRowIsSet(true);
        }
        if (incoming.get(2)) {
          {
            org.apache.thrift.protocol.TList _list167 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.columns = new ArrayList<ByteBuffer>(_list167.size);
            for (int _i168 = 0; _i168 < _list167.size; ++_i168)
            {
              ByteBuffer _elem169; // required
              _elem169 = iprot.readBinary();
              struct.columns.add(_elem169);
            }
          }
          struct.setColumnsIsSet(true);
        }
        if (incoming.get(3)) {
          {
            org.apache.thrift.protocol.TMap _map170 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.attributes = new HashMap<ByteBuffer,ByteBuffer>(2*_map170.size);
            for (int _i171 = 0; _i171 < _map170.size; ++_i171)
            {
              ByteBuffer _key172; // required
              ByteBuffer _val173; // required
              _key172 = iprot.readBinary();
              _val173 = iprot.readBinary();
              struct.attributes.put(_key172, _val173);
            }
          }
          struct.setAttributesIsSet(true);
        }
      }
    }

  }

  public static class getRowWithColumns_result implements org.apache.thrift.TBase<getRowWithColumns_result, getRowWithColumns_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRowWithColumns_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getRowWithColumns_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getRowWithColumns_resultTupleSchemeFactory());
    }

    public List<TRowResult> success; // required
    public IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TRowResult.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRowWithColumns_result.class, metaDataMap);
    }

    public getRowWithColumns_result() {
    }

    public getRowWithColumns_result(
      List<TRowResult> success,
      IOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRowWithColumns_result(getRowWithColumns_result other) {
      if (other.isSetSuccess()) {
        List<TRowResult> __this__success = new ArrayList<TRowResult>();
        for (TRowResult other_element : other.success) {
          __this__success.add(new TRowResult(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public getRowWithColumns_result deepCopy() {
      return new getRowWithColumns_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<TRowResult> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TRowResult elem) {
      if (this.success == null) {
        this.success = new ArrayList<TRowResult>();
      }
      this.success.add(elem);
    }

    public List<TRowResult> getSuccess() {
      return this.success;
    }

    public getRowWithColumns_result setSuccess(List<TRowResult> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public IOError getIo() {
      return this.io;
    }

    public getRowWithColumns_result setIo(IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<TRowResult>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRowWithColumns_result)
        return this.equals((getRowWithColumns_result)that);
      return false;
    }

    public boolean equals(getRowWithColumns_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_io = true && (isSetIo());
      builder.append(present_io);
      if (present_io)
        builder.append(io);

      return builder.toHashCode();
    }

    public int compareTo(getRowWithColumns_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getRowWithColumns_result typedOther = (getRowWithColumns_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIo()).compareTo(typedOther.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, typedOther.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getRowWithColumns_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRowWithColumns_resultStandardSchemeFactory implements SchemeFactory {
      public getRowWithColumns_resultStandardScheme getScheme() {
        return new getRowWithColumns_resultStandardScheme();
      }
    }

    private static class getRowWithColumns_resultStandardScheme extends StandardScheme<getRowWithColumns_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRowWithColumns_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list174 = iprot.readListBegin();
                  struct.success = new ArrayList<TRowResult>(_list174.size);
                  for (int _i175 = 0; _i175 < _list174.size; ++_i175)
                  {
                    TRowResult _elem176; // required
                    _elem176 = new TRowResult();
                    _elem176.read(iprot);
                    struct.success.add(_elem176);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRowWithColumns_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (TRowResult _iter177 : struct.success)
            {
              _iter177.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRowWithColumns_resultTupleSchemeFactory implements SchemeFactory {
      public getRowWithColumns_resultTupleScheme getScheme() {
        return new getRowWithColumns_resultTupleScheme();
      }
    }

    private static class getRowWithColumns_resultTupleScheme extends TupleScheme<getRowWithColumns_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRowWithColumns_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (TRowResult _iter178 : struct.success)
            {
              _iter178.write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRowWithColumns_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list179 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<TRowResult>(_list179.size);
            for (int _i180 = 0; _i180 < _list179.size; ++_i180)
            {
              TRowResult _elem181; // required
              _elem181 = new TRowResult();
              _elem181.read(iprot);
              struct.success.add(_elem181);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

  }

  public static class getRowTs_args implements org.apache.thrift.TBase<getRowTs_args, getRowTs_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRowTs_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField ROW_FIELD_DESC = new org.apache.thrift.protocol.TField("row", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField TIMESTAMP_FIELD_DESC = new org.apache.thrift.protocol.TField("timestamp", org.apache.thrift.protocol.TType.I64, (short)3);
    private static final org.apache.thrift.protocol.TField ATTRIBUTES_FIELD_DESC = new org.apache.thrift.protocol.TField("attributes", org.apache.thrift.protocol.TType.MAP, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getRowTs_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getRowTs_argsTupleSchemeFactory());
    }

    /**
     * name of the table
     */
    public ByteBuffer tableName; // required
    /**
     * row key
     */
    public ByteBuffer row; // required
    /**
     * timestamp
     */
    public long timestamp; // required
    /**
     * Get attributes
     */
    public Map<ByteBuffer,ByteBuffer> attributes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of the table
       */
      TABLE_NAME((short)1, "tableName"),
      /**
       * row key
       */
      ROW((short)2, "row"),
      /**
       * timestamp
       */
      TIMESTAMP((short)3, "timestamp"),
      /**
       * Get attributes
       */
      ATTRIBUTES((short)4, "attributes");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          case 2: // ROW
            return ROW;
          case 3: // TIMESTAMP
            return TIMESTAMP;
          case 4: // ATTRIBUTES
            return ATTRIBUTES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TIMESTAMP_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.ROW, new org.apache.thrift.meta_data.FieldMetaData("row", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.TIMESTAMP, new org.apache.thrift.meta_data.FieldMetaData("timestamp", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.ATTRIBUTES, new org.apache.thrift.meta_data.FieldMetaData("attributes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"), 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRowTs_args.class, metaDataMap);
    }

    public getRowTs_args() {
    }

    public getRowTs_args(
      ByteBuffer tableName,
      ByteBuffer row,
      long timestamp,
      Map<ByteBuffer,ByteBuffer> attributes)
    {
      this();
      this.tableName = tableName;
      this.row = row;
      this.timestamp = timestamp;
      setTimestampIsSet(true);
      this.attributes = attributes;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRowTs_args(getRowTs_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
      if (other.isSetRow()) {
        this.row = other.row;
      }
      this.timestamp = other.timestamp;
      if (other.isSetAttributes()) {
        Map<ByteBuffer,ByteBuffer> __this__attributes = new HashMap<ByteBuffer,ByteBuffer>();
        for (Map.Entry<ByteBuffer, ByteBuffer> other_element : other.attributes.entrySet()) {

          ByteBuffer other_element_key = other_element.getKey();
          ByteBuffer other_element_value = other_element.getValue();

          ByteBuffer __this__attributes_copy_key = other_element_key;

          ByteBuffer __this__attributes_copy_value = other_element_value;

          __this__attributes.put(__this__attributes_copy_key, __this__attributes_copy_value);
        }
        this.attributes = __this__attributes;
      }
    }

    public getRowTs_args deepCopy() {
      return new getRowTs_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
      this.row = null;
      setTimestampIsSet(false);
      this.timestamp = 0;
      this.attributes = null;
    }

    /**
     * name of the table
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public ByteBuffer bufferForTableName() {
      return tableName;
    }

    /**
     * name of the table
     */
    public getRowTs_args setTableName(byte[] tableName) {
      setTableName(tableName == null ? (ByteBuffer)null : ByteBuffer.wrap(tableName));
      return this;
    }

    public getRowTs_args setTableName(ByteBuffer tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    /**
     * row key
     */
    public byte[] getRow() {
      setRow(org.apache.thrift.TBaseHelper.rightSize(row));
      return row == null ? null : row.array();
    }

    public ByteBuffer bufferForRow() {
      return row;
    }

    /**
     * row key
     */
    public getRowTs_args setRow(byte[] row) {
      setRow(row == null ? (ByteBuffer)null : ByteBuffer.wrap(row));
      return this;
    }

    public getRowTs_args setRow(ByteBuffer row) {
      this.row = row;
      return this;
    }

    public void unsetRow() {
      this.row = null;
    }

    /** Returns true if field row is set (has been assigned a value) and false otherwise */
    public boolean isSetRow() {
      return this.row != null;
    }

    public void setRowIsSet(boolean value) {
      if (!value) {
        this.row = null;
      }
    }

    /**
     * timestamp
     */
    public long getTimestamp() {
      return this.timestamp;
    }

    /**
     * timestamp
     */
    public getRowTs_args setTimestamp(long timestamp) {
      this.timestamp = timestamp;
      setTimestampIsSet(true);
      return this;
    }

    public void unsetTimestamp() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __TIMESTAMP_ISSET_ID);
    }

    /** Returns true if field timestamp is set (has been assigned a value) and false otherwise */
    public boolean isSetTimestamp() {
      return EncodingUtils.testBit(__isset_bitfield, __TIMESTAMP_ISSET_ID);
    }

    public void setTimestampIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __TIMESTAMP_ISSET_ID, value);
    }

    public int getAttributesSize() {
      return (this.attributes == null) ? 0 : this.attributes.size();
    }

    public void putToAttributes(ByteBuffer key, ByteBuffer val) {
      if (this.attributes == null) {
        this.attributes = new HashMap<ByteBuffer,ByteBuffer>();
      }
      this.attributes.put(key, val);
    }

    /**
     * Get attributes
     */
    public Map<ByteBuffer,ByteBuffer> getAttributes() {
      return this.attributes;
    }

    /**
     * Get attributes
     */
    public getRowTs_args setAttributes(Map<ByteBuffer,ByteBuffer> attributes) {
      this.attributes = attributes;
      return this;
    }

    public void unsetAttributes() {
      this.attributes = null;
    }

    /** Returns true if field attributes is set (has been assigned a value) and false otherwise */
    public boolean isSetAttributes() {
      return this.attributes != null;
    }

    public void setAttributesIsSet(boolean value) {
      if (!value) {
        this.attributes = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((ByteBuffer)value);
        }
        break;

      case ROW:
        if (value == null) {
          unsetRow();
        } else {
          setRow((ByteBuffer)value);
        }
        break;

      case TIMESTAMP:
        if (value == null) {
          unsetTimestamp();
        } else {
          setTimestamp((Long)value);
        }
        break;

      case ATTRIBUTES:
        if (value == null) {
          unsetAttributes();
        } else {
          setAttributes((Map<ByteBuffer,ByteBuffer>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      case ROW:
        return getRow();

      case TIMESTAMP:
        return Long.valueOf(getTimestamp());

      case ATTRIBUTES:
        return getAttributes();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      case ROW:
        return isSetRow();
      case TIMESTAMP:
        return isSetTimestamp();
      case ATTRIBUTES:
        return isSetAttributes();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRowTs_args)
        return this.equals((getRowTs_args)that);
      return false;
    }

    public boolean equals(getRowTs_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_row = true && this.isSetRow();
      boolean that_present_row = true && that.isSetRow();
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!this.row.equals(that.row))
          return false;
      }

      boolean this_present_timestamp = true;
      boolean that_present_timestamp = true;
      if (this_present_timestamp || that_present_timestamp) {
        if (!(this_present_timestamp && that_present_timestamp))
          return false;
        if (this.timestamp != that.timestamp)
          return false;
      }

      boolean this_present_attributes = true && this.isSetAttributes();
      boolean that_present_attributes = true && that.isSetAttributes();
      if (this_present_attributes || that_present_attributes) {
        if (!(this_present_attributes && that_present_attributes))
          return false;
        if (!this.attributes.equals(that.attributes))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_tableName = true && (isSetTableName());
      builder.append(present_tableName);
      if (present_tableName)
        builder.append(tableName);

      boolean present_row = true && (isSetRow());
      builder.append(present_row);
      if (present_row)
        builder.append(row);

      boolean present_timestamp = true;
      builder.append(present_timestamp);
      if (present_timestamp)
        builder.append(timestamp);

      boolean present_attributes = true && (isSetAttributes());
      builder.append(present_attributes);
      if (present_attributes)
        builder.append(attributes);

      return builder.toHashCode();
    }

    public int compareTo(getRowTs_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getRowTs_args typedOther = (getRowTs_args)other;

      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(typedOther.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, typedOther.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetRow()).compareTo(typedOther.isSetRow());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRow()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.row, typedOther.row);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTimestamp()).compareTo(typedOther.isSetTimestamp());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTimestamp()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.timestamp, typedOther.timestamp);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetAttributes()).compareTo(typedOther.isSetAttributes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAttributes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.attributes, typedOther.attributes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getRowTs_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("row:");
      if (this.row == null) {
        sb.append("null");
      } else {
        sb.append(this.row);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("timestamp:");
      sb.append(this.timestamp);
      first = false;
      if (!first) sb.append(", ");
      sb.append("attributes:");
      if (this.attributes == null) {
        sb.append("null");
      } else {
        sb.append(this.attributes);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRowTs_argsStandardSchemeFactory implements SchemeFactory {
      public getRowTs_argsStandardScheme getScheme() {
        return new getRowTs_argsStandardScheme();
      }
    }

    private static class getRowTs_argsStandardScheme extends StandardScheme<getRowTs_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRowTs_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ROW
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.row = iprot.readBinary();
                struct.setRowIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // TIMESTAMP
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.timestamp = iprot.readI64();
                struct.setTimestampIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // ATTRIBUTES
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map182 = iprot.readMapBegin();
                  struct.attributes = new HashMap<ByteBuffer,ByteBuffer>(2*_map182.size);
                  for (int _i183 = 0; _i183 < _map182.size; ++_i183)
                  {
                    ByteBuffer _key184; // required
                    ByteBuffer _val185; // required
                    _key184 = iprot.readBinary();
                    _val185 = iprot.readBinary();
                    struct.attributes.put(_key184, _val185);
                  }
                  iprot.readMapEnd();
                }
                struct.setAttributesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRowTs_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        if (struct.row != null) {
          oprot.writeFieldBegin(ROW_FIELD_DESC);
          oprot.writeBinary(struct.row);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(TIMESTAMP_FIELD_DESC);
        oprot.writeI64(struct.timestamp);
        oprot.writeFieldEnd();
        if (struct.attributes != null) {
          oprot.writeFieldBegin(ATTRIBUTES_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, struct.attributes.size()));
            for (Map.Entry<ByteBuffer, ByteBuffer> _iter186 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter186.getKey());
              oprot.writeBinary(_iter186.getValue());
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRowTs_argsTupleSchemeFactory implements SchemeFactory {
      public getRowTs_argsTupleScheme getScheme() {
        return new getRowTs_argsTupleScheme();
      }
    }

    private static class getRowTs_argsTupleScheme extends TupleScheme<getRowTs_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRowTs_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        if (struct.isSetRow()) {
          optionals.set(1);
        }
        if (struct.isSetTimestamp()) {
          optionals.set(2);
        }
        if (struct.isSetAttributes()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
        if (struct.isSetRow()) {
          oprot.writeBinary(struct.row);
        }
        if (struct.isSetTimestamp()) {
          oprot.writeI64(struct.timestamp);
        }
        if (struct.isSetAttributes()) {
          {
            oprot.writeI32(struct.attributes.size());
            for (Map.Entry<ByteBuffer, ByteBuffer> _iter187 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter187.getKey());
              oprot.writeBinary(_iter187.getValue());
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRowTs_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(1)) {
          struct.row = iprot.readBinary();
          struct.setRowIsSet(true);
        }
        if (incoming.get(2)) {
          struct.timestamp = iprot.readI64();
          struct.setTimestampIsSet(true);
        }
        if (incoming.get(3)) {
          {
            org.apache.thrift.protocol.TMap _map188 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.attributes = new HashMap<ByteBuffer,ByteBuffer>(2*_map188.size);
            for (int _i189 = 0; _i189 < _map188.size; ++_i189)
            {
              ByteBuffer _key190; // required
              ByteBuffer _val191; // required
              _key190 = iprot.readBinary();
              _val191 = iprot.readBinary();
              struct.attributes.put(_key190, _val191);
            }
          }
          struct.setAttributesIsSet(true);
        }
      }
    }

  }

  public static class getRowTs_result implements org.apache.thrift.TBase<getRowTs_result, getRowTs_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRowTs_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getRowTs_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getRowTs_resultTupleSchemeFactory());
    }

    public List<TRowResult> success; // required
    public IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TRowResult.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRowTs_result.class, metaDataMap);
    }

    public getRowTs_result() {
    }

    public getRowTs_result(
      List<TRowResult> success,
      IOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRowTs_result(getRowTs_result other) {
      if (other.isSetSuccess()) {
        List<TRowResult> __this__success = new ArrayList<TRowResult>();
        for (TRowResult other_element : other.success) {
          __this__success.add(new TRowResult(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public getRowTs_result deepCopy() {
      return new getRowTs_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<TRowResult> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TRowResult elem) {
      if (this.success == null) {
        this.success = new ArrayList<TRowResult>();
      }
      this.success.add(elem);
    }

    public List<TRowResult> getSuccess() {
      return this.success;
    }

    public getRowTs_result setSuccess(List<TRowResult> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public IOError getIo() {
      return this.io;
    }

    public getRowTs_result setIo(IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<TRowResult>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRowTs_result)
        return this.equals((getRowTs_result)that);
      return false;
    }

    public boolean equals(getRowTs_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_io = true && (isSetIo());
      builder.append(present_io);
      if (present_io)
        builder.append(io);

      return builder.toHashCode();
    }

    public int compareTo(getRowTs_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getRowTs_result typedOther = (getRowTs_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIo()).compareTo(typedOther.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, typedOther.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getRowTs_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRowTs_resultStandardSchemeFactory implements SchemeFactory {
      public getRowTs_resultStandardScheme getScheme() {
        return new getRowTs_resultStandardScheme();
      }
    }

    private static class getRowTs_resultStandardScheme extends StandardScheme<getRowTs_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRowTs_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list192 = iprot.readListBegin();
                  struct.success = new ArrayList<TRowResult>(_list192.size);
                  for (int _i193 = 0; _i193 < _list192.size; ++_i193)
                  {
                    TRowResult _elem194; // required
                    _elem194 = new TRowResult();
                    _elem194.read(iprot);
                    struct.success.add(_elem194);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRowTs_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (TRowResult _iter195 : struct.success)
            {
              _iter195.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRowTs_resultTupleSchemeFactory implements SchemeFactory {
      public getRowTs_resultTupleScheme getScheme() {
        return new getRowTs_resultTupleScheme();
      }
    }

    private static class getRowTs_resultTupleScheme extends TupleScheme<getRowTs_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRowTs_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (TRowResult _iter196 : struct.success)
            {
              _iter196.write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRowTs_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list197 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<TRowResult>(_list197.size);
            for (int _i198 = 0; _i198 < _list197.size; ++_i198)
            {
              TRowResult _elem199; // required
              _elem199 = new TRowResult();
              _elem199.read(iprot);
              struct.success.add(_elem199);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

  }

  public static class getRowWithColumnsTs_args implements org.apache.thrift.TBase<getRowWithColumnsTs_args, getRowWithColumnsTs_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRowWithColumnsTs_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField ROW_FIELD_DESC = new org.apache.thrift.protocol.TField("row", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField COLUMNS_FIELD_DESC = new org.apache.thrift.protocol.TField("columns", org.apache.thrift.protocol.TType.LIST, (short)3);
    private static final org.apache.thrift.protocol.TField TIMESTAMP_FIELD_DESC = new org.apache.thrift.protocol.TField("timestamp", org.apache.thrift.protocol.TType.I64, (short)4);
    private static final org.apache.thrift.protocol.TField ATTRIBUTES_FIELD_DESC = new org.apache.thrift.protocol.TField("attributes", org.apache.thrift.protocol.TType.MAP, (short)5);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getRowWithColumnsTs_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getRowWithColumnsTs_argsTupleSchemeFactory());
    }

    /**
     * name of table
     */
    public ByteBuffer tableName; // required
    /**
     * row key
     */
    public ByteBuffer row; // required
    /**
     * List of columns to return, null for all columns
     */
    public List<ByteBuffer> columns; // required
    public long timestamp; // required
    /**
     * Get attributes
     */
    public Map<ByteBuffer,ByteBuffer> attributes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of table
       */
      TABLE_NAME((short)1, "tableName"),
      /**
       * row key
       */
      ROW((short)2, "row"),
      /**
       * List of columns to return, null for all columns
       */
      COLUMNS((short)3, "columns"),
      TIMESTAMP((short)4, "timestamp"),
      /**
       * Get attributes
       */
      ATTRIBUTES((short)5, "attributes");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          case 2: // ROW
            return ROW;
          case 3: // COLUMNS
            return COLUMNS;
          case 4: // TIMESTAMP
            return TIMESTAMP;
          case 5: // ATTRIBUTES
            return ATTRIBUTES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TIMESTAMP_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.ROW, new org.apache.thrift.meta_data.FieldMetaData("row", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.COLUMNS, new org.apache.thrift.meta_data.FieldMetaData("columns", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      tmpMap.put(_Fields.TIMESTAMP, new org.apache.thrift.meta_data.FieldMetaData("timestamp", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.ATTRIBUTES, new org.apache.thrift.meta_data.FieldMetaData("attributes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"), 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRowWithColumnsTs_args.class, metaDataMap);
    }

    public getRowWithColumnsTs_args() {
    }

    public getRowWithColumnsTs_args(
      ByteBuffer tableName,
      ByteBuffer row,
      List<ByteBuffer> columns,
      long timestamp,
      Map<ByteBuffer,ByteBuffer> attributes)
    {
      this();
      this.tableName = tableName;
      this.row = row;
      this.columns = columns;
      this.timestamp = timestamp;
      setTimestampIsSet(true);
      this.attributes = attributes;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRowWithColumnsTs_args(getRowWithColumnsTs_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
      if (other.isSetRow()) {
        this.row = other.row;
      }
      if (other.isSetColumns()) {
        List<ByteBuffer> __this__columns = new ArrayList<ByteBuffer>();
        for (ByteBuffer other_element : other.columns) {
          __this__columns.add(other_element);
        }
        this.columns = __this__columns;
      }
      this.timestamp = other.timestamp;
      if (other.isSetAttributes()) {
        Map<ByteBuffer,ByteBuffer> __this__attributes = new HashMap<ByteBuffer,ByteBuffer>();
        for (Map.Entry<ByteBuffer, ByteBuffer> other_element : other.attributes.entrySet()) {

          ByteBuffer other_element_key = other_element.getKey();
          ByteBuffer other_element_value = other_element.getValue();

          ByteBuffer __this__attributes_copy_key = other_element_key;

          ByteBuffer __this__attributes_copy_value = other_element_value;

          __this__attributes.put(__this__attributes_copy_key, __this__attributes_copy_value);
        }
        this.attributes = __this__attributes;
      }
    }

    public getRowWithColumnsTs_args deepCopy() {
      return new getRowWithColumnsTs_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
      this.row = null;
      this.columns = null;
      setTimestampIsSet(false);
      this.timestamp = 0;
      this.attributes = null;
    }

    /**
     * name of table
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public ByteBuffer bufferForTableName() {
      return tableName;
    }

    /**
     * name of table
     */
    public getRowWithColumnsTs_args setTableName(byte[] tableName) {
      setTableName(tableName == null ? (ByteBuffer)null : ByteBuffer.wrap(tableName));
      return this;
    }

    public getRowWithColumnsTs_args setTableName(ByteBuffer tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    /**
     * row key
     */
    public byte[] getRow() {
      setRow(org.apache.thrift.TBaseHelper.rightSize(row));
      return row == null ? null : row.array();
    }

    public ByteBuffer bufferForRow() {
      return row;
    }

    /**
     * row key
     */
    public getRowWithColumnsTs_args setRow(byte[] row) {
      setRow(row == null ? (ByteBuffer)null : ByteBuffer.wrap(row));
      return this;
    }

    public getRowWithColumnsTs_args setRow(ByteBuffer row) {
      this.row = row;
      return this;
    }

    public void unsetRow() {
      this.row = null;
    }

    /** Returns true if field row is set (has been assigned a value) and false otherwise */
    public boolean isSetRow() {
      return this.row != null;
    }

    public void setRowIsSet(boolean value) {
      if (!value) {
        this.row = null;
      }
    }

    public int getColumnsSize() {
      return (this.columns == null) ? 0 : this.columns.size();
    }

    public java.util.Iterator<ByteBuffer> getColumnsIterator() {
      return (this.columns == null) ? null : this.columns.iterator();
    }

    public void addToColumns(ByteBuffer elem) {
      if (this.columns == null) {
        this.columns = new ArrayList<ByteBuffer>();
      }
      this.columns.add(elem);
    }

    /**
     * List of columns to return, null for all columns
     */
    public List<ByteBuffer> getColumns() {
      return this.columns;
    }

    /**
     * List of columns to return, null for all columns
     */
    public getRowWithColumnsTs_args setColumns(List<ByteBuffer> columns) {
      this.columns = columns;
      return this;
    }

    public void unsetColumns() {
      this.columns = null;
    }

    /** Returns true if field columns is set (has been assigned a value) and false otherwise */
    public boolean isSetColumns() {
      return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
      if (!value) {
        this.columns = null;
      }
    }

    public long getTimestamp() {
      return this.timestamp;
    }

    public getRowWithColumnsTs_args setTimestamp(long timestamp) {
      this.timestamp = timestamp;
      setTimestampIsSet(true);
      return this;
    }

    public void unsetTimestamp() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __TIMESTAMP_ISSET_ID);
    }

    /** Returns true if field timestamp is set (has been assigned a value) and false otherwise */
    public boolean isSetTimestamp() {
      return EncodingUtils.testBit(__isset_bitfield, __TIMESTAMP_ISSET_ID);
    }

    public void setTimestampIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __TIMESTAMP_ISSET_ID, value);
    }

    public int getAttributesSize() {
      return (this.attributes == null) ? 0 : this.attributes.size();
    }

    public void putToAttributes(ByteBuffer key, ByteBuffer val) {
      if (this.attributes == null) {
        this.attributes = new HashMap<ByteBuffer,ByteBuffer>();
      }
      this.attributes.put(key, val);
    }

    /**
     * Get attributes
     */
    public Map<ByteBuffer,ByteBuffer> getAttributes() {
      return this.attributes;
    }

    /**
     * Get attributes
     */
    public getRowWithColumnsTs_args setAttributes(Map<ByteBuffer,ByteBuffer> attributes) {
      this.attributes = attributes;
      return this;
    }

    public void unsetAttributes() {
      this.attributes = null;
    }

    /** Returns true if field attributes is set (has been assigned a value) and false otherwise */
    public boolean isSetAttributes() {
      return this.attributes != null;
    }

    public void setAttributesIsSet(boolean value) {
      if (!value) {
        this.attributes = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((ByteBuffer)value);
        }
        break;

      case ROW:
        if (value == null) {
          unsetRow();
        } else {
          setRow((ByteBuffer)value);
        }
        break;

      case COLUMNS:
        if (value == null) {
          unsetColumns();
        } else {
          setColumns((List<ByteBuffer>)value);
        }
        break;

      case TIMESTAMP:
        if (value == null) {
          unsetTimestamp();
        } else {
          setTimestamp((Long)value);
        }
        break;

      case ATTRIBUTES:
        if (value == null) {
          unsetAttributes();
        } else {
          setAttributes((Map<ByteBuffer,ByteBuffer>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      case ROW:
        return getRow();

      case COLUMNS:
        return getColumns();

      case TIMESTAMP:
        return Long.valueOf(getTimestamp());

      case ATTRIBUTES:
        return getAttributes();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      case ROW:
        return isSetRow();
      case COLUMNS:
        return isSetColumns();
      case TIMESTAMP:
        return isSetTimestamp();
      case ATTRIBUTES:
        return isSetAttributes();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRowWithColumnsTs_args)
        return this.equals((getRowWithColumnsTs_args)that);
      return false;
    }

    public boolean equals(getRowWithColumnsTs_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_row = true && this.isSetRow();
      boolean that_present_row = true && that.isSetRow();
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!this.row.equals(that.row))
          return false;
      }

      boolean this_present_columns = true && this.isSetColumns();
      boolean that_present_columns = true && that.isSetColumns();
      if (this_present_columns || that_present_columns) {
        if (!(this_present_columns && that_present_columns))
          return false;
        if (!this.columns.equals(that.columns))
          return false;
      }

      boolean this_present_timestamp = true;
      boolean that_present_timestamp = true;
      if (this_present_timestamp || that_present_timestamp) {
        if (!(this_present_timestamp && that_present_timestamp))
          return false;
        if (this.timestamp != that.timestamp)
          return false;
      }

      boolean this_present_attributes = true && this.isSetAttributes();
      boolean that_present_attributes = true && that.isSetAttributes();
      if (this_present_attributes || that_present_attributes) {
        if (!(this_present_attributes && that_present_attributes))
          return false;
        if (!this.attributes.equals(that.attributes))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_tableName = true && (isSetTableName());
      builder.append(present_tableName);
      if (present_tableName)
        builder.append(tableName);

      boolean present_row = true && (isSetRow());
      builder.append(present_row);
      if (present_row)
        builder.append(row);

      boolean present_columns = true && (isSetColumns());
      builder.append(present_columns);
      if (present_columns)
        builder.append(columns);

      boolean present_timestamp = true;
      builder.append(present_timestamp);
      if (present_timestamp)
        builder.append(timestamp);

      boolean present_attributes = true && (isSetAttributes());
      builder.append(present_attributes);
      if (present_attributes)
        builder.append(attributes);

      return builder.toHashCode();
    }

    public int compareTo(getRowWithColumnsTs_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getRowWithColumnsTs_args typedOther = (getRowWithColumnsTs_args)other;

      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(typedOther.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, typedOther.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetRow()).compareTo(typedOther.isSetRow());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRow()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.row, typedOther.row);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetColumns()).compareTo(typedOther.isSetColumns());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumns()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.columns, typedOther.columns);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTimestamp()).compareTo(typedOther.isSetTimestamp());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTimestamp()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.timestamp, typedOther.timestamp);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetAttributes()).compareTo(typedOther.isSetAttributes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAttributes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.attributes, typedOther.attributes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getRowWithColumnsTs_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("row:");
      if (this.row == null) {
        sb.append("null");
      } else {
        sb.append(this.row);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("columns:");
      if (this.columns == null) {
        sb.append("null");
      } else {
        sb.append(this.columns);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("timestamp:");
      sb.append(this.timestamp);
      first = false;
      if (!first) sb.append(", ");
      sb.append("attributes:");
      if (this.attributes == null) {
        sb.append("null");
      } else {
        sb.append(this.attributes);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRowWithColumnsTs_argsStandardSchemeFactory implements SchemeFactory {
      public getRowWithColumnsTs_argsStandardScheme getScheme() {
        return new getRowWithColumnsTs_argsStandardScheme();
      }
    }

    private static class getRowWithColumnsTs_argsStandardScheme extends StandardScheme<getRowWithColumnsTs_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRowWithColumnsTs_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ROW
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.row = iprot.readBinary();
                struct.setRowIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // COLUMNS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list200 = iprot.readListBegin();
                  struct.columns = new ArrayList<ByteBuffer>(_list200.size);
                  for (int _i201 = 0; _i201 < _list200.size; ++_i201)
                  {
                    ByteBuffer _elem202; // required
                    _elem202 = iprot.readBinary();
                    struct.columns.add(_elem202);
                  }
                  iprot.readListEnd();
                }
                struct.setColumnsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // TIMESTAMP
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.timestamp = iprot.readI64();
                struct.setTimestampIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // ATTRIBUTES
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map203 = iprot.readMapBegin();
                  struct.attributes = new HashMap<ByteBuffer,ByteBuffer>(2*_map203.size);
                  for (int _i204 = 0; _i204 < _map203.size; ++_i204)
                  {
                    ByteBuffer _key205; // required
                    ByteBuffer _val206; // required
                    _key205 = iprot.readBinary();
                    _val206 = iprot.readBinary();
                    struct.attributes.put(_key205, _val206);
                  }
                  iprot.readMapEnd();
                }
                struct.setAttributesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRowWithColumnsTs_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        if (struct.row != null) {
          oprot.writeFieldBegin(ROW_FIELD_DESC);
          oprot.writeBinary(struct.row);
          oprot.writeFieldEnd();
        }
        if (struct.columns != null) {
          oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.columns.size()));
            for (ByteBuffer _iter207 : struct.columns)
            {
              oprot.writeBinary(_iter207);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(TIMESTAMP_FIELD_DESC);
        oprot.writeI64(struct.timestamp);
        oprot.writeFieldEnd();
        if (struct.attributes != null) {
          oprot.writeFieldBegin(ATTRIBUTES_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, struct.attributes.size()));
            for (Map.Entry<ByteBuffer, ByteBuffer> _iter208 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter208.getKey());
              oprot.writeBinary(_iter208.getValue());
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRowWithColumnsTs_argsTupleSchemeFactory implements SchemeFactory {
      public getRowWithColumnsTs_argsTupleScheme getScheme() {
        return new getRowWithColumnsTs_argsTupleScheme();
      }
    }

    private static class getRowWithColumnsTs_argsTupleScheme extends TupleScheme<getRowWithColumnsTs_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRowWithColumnsTs_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        if (struct.isSetRow()) {
          optionals.set(1);
        }
        if (struct.isSetColumns()) {
          optionals.set(2);
        }
        if (struct.isSetTimestamp()) {
          optionals.set(3);
        }
        if (struct.isSetAttributes()) {
          optionals.set(4);
        }
        oprot.writeBitSet(optionals, 5);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
        if (struct.isSetRow()) {
          oprot.writeBinary(struct.row);
        }
        if (struct.isSetColumns()) {
          {
            oprot.writeI32(struct.columns.size());
            for (ByteBuffer _iter209 : struct.columns)
            {
              oprot.writeBinary(_iter209);
            }
          }
        }
        if (struct.isSetTimestamp()) {
          oprot.writeI64(struct.timestamp);
        }
        if (struct.isSetAttributes()) {
          {
            oprot.writeI32(struct.attributes.size());
            for (Map.Entry<ByteBuffer, ByteBuffer> _iter210 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter210.getKey());
              oprot.writeBinary(_iter210.getValue());
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRowWithColumnsTs_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(5);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(1)) {
          struct.row = iprot.readBinary();
          struct.setRowIsSet(true);
        }
        if (incoming.get(2)) {
          {
            org.apache.thrift.protocol.TList _list211 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.columns = new ArrayList<ByteBuffer>(_list211.size);
            for (int _i212 = 0; _i212 < _list211.size; ++_i212)
            {
              ByteBuffer _elem213; // required
              _elem213 = iprot.readBinary();
              struct.columns.add(_elem213);
            }
          }
          struct.setColumnsIsSet(true);
        }
        if (incoming.get(3)) {
          struct.timestamp = iprot.readI64();
          struct.setTimestampIsSet(true);
        }
        if (incoming.get(4)) {
          {
            org.apache.thrift.protocol.TMap _map214 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.attributes = new HashMap<ByteBuffer,ByteBuffer>(2*_map214.size);
            for (int _i215 = 0; _i215 < _map214.size; ++_i215)
            {
              ByteBuffer _key216; // required
              ByteBuffer _val217; // required
              _key216 = iprot.readBinary();
              _val217 = iprot.readBinary();
              struct.attributes.put(_key216, _val217);
            }
          }
          struct.setAttributesIsSet(true);
        }
      }
    }

  }

  public static class getRowWithColumnsTs_result implements org.apache.thrift.TBase<getRowWithColumnsTs_result, getRowWithColumnsTs_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRowWithColumnsTs_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getRowWithColumnsTs_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getRowWithColumnsTs_resultTupleSchemeFactory());
    }

    public List<TRowResult> success; // required
    public IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TRowResult.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRowWithColumnsTs_result.class, metaDataMap);
    }

    public getRowWithColumnsTs_result() {
    }

    public getRowWithColumnsTs_result(
      List<TRowResult> success,
      IOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRowWithColumnsTs_result(getRowWithColumnsTs_result other) {
      if (other.isSetSuccess()) {
        List<TRowResult> __this__success = new ArrayList<TRowResult>();
        for (TRowResult other_element : other.success) {
          __this__success.add(new TRowResult(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public getRowWithColumnsTs_result deepCopy() {
      return new getRowWithColumnsTs_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<TRowResult> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TRowResult elem) {
      if (this.success == null) {
        this.success = new ArrayList<TRowResult>();
      }
      this.success.add(elem);
    }

    public List<TRowResult> getSuccess() {
      return this.success;
    }

    public getRowWithColumnsTs_result setSuccess(List<TRowResult> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public IOError getIo() {
      return this.io;
    }

    public getRowWithColumnsTs_result setIo(IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<TRowResult>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRowWithColumnsTs_result)
        return this.equals((getRowWithColumnsTs_result)that);
      return false;
    }

    public boolean equals(getRowWithColumnsTs_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_io = true && (isSetIo());
      builder.append(present_io);
      if (present_io)
        builder.append(io);

      return builder.toHashCode();
    }

    public int compareTo(getRowWithColumnsTs_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getRowWithColumnsTs_result typedOther = (getRowWithColumnsTs_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIo()).compareTo(typedOther.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, typedOther.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getRowWithColumnsTs_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRowWithColumnsTs_resultStandardSchemeFactory implements SchemeFactory {
      public getRowWithColumnsTs_resultStandardScheme getScheme() {
        return new getRowWithColumnsTs_resultStandardScheme();
      }
    }

    private static class getRowWithColumnsTs_resultStandardScheme extends StandardScheme<getRowWithColumnsTs_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRowWithColumnsTs_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list218 = iprot.readListBegin();
                  struct.success = new ArrayList<TRowResult>(_list218.size);
                  for (int _i219 = 0; _i219 < _list218.size; ++_i219)
                  {
                    TRowResult _elem220; // required
                    _elem220 = new TRowResult();
                    _elem220.read(iprot);
                    struct.success.add(_elem220);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRowWithColumnsTs_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (TRowResult _iter221 : struct.success)
            {
              _iter221.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRowWithColumnsTs_resultTupleSchemeFactory implements SchemeFactory {
      public getRowWithColumnsTs_resultTupleScheme getScheme() {
        return new getRowWithColumnsTs_resultTupleScheme();
      }
    }

    private static class getRowWithColumnsTs_resultTupleScheme extends TupleScheme<getRowWithColumnsTs_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRowWithColumnsTs_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (TRowResult _iter222 : struct.success)
            {
              _iter222.write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRowWithColumnsTs_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list223 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<TRowResult>(_list223.size);
            for (int _i224 = 0; _i224 < _list223.size; ++_i224)
            {
              TRowResult _elem225; // required
              _elem225 = new TRowResult();
              _elem225.read(iprot);
              struct.success.add(_elem225);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

  }

  public static class getRows_args implements org.apache.thrift.TBase<getRows_args, getRows_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRows_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField ROWS_FIELD_DESC = new org.apache.thrift.protocol.TField("rows", org.apache.thrift.protocol.TType.LIST, (short)2);
    private static final org.apache.thrift.protocol.TField ATTRIBUTES_FIELD_DESC = new org.apache.thrift.protocol.TField("attributes", org.apache.thrift.protocol.TType.MAP, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getRows_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getRows_argsTupleSchemeFactory());
    }

    /**
     * name of table
     */
    public ByteBuffer tableName; // required
    /**
     * row keys
     */
    public List<ByteBuffer> rows; // required
    /**
     * Get attributes
     */
    public Map<ByteBuffer,ByteBuffer> attributes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of table
       */
      TABLE_NAME((short)1, "tableName"),
      /**
       * row keys
       */
      ROWS((short)2, "rows"),
      /**
       * Get attributes
       */
      ATTRIBUTES((short)3, "attributes");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          case 2: // ROWS
            return ROWS;
          case 3: // ATTRIBUTES
            return ATTRIBUTES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.ROWS, new org.apache.thrift.meta_data.FieldMetaData("rows", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      tmpMap.put(_Fields.ATTRIBUTES, new org.apache.thrift.meta_data.FieldMetaData("attributes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"), 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRows_args.class, metaDataMap);
    }

    public getRows_args() {
    }

    public getRows_args(
      ByteBuffer tableName,
      List<ByteBuffer> rows,
      Map<ByteBuffer,ByteBuffer> attributes)
    {
      this();
      this.tableName = tableName;
      this.rows = rows;
      this.attributes = attributes;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRows_args(getRows_args other) {
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
      if (other.isSetRows()) {
        List<ByteBuffer> __this__rows = new ArrayList<ByteBuffer>();
        for (ByteBuffer other_element : other.rows) {
          __this__rows.add(other_element);
        }
        this.rows = __this__rows;
      }
      if (other.isSetAttributes()) {
        Map<ByteBuffer,ByteBuffer> __this__attributes = new HashMap<ByteBuffer,ByteBuffer>();
        for (Map.Entry<ByteBuffer, ByteBuffer> other_element : other.attributes.entrySet()) {

          ByteBuffer other_element_key = other_element.getKey();
          ByteBuffer other_element_value = other_element.getValue();

          ByteBuffer __this__attributes_copy_key = other_element_key;

          ByteBuffer __this__attributes_copy_value = other_element_value;

          __this__attributes.put(__this__attributes_copy_key, __this__attributes_copy_value);
        }
        this.attributes = __this__attributes;
      }
    }

    public getRows_args deepCopy() {
      return new getRows_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
      this.rows = null;
      this.attributes = null;
    }

    /**
     * name of table
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public ByteBuffer bufferForTableName() {
      return tableName;
    }

    /**
     * name of table
     */
    public getRows_args setTableName(byte[] tableName) {
      setTableName(tableName == null ? (ByteBuffer)null : ByteBuffer.wrap(tableName));
      return this;
    }

    public getRows_args setTableName(ByteBuffer tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public int getRowsSize() {
      return (this.rows == null) ? 0 : this.rows.size();
    }

    public java.util.Iterator<ByteBuffer> getRowsIterator() {
      return (this.rows == null) ? null : this.rows.iterator();
    }

    public void addToRows(ByteBuffer elem) {
      if (this.rows == null) {
        this.rows = new ArrayList<ByteBuffer>();
      }
      this.rows.add(elem);
    }

    /**
     * row keys
     */
    public List<ByteBuffer> getRows() {
      return this.rows;
    }

    /**
     * row keys
     */
    public getRows_args setRows(List<ByteBuffer> rows) {
      this.rows = rows;
      return this;
    }

    public void unsetRows() {
      this.rows = null;
    }

    /** Returns true if field rows is set (has been assigned a value) and false otherwise */
    public boolean isSetRows() {
      return this.rows != null;
    }

    public void setRowsIsSet(boolean value) {
      if (!value) {
        this.rows = null;
      }
    }

    public int getAttributesSize() {
      return (this.attributes == null) ? 0 : this.attributes.size();
    }

    public void putToAttributes(ByteBuffer key, ByteBuffer val) {
      if (this.attributes == null) {
        this.attributes = new HashMap<ByteBuffer,ByteBuffer>();
      }
      this.attributes.put(key, val);
    }

    /**
     * Get attributes
     */
    public Map<ByteBuffer,ByteBuffer> getAttributes() {
      return this.attributes;
    }

    /**
     * Get attributes
     */
    public getRows_args setAttributes(Map<ByteBuffer,ByteBuffer> attributes) {
      this.attributes = attributes;
      return this;
    }

    public void unsetAttributes() {
      this.attributes = null;
    }

    /** Returns true if field attributes is set (has been assigned a value) and false otherwise */
    public boolean isSetAttributes() {
      return this.attributes != null;
    }

    public void setAttributesIsSet(boolean value) {
      if (!value) {
        this.attributes = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((ByteBuffer)value);
        }
        break;

      case ROWS:
        if (value == null) {
          unsetRows();
        } else {
          setRows((List<ByteBuffer>)value);
        }
        break;

      case ATTRIBUTES:
        if (value == null) {
          unsetAttributes();
        } else {
          setAttributes((Map<ByteBuffer,ByteBuffer>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      case ROWS:
        return getRows();

      case ATTRIBUTES:
        return getAttributes();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      case ROWS:
        return isSetRows();
      case ATTRIBUTES:
        return isSetAttributes();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRows_args)
        return this.equals((getRows_args)that);
      return false;
    }

    public boolean equals(getRows_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_rows = true && this.isSetRows();
      boolean that_present_rows = true && that.isSetRows();
      if (this_present_rows || that_present_rows) {
        if (!(this_present_rows && that_present_rows))
          return false;
        if (!this.rows.equals(that.rows))
          return false;
      }

      boolean this_present_attributes = true && this.isSetAttributes();
      boolean that_present_attributes = true && that.isSetAttributes();
      if (this_present_attributes || that_present_attributes) {
        if (!(this_present_attributes && that_present_attributes))
          return false;
        if (!this.attributes.equals(that.attributes))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_tableName = true && (isSetTableName());
      builder.append(present_tableName);
      if (present_tableName)
        builder.append(tableName);

      boolean present_rows = true && (isSetRows());
      builder.append(present_rows);
      if (present_rows)
        builder.append(rows);

      boolean present_attributes = true && (isSetAttributes());
      builder.append(present_attributes);
      if (present_attributes)
        builder.append(attributes);

      return builder.toHashCode();
    }

    public int compareTo(getRows_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getRows_args typedOther = (getRows_args)other;

      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(typedOther.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, typedOther.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetRows()).compareTo(typedOther.isSetRows());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRows()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.rows, typedOther.rows);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetAttributes()).compareTo(typedOther.isSetAttributes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAttributes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.attributes, typedOther.attributes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getRows_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("rows:");
      if (this.rows == null) {
        sb.append("null");
      } else {
        sb.append(this.rows);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("attributes:");
      if (this.attributes == null) {
        sb.append("null");
      } else {
        sb.append(this.attributes);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRows_argsStandardSchemeFactory implements SchemeFactory {
      public getRows_argsStandardScheme getScheme() {
        return new getRows_argsStandardScheme();
      }
    }

    private static class getRows_argsStandardScheme extends StandardScheme<getRows_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRows_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ROWS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list226 = iprot.readListBegin();
                  struct.rows = new ArrayList<ByteBuffer>(_list226.size);
                  for (int _i227 = 0; _i227 < _list226.size; ++_i227)
                  {
                    ByteBuffer _elem228; // required
                    _elem228 = iprot.readBinary();
                    struct.rows.add(_elem228);
                  }
                  iprot.readListEnd();
                }
                struct.setRowsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // ATTRIBUTES
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map229 = iprot.readMapBegin();
                  struct.attributes = new HashMap<ByteBuffer,ByteBuffer>(2*_map229.size);
                  for (int _i230 = 0; _i230 < _map229.size; ++_i230)
                  {
                    ByteBuffer _key231; // required
                    ByteBuffer _val232; // required
                    _key231 = iprot.readBinary();
                    _val232 = iprot.readBinary();
                    struct.attributes.put(_key231, _val232);
                  }
                  iprot.readMapEnd();
                }
                struct.setAttributesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRows_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        if (struct.rows != null) {
          oprot.writeFieldBegin(ROWS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.rows.size()));
            for (ByteBuffer _iter233 : struct.rows)
            {
              oprot.writeBinary(_iter233);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.attributes != null) {
          oprot.writeFieldBegin(ATTRIBUTES_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, struct.attributes.size()));
            for (Map.Entry<ByteBuffer, ByteBuffer> _iter234 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter234.getKey());
              oprot.writeBinary(_iter234.getValue());
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRows_argsTupleSchemeFactory implements SchemeFactory {
      public getRows_argsTupleScheme getScheme() {
        return new getRows_argsTupleScheme();
      }
    }

    private static class getRows_argsTupleScheme extends TupleScheme<getRows_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRows_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        if (struct.isSetRows()) {
          optionals.set(1);
        }
        if (struct.isSetAttributes()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
        if (struct.isSetRows()) {
          {
            oprot.writeI32(struct.rows.size());
            for (ByteBuffer _iter235 : struct.rows)
            {
              oprot.writeBinary(_iter235);
            }
          }
        }
        if (struct.isSetAttributes()) {
          {
            oprot.writeI32(struct.attributes.size());
            for (Map.Entry<ByteBuffer, ByteBuffer> _iter236 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter236.getKey());
              oprot.writeBinary(_iter236.getValue());
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRows_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(1)) {
          {
            org.apache.thrift.protocol.TList _list237 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.rows = new ArrayList<ByteBuffer>(_list237.size);
            for (int _i238 = 0; _i238 < _list237.size; ++_i238)
            {
              ByteBuffer _elem239; // required
              _elem239 = iprot.readBinary();
              struct.rows.add(_elem239);
            }
          }
          struct.setRowsIsSet(true);
        }
        if (incoming.get(2)) {
          {
            org.apache.thrift.protocol.TMap _map240 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.attributes = new HashMap<ByteBuffer,ByteBuffer>(2*_map240.size);
            for (int _i241 = 0; _i241 < _map240.size; ++_i241)
            {
              ByteBuffer _key242; // required
              ByteBuffer _val243; // required
              _key242 = iprot.readBinary();
              _val243 = iprot.readBinary();
              struct.attributes.put(_key242, _val243);
            }
          }
          struct.setAttributesIsSet(true);
        }
      }
    }

  }

  public static class getRows_result implements org.apache.thrift.TBase<getRows_result, getRows_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRows_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getRows_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getRows_resultTupleSchemeFactory());
    }

    public List<TRowResult> success; // required
    public IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TRowResult.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRows_result.class, metaDataMap);
    }

    public getRows_result() {
    }

    public getRows_result(
      List<TRowResult> success,
      IOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRows_result(getRows_result other) {
      if (other.isSetSuccess()) {
        List<TRowResult> __this__success = new ArrayList<TRowResult>();
        for (TRowResult other_element : other.success) {
          __this__success.add(new TRowResult(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public getRows_result deepCopy() {
      return new getRows_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<TRowResult> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TRowResult elem) {
      if (this.success == null) {
        this.success = new ArrayList<TRowResult>();
      }
      this.success.add(elem);
    }

    public List<TRowResult> getSuccess() {
      return this.success;
    }

    public getRows_result setSuccess(List<TRowResult> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public IOError getIo() {
      return this.io;
    }

    public getRows_result setIo(IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<TRowResult>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRows_result)
        return this.equals((getRows_result)that);
      return false;
    }

    public boolean equals(getRows_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_io = true && (isSetIo());
      builder.append(present_io);
      if (present_io)
        builder.append(io);

      return builder.toHashCode();
    }

    public int compareTo(getRows_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getRows_result typedOther = (getRows_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIo()).compareTo(typedOther.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, typedOther.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getRows_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRows_resultStandardSchemeFactory implements SchemeFactory {
      public getRows_resultStandardScheme getScheme() {
        return new getRows_resultStandardScheme();
      }
    }

    private static class getRows_resultStandardScheme extends StandardScheme<getRows_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRows_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list244 = iprot.readListBegin();
                  struct.success = new ArrayList<TRowResult>(_list244.size);
                  for (int _i245 = 0; _i245 < _list244.size; ++_i245)
                  {
                    TRowResult _elem246; // required
                    _elem246 = new TRowResult();
                    _elem246.read(iprot);
                    struct.success.add(_elem246);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRows_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (TRowResult _iter247 : struct.success)
            {
              _iter247.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRows_resultTupleSchemeFactory implements SchemeFactory {
      public getRows_resultTupleScheme getScheme() {
        return new getRows_resultTupleScheme();
      }
    }

    private static class getRows_resultTupleScheme extends TupleScheme<getRows_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRows_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (TRowResult _iter248 : struct.success)
            {
              _iter248.write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRows_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list249 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<TRowResult>(_list249.size);
            for (int _i250 = 0; _i250 < _list249.size; ++_i250)
            {
              TRowResult _elem251; // required
              _elem251 = new TRowResult();
              _elem251.read(iprot);
              struct.success.add(_elem251);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

  }

  public static class getRowsWithColumns_args implements org.apache.thrift.TBase<getRowsWithColumns_args, getRowsWithColumns_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRowsWithColumns_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField ROWS_FIELD_DESC = new org.apache.thrift.protocol.TField("rows", org.apache.thrift.protocol.TType.LIST, (short)2);
    private static final org.apache.thrift.protocol.TField COLUMNS_FIELD_DESC = new org.apache.thrift.protocol.TField("columns", org.apache.thrift.protocol.TType.LIST, (short)3);
    private static final org.apache.thrift.protocol.TField ATTRIBUTES_FIELD_DESC = new org.apache.thrift.protocol.TField("attributes", org.apache.thrift.protocol.TType.MAP, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getRowsWithColumns_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getRowsWithColumns_argsTupleSchemeFactory());
    }

    /**
     * name of table
     */
    public ByteBuffer tableName; // required
    /**
     * row keys
     */
    public List<ByteBuffer> rows; // required
    /**
     * List of columns to return, null for all columns
     */
    public List<ByteBuffer> columns; // required
    /**
     * Get attributes
     */
    public Map<ByteBuffer,ByteBuffer> attributes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of table
       */
      TABLE_NAME((short)1, "tableName"),
      /**
       * row keys
       */
      ROWS((short)2, "rows"),
      /**
       * List of columns to return, null for all columns
       */
      COLUMNS((short)3, "columns"),
      /**
       * Get attributes
       */
      ATTRIBUTES((short)4, "attributes");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          case 2: // ROWS
            return ROWS;
          case 3: // COLUMNS
            return COLUMNS;
          case 4: // ATTRIBUTES
            return ATTRIBUTES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.ROWS, new org.apache.thrift.meta_data.FieldMetaData("rows", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      tmpMap.put(_Fields.COLUMNS, new org.apache.thrift.meta_data.FieldMetaData("columns", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      tmpMap.put(_Fields.ATTRIBUTES, new org.apache.thrift.meta_data.FieldMetaData("attributes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"), 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRowsWithColumns_args.class, metaDataMap);
    }

    public getRowsWithColumns_args() {
    }

    public getRowsWithColumns_args(
      ByteBuffer tableName,
      List<ByteBuffer> rows,
      List<ByteBuffer> columns,
      Map<ByteBuffer,ByteBuffer> attributes)
    {
      this();
      this.tableName = tableName;
      this.rows = rows;
      this.columns = columns;
      this.attributes = attributes;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRowsWithColumns_args(getRowsWithColumns_args other) {
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
      if (other.isSetRows()) {
        List<ByteBuffer> __this__rows = new ArrayList<ByteBuffer>();
        for (ByteBuffer other_element : other.rows) {
          __this__rows.add(other_element);
        }
        this.rows = __this__rows;
      }
      if (other.isSetColumns()) {
        List<ByteBuffer> __this__columns = new ArrayList<ByteBuffer>();
        for (ByteBuffer other_element : other.columns) {
          __this__columns.add(other_element);
        }
        this.columns = __this__columns;
      }
      if (other.isSetAttributes()) {
        Map<ByteBuffer,ByteBuffer> __this__attributes = new HashMap<ByteBuffer,ByteBuffer>();
        for (Map.Entry<ByteBuffer, ByteBuffer> other_element : other.attributes.entrySet()) {

          ByteBuffer other_element_key = other_element.getKey();
          ByteBuffer other_element_value = other_element.getValue();

          ByteBuffer __this__attributes_copy_key = other_element_key;

          ByteBuffer __this__attributes_copy_value = other_element_value;

          __this__attributes.put(__this__attributes_copy_key, __this__attributes_copy_value);
        }
        this.attributes = __this__attributes;
      }
    }

    public getRowsWithColumns_args deepCopy() {
      return new getRowsWithColumns_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
      this.rows = null;
      this.columns = null;
      this.attributes = null;
    }

    /**
     * name of table
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public ByteBuffer bufferForTableName() {
      return tableName;
    }

    /**
     * name of table
     */
    public getRowsWithColumns_args setTableName(byte[] tableName) {
      setTableName(tableName == null ? (ByteBuffer)null : ByteBuffer.wrap(tableName));
      return this;
    }

    public getRowsWithColumns_args setTableName(ByteBuffer tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public int getRowsSize() {
      return (this.rows == null) ? 0 : this.rows.size();
    }

    public java.util.Iterator<ByteBuffer> getRowsIterator() {
      return (this.rows == null) ? null : this.rows.iterator();
    }

    public void addToRows(ByteBuffer elem) {
      if (this.rows == null) {
        this.rows = new ArrayList<ByteBuffer>();
      }
      this.rows.add(elem);
    }

    /**
     * row keys
     */
    public List<ByteBuffer> getRows() {
      return this.rows;
    }

    /**
     * row keys
     */
    public getRowsWithColumns_args setRows(List<ByteBuffer> rows) {
      this.rows = rows;
      return this;
    }

    public void unsetRows() {
      this.rows = null;
    }

    /** Returns true if field rows is set (has been assigned a value) and false otherwise */
    public boolean isSetRows() {
      return this.rows != null;
    }

    public void setRowsIsSet(boolean value) {
      if (!value) {
        this.rows = null;
      }
    }

    public int getColumnsSize() {
      return (this.columns == null) ? 0 : this.columns.size();
    }

    public java.util.Iterator<ByteBuffer> getColumnsIterator() {
      return (this.columns == null) ? null : this.columns.iterator();
    }

    public void addToColumns(ByteBuffer elem) {
      if (this.columns == null) {
        this.columns = new ArrayList<ByteBuffer>();
      }
      this.columns.add(elem);
    }

    /**
     * List of columns to return, null for all columns
     */
    public List<ByteBuffer> getColumns() {
      return this.columns;
    }

    /**
     * List of columns to return, null for all columns
     */
    public getRowsWithColumns_args setColumns(List<ByteBuffer> columns) {
      this.columns = columns;
      return this;
    }

    public void unsetColumns() {
      this.columns = null;
    }

    /** Returns true if field columns is set (has been assigned a value) and false otherwise */
    public boolean isSetColumns() {
      return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
      if (!value) {
        this.columns = null;
      }
    }

    public int getAttributesSize() {
      return (this.attributes == null) ? 0 : this.attributes.size();
    }

    public void putToAttributes(ByteBuffer key, ByteBuffer val) {
      if (this.attributes == null) {
        this.attributes = new HashMap<ByteBuffer,ByteBuffer>();
      }
      this.attributes.put(key, val);
    }

    /**
     * Get attributes
     */
    public Map<ByteBuffer,ByteBuffer> getAttributes() {
      return this.attributes;
    }

    /**
     * Get attributes
     */
    public getRowsWithColumns_args setAttributes(Map<ByteBuffer,ByteBuffer> attributes) {
      this.attributes = attributes;
      return this;
    }

    public void unsetAttributes() {
      this.attributes = null;
    }

    /** Returns true if field attributes is set (has been assigned a value) and false otherwise */
    public boolean isSetAttributes() {
      return this.attributes != null;
    }

    public void setAttributesIsSet(boolean value) {
      if (!value) {
        this.attributes = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((ByteBuffer)value);
        }
        break;

      case ROWS:
        if (value == null) {
          unsetRows();
        } else {
          setRows((List<ByteBuffer>)value);
        }
        break;

      case COLUMNS:
        if (value == null) {
          unsetColumns();
        } else {
          setColumns((List<ByteBuffer>)value);
        }
        break;

      case ATTRIBUTES:
        if (value == null) {
          unsetAttributes();
        } else {
          setAttributes((Map<ByteBuffer,ByteBuffer>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      case ROWS:
        return getRows();

      case COLUMNS:
        return getColumns();

      case ATTRIBUTES:
        return getAttributes();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      case ROWS:
        return isSetRows();
      case COLUMNS:
        return isSetColumns();
      case ATTRIBUTES:
        return isSetAttributes();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRowsWithColumns_args)
        return this.equals((getRowsWithColumns_args)that);
      return false;
    }

    public boolean equals(getRowsWithColumns_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_rows = true && this.isSetRows();
      boolean that_present_rows = true && that.isSetRows();
      if (this_present_rows || that_present_rows) {
        if (!(this_present_rows && that_present_rows))
          return false;
        if (!this.rows.equals(that.rows))
          return false;
      }

      boolean this_present_columns = true && this.isSetColumns();
      boolean that_present_columns = true && that.isSetColumns();
      if (this_present_columns || that_present_columns) {
        if (!(this_present_columns && that_present_columns))
          return false;
        if (!this.columns.equals(that.columns))
          return false;
      }

      boolean this_present_attributes = true && this.isSetAttributes();
      boolean that_present_attributes = true && that.isSetAttributes();
      if (this_present_attributes || that_present_attributes) {
        if (!(this_present_attributes && that_present_attributes))
          return false;
        if (!this.attributes.equals(that.attributes))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_tableName = true && (isSetTableName());
      builder.append(present_tableName);
      if (present_tableName)
        builder.append(tableName);

      boolean present_rows = true && (isSetRows());
      builder.append(present_rows);
      if (present_rows)
        builder.append(rows);

      boolean present_columns = true && (isSetColumns());
      builder.append(present_columns);
      if (present_columns)
        builder.append(columns);

      boolean present_attributes = true && (isSetAttributes());
      builder.append(present_attributes);
      if (present_attributes)
        builder.append(attributes);

      return builder.toHashCode();
    }

    public int compareTo(getRowsWithColumns_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getRowsWithColumns_args typedOther = (getRowsWithColumns_args)other;

      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(typedOther.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, typedOther.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetRows()).compareTo(typedOther.isSetRows());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRows()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.rows, typedOther.rows);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetColumns()).compareTo(typedOther.isSetColumns());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumns()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.columns, typedOther.columns);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetAttributes()).compareTo(typedOther.isSetAttributes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAttributes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.attributes, typedOther.attributes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getRowsWithColumns_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("rows:");
      if (this.rows == null) {
        sb.append("null");
      } else {
        sb.append(this.rows);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("columns:");
      if (this.columns == null) {
        sb.append("null");
      } else {
        sb.append(this.columns);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("attributes:");
      if (this.attributes == null) {
        sb.append("null");
      } else {
        sb.append(this.attributes);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRowsWithColumns_argsStandardSchemeFactory implements SchemeFactory {
      public getRowsWithColumns_argsStandardScheme getScheme() {
        return new getRowsWithColumns_argsStandardScheme();
      }
    }

    private static class getRowsWithColumns_argsStandardScheme extends StandardScheme<getRowsWithColumns_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRowsWithColumns_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ROWS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list252 = iprot.readListBegin();
                  struct.rows = new ArrayList<ByteBuffer>(_list252.size);
                  for (int _i253 = 0; _i253 < _list252.size; ++_i253)
                  {
                    ByteBuffer _elem254; // required
                    _elem254 = iprot.readBinary();
                    struct.rows.add(_elem254);
                  }
                  iprot.readListEnd();
                }
                struct.setRowsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // COLUMNS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list255 = iprot.readListBegin();
                  struct.columns = new ArrayList<ByteBuffer>(_list255.size);
                  for (int _i256 = 0; _i256 < _list255.size; ++_i256)
                  {
                    ByteBuffer _elem257; // required
                    _elem257 = iprot.readBinary();
                    struct.columns.add(_elem257);
                  }
                  iprot.readListEnd();
                }
                struct.setColumnsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // ATTRIBUTES
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map258 = iprot.readMapBegin();
                  struct.attributes = new HashMap<ByteBuffer,ByteBuffer>(2*_map258.size);
                  for (int _i259 = 0; _i259 < _map258.size; ++_i259)
                  {
                    ByteBuffer _key260; // required
                    ByteBuffer _val261; // required
                    _key260 = iprot.readBinary();
                    _val261 = iprot.readBinary();
                    struct.attributes.put(_key260, _val261);
                  }
                  iprot.readMapEnd();
                }
                struct.setAttributesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRowsWithColumns_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        if (struct.rows != null) {
          oprot.writeFieldBegin(ROWS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.rows.size()));
            for (ByteBuffer _iter262 : struct.rows)
            {
              oprot.writeBinary(_iter262);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.columns != null) {
          oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.columns.size()));
            for (ByteBuffer _iter263 : struct.columns)
            {
              oprot.writeBinary(_iter263);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.attributes != null) {
          oprot.writeFieldBegin(ATTRIBUTES_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, struct.attributes.size()));
            for (Map.Entry<ByteBuffer, ByteBuffer> _iter264 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter264.getKey());
              oprot.writeBinary(_iter264.getValue());
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRowsWithColumns_argsTupleSchemeFactory implements SchemeFactory {
      public getRowsWithColumns_argsTupleScheme getScheme() {
        return new getRowsWithColumns_argsTupleScheme();
      }
    }

    private static class getRowsWithColumns_argsTupleScheme extends TupleScheme<getRowsWithColumns_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRowsWithColumns_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        if (struct.isSetRows()) {
          optionals.set(1);
        }
        if (struct.isSetColumns()) {
          optionals.set(2);
        }
        if (struct.isSetAttributes()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
        if (struct.isSetRows()) {
          {
            oprot.writeI32(struct.rows.size());
            for (ByteBuffer _iter265 : struct.rows)
            {
              oprot.writeBinary(_iter265);
            }
          }
        }
        if (struct.isSetColumns()) {
          {
            oprot.writeI32(struct.columns.size());
            for (ByteBuffer _iter266 : struct.columns)
            {
              oprot.writeBinary(_iter266);
            }
          }
        }
        if (struct.isSetAttributes()) {
          {
            oprot.writeI32(struct.attributes.size());
            for (Map.Entry<ByteBuffer, ByteBuffer> _iter267 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter267.getKey());
              oprot.writeBinary(_iter267.getValue());
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRowsWithColumns_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(1)) {
          {
            org.apache.thrift.protocol.TList _list268 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.rows = new ArrayList<ByteBuffer>(_list268.size);
            for (int _i269 = 0; _i269 < _list268.size; ++_i269)
            {
              ByteBuffer _elem270; // required
              _elem270 = iprot.readBinary();
              struct.rows.add(_elem270);
            }
          }
          struct.setRowsIsSet(true);
        }
        if (incoming.get(2)) {
          {
            org.apache.thrift.protocol.TList _list271 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.columns = new ArrayList<ByteBuffer>(_list271.size);
            for (int _i272 = 0; _i272 < _list271.size; ++_i272)
            {
              ByteBuffer _elem273; // required
              _elem273 = iprot.readBinary();
              struct.columns.add(_elem273);
            }
          }
          struct.setColumnsIsSet(true);
        }
        if (incoming.get(3)) {
          {
            org.apache.thrift.protocol.TMap _map274 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.attributes = new HashMap<ByteBuffer,ByteBuffer>(2*_map274.size);
            for (int _i275 = 0; _i275 < _map274.size; ++_i275)
            {
              ByteBuffer _key276; // required
              ByteBuffer _val277; // required
              _key276 = iprot.readBinary();
              _val277 = iprot.readBinary();
              struct.attributes.put(_key276, _val277);
            }
          }
          struct.setAttributesIsSet(true);
        }
      }
    }

  }

  public static class getRowsWithColumns_result implements org.apache.thrift.TBase<getRowsWithColumns_result, getRowsWithColumns_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRowsWithColumns_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getRowsWithColumns_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getRowsWithColumns_resultTupleSchemeFactory());
    }

    public List<TRowResult> success; // required
    public IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TRowResult.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRowsWithColumns_result.class, metaDataMap);
    }

    public getRowsWithColumns_result() {
    }

    public getRowsWithColumns_result(
      List<TRowResult> success,
      IOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRowsWithColumns_result(getRowsWithColumns_result other) {
      if (other.isSetSuccess()) {
        List<TRowResult> __this__success = new ArrayList<TRowResult>();
        for (TRowResult other_element : other.success) {
          __this__success.add(new TRowResult(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public getRowsWithColumns_result deepCopy() {
      return new getRowsWithColumns_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<TRowResult> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TRowResult elem) {
      if (this.success == null) {
        this.success = new ArrayList<TRowResult>();
      }
      this.success.add(elem);
    }

    public List<TRowResult> getSuccess() {
      return this.success;
    }

    public getRowsWithColumns_result setSuccess(List<TRowResult> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public IOError getIo() {
      return this.io;
    }

    public getRowsWithColumns_result setIo(IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<TRowResult>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRowsWithColumns_result)
        return this.equals((getRowsWithColumns_result)that);
      return false;
    }

    public boolean equals(getRowsWithColumns_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_io = true && (isSetIo());
      builder.append(present_io);
      if (present_io)
        builder.append(io);

      return builder.toHashCode();
    }

    public int compareTo(getRowsWithColumns_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getRowsWithColumns_result typedOther = (getRowsWithColumns_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIo()).compareTo(typedOther.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, typedOther.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getRowsWithColumns_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRowsWithColumns_resultStandardSchemeFactory implements SchemeFactory {
      public getRowsWithColumns_resultStandardScheme getScheme() {
        return new getRowsWithColumns_resultStandardScheme();
      }
    }

    private static class getRowsWithColumns_resultStandardScheme extends StandardScheme<getRowsWithColumns_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRowsWithColumns_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list278 = iprot.readListBegin();
                  struct.success = new ArrayList<TRowResult>(_list278.size);
                  for (int _i279 = 0; _i279 < _list278.size; ++_i279)
                  {
                    TRowResult _elem280; // required
                    _elem280 = new TRowResult();
                    _elem280.read(iprot);
                    struct.success.add(_elem280);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRowsWithColumns_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (TRowResult _iter281 : struct.success)
            {
              _iter281.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRowsWithColumns_resultTupleSchemeFactory implements SchemeFactory {
      public getRowsWithColumns_resultTupleScheme getScheme() {
        return new getRowsWithColumns_resultTupleScheme();
      }
    }

    private static class getRowsWithColumns_resultTupleScheme extends TupleScheme<getRowsWithColumns_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRowsWithColumns_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (TRowResult _iter282 : struct.success)
            {
              _iter282.write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRowsWithColumns_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list283 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<TRowResult>(_list283.size);
            for (int _i284 = 0; _i284 < _list283.size; ++_i284)
            {
              TRowResult _elem285; // required
              _elem285 = new TRowResult();
              _elem285.read(iprot);
              struct.success.add(_elem285);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

  }

  public static class getRowsTs_args implements org.apache.thrift.TBase<getRowsTs_args, getRowsTs_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRowsTs_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField ROWS_FIELD_DESC = new org.apache.thrift.protocol.TField("rows", org.apache.thrift.protocol.TType.LIST, (short)2);
    private static final org.apache.thrift.protocol.TField TIMESTAMP_FIELD_DESC = new org.apache.thrift.protocol.TField("timestamp", org.apache.thrift.protocol.TType.I64, (short)3);
    private static final org.apache.thrift.protocol.TField ATTRIBUTES_FIELD_DESC = new org.apache.thrift.protocol.TField("attributes", org.apache.thrift.protocol.TType.MAP, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getRowsTs_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getRowsTs_argsTupleSchemeFactory());
    }

    /**
     * name of the table
     */
    public ByteBuffer tableName; // required
    /**
     * row keys
     */
    public List<ByteBuffer> rows; // required
    /**
     * timestamp
     */
    public long timestamp; // required
    /**
     * Get attributes
     */
    public Map<ByteBuffer,ByteBuffer> attributes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of the table
       */
      TABLE_NAME((short)1, "tableName"),
      /**
       * row keys
       */
      ROWS((short)2, "rows"),
      /**
       * timestamp
       */
      TIMESTAMP((short)3, "timestamp"),
      /**
       * Get attributes
       */
      ATTRIBUTES((short)4, "attributes");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          case 2: // ROWS
            return ROWS;
          case 3: // TIMESTAMP
            return TIMESTAMP;
          case 4: // ATTRIBUTES
            return ATTRIBUTES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TIMESTAMP_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.ROWS, new org.apache.thrift.meta_data.FieldMetaData("rows", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      tmpMap.put(_Fields.TIMESTAMP, new org.apache.thrift.meta_data.FieldMetaData("timestamp", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.ATTRIBUTES, new org.apache.thrift.meta_data.FieldMetaData("attributes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"), 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRowsTs_args.class, metaDataMap);
    }

    public getRowsTs_args() {
    }

    public getRowsTs_args(
      ByteBuffer tableName,
      List<ByteBuffer> rows,
      long timestamp,
      Map<ByteBuffer,ByteBuffer> attributes)
    {
      this();
      this.tableName = tableName;
      this.rows = rows;
      this.timestamp = timestamp;
      setTimestampIsSet(true);
      this.attributes = attributes;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRowsTs_args(getRowsTs_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
      if (other.isSetRows()) {
        List<ByteBuffer> __this__rows = new ArrayList<ByteBuffer>();
        for (ByteBuffer other_element : other.rows) {
          __this__rows.add(other_element);
        }
        this.rows = __this__rows;
      }
      this.timestamp = other.timestamp;
      if (other.isSetAttributes()) {
        Map<ByteBuffer,ByteBuffer> __this__attributes = new HashMap<ByteBuffer,ByteBuffer>();
        for (Map.Entry<ByteBuffer, ByteBuffer> other_element : other.attributes.entrySet()) {

          ByteBuffer other_element_key = other_element.getKey();
          ByteBuffer other_element_value = other_element.getValue();

          ByteBuffer __this__attributes_copy_key = other_element_key;

          ByteBuffer __this__attributes_copy_value = other_element_value;

          __this__attributes.put(__this__attributes_copy_key, __this__attributes_copy_value);
        }
        this.attributes = __this__attributes;
      }
    }

    public getRowsTs_args deepCopy() {
      return new getRowsTs_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
      this.rows = null;
      setTimestampIsSet(false);
      this.timestamp = 0;
      this.attributes = null;
    }

    /**
     * name of the table
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public ByteBuffer bufferForTableName() {
      return tableName;
    }

    /**
     * name of the table
     */
    public getRowsTs_args setTableName(byte[] tableName) {
      setTableName(tableName == null ? (ByteBuffer)null : ByteBuffer.wrap(tableName));
      return this;
    }

    public getRowsTs_args setTableName(ByteBuffer tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public int getRowsSize() {
      return (this.rows == null) ? 0 : this.rows.size();
    }

    public java.util.Iterator<ByteBuffer> getRowsIterator() {
      return (this.rows == null) ? null : this.rows.iterator();
    }

    public void addToRows(ByteBuffer elem) {
      if (this.rows == null) {
        this.rows = new ArrayList<ByteBuffer>();
      }
      this.rows.add(elem);
    }

    /**
     * row keys
     */
    public List<ByteBuffer> getRows() {
      return this.rows;
    }

    /**
     * row keys
     */
    public getRowsTs_args setRows(List<ByteBuffer> rows) {
      this.rows = rows;
      return this;
    }

    public void unsetRows() {
      this.rows = null;
    }

    /** Returns true if field rows is set (has been assigned a value) and false otherwise */
    public boolean isSetRows() {
      return this.rows != null;
    }

    public void setRowsIsSet(boolean value) {
      if (!value) {
        this.rows = null;
      }
    }

    /**
     * timestamp
     */
    public long getTimestamp() {
      return this.timestamp;
    }

    /**
     * timestamp
     */
    public getRowsTs_args setTimestamp(long timestamp) {
      this.timestamp = timestamp;
      setTimestampIsSet(true);
      return this;
    }

    public void unsetTimestamp() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __TIMESTAMP_ISSET_ID);
    }

    /** Returns true if field timestamp is set (has been assigned a value) and false otherwise */
    public boolean isSetTimestamp() {
      return EncodingUtils.testBit(__isset_bitfield, __TIMESTAMP_ISSET_ID);
    }

    public void setTimestampIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __TIMESTAMP_ISSET_ID, value);
    }

    public int getAttributesSize() {
      return (this.attributes == null) ? 0 : this.attributes.size();
    }

    public void putToAttributes(ByteBuffer key, ByteBuffer val) {
      if (this.attributes == null) {
        this.attributes = new HashMap<ByteBuffer,ByteBuffer>();
      }
      this.attributes.put(key, val);
    }

    /**
     * Get attributes
     */
    public Map<ByteBuffer,ByteBuffer> getAttributes() {
      return this.attributes;
    }

    /**
     * Get attributes
     */
    public getRowsTs_args setAttributes(Map<ByteBuffer,ByteBuffer> attributes) {
      this.attributes = attributes;
      return this;
    }

    public void unsetAttributes() {
      this.attributes = null;
    }

    /** Returns true if field attributes is set (has been assigned a value) and false otherwise */
    public boolean isSetAttributes() {
      return this.attributes != null;
    }

    public void setAttributesIsSet(boolean value) {
      if (!value) {
        this.attributes = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((ByteBuffer)value);
        }
        break;

      case ROWS:
        if (value == null) {
          unsetRows();
        } else {
          setRows((List<ByteBuffer>)value);
        }
        break;

      case TIMESTAMP:
        if (value == null) {
          unsetTimestamp();
        } else {
          setTimestamp((Long)value);
        }
        break;

      case ATTRIBUTES:
        if (value == null) {
          unsetAttributes();
        } else {
          setAttributes((Map<ByteBuffer,ByteBuffer>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      case ROWS:
        return getRows();

      case TIMESTAMP:
        return Long.valueOf(getTimestamp());

      case ATTRIBUTES:
        return getAttributes();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      case ROWS:
        return isSetRows();
      case TIMESTAMP:
        return isSetTimestamp();
      case ATTRIBUTES:
        return isSetAttributes();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRowsTs_args)
        return this.equals((getRowsTs_args)that);
      return false;
    }

    public boolean equals(getRowsTs_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_rows = true && this.isSetRows();
      boolean that_present_rows = true && that.isSetRows();
      if (this_present_rows || that_present_rows) {
        if (!(this_present_rows && that_present_rows))
          return false;
        if (!this.rows.equals(that.rows))
          return false;
      }

      boolean this_present_timestamp = true;
      boolean that_present_timestamp = true;
      if (this_present_timestamp || that_present_timestamp) {
        if (!(this_present_timestamp && that_present_timestamp))
          return false;
        if (this.timestamp != that.timestamp)
          return false;
      }

      boolean this_present_attributes = true && this.isSetAttributes();
      boolean that_present_attributes = true && that.isSetAttributes();
      if (this_present_attributes || that_present_attributes) {
        if (!(this_present_attributes && that_present_attributes))
          return false;
        if (!this.attributes.equals(that.attributes))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_tableName = true && (isSetTableName());
      builder.append(present_tableName);
      if (present_tableName)
        builder.append(tableName);

      boolean present_rows = true && (isSetRows());
      builder.append(present_rows);
      if (present_rows)
        builder.append(rows);

      boolean present_timestamp = true;
      builder.append(present_timestamp);
      if (present_timestamp)
        builder.append(timestamp);

      boolean present_attributes = true && (isSetAttributes());
      builder.append(present_attributes);
      if (present_attributes)
        builder.append(attributes);

      return builder.toHashCode();
    }

    public int compareTo(getRowsTs_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getRowsTs_args typedOther = (getRowsTs_args)other;

      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(typedOther.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, typedOther.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetRows()).compareTo(typedOther.isSetRows());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRows()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.rows, typedOther.rows);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTimestamp()).compareTo(typedOther.isSetTimestamp());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTimestamp()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.timestamp, typedOther.timestamp);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetAttributes()).compareTo(typedOther.isSetAttributes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAttributes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.attributes, typedOther.attributes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getRowsTs_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("rows:");
      if (this.rows == null) {
        sb.append("null");
      } else {
        sb.append(this.rows);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("timestamp:");
      sb.append(this.timestamp);
      first = false;
      if (!first) sb.append(", ");
      sb.append("attributes:");
      if (this.attributes == null) {
        sb.append("null");
      } else {
        sb.append(this.attributes);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRowsTs_argsStandardSchemeFactory implements SchemeFactory {
      public getRowsTs_argsStandardScheme getScheme() {
        return new getRowsTs_argsStandardScheme();
      }
    }

    private static class getRowsTs_argsStandardScheme extends StandardScheme<getRowsTs_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRowsTs_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ROWS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list286 = iprot.readListBegin();
                  struct.rows = new ArrayList<ByteBuffer>(_list286.size);
                  for (int _i287 = 0; _i287 < _list286.size; ++_i287)
                  {
                    ByteBuffer _elem288; // required
                    _elem288 = iprot.readBinary();
                    struct.rows.add(_elem288);
                  }
                  iprot.readListEnd();
                }
                struct.setRowsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // TIMESTAMP
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.timestamp = iprot.readI64();
                struct.setTimestampIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // ATTRIBUTES
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map289 = iprot.readMapBegin();
                  struct.attributes = new HashMap<ByteBuffer,ByteBuffer>(2*_map289.size);
                  for (int _i290 = 0; _i290 < _map289.size; ++_i290)
                  {
                    ByteBuffer _key291; // required
                    ByteBuffer _val292; // required
                    _key291 = iprot.readBinary();
                    _val292 = iprot.readBinary();
                    struct.attributes.put(_key291, _val292);
                  }
                  iprot.readMapEnd();
                }
                struct.setAttributesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRowsTs_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        if (struct.rows != null) {
          oprot.writeFieldBegin(ROWS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.rows.size()));
            for (ByteBuffer _iter293 : struct.rows)
            {
              oprot.writeBinary(_iter293);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(TIMESTAMP_FIELD_DESC);
        oprot.writeI64(struct.timestamp);
        oprot.writeFieldEnd();
        if (struct.attributes != null) {
          oprot.writeFieldBegin(ATTRIBUTES_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, struct.attributes.size()));
            for (Map.Entry<ByteBuffer, ByteBuffer> _iter294 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter294.getKey());
              oprot.writeBinary(_iter294.getValue());
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRowsTs_argsTupleSchemeFactory implements SchemeFactory {
      public getRowsTs_argsTupleScheme getScheme() {
        return new getRowsTs_argsTupleScheme();
      }
    }

    private static class getRowsTs_argsTupleScheme extends TupleScheme<getRowsTs_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRowsTs_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        if (struct.isSetRows()) {
          optionals.set(1);
        }
        if (struct.isSetTimestamp()) {
          optionals.set(2);
        }
        if (struct.isSetAttributes()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
        if (struct.isSetRows()) {
          {
            oprot.writeI32(struct.rows.size());
            for (ByteBuffer _iter295 : struct.rows)
            {
              oprot.writeBinary(_iter295);
            }
          }
        }
        if (struct.isSetTimestamp()) {
          oprot.writeI64(struct.timestamp);
        }
        if (struct.isSetAttributes()) {
          {
            oprot.writeI32(struct.attributes.size());
            for (Map.Entry<ByteBuffer, ByteBuffer> _iter296 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter296.getKey());
              oprot.writeBinary(_iter296.getValue());
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRowsTs_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(1)) {
          {
            org.apache.thrift.protocol.TList _list297 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.rows = new ArrayList<ByteBuffer>(_list297.size);
            for (int _i298 = 0; _i298 < _list297.size; ++_i298)
            {
              ByteBuffer _elem299; // required
              _elem299 = iprot.readBinary();
              struct.rows.add(_elem299);
            }
          }
          struct.setRowsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.timestamp = iprot.readI64();
          struct.setTimestampIsSet(true);
        }
        if (incoming.get(3)) {
          {
            org.apache.thrift.protocol.TMap _map300 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.attributes = new HashMap<ByteBuffer,ByteBuffer>(2*_map300.size);
            for (int _i301 = 0; _i301 < _map300.size; ++_i301)
            {
              ByteBuffer _key302; // required
              ByteBuffer _val303; // required
              _key302 = iprot.readBinary();
              _val303 = iprot.readBinary();
              struct.attributes.put(_key302, _val303);
            }
          }
          struct.setAttributesIsSet(true);
        }
      }
    }

  }

  public static class getRowsTs_result implements org.apache.thrift.TBase<getRowsTs_result, getRowsTs_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRowsTs_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getRowsTs_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getRowsTs_resultTupleSchemeFactory());
    }

    public List<TRowResult> success; // required
    public IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TRowResult.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRowsTs_result.class, metaDataMap);
    }

    public getRowsTs_result() {
    }

    public getRowsTs_result(
      List<TRowResult> success,
      IOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRowsTs_result(getRowsTs_result other) {
      if (other.isSetSuccess()) {
        List<TRowResult> __this__success = new ArrayList<TRowResult>();
        for (TRowResult other_element : other.success) {
          __this__success.add(new TRowResult(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public getRowsTs_result deepCopy() {
      return new getRowsTs_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<TRowResult> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TRowResult elem) {
      if (this.success == null) {
        this.success = new ArrayList<TRowResult>();
      }
      this.success.add(elem);
    }

    public List<TRowResult> getSuccess() {
      return this.success;
    }

    public getRowsTs_result setSuccess(List<TRowResult> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public IOError getIo() {
      return this.io;
    }

    public getRowsTs_result setIo(IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<TRowResult>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRowsTs_result)
        return this.equals((getRowsTs_result)that);
      return false;
    }

    public boolean equals(getRowsTs_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_io = true && (isSetIo());
      builder.append(present_io);
      if (present_io)
        builder.append(io);

      return builder.toHashCode();
    }

    public int compareTo(getRowsTs_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getRowsTs_result typedOther = (getRowsTs_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIo()).compareTo(typedOther.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, typedOther.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getRowsTs_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRowsTs_resultStandardSchemeFactory implements SchemeFactory {
      public getRowsTs_resultStandardScheme getScheme() {
        return new getRowsTs_resultStandardScheme();
      }
    }

    private static class getRowsTs_resultStandardScheme extends StandardScheme<getRowsTs_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRowsTs_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list304 = iprot.readListBegin();
                  struct.success = new ArrayList<TRowResult>(_list304.size);
                  for (int _i305 = 0; _i305 < _list304.size; ++_i305)
                  {
                    TRowResult _elem306; // required
                    _elem306 = new TRowResult();
                    _elem306.read(iprot);
                    struct.success.add(_elem306);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRowsTs_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (TRowResult _iter307 : struct.success)
            {
              _iter307.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRowsTs_resultTupleSchemeFactory implements SchemeFactory {
      public getRowsTs_resultTupleScheme getScheme() {
        return new getRowsTs_resultTupleScheme();
      }
    }

    private static class getRowsTs_resultTupleScheme extends TupleScheme<getRowsTs_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRowsTs_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (TRowResult _iter308 : struct.success)
            {
              _iter308.write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRowsTs_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list309 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<TRowResult>(_list309.size);
            for (int _i310 = 0; _i310 < _list309.size; ++_i310)
            {
              TRowResult _elem311; // required
              _elem311 = new TRowResult();
              _elem311.read(iprot);
              struct.success.add(_elem311);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

  }

  public static class getRowsWithColumnsTs_args implements org.apache.thrift.TBase<getRowsWithColumnsTs_args, getRowsWithColumnsTs_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRowsWithColumnsTs_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField ROWS_FIELD_DESC = new org.apache.thrift.protocol.TField("rows", org.apache.thrift.protocol.TType.LIST, (short)2);
    private static final org.apache.thrift.protocol.TField COLUMNS_FIELD_DESC = new org.apache.thrift.protocol.TField("columns", org.apache.thrift.protocol.TType.LIST, (short)3);
    private static final org.apache.thrift.protocol.TField TIMESTAMP_FIELD_DESC = new org.apache.thrift.protocol.TField("timestamp", org.apache.thrift.protocol.TType.I64, (short)4);
    private static final org.apache.thrift.protocol.TField ATTRIBUTES_FIELD_DESC = new org.apache.thrift.protocol.TField("attributes", org.apache.thrift.protocol.TType.MAP, (short)5);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getRowsWithColumnsTs_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getRowsWithColumnsTs_argsTupleSchemeFactory());
    }

    /**
     * name of table
     */
    public ByteBuffer tableName; // required
    /**
     * row keys
     */
    public List<ByteBuffer> rows; // required
    /**
     * List of columns to return, null for all columns
     */
    public List<ByteBuffer> columns; // required
    public long timestamp; // required
    /**
     * Get attributes
     */
    public Map<ByteBuffer,ByteBuffer> attributes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of table
       */
      TABLE_NAME((short)1, "tableName"),
      /**
       * row keys
       */
      ROWS((short)2, "rows"),
      /**
       * List of columns to return, null for all columns
       */
      COLUMNS((short)3, "columns"),
      TIMESTAMP((short)4, "timestamp"),
      /**
       * Get attributes
       */
      ATTRIBUTES((short)5, "attributes");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          case 2: // ROWS
            return ROWS;
          case 3: // COLUMNS
            return COLUMNS;
          case 4: // TIMESTAMP
            return TIMESTAMP;
          case 5: // ATTRIBUTES
            return ATTRIBUTES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TIMESTAMP_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.ROWS, new org.apache.thrift.meta_data.FieldMetaData("rows", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      tmpMap.put(_Fields.COLUMNS, new org.apache.thrift.meta_data.FieldMetaData("columns", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      tmpMap.put(_Fields.TIMESTAMP, new org.apache.thrift.meta_data.FieldMetaData("timestamp", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.ATTRIBUTES, new org.apache.thrift.meta_data.FieldMetaData("attributes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"), 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRowsWithColumnsTs_args.class, metaDataMap);
    }

    public getRowsWithColumnsTs_args() {
    }

    public getRowsWithColumnsTs_args(
      ByteBuffer tableName,
      List<ByteBuffer> rows,
      List<ByteBuffer> columns,
      long timestamp,
      Map<ByteBuffer,ByteBuffer> attributes)
    {
      this();
      this.tableName = tableName;
      this.rows = rows;
      this.columns = columns;
      this.timestamp = timestamp;
      setTimestampIsSet(true);
      this.attributes = attributes;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRowsWithColumnsTs_args(getRowsWithColumnsTs_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
      if (other.isSetRows()) {
        List<ByteBuffer> __this__rows = new ArrayList<ByteBuffer>();
        for (ByteBuffer other_element : other.rows) {
          __this__rows.add(other_element);
        }
        this.rows = __this__rows;
      }
      if (other.isSetColumns()) {
        List<ByteBuffer> __this__columns = new ArrayList<ByteBuffer>();
        for (ByteBuffer other_element : other.columns) {
          __this__columns.add(other_element);
        }
        this.columns = __this__columns;
      }
      this.timestamp = other.timestamp;
      if (other.isSetAttributes()) {
        Map<ByteBuffer,ByteBuffer> __this__attributes = new HashMap<ByteBuffer,ByteBuffer>();
        for (Map.Entry<ByteBuffer, ByteBuffer> other_element : other.attributes.entrySet()) {

          ByteBuffer other_element_key = other_element.getKey();
          ByteBuffer other_element_value = other_element.getValue();

          ByteBuffer __this__attributes_copy_key = other_element_key;

          ByteBuffer __this__attributes_copy_value = other_element_value;

          __this__attributes.put(__this__attributes_copy_key, __this__attributes_copy_value);
        }
        this.attributes = __this__attributes;
      }
    }

    public getRowsWithColumnsTs_args deepCopy() {
      return new getRowsWithColumnsTs_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
      this.rows = null;
      this.columns = null;
      setTimestampIsSet(false);
      this.timestamp = 0;
      this.attributes = null;
    }

    /**
     * name of table
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public ByteBuffer bufferForTableName() {
      return tableName;
    }

    /**
     * name of table
     */
    public getRowsWithColumnsTs_args setTableName(byte[] tableName) {
      setTableName(tableName == null ? (ByteBuffer)null : ByteBuffer.wrap(tableName));
      return this;
    }

    public getRowsWithColumnsTs_args setTableName(ByteBuffer tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public int getRowsSize() {
      return (this.rows == null) ? 0 : this.rows.size();
    }

    public java.util.Iterator<ByteBuffer> getRowsIterator() {
      return (this.rows == null) ? null : this.rows.iterator();
    }

    public void addToRows(ByteBuffer elem) {
      if (this.rows == null) {
        this.rows = new ArrayList<ByteBuffer>();
      }
      this.rows.add(elem);
    }

    /**
     * row keys
     */
    public List<ByteBuffer> getRows() {
      return this.rows;
    }

    /**
     * row keys
     */
    public getRowsWithColumnsTs_args setRows(List<ByteBuffer> rows) {
      this.rows = rows;
      return this;
    }

    public void unsetRows() {
      this.rows = null;
    }

    /** Returns true if field rows is set (has been assigned a value) and false otherwise */
    public boolean isSetRows() {
      return this.rows != null;
    }

    public void setRowsIsSet(boolean value) {
      if (!value) {
        this.rows = null;
      }
    }

    public int getColumnsSize() {
      return (this.columns == null) ? 0 : this.columns.size();
    }

    public java.util.Iterator<ByteBuffer> getColumnsIterator() {
      return (this.columns == null) ? null : this.columns.iterator();
    }

    public void addToColumns(ByteBuffer elem) {
      if (this.columns == null) {
        this.columns = new ArrayList<ByteBuffer>();
      }
      this.columns.add(elem);
    }

    /**
     * List of columns to return, null for all columns
     */
    public List<ByteBuffer> getColumns() {
      return this.columns;
    }

    /**
     * List of columns to return, null for all columns
     */
    public getRowsWithColumnsTs_args setColumns(List<ByteBuffer> columns) {
      this.columns = columns;
      return this;
    }

    public void unsetColumns() {
      this.columns = null;
    }

    /** Returns true if field columns is set (has been assigned a value) and false otherwise */
    public boolean isSetColumns() {
      return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
      if (!value) {
        this.columns = null;
      }
    }

    public long getTimestamp() {
      return this.timestamp;
    }

    public getRowsWithColumnsTs_args setTimestamp(long timestamp) {
      this.timestamp = timestamp;
      setTimestampIsSet(true);
      return this;
    }

    public void unsetTimestamp() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __TIMESTAMP_ISSET_ID);
    }

    /** Returns true if field timestamp is set (has been assigned a value) and false otherwise */
    public boolean isSetTimestamp() {
      return EncodingUtils.testBit(__isset_bitfield, __TIMESTAMP_ISSET_ID);
    }

    public void setTimestampIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __TIMESTAMP_ISSET_ID, value);
    }

    public int getAttributesSize() {
      return (this.attributes == null) ? 0 : this.attributes.size();
    }

    public void putToAttributes(ByteBuffer key, ByteBuffer val) {
      if (this.attributes == null) {
        this.attributes = new HashMap<ByteBuffer,ByteBuffer>();
      }
      this.attributes.put(key, val);
    }

    /**
     * Get attributes
     */
    public Map<ByteBuffer,ByteBuffer> getAttributes() {
      return this.attributes;
    }

    /**
     * Get attributes
     */
    public getRowsWithColumnsTs_args setAttributes(Map<ByteBuffer,ByteBuffer> attributes) {
      this.attributes = attributes;
      return this;
    }

    public void unsetAttributes() {
      this.attributes = null;
    }

    /** Returns true if field attributes is set (has been assigned a value) and false otherwise */
    public boolean isSetAttributes() {
      return this.attributes != null;
    }

    public void setAttributesIsSet(boolean value) {
      if (!value) {
        this.attributes = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((ByteBuffer)value);
        }
        break;

      case ROWS:
        if (value == null) {
          unsetRows();
        } else {
          setRows((List<ByteBuffer>)value);
        }
        break;

      case COLUMNS:
        if (value == null) {
          unsetColumns();
        } else {
          setColumns((List<ByteBuffer>)value);
        }
        break;

      case TIMESTAMP:
        if (value == null) {
          unsetTimestamp();
        } else {
          setTimestamp((Long)value);
        }
        break;

      case ATTRIBUTES:
        if (value == null) {
          unsetAttributes();
        } else {
          setAttributes((Map<ByteBuffer,ByteBuffer>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      case ROWS:
        return getRows();

      case COLUMNS:
        return getColumns();

      case TIMESTAMP:
        return Long.valueOf(getTimestamp());

      case ATTRIBUTES:
        return getAttributes();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      case ROWS:
        return isSetRows();
      case COLUMNS:
        return isSetColumns();
      case TIMESTAMP:
        return isSetTimestamp();
      case ATTRIBUTES:
        return isSetAttributes();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRowsWithColumnsTs_args)
        return this.equals((getRowsWithColumnsTs_args)that);
      return false;
    }

    public boolean equals(getRowsWithColumnsTs_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_rows = true && this.isSetRows();
      boolean that_present_rows = true && that.isSetRows();
      if (this_present_rows || that_present_rows) {
        if (!(this_present_rows && that_present_rows))
          return false;
        if (!this.rows.equals(that.rows))
          return false;
      }

      boolean this_present_columns = true && this.isSetColumns();
      boolean that_present_columns = true && that.isSetColumns();
      if (this_present_columns || that_present_columns) {
        if (!(this_present_columns && that_present_columns))
          return false;
        if (!this.columns.equals(that.columns))
          return false;
      }

      boolean this_present_timestamp = true;
      boolean that_present_timestamp = true;
      if (this_present_timestamp || that_present_timestamp) {
        if (!(this_present_timestamp && that_present_timestamp))
          return false;
        if (this.timestamp != that.timestamp)
          return false;
      }

      boolean this_present_attributes = true && this.isSetAttributes();
      boolean that_present_attributes = true && that.isSetAttributes();
      if (this_present_attributes || that_present_attributes) {
        if (!(this_present_attributes && that_present_attributes))
          return false;
        if (!this.attributes.equals(that.attributes))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_tableName = true && (isSetTableName());
      builder.append(present_tableName);
      if (present_tableName)
        builder.append(tableName);

      boolean present_rows = true && (isSetRows());
      builder.append(present_rows);
      if (present_rows)
        builder.append(rows);

      boolean present_columns = true && (isSetColumns());
      builder.append(present_columns);
      if (present_columns)
        builder.append(columns);

      boolean present_timestamp = true;
      builder.append(present_timestamp);
      if (present_timestamp)
        builder.append(timestamp);

      boolean present_attributes = true && (isSetAttributes());
      builder.append(present_attributes);
      if (present_attributes)
        builder.append(attributes);

      return builder.toHashCode();
    }

    public int compareTo(getRowsWithColumnsTs_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getRowsWithColumnsTs_args typedOther = (getRowsWithColumnsTs_args)other;

      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(typedOther.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, typedOther.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetRows()).compareTo(typedOther.isSetRows());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRows()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.rows, typedOther.rows);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetColumns()).compareTo(typedOther.isSetColumns());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumns()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.columns, typedOther.columns);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTimestamp()).compareTo(typedOther.isSetTimestamp());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTimestamp()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.timestamp, typedOther.timestamp);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetAttributes()).compareTo(typedOther.isSetAttributes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAttributes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.attributes, typedOther.attributes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getRowsWithColumnsTs_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("rows:");
      if (this.rows == null) {
        sb.append("null");
      } else {
        sb.append(this.rows);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("columns:");
      if (this.columns == null) {
        sb.append("null");
      } else {
        sb.append(this.columns);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("timestamp:");
      sb.append(this.timestamp);
      first = false;
      if (!first) sb.append(", ");
      sb.append("attributes:");
      if (this.attributes == null) {
        sb.append("null");
      } else {
        sb.append(this.attributes);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRowsWithColumnsTs_argsStandardSchemeFactory implements SchemeFactory {
      public getRowsWithColumnsTs_argsStandardScheme getScheme() {
        return new getRowsWithColumnsTs_argsStandardScheme();
      }
    }

    private static class getRowsWithColumnsTs_argsStandardScheme extends StandardScheme<getRowsWithColumnsTs_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRowsWithColumnsTs_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ROWS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list312 = iprot.readListBegin();
                  struct.rows = new ArrayList<ByteBuffer>(_list312.size);
                  for (int _i313 = 0; _i313 < _list312.size; ++_i313)
                  {
                    ByteBuffer _elem314; // required
                    _elem314 = iprot.readBinary();
                    struct.rows.add(_elem314);
                  }
                  iprot.readListEnd();
                }
                struct.setRowsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // COLUMNS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list315 = iprot.readListBegin();
                  struct.columns = new ArrayList<ByteBuffer>(_list315.size);
                  for (int _i316 = 0; _i316 < _list315.size; ++_i316)
                  {
                    ByteBuffer _elem317; // required
                    _elem317 = iprot.readBinary();
                    struct.columns.add(_elem317);
                  }
                  iprot.readListEnd();
                }
                struct.setColumnsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // TIMESTAMP
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.timestamp = iprot.readI64();
                struct.setTimestampIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // ATTRIBUTES
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map318 = iprot.readMapBegin();
                  struct.attributes = new HashMap<ByteBuffer,ByteBuffer>(2*_map318.size);
                  for (int _i319 = 0; _i319 < _map318.size; ++_i319)
                  {
                    ByteBuffer _key320; // required
                    ByteBuffer _val321; // required
                    _key320 = iprot.readBinary();
                    _val321 = iprot.readBinary();
                    struct.attributes.put(_key320, _val321);
                  }
                  iprot.readMapEnd();
                }
                struct.setAttributesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRowsWithColumnsTs_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        if (struct.rows != null) {
          oprot.writeFieldBegin(ROWS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.rows.size()));
            for (ByteBuffer _iter322 : struct.rows)
            {
              oprot.writeBinary(_iter322);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.columns != null) {
          oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.columns.size()));
            for (ByteBuffer _iter323 : struct.columns)
            {
              oprot.writeBinary(_iter323);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(TIMESTAMP_FIELD_DESC);
        oprot.writeI64(struct.timestamp);
        oprot.writeFieldEnd();
        if (struct.attributes != null) {
          oprot.writeFieldBegin(ATTRIBUTES_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, struct.attributes.size()));
            for (Map.Entry<ByteBuffer, ByteBuffer> _iter324 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter324.getKey());
              oprot.writeBinary(_iter324.getValue());
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRowsWithColumnsTs_argsTupleSchemeFactory implements SchemeFactory {
      public getRowsWithColumnsTs_argsTupleScheme getScheme() {
        return new getRowsWithColumnsTs_argsTupleScheme();
      }
    }

    private static class getRowsWithColumnsTs_argsTupleScheme extends TupleScheme<getRowsWithColumnsTs_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRowsWithColumnsTs_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        if (struct.isSetRows()) {
          optionals.set(1);
        }
        if (struct.isSetColumns()) {
          optionals.set(2);
        }
        if (struct.isSetTimestamp()) {
          optionals.set(3);
        }
        if (struct.isSetAttributes()) {
          optionals.set(4);
        }
        oprot.writeBitSet(optionals, 5);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
        if (struct.isSetRows()) {
          {
            oprot.writeI32(struct.rows.size());
            for (ByteBuffer _iter325 : struct.rows)
            {
              oprot.writeBinary(_iter325);
            }
          }
        }
        if (struct.isSetColumns()) {
          {
            oprot.writeI32(struct.columns.size());
            for (ByteBuffer _iter326 : struct.columns)
            {
              oprot.writeBinary(_iter326);
            }
          }
        }
        if (struct.isSetTimestamp()) {
          oprot.writeI64(struct.timestamp);
        }
        if (struct.isSetAttributes()) {
          {
            oprot.writeI32(struct.attributes.size());
            for (Map.Entry<ByteBuffer, ByteBuffer> _iter327 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter327.getKey());
              oprot.writeBinary(_iter327.getValue());
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRowsWithColumnsTs_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(5);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(1)) {
          {
            org.apache.thrift.protocol.TList _list328 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.rows = new ArrayList<ByteBuffer>(_list328.size);
            for (int _i329 = 0; _i329 < _list328.size; ++_i329)
            {
              ByteBuffer _elem330; // required
              _elem330 = iprot.readBinary();
              struct.rows.add(_elem330);
            }
          }
          struct.setRowsIsSet(true);
        }
        if (incoming.get(2)) {
          {
            org.apache.thrift.protocol.TList _list331 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.columns = new ArrayList<ByteBuffer>(_list331.size);
            for (int _i332 = 0; _i332 < _list331.size; ++_i332)
            {
              ByteBuffer _elem333; // required
              _elem333 = iprot.readBinary();
              struct.columns.add(_elem333);
            }
          }
          struct.setColumnsIsSet(true);
        }
        if (incoming.get(3)) {
          struct.timestamp = iprot.readI64();
          struct.setTimestampIsSet(true);
        }
        if (incoming.get(4)) {
          {
            org.apache.thrift.protocol.TMap _map334 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.attributes = new HashMap<ByteBuffer,ByteBuffer>(2*_map334.size);
            for (int _i335 = 0; _i335 < _map334.size; ++_i335)
            {
              ByteBuffer _key336; // required
              ByteBuffer _val337; // required
              _key336 = iprot.readBinary();
              _val337 = iprot.readBinary();
              struct.attributes.put(_key336, _val337);
            }
          }
          struct.setAttributesIsSet(true);
        }
      }
    }

  }

  public static class getRowsWithColumnsTs_result implements org.apache.thrift.TBase<getRowsWithColumnsTs_result, getRowsWithColumnsTs_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRowsWithColumnsTs_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getRowsWithColumnsTs_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getRowsWithColumnsTs_resultTupleSchemeFactory());
    }

    public List<TRowResult> success; // required
    public IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TRowResult.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRowsWithColumnsTs_result.class, metaDataMap);
    }

    public getRowsWithColumnsTs_result() {
    }

    public getRowsWithColumnsTs_result(
      List<TRowResult> success,
      IOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRowsWithColumnsTs_result(getRowsWithColumnsTs_result other) {
      if (other.isSetSuccess()) {
        List<TRowResult> __this__success = new ArrayList<TRowResult>();
        for (TRowResult other_element : other.success) {
          __this__success.add(new TRowResult(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public getRowsWithColumnsTs_result deepCopy() {
      return new getRowsWithColumnsTs_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<TRowResult> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TRowResult elem) {
      if (this.success == null) {
        this.success = new ArrayList<TRowResult>();
      }
      this.success.add(elem);
    }

    public List<TRowResult> getSuccess() {
      return this.success;
    }

    public getRowsWithColumnsTs_result setSuccess(List<TRowResult> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public IOError getIo() {
      return this.io;
    }

    public getRowsWithColumnsTs_result setIo(IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<TRowResult>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRowsWithColumnsTs_result)
        return this.equals((getRowsWithColumnsTs_result)that);
      return false;
    }

    public boolean equals(getRowsWithColumnsTs_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_io = true && (isSetIo());
      builder.append(present_io);
      if (present_io)
        builder.append(io);

      return builder.toHashCode();
    }

    public int compareTo(getRowsWithColumnsTs_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      getRowsWithColumnsTs_result typedOther = (getRowsWithColumnsTs_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIo()).compareTo(typedOther.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, typedOther.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getRowsWithColumnsTs_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRowsWithColumnsTs_resultStandardSchemeFactory implements SchemeFactory {
      public getRowsWithColumnsTs_resultStandardScheme getScheme() {
        return new getRowsWithColumnsTs_resultStandardScheme();
      }
    }

    private static class getRowsWithColumnsTs_resultStandardScheme extends StandardScheme<getRowsWithColumnsTs_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRowsWithColumnsTs_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list338 = iprot.readListBegin();
                  struct.success = new ArrayList<TRowResult>(_list338.size);
                  for (int _i339 = 0; _i339 < _list338.size; ++_i339)
                  {
                    TRowResult _elem340; // required
                    _elem340 = new TRowResult();
                    _elem340.read(iprot);
                    struct.success.add(_elem340);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRowsWithColumnsTs_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (TRowResult _iter341 : struct.success)
            {
              _iter341.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRowsWithColumnsTs_resultTupleSchemeFactory implements SchemeFactory {
      public getRowsWithColumnsTs_resultTupleScheme getScheme() {
        return new getRowsWithColumnsTs_resultTupleScheme();
      }
    }

    private static class getRowsWithColumnsTs_resultTupleScheme extends TupleScheme<getRowsWithColumnsTs_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRowsWithColumnsTs_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (TRowResult _iter342 : struct.success)
            {
              _iter342.write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRowsWithColumnsTs_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list343 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<TRowResult>(_list343.size);
            for (int _i344 = 0; _i344 < _list343.size; ++_i344)
            {
              TRowResult _elem345; // required
              _elem345 = new TRowResult();
              _elem345.read(iprot);
              struct.success.add(_elem345);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

  }

  public static class mutateRow_args implements org.apache.thrift.TBase<mutateRow_args, mutateRow_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("mutateRow_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField ROW_FIELD_DESC = new org.apache.thrift.protocol.TField("row", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField MUTATIONS_FIELD_DESC = new org.apache.thrift.protocol.TField("mutations", org.apache.thrift.protocol.TType.LIST, (short)3);
    private static final org.apache.thrift.protocol.TField ATTRIBUTES_FIELD_DESC = new org.apache.thrift.protocol.TField("attributes", org.apache.thrift.protocol.TType.MAP, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new mutateRow_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new mutateRow_argsTupleSchemeFactory());
    }

    /**
     * name of table
     */
    public ByteBuffer tableName; // required
    /**
     * row key
     */
    public ByteBuffer row; // required
    /**
     * list of mutation commands
     */
    public List<Mutation> mutations; // required
    /**
     * Mutation attributes
     */
    public Map<ByteBuffer,ByteBuffer> attributes; // required

    /** The set of fields this struct