/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.thrift.ThriftMetrics;
import org.apache.hadoop.hbase.thrift2.ThriftUtilities;
import org.apache.hadoop.hbase.thrift2.generated.TAppend;
import org.apache.hadoop.hbase.thrift2.generated.TCompareOp;
import org.apache.hadoop.hbase.thrift2.generated.TDelete;
import org.apache.hadoop.hbase.thrift2.generated.TGet;
import org.apache.hadoop.hbase.thrift2.generated.THBaseService;
import org.apache.hadoop.hbase.thrift2.generated.THRegionLocation;
import org.apache.hadoop.hbase.thrift2.generated.TIOError;
import org.apache.hadoop.hbase.thrift2.generated.TIllegalArgument;
import org.apache.hadoop.hbase.thrift2.generated.TIncrement;
import org.apache.hadoop.hbase.thrift2.generated.TPut;
import org.apache.hadoop.hbase.thrift2.generated.TResult;
import org.apache.hadoop.hbase.thrift2.generated.TRowMutations;
import org.apache.hadoop.hbase.thrift2.generated.TScan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConnectionCache;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ThriftHBaseServiceHandler
implements THBaseService.Iface {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftHBaseServiceHandler.class);
    private final AtomicInteger nextScannerId = new AtomicInteger(0);
    private final Map<Integer, ResultScanner> scannerMap = new ConcurrentHashMap<Integer, ResultScanner>();
    private final ConnectionCache connectionCache;
    static final String CLEANUP_INTERVAL = "hbase.thrift.connection.cleanup-interval";
    static final String MAX_IDLETIME = "hbase.thrift.connection.max-idletime";
    private static final IOException ioe = new DoNotRetryIOException("Thrift Server is in Read-only mode.");
    private boolean isReadOnly;

    public static THBaseService.Iface newInstance(THBaseService.Iface handler, ThriftMetrics metrics) {
        return (THBaseService.Iface)Proxy.newProxyInstance(handler.getClass().getClassLoader(), new Class[]{THBaseService.Iface.class}, (InvocationHandler)new THBaseServiceMetricsProxy(handler, metrics));
    }

    private static long now() {
        return System.nanoTime();
    }

    ThriftHBaseServiceHandler(Configuration conf, UserProvider userProvider) throws IOException {
        int cleanInterval = conf.getInt(CLEANUP_INTERVAL, 10000);
        int maxIdleTime = conf.getInt(MAX_IDLETIME, 600000);
        this.connectionCache = new ConnectionCache(conf, userProvider, cleanInterval, maxIdleTime);
        this.isReadOnly = conf.getBoolean("hbase.thrift.readonly", false);
    }

    private Table getTable(ByteBuffer tableName) {
        try {
            return this.connectionCache.getTable(Bytes.toString((byte[])TBaseHelper.byteBufferToByteArray((ByteBuffer)tableName)));
        }
        catch (IOException ie) {
            throw new RuntimeException(ie);
        }
    }

    private RegionLocator getLocator(ByteBuffer tableName) {
        try {
            return this.connectionCache.getRegionLocator(TBaseHelper.byteBufferToByteArray((ByteBuffer)tableName));
        }
        catch (IOException ie) {
            throw new RuntimeException(ie);
        }
    }

    private void closeTable(Table table) throws TIOError {
        try {
            table.close();
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    private TIOError getTIOError(IOException e) {
        TIOErrorWithCause err = new TIOErrorWithCause(e);
        err.setMessage(e.getMessage());
        return err;
    }

    private int addScanner(ResultScanner scanner) {
        int id = this.nextScannerId.getAndIncrement();
        this.scannerMap.put(id, scanner);
        return id;
    }

    private ResultScanner getScanner(int id) {
        return this.scannerMap.get(id);
    }

    void setEffectiveUser(String effectiveUser) {
        this.connectionCache.setEffectiveUser(effectiveUser);
    }

    protected ResultScanner removeScanner(int id) {
        return this.scannerMap.remove(id);
    }

    @Override
    public boolean exists(ByteBuffer table, TGet get2) throws TIOError, TException {
        Table htable = this.getTable(table);
        try {
            boolean bl = htable.exists(ThriftUtilities.getFromThrift(get2));
            return bl;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public List<Boolean> existsAll(ByteBuffer table, List<TGet> gets) throws TIOError, TException {
        Table htable = this.getTable(table);
        try {
            boolean[] exists2 = htable.existsAll(ThriftUtilities.getsFromThrift(gets));
            ArrayList<Boolean> result = new ArrayList<Boolean>(exists2.length);
            for (boolean exist : exists2) {
                result.add(exist);
            }
            ArrayList<Boolean> arrayList = result;
            return arrayList;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public TResult get(ByteBuffer table, TGet get2) throws TIOError, TException {
        Table htable = this.getTable(table);
        try {
            TResult tResult = ThriftUtilities.resultFromHBase(htable.get(ThriftUtilities.getFromThrift(get2)));
            return tResult;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public List<TResult> getMultiple(ByteBuffer table, List<TGet> gets) throws TIOError, TException {
        Table htable = this.getTable(table);
        try {
            List<TResult> list = ThriftUtilities.resultsFromHBase(htable.get(ThriftUtilities.getsFromThrift(gets)));
            return list;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public void put(ByteBuffer table, TPut put2) throws TIOError, TException {
        this.checkReadOnlyMode();
        Table htable = this.getTable(table);
        try {
            htable.put(ThriftUtilities.putFromThrift(put2));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public boolean checkAndPut(ByteBuffer table, ByteBuffer row, ByteBuffer family, ByteBuffer qualifier, ByteBuffer value, TPut put2) throws TIOError, TException {
        this.checkReadOnlyMode();
        Table htable = this.getTable(table);
        try {
            Table.CheckAndMutateBuilder builder = htable.checkAndMutate(TBaseHelper.byteBufferToByteArray((ByteBuffer)row), TBaseHelper.byteBufferToByteArray((ByteBuffer)family)).qualifier(TBaseHelper.byteBufferToByteArray((ByteBuffer)qualifier));
            if (value == null) {
                boolean bl = builder.ifNotExists().thenPut(ThriftUtilities.putFromThrift(put2));
                return bl;
            }
            boolean bl = builder.ifEquals(TBaseHelper.byteBufferToByteArray((ByteBuffer)value)).thenPut(ThriftUtilities.putFromThrift(put2));
            return bl;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public void putMultiple(ByteBuffer table, List<TPut> puts) throws TIOError, TException {
        this.checkReadOnlyMode();
        Table htable = this.getTable(table);
        try {
            htable.put(ThriftUtilities.putsFromThrift(puts));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public void deleteSingle(ByteBuffer table, TDelete deleteSingle2) throws TIOError, TException {
        this.checkReadOnlyMode();
        Table htable = this.getTable(table);
        try {
            htable.delete(ThriftUtilities.deleteFromThrift(deleteSingle2));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public List<TDelete> deleteMultiple(ByteBuffer table, List<TDelete> deletes) throws TIOError, TException {
        this.checkReadOnlyMode();
        Table htable = this.getTable(table);
        try {
            htable.delete(ThriftUtilities.deletesFromThrift(deletes));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkAndMutate(ByteBuffer table, ByteBuffer row, ByteBuffer family, ByteBuffer qualifier, TCompareOp compareOp, ByteBuffer value, TRowMutations rowMutations) throws TIOError, TException {
        this.checkReadOnlyMode();
        try (Table htable = this.getTable(table);){
            boolean bl = htable.checkAndMutate(TBaseHelper.byteBufferToByteArray((ByteBuffer)row), TBaseHelper.byteBufferToByteArray((ByteBuffer)family)).qualifier(TBaseHelper.byteBufferToByteArray((ByteBuffer)qualifier)).ifMatches(ThriftUtilities.compareOpFromThrift(compareOp), TBaseHelper.byteBufferToByteArray((ByteBuffer)value)).thenMutate(ThriftUtilities.rowMutationsFromThrift(rowMutations));
            return bl;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public boolean checkAndDelete(ByteBuffer table, ByteBuffer row, ByteBuffer family, ByteBuffer qualifier, ByteBuffer value, TDelete deleteSingle2) throws TIOError, TException {
        this.checkReadOnlyMode();
        Table htable = this.getTable(table);
        try {
            Table.CheckAndMutateBuilder mutateBuilder = htable.checkAndMutate(TBaseHelper.byteBufferToByteArray((ByteBuffer)row), TBaseHelper.byteBufferToByteArray((ByteBuffer)family)).qualifier(TBaseHelper.byteBufferToByteArray((ByteBuffer)qualifier));
            if (value == null) {
                boolean bl = mutateBuilder.ifNotExists().thenDelete(ThriftUtilities.deleteFromThrift(deleteSingle2));
                return bl;
            }
            boolean bl = mutateBuilder.ifEquals(TBaseHelper.byteBufferToByteArray((ByteBuffer)value)).thenDelete(ThriftUtilities.deleteFromThrift(deleteSingle2));
            return bl;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public TResult increment(ByteBuffer table, TIncrement increment2) throws TIOError, TException {
        this.checkReadOnlyMode();
        Table htable = this.getTable(table);
        try {
            TResult tResult = ThriftUtilities.resultFromHBase(htable.increment(ThriftUtilities.incrementFromThrift(increment2)));
            return tResult;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public TResult append(ByteBuffer table, TAppend append2) throws TIOError, TException {
        this.checkReadOnlyMode();
        Table htable = this.getTable(table);
        try {
            TResult tResult = ThriftUtilities.resultFromHBase(htable.append(ThriftUtilities.appendFromThrift(append2)));
            return tResult;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public int openScanner(ByteBuffer table, TScan scan) throws TIOError, TException {
        Table htable = this.getTable(table);
        ResultScanner resultScanner = null;
        try {
            resultScanner = htable.getScanner(ThriftUtilities.scanFromThrift(scan));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
        return this.addScanner(resultScanner);
    }

    @Override
    public List<TResult> getScannerRows(int scannerId, int numRows) throws TIOError, TIllegalArgument, TException {
        ResultScanner scanner = this.getScanner(scannerId);
        if (scanner == null) {
            TIllegalArgument ex = new TIllegalArgument();
            ex.setMessage("Invalid scanner Id");
            throw ex;
        }
        try {
            this.connectionCache.updateConnectionAccessTime();
            return ThriftUtilities.resultsFromHBase(scanner.next(numRows));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public List<TResult> getScannerResults(ByteBuffer table, TScan scan, int numRows) throws TIOError, TException {
        Table htable = this.getTable(table);
        List<TResult> results = null;
        ResultScanner scanner = null;
        try {
            scanner = htable.getScanner(ThriftUtilities.scanFromThrift(scan));
            results = ThriftUtilities.resultsFromHBase(scanner.next(numRows));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
            this.closeTable(htable);
        }
        return results;
    }

    @Override
    public void closeScanner(int scannerId) throws TIOError, TIllegalArgument, TException {
        LOG.debug("scannerClose: id=" + scannerId);
        ResultScanner scanner = this.getScanner(scannerId);
        if (scanner == null) {
            String message = "scanner ID is invalid";
            LOG.warn(message);
            TIllegalArgument ex = new TIllegalArgument();
            ex.setMessage("Invalid scanner Id");
            throw ex;
        }
        scanner.close();
        this.removeScanner(scannerId);
    }

    @Override
    public void mutateRow(ByteBuffer table, TRowMutations rowMutations) throws TIOError, TException {
        this.checkReadOnlyMode();
        Table htable = this.getTable(table);
        try {
            htable.mutateRow(ThriftUtilities.rowMutationsFromThrift(rowMutations));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public List<THRegionLocation> getAllRegionLocations(ByteBuffer table) throws TIOError, TException {
        RegionLocator locator = null;
        try {
            locator = this.getLocator(table);
            List<THRegionLocation> list = ThriftUtilities.regionLocationsFromHBase(locator.getAllRegionLocations());
            return list;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            if (locator != null) {
                try {
                    locator.close();
                }
                catch (IOException e) {
                    LOG.warn("Couldn't close the locator.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public THRegionLocation getRegionLocation(ByteBuffer table, ByteBuffer row, boolean reload) throws TIOError, TException {
        RegionLocator locator = null;
        try {
            locator = this.getLocator(table);
            byte[] rowBytes = TBaseHelper.byteBufferToByteArray((ByteBuffer)row);
            HRegionLocation hrl = locator.getRegionLocation(rowBytes, reload);
            THRegionLocation tHRegionLocation = ThriftUtilities.regionLocationFromHBase(hrl);
            return tHRegionLocation;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            if (locator != null) {
                try {
                    locator.close();
                }
                catch (IOException e) {
                    LOG.warn("Couldn't close the locator.", (Throwable)e);
                }
            }
        }
    }

    private void checkReadOnlyMode() throws TIOError {
        if (this.isReadOnly()) {
            throw this.getTIOError(ioe);
        }
    }

    private boolean isReadOnly() {
        return this.isReadOnly;
    }

    private static class TIOErrorWithCause
    extends TIOError {
        private Throwable cause;

        public TIOErrorWithCause(Throwable cause) {
            this.cause = cause;
        }

        public synchronized Throwable getCause() {
            return this.cause;
        }

        @Override
        public boolean equals(Object other) {
            if (super.equals(other) && other instanceof TIOErrorWithCause) {
                Throwable otherCause = ((TIOErrorWithCause)other).getCause();
                if (this.getCause() != null) {
                    return otherCause != null && this.getCause().equals(otherCause);
                }
                return otherCause == null;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.cause != null ? this.cause.hashCode() : 0);
            return result;
        }
    }

    private static final class THBaseServiceMetricsProxy
    implements InvocationHandler {
        private final THBaseService.Iface handler;
        private final ThriftMetrics metrics;

        private THBaseServiceMetricsProxy(THBaseService.Iface handler, ThriftMetrics metrics) {
            this.handler = handler;
            this.metrics = metrics;
        }

        @Override
        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            Object result;
            long start = ThriftHBaseServiceHandler.now();
            try {
                result = m.invoke((Object)this.handler, args);
            }
            catch (InvocationTargetException e) {
                this.metrics.exception(e.getCause());
                throw e.getTargetException();
            }
            catch (Exception e) {
                this.metrics.exception(e);
                throw new RuntimeException("unexpected invocation exception: " + e.getMessage());
            }
            finally {
                long processTime = ThriftHBaseServiceHandler.now() - start;
                this.metrics.incMethodTime(m.getName(), processTime);
            }
            return result;
        }
    }
}

