/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Base64;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.SecurityUtil;
import org.apache.hadoop.hbase.thrift.HBaseServiceHandler;
import org.apache.hadoop.hbase.thrift.HttpAuthenticationException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServlet;
import org.apache.yetus.audience.InterfaceAudience;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ThriftHttpServlet
extends TServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)ThriftHttpServlet.class.getName());
    private final transient UserGroupInformation serviceUGI;
    private final transient UserGroupInformation httpUGI;
    private final transient HBaseServiceHandler handler;
    private final boolean doAsEnabled;
    private final boolean securityEnabled;
    public static final String NEGOTIATE = "Negotiate";

    public ThriftHttpServlet(TProcessor processor, TProtocolFactory protocolFactory, UserGroupInformation serviceUGI, Configuration conf, HBaseServiceHandler handler, boolean securityEnabled, boolean doAsEnabled) throws IOException {
        super(processor, protocolFactory);
        this.serviceUGI = serviceUGI;
        this.handler = handler;
        this.securityEnabled = securityEnabled;
        this.doAsEnabled = doAsEnabled;
        if (securityEnabled) {
            UserGroupInformation.setConfiguration((Configuration)conf);
            this.httpUGI = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)conf.get("hbase.thrift.spnego.principal"), (String)conf.get("hbase.thrift.spnego.keytab.file"));
        } else {
            this.httpUGI = null;
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String doAsUserFromQuery;
        String effectiveUser = request.getRemoteUser();
        if (this.securityEnabled) {
            String authHeader = request.getHeader("Authorization");
            if (authHeader == null || authHeader.isEmpty()) {
                response.addHeader("WWW-Authenticate", NEGOTIATE);
                response.sendError(401);
                return;
            }
            try {
                RemoteUserIdentity identity = this.doKerberosAuth(request);
                effectiveUser = identity.principal;
                response.addHeader("WWW-Authenticate", "Negotiate " + identity.outToken);
            }
            catch (HttpAuthenticationException e) {
                LOG.error("Kerberos Authentication failed", (Throwable)e);
                response.addHeader("WWW-Authenticate", NEGOTIATE);
                response.sendError(401, "Authentication Error: " + e.getMessage());
                return;
            }
        }
        if (effectiveUser == null) {
            effectiveUser = this.serviceUGI.getShortUserName();
        }
        if ((doAsUserFromQuery = request.getHeader("doAs")) != null) {
            if (!this.doAsEnabled) {
                throw new ServletException("Support for proxyuser is not configured");
            }
            UserGroupInformation remoteUser = UserGroupInformation.createRemoteUser((String)effectiveUser);
            UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)doAsUserFromQuery, (UserGroupInformation)remoteUser);
            try {
                ProxyUsers.authorize((UserGroupInformation)ugi, (String)request.getRemoteAddr());
            }
            catch (AuthorizationException e) {
                throw new ServletException((Throwable)e);
            }
            effectiveUser = doAsUserFromQuery;
        }
        this.handler.setEffectiveUser(effectiveUser);
        super.doPost(request, response);
    }

    private RemoteUserIdentity doKerberosAuth(HttpServletRequest request) throws HttpAuthenticationException {
        HttpKerberosServerAction action = new HttpKerberosServerAction(request, this.httpUGI);
        try {
            String principal = (String)this.httpUGI.doAs((PrivilegedExceptionAction)action);
            return new RemoteUserIdentity(principal, action.outToken);
        }
        catch (Exception e) {
            LOG.info("Failed to authenticate with {} kerberos principal", (Object)this.httpUGI.getUserName());
            throw new HttpAuthenticationException(e);
        }
    }

    private static class HttpKerberosServerAction
    implements PrivilegedExceptionAction<String> {
        final HttpServletRequest request;
        final UserGroupInformation httpUGI;
        String outToken = null;

        HttpKerberosServerAction(HttpServletRequest request, UserGroupInformation httpUGI) {
            this.request = request;
            this.httpUGI = httpUGI;
        }

        @Override
        public String run() throws HttpAuthenticationException {
            GSSManager manager = GSSManager.getInstance();
            GSSContext gssContext = null;
            String serverPrincipal = SecurityUtil.getPrincipalWithoutRealm((String)this.httpUGI.getUserName());
            try {
                Oid kerberosMechOid = new Oid("1.2.840.113554.1.2.2");
                Oid spnegoMechOid = new Oid("1.3.6.1.5.5.2");
                Oid krb5PrincipalOid = new Oid("1.2.840.113554.1.2.2.1");
                GSSName serverName = manager.createName(serverPrincipal, krb5PrincipalOid);
                GSSCredential serverCreds = manager.createCredential(serverName, 0, new Oid[]{kerberosMechOid, spnegoMechOid}, 2);
                gssContext = manager.createContext(serverCreds);
                String serviceTicketBase64 = this.getAuthHeader(this.request);
                byte[] inToken = Base64.getDecoder().decode(serviceTicketBase64);
                byte[] res = gssContext.acceptSecContext(inToken, 0, inToken.length);
                if (res != null) {
                    this.outToken = Base64.getEncoder().encodeToString(res).replace("\n", "");
                }
                if (!gssContext.isEstablished()) {
                    throw new HttpAuthenticationException("Kerberos authentication failed: unable to establish context with the service ticket provided by the client.");
                }
                String string = SecurityUtil.getUserFromPrincipal((String)gssContext.getSrcName().toString());
                return string;
            }
            catch (GSSException e) {
                throw new HttpAuthenticationException("Kerberos authentication failed: ", e);
            }
            finally {
                if (gssContext != null) {
                    try {
                        gssContext.dispose();
                    }
                    catch (GSSException e) {
                        LOG.warn("Error while disposing GSS Context", (Throwable)e);
                    }
                }
            }
        }

        private String getAuthHeader(HttpServletRequest request) throws HttpAuthenticationException {
            String authHeader = request.getHeader("Authorization");
            if (authHeader == null || authHeader.isEmpty()) {
                throw new HttpAuthenticationException("Authorization header received from the client is empty.");
            }
            int beginIndex = "Negotiate ".length();
            String authHeaderBase64String = authHeader.substring(beginIndex);
            if (authHeaderBase64String.isEmpty()) {
                throw new HttpAuthenticationException("Authorization header received from the client does not contain any data.");
            }
            return authHeaderBase64String;
        }
    }

    private static class RemoteUserIdentity {
        final String outToken;
        final String principal;

        RemoteUserIdentity(String principal, String outToken) {
            this.principal = principal;
            this.outToken = outToken;
        }
    }
}

