/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseZKTestingUtility;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ZKTests;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ZKTests.class, MediumTests.class})
public class TestHQuorumPeer {
    private static final HBaseZKTestingUtility TEST_UTIL = new HBaseZKTestingUtility();
    private static int PORT_NO = 21818;
    private Path dataDir;

    @Before
    public void setup() throws IOException {
        TEST_UTIL.getConfiguration().setInt("hbase.zookeeper.property.clientPort", PORT_NO);
        this.dataDir = TEST_UTIL.getDataTestDir(this.getClass().getName());
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        if (fs.exists(this.dataDir) && !fs.delete(this.dataDir, true)) {
            throw new IOException("Failed cleanup of " + this.dataDir);
        }
        if (!fs.mkdirs(this.dataDir)) {
            throw new IOException("Failed create of " + this.dataDir);
        }
    }

    @Test
    public void testMakeZKProps() {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.set("hbase.zookeeper.property.dataDir", this.dataDir.toString());
        Properties properties = ZKConfig.makeZKProps((Configuration)conf);
        Assert.assertEquals((Object)this.dataDir.toString(), (Object)((String)properties.get("dataDir")));
        Assert.assertEquals((Object)PORT_NO, (Object)Integer.valueOf(properties.getProperty("clientPort")));
        Assert.assertEquals((Object)"localhost:2888:3888", (Object)properties.get("server.0"));
        Assert.assertEquals(null, (Object)properties.get("server.1"));
        String oldValue = conf.get("hbase.zookeeper.quorum");
        conf.set("hbase.zookeeper.quorum", "a.foo.bar,b.foo.bar,c.foo.bar");
        properties = ZKConfig.makeZKProps((Configuration)conf);
        Assert.assertEquals((Object)this.dataDir.toString(), (Object)properties.get("dataDir"));
        Assert.assertEquals((Object)PORT_NO, (Object)Integer.valueOf(properties.getProperty("clientPort")));
        Assert.assertEquals((Object)"a.foo.bar:2888:3888", (Object)properties.get("server.0"));
        Assert.assertEquals((Object)"b.foo.bar:2888:3888", (Object)properties.get("server.1"));
        Assert.assertEquals((Object)"c.foo.bar:2888:3888", (Object)properties.get("server.2"));
        Assert.assertEquals(null, (Object)properties.get("server.3"));
        conf.set("hbase.zookeeper.quorum", oldValue);
    }

    @Test
    public void testShouldAssignDefaultZookeeperClientPort() {
        Configuration config = HBaseConfiguration.create();
        config.clear();
        Properties p = ZKConfig.makeZKProps((Configuration)config);
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)2181, (Object)p.get("clientPort"));
    }

    @Test
    public void testGetZKQuorumServersString() {
        Configuration config = new Configuration(TEST_UTIL.getConfiguration());
        config.setInt("hbase.zookeeper.property.clientPort", 8888);
        config.set("hbase.zookeeper.quorum", "foo:1234,bar:5678,baz,qux:9012");
        String s = ZKConfig.getZKQuorumServersString((Configuration)config);
        Assert.assertEquals((Object)"foo:1234,bar:5678,baz:8888,qux:9012", (Object)s);
    }
}

