/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseZKTestingUtility;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ZKTests;
import org.apache.hadoop.hbase.zookeeper.ReadOnlyZKClient;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperHelper;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ZKTests.class, MediumTests.class})
public class TestReadOnlyZKClient {
    private static HBaseZKTestingUtility UTIL = new HBaseZKTestingUtility();
    private static int PORT;
    private static String PATH;
    private static byte[] DATA;
    private static int CHILDREN;
    private static ReadOnlyZKClient RO_ZK;

    @BeforeClass
    public static void setUp() throws Exception {
        PORT = UTIL.startMiniZKCluster().getClientPort();
        ZooKeeper zk = ZooKeeperHelper.getConnectedZooKeeper((String)("localhost:" + PORT), (int)10000);
        DATA = new byte[10];
        ThreadLocalRandom.current().nextBytes(DATA);
        zk.create(PATH, DATA, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        for (int i = 0; i < CHILDREN; ++i) {
            zk.create(PATH + "/c" + i, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        zk.close();
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.zookeeper.quorum", "localhost:" + PORT);
        conf.setInt("zookeeper.recovery.retry", 3);
        conf.setInt("zookeeper.recovery.retry.intervalmill", 100);
        conf.setInt("zookeeper.keep-alive.time", 3000);
        RO_ZK = new ReadOnlyZKClient(conf);
        Assert.assertNull((Object)RO_ZK.getZooKeeper());
    }

    @AfterClass
    public static void tearDown() throws IOException {
        RO_ZK.close();
        UTIL.shutdownMiniZKCluster();
        UTIL.cleanupTestDir();
    }

    @Test
    public void testGetAndExists() throws Exception {
        Assert.assertArrayEquals((byte[])DATA, (byte[])((byte[])RO_ZK.get(PATH).get()));
        Assert.assertEquals((long)CHILDREN, (long)((Stat)RO_ZK.exists(PATH).get()).getNumChildren());
        Assert.assertNotNull((Object)RO_ZK.getZooKeeper());
        UTIL.waitFor(10000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                return RO_ZK.getZooKeeper() == null;
            }

            public String explainFailure() throws Exception {
                return "Connection to zookeeper is still alive";
            }
        });
    }

    @Test
    public void testNoNode() throws InterruptedException, ExecutionException {
        String pathNotExists = PATH + "_whatever";
        try {
            RO_ZK.get(pathNotExists).get();
            Assert.fail((String)("should fail because of " + pathNotExists + " does not exist"));
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(KeeperException.class));
            KeeperException ke = (KeeperException)e.getCause();
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)ke.code());
            Assert.assertEquals((Object)pathNotExists, (Object)ke.getPath());
        }
        Assert.assertNull(RO_ZK.exists(pathNotExists).get());
    }

    @Test
    public void testSessionExpire() throws Exception {
        Assert.assertArrayEquals((byte[])DATA, (byte[])((byte[])RO_ZK.get(PATH).get()));
        ZooKeeper zk = RO_ZK.getZooKeeper();
        long sessionId = zk.getSessionId();
        ((ZooKeeperServer)UTIL.getZkCluster().getZooKeeperServers().get(0)).closeSession(sessionId);
        Assert.assertSame((Object)zk, (Object)RO_ZK.getZooKeeper());
        byte[] got = (byte[])RO_ZK.get(PATH).get();
        Assert.assertArrayEquals((byte[])DATA, (byte[])got);
        Assert.assertNotNull((Object)RO_ZK.getZooKeeper());
        Assert.assertNotSame((Object)zk, (Object)RO_ZK.getZooKeeper());
        Assert.assertNotEquals((long)sessionId, (long)RO_ZK.getZooKeeper().getSessionId());
    }

    static {
        PATH = "/test";
        CHILDREN = 5;
    }
}

