/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseZKTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ZKTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKListener;
import org.apache.hadoop.hbase.zookeeper.ZKNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperHelper;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ZKTests.class, MediumTests.class})
public class TestZKNodeTracker {
    private static final Logger LOG = LoggerFactory.getLogger(TestZKNodeTracker.class);
    private static final HBaseZKTestingUtility TEST_UTIL = new HBaseZKTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testInterruptible() throws IOException, InterruptedException {
        StubAbortable abortable = new StubAbortable();
        ZKWatcher zk = new ZKWatcher(TEST_UTIL.getConfiguration(), "testInterruptible", (Abortable)abortable);
        final TestTracker tracker = new TestTracker(zk, "/xyz", abortable);
        tracker.start();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    tracker.blockUntilAvailable();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted", e);
                }
            }
        };
        t.start();
        while (!t.isAlive()) {
            Threads.sleep((long)1L);
        }
        tracker.stop();
        t.join();
    }

    @Test
    public void testNodeTracker() throws Exception {
        StubAbortable abortable = new StubAbortable();
        ZKWatcher zk = new ZKWatcher(TEST_UTIL.getConfiguration(), "testNodeTracker", (Abortable)abortable);
        ZKUtil.createAndFailSilent((ZKWatcher)zk, (String)zk.znodePaths.baseZNode);
        String node = ZNodePaths.joinZNode((String)zk.znodePaths.baseZNode, (String)Long.toString(ThreadLocalRandom.current().nextLong()));
        byte[] dataOne = Bytes.toBytes((String)"dataOne");
        byte[] dataTwo = Bytes.toBytes((String)"dataTwo");
        TestTracker localTracker = new TestTracker(zk, node, abortable);
        localTracker.start();
        zk.registerListener((ZKListener)localTracker);
        Assert.assertNull((Object)localTracker.getData(false));
        WaitToGetDataThread thread = new WaitToGetDataThread(zk, node);
        thread.start();
        Assert.assertFalse((boolean)thread.hasData);
        TestTracker secondTracker = new TestTracker(zk, node, null);
        secondTracker.start();
        zk.registerListener((ZKListener)secondTracker);
        TestingZKListener zkListener = new TestingZKListener(zk, node);
        zk.registerListener((ZKListener)zkListener);
        Assert.assertEquals((long)0L, (long)zkListener.createdLock.availablePermits());
        ZooKeeper zkconn = ZooKeeperHelper.getConnectedZooKeeper((String)ZKConfig.getZKQuorumServersString((Configuration)TEST_UTIL.getConfiguration()), (int)60000);
        zkconn.create(node, dataOne, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zkListener.waitForCreation();
        thread.join();
        Assert.assertNotNull((Object)localTracker.getData(false));
        Assert.assertNotNull((Object)localTracker.blockUntilAvailable());
        Assert.assertTrue((boolean)Bytes.equals((byte[])localTracker.getData(false), (byte[])dataOne));
        Assert.assertTrue((boolean)thread.hasData);
        Assert.assertTrue((boolean)Bytes.equals((byte[])thread.tracker.getData(false), (byte[])dataOne));
        LOG.info("Successfully got data one");
        Assert.assertNotNull((Object)secondTracker.getData(false));
        Assert.assertNotNull((Object)secondTracker.blockUntilAvailable());
        Assert.assertTrue((boolean)Bytes.equals((byte[])secondTracker.getData(false), (byte[])dataOne));
        LOG.info("Successfully got data one with the second tracker");
        zkconn.delete(node, -1);
        zkListener.waitForDeletion();
        TestTracker threadTracker = thread.tracker;
        thread = new WaitToGetDataThread(zk, node, threadTracker);
        thread.start();
        Assert.assertFalse((boolean)thread.hasData);
        Assert.assertNull((Object)secondTracker.getData(false));
        Assert.assertNull((Object)localTracker.getData(false));
        LOG.info("Successfully made unavailable");
        zkconn.create(node, dataTwo, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zkListener.waitForCreation();
        thread.join();
        Assert.assertNotNull((Object)localTracker.getData(false));
        Assert.assertNotNull((Object)localTracker.blockUntilAvailable());
        Assert.assertTrue((boolean)Bytes.equals((byte[])localTracker.getData(false), (byte[])dataTwo));
        Assert.assertNotNull((Object)secondTracker.getData(false));
        Assert.assertNotNull((Object)secondTracker.blockUntilAvailable());
        Assert.assertTrue((boolean)Bytes.equals((byte[])secondTracker.getData(false), (byte[])dataTwo));
        Assert.assertTrue((boolean)thread.hasData);
        Assert.assertTrue((boolean)Bytes.equals((byte[])thread.tracker.getData(false), (byte[])dataTwo));
        LOG.info("Successfully got data two on all trackers and threads");
        zkconn.setData(node, dataOne, -1);
        zkListener.waitForDataChange();
        Assert.assertNotNull((Object)localTracker.getData(false));
        Assert.assertNotNull((Object)localTracker.blockUntilAvailable());
        Assert.assertTrue((boolean)Bytes.equals((byte[])localTracker.getData(false), (byte[])dataOne));
        Assert.assertNotNull((Object)secondTracker.getData(false));
        Assert.assertNotNull((Object)secondTracker.blockUntilAvailable());
        Assert.assertTrue((boolean)Bytes.equals((byte[])secondTracker.getData(false), (byte[])dataOne));
        Assert.assertTrue((boolean)thread.hasData);
        Assert.assertTrue((boolean)Bytes.equals((byte[])thread.tracker.getData(false), (byte[])dataOne));
        LOG.info("Successfully got data one following a data change on all trackers and threads");
    }

    @Test
    public void testCleanZNode() throws Exception {
        ZKWatcher zkw = new ZKWatcher(TEST_UTIL.getConfiguration(), "testNodeTracker", (Abortable)new StubAbortable());
        ServerName sn = ServerName.valueOf((String)"127.0.0.1:52", (long)45L);
        ZKUtil.createAndFailSilent((ZKWatcher)zkw, (String)TEST_UTIL.getConfiguration().get("zookeeper.znode.parent", "/hbase"));
        String nodeName = zkw.znodePaths.masterAddressZNode;
        ZKUtil.createAndFailSilent((ZKWatcher)zkw, (String)nodeName);
        MasterAddressTracker.deleteIfEquals((ZKWatcher)zkw, (String)sn.toString());
        Assert.assertNotNull((Object)ZKUtil.getData((ZKWatcher)zkw, (String)nodeName));
        ZKUtil.setData((ZKWatcher)zkw, (String)nodeName, (byte[])MasterAddressTracker.toByteArray((ServerName)sn, (int)0));
        MasterAddressTracker.deleteIfEquals((ZKWatcher)zkw, (String)ServerName.valueOf((String)"127.0.0.2:52", (long)45L).toString());
        Assert.assertNotNull((Object)ZKUtil.getData((ZKWatcher)zkw, (String)nodeName));
        ZKUtil.setData((ZKWatcher)zkw, (String)nodeName, (byte[])MasterAddressTracker.toByteArray((ServerName)sn, (int)0));
        MasterAddressTracker.deleteIfEquals((ZKWatcher)zkw, (String)sn.toString());
        Assert.assertNull((Object)ZKUtil.getData((ZKWatcher)zkw, (String)nodeName));
        MasterAddressTracker.deleteIfEquals((ZKWatcher)zkw, (String)sn.toString());
    }

    public static class StubAbortable
    implements Abortable {
        public void abort(String msg, Throwable t) {
        }

        public boolean isAborted() {
            return false;
        }
    }

    public static class TestingZKListener
    extends ZKListener {
        private static final Logger LOG = LoggerFactory.getLogger(TestingZKListener.class);
        private Semaphore deletedLock = new Semaphore(0);
        private Semaphore createdLock = new Semaphore(0);
        private Semaphore changedLock = new Semaphore(0);
        private String node;

        public TestingZKListener(ZKWatcher watcher, String node) {
            super(watcher);
            this.node = node;
        }

        public void nodeDeleted(String path) {
            if (path.equals(this.node)) {
                LOG.debug("nodeDeleted(" + path + ")");
                this.deletedLock.release();
            }
        }

        public void nodeCreated(String path) {
            if (path.equals(this.node)) {
                LOG.debug("nodeCreated(" + path + ")");
                this.createdLock.release();
            }
        }

        public void nodeDataChanged(String path) {
            if (path.equals(this.node)) {
                LOG.debug("nodeDataChanged(" + path + ")");
                this.changedLock.release();
            }
        }

        public void waitForDeletion() throws InterruptedException {
            this.deletedLock.acquire();
        }

        public void waitForCreation() throws InterruptedException {
            this.createdLock.acquire();
        }

        public void waitForDataChange() throws InterruptedException {
            this.changedLock.acquire();
        }
    }

    public static class TestTracker
    extends ZKNodeTracker {
        public TestTracker(ZKWatcher watcher, String node, Abortable abortable) {
            super(watcher, node, abortable);
        }
    }

    public static class WaitToGetDataThread
    extends Thread {
        TestTracker tracker;
        boolean hasData;

        public WaitToGetDataThread(ZKWatcher zk, String node) {
            this.tracker = new TestTracker(zk, node, null);
            this.tracker.start();
            zk.registerListener((ZKListener)this.tracker);
            this.hasData = false;
        }

        public WaitToGetDataThread(ZKWatcher zk, String node, TestTracker tracker) {
            this.tracker = tracker;
            this.hasData = false;
        }

        @Override
        public void run() {
            LOG.info("Waiting for data to be available in WaitToGetDataThread");
            try {
                this.tracker.blockUntilAvailable();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            LOG.info("Data now available in tracker from WaitToGetDataThread");
            this.hasData = true;
        }
    }
}

