/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.testclassification.ZKTests;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ZKTests.class, SmallTests.class})
public class TestZKWatcher {
    @Test
    public void testIsClientReadable() throws IOException {
        ZKWatcher watcher = new ZKWatcher(HBaseConfiguration.create(), "testIsClientReadable", null, false);
        Assert.assertTrue((boolean)watcher.isClientReadable(watcher.znodePaths.baseZNode));
        Assert.assertTrue((boolean)watcher.isClientReadable(watcher.znodePaths.getZNodeForReplica(0)));
        Assert.assertTrue((boolean)watcher.isClientReadable(watcher.znodePaths.masterAddressZNode));
        Assert.assertTrue((boolean)watcher.isClientReadable(watcher.znodePaths.clusterIdZNode));
        Assert.assertTrue((boolean)watcher.isClientReadable(watcher.znodePaths.tableZNode));
        Assert.assertTrue((boolean)watcher.isClientReadable(ZNodePaths.joinZNode((String)watcher.znodePaths.tableZNode, (String)"foo")));
        Assert.assertTrue((boolean)watcher.isClientReadable(watcher.znodePaths.rsZNode));
        Assert.assertFalse((boolean)watcher.isClientReadable(watcher.znodePaths.tableLockZNode));
        Assert.assertFalse((boolean)watcher.isClientReadable(watcher.znodePaths.balancerZNode));
        Assert.assertFalse((boolean)watcher.isClientReadable(watcher.znodePaths.regionNormalizerZNode));
        Assert.assertFalse((boolean)watcher.isClientReadable(watcher.znodePaths.clusterStateZNode));
        Assert.assertFalse((boolean)watcher.isClientReadable(watcher.znodePaths.drainingZNode));
        Assert.assertFalse((boolean)watcher.isClientReadable(watcher.znodePaths.splitLogZNode));
        Assert.assertFalse((boolean)watcher.isClientReadable(watcher.znodePaths.backupMasterAddressesZNode));
        watcher.close();
    }
}

