/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class MetaTableLocator {
    private static final Logger LOG = LoggerFactory.getLogger(MetaTableLocator.class);

    private MetaTableLocator() {
    }

    public static boolean isLocationAvailable(ZKWatcher zkw) {
        return MetaTableLocator.getMetaRegionLocation(zkw) != null;
    }

    public static List<Pair<RegionInfo, ServerName>> getMetaRegionsAndLocations(ZKWatcher zkw) {
        return MetaTableLocator.getMetaRegionsAndLocations(zkw, 0);
    }

    public static List<Pair<RegionInfo, ServerName>> getMetaRegionsAndLocations(ZKWatcher zkw, int replicaId) {
        ServerName serverName = MetaTableLocator.getMetaRegionLocation(zkw, replicaId);
        ArrayList<Pair<RegionInfo, ServerName>> list = new ArrayList<Pair<RegionInfo, ServerName>>(1);
        list.add(new Pair((Object)RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO, (int)replicaId), (Object)serverName));
        return list;
    }

    public static List<RegionInfo> getMetaRegions(ZKWatcher zkw) {
        return MetaTableLocator.getMetaRegions(zkw, 0);
    }

    public static List<RegionInfo> getMetaRegions(ZKWatcher zkw, int replicaId) {
        List<Pair<RegionInfo, ServerName>> result = MetaTableLocator.getMetaRegionsAndLocations(zkw, replicaId);
        return MetaTableLocator.getListOfRegionInfos(result);
    }

    private static List<RegionInfo> getListOfRegionInfos(List<Pair<RegionInfo, ServerName>> pairs) {
        if (pairs == null || pairs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RegionInfo> result = new ArrayList<RegionInfo>(pairs.size());
        for (Pair<RegionInfo, ServerName> pair : pairs) {
            result.add((RegionInfo)pair.getFirst());
        }
        return result;
    }

    public static ServerName getMetaRegionLocation(ZKWatcher zkw) {
        try {
            RegionState state = MetaTableLocator.getMetaRegionState(zkw);
            return state.isOpened() ? state.getServerName() : null;
        }
        catch (KeeperException ke) {
            return null;
        }
    }

    public static ServerName getMetaRegionLocation(ZKWatcher zkw, int replicaId) {
        try {
            RegionState state = MetaTableLocator.getMetaRegionState(zkw, replicaId);
            return state.isOpened() ? state.getServerName() : null;
        }
        catch (KeeperException ke) {
            return null;
        }
    }

    public static ServerName waitMetaRegionLocation(ZKWatcher zkw, long timeout) throws InterruptedException, NotAllMetaRegionsOnlineException {
        return MetaTableLocator.waitMetaRegionLocation(zkw, 0, timeout);
    }

    public static ServerName waitMetaRegionLocation(ZKWatcher zkw, int replicaId, long timeout) throws InterruptedException, NotAllMetaRegionsOnlineException {
        try {
            if (ZKUtil.checkExists(zkw, zkw.getZNodePaths().baseZNode) == -1) {
                String errorMsg = "Check the value configured in 'zookeeper.znode.parent'. There could be a mismatch with the one configured in the master.";
                LOG.error(errorMsg);
                throw new IllegalArgumentException(errorMsg);
            }
        }
        catch (KeeperException e) {
            throw new IllegalStateException("KeeperException while trying to check baseZNode:", e);
        }
        ServerName sn = MetaTableLocator.blockUntilAvailable(zkw, replicaId, timeout);
        if (sn == null) {
            throw new NotAllMetaRegionsOnlineException("Timed out; " + timeout + "ms");
        }
        return sn;
    }

    public static void setMetaLocation(ZKWatcher zookeeper, ServerName serverName, RegionState.State state) throws KeeperException {
        MetaTableLocator.setMetaLocation(zookeeper, serverName, 0, state);
    }

    public static void setMetaLocation(ZKWatcher zookeeper, ServerName serverName, int replicaId, RegionState.State state) throws KeeperException {
        if (serverName == null) {
            LOG.warn("Tried to set null ServerName in hbase:meta; skipping -- ServerName required");
            return;
        }
        LOG.info("Setting hbase:meta (replicaId=" + replicaId + ") location in ZooKeeper as " + serverName);
        ZooKeeperProtos.MetaRegionServer pbrsr = ZooKeeperProtos.MetaRegionServer.newBuilder().setServer(ProtobufUtil.toServerName((ServerName)serverName)).setRpcVersion(0).setState(state.convert()).build();
        byte[] data = ProtobufUtil.prependPBMagic((byte[])pbrsr.toByteArray());
        try {
            ZKUtil.setData(zookeeper, zookeeper.getZNodePaths().getZNodeForReplica(replicaId), data);
        }
        catch (KeeperException.NoNodeException nne) {
            if (replicaId == 0) {
                LOG.debug("META region location doesn't exist, create it");
            } else {
                LOG.debug("META region location doesn't exist for replicaId=" + replicaId + ", create it");
            }
            ZKUtil.createAndWatch(zookeeper, zookeeper.getZNodePaths().getZNodeForReplica(replicaId), data);
        }
    }

    public static RegionState getMetaRegionState(ZKWatcher zkw) throws KeeperException {
        return MetaTableLocator.getMetaRegionState(zkw, 0);
    }

    public static RegionState getMetaRegionState(ZKWatcher zkw, int replicaId) throws KeeperException {
        ServerName serverName;
        RegionState.State state;
        block8: {
            state = RegionState.State.OPEN;
            serverName = null;
            try {
                byte[] data = ZKUtil.getData(zkw, zkw.getZNodePaths().getZNodeForReplica(replicaId));
                if (data != null && data.length > 0 && ProtobufUtil.isPBMagicPrefix((byte[])data)) {
                    try {
                        int prefixLen = ProtobufUtil.lengthOfPBMagic();
                        ZooKeeperProtos.MetaRegionServer rl = (ZooKeeperProtos.MetaRegionServer)ZooKeeperProtos.MetaRegionServer.parser().parseFrom(data, prefixLen, data.length - prefixLen);
                        if (rl.hasState()) {
                            state = RegionState.State.convert((ClusterStatusProtos.RegionState.State)rl.getState());
                        }
                        HBaseProtos.ServerName sn = rl.getServer();
                        serverName = ServerName.valueOf((String)sn.getHostName(), (int)sn.getPort(), (long)sn.getStartCode());
                        break block8;
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new DeserializationException("Unable to parse meta region location");
                    }
                }
                serverName = ProtobufUtil.parseServerNameFrom((byte[])data);
            }
            catch (DeserializationException e) {
                throw ZKUtil.convert(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (serverName == null) {
            state = RegionState.State.OFFLINE;
        }
        return new RegionState(RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO, (int)replicaId), state, serverName);
    }

    public static void deleteMetaLocation(ZKWatcher zookeeper) throws KeeperException {
        MetaTableLocator.deleteMetaLocation(zookeeper, 0);
    }

    public static void deleteMetaLocation(ZKWatcher zookeeper, int replicaId) throws KeeperException {
        if (replicaId == 0) {
            LOG.info("Deleting hbase:meta region location in ZooKeeper");
        } else {
            LOG.info("Deleting hbase:meta for " + replicaId + " region location in ZooKeeper");
        }
        try {
            ZKUtil.deleteNode(zookeeper, zookeeper.getZNodePaths().getZNodeForReplica(replicaId));
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    public static List<ServerName> blockUntilAvailable(ZKWatcher zkw, long timeout, Configuration conf) throws InterruptedException {
        int numReplicasConfigured = 1;
        ArrayList<ServerName> servers = new ArrayList<ServerName>();
        ServerName server = MetaTableLocator.blockUntilAvailable(zkw, timeout);
        if (server == null) {
            return null;
        }
        servers.add(server);
        try {
            List<String> metaReplicaNodes = zkw.getMetaReplicaNodes();
            numReplicasConfigured = metaReplicaNodes.size();
        }
        catch (KeeperException e) {
            LOG.warn("Got ZK exception " + (Object)((Object)e));
        }
        for (int replicaId = 1; replicaId < numReplicasConfigured; ++replicaId) {
            servers.add(MetaTableLocator.getMetaRegionLocation(zkw, replicaId));
        }
        return servers;
    }

    public static ServerName blockUntilAvailable(ZKWatcher zkw, long timeout) throws InterruptedException {
        return MetaTableLocator.blockUntilAvailable(zkw, 0, timeout);
    }

    public static ServerName blockUntilAvailable(ZKWatcher zkw, int replicaId, long timeout) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        if (zkw == null) {
            throw new IllegalArgumentException();
        }
        long startTime = System.currentTimeMillis();
        ServerName sn = null;
        while ((sn = MetaTableLocator.getMetaRegionLocation(zkw, replicaId)) == null && System.currentTimeMillis() - startTime <= timeout - 200L) {
            Thread.sleep(200L);
        }
        return sn;
    }
}

