/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import com.google.errorprone.annotations.RestrictedApi;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class MetaTableLocator {
    private static final Logger LOG = LoggerFactory.getLogger(MetaTableLocator.class);

    private MetaTableLocator() {
    }

    @RestrictedApi(explanation="Should only be called in tests or ZKUtil", link="", allowedOnPath=".*/src/test/.*|.*/ZKDump\\.java")
    public static ServerName getMetaRegionLocation(ZKWatcher zkw) {
        try {
            RegionState state = MetaTableLocator.getMetaRegionState(zkw);
            return state.isOpened() ? state.getServerName() : null;
        }
        catch (KeeperException ke) {
            return null;
        }
    }

    @RestrictedApi(explanation="Should only be called in self or ZKUtil", link="", allowedOnPath=".*(MetaTableLocator|ZKDump)\\.java")
    public static ServerName getMetaRegionLocation(ZKWatcher zkw, int replicaId) {
        try {
            RegionState state = MetaTableLocator.getMetaRegionState(zkw, replicaId);
            return state.isOpened() ? state.getServerName() : null;
        }
        catch (KeeperException ke) {
            return null;
        }
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    public static ServerName waitMetaRegionLocation(ZKWatcher zkw, long timeout) throws InterruptedException, NotAllMetaRegionsOnlineException {
        return MetaTableLocator.waitMetaRegionLocation(zkw, 0, timeout);
    }

    private static ServerName waitMetaRegionLocation(ZKWatcher zkw, int replicaId, long timeout) throws InterruptedException, NotAllMetaRegionsOnlineException {
        try {
            if (ZKUtil.checkExists(zkw, zkw.getZNodePaths().baseZNode) == -1) {
                String errorMsg = "Check the value configured in 'zookeeper.znode.parent'. There could be a mismatch with the one configured in the master.";
                LOG.error(errorMsg);
                throw new IllegalArgumentException(errorMsg);
            }
        }
        catch (KeeperException e) {
            throw new IllegalStateException("KeeperException while trying to check baseZNode:", e);
        }
        ServerName sn = MetaTableLocator.blockUntilAvailable(zkw, replicaId, timeout);
        if (sn == null) {
            throw new NotAllMetaRegionsOnlineException("Timed out; " + timeout + "ms");
        }
        return sn;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    public static void setMetaLocation(ZKWatcher zookeeper, ServerName serverName, RegionState.State state) throws KeeperException {
        MetaTableLocator.setMetaLocation(zookeeper, serverName, 0, state);
    }

    public static void setMetaLocation(ZKWatcher zookeeper, ServerName serverName, int replicaId, RegionState.State state) throws KeeperException {
        if (serverName == null) {
            LOG.warn("Tried to set null ServerName in hbase:meta; skipping -- ServerName required");
            return;
        }
        LOG.info("Setting hbase:meta replicaId={} location in ZooKeeper as {}, state={}", new Object[]{replicaId, serverName, state});
        ZooKeeperProtos.MetaRegionServer pbrsr = ZooKeeperProtos.MetaRegionServer.newBuilder().setServer(ProtobufUtil.toServerName((ServerName)serverName)).setRpcVersion(0).setState(state.convert()).build();
        byte[] data = ProtobufUtil.prependPBMagic((byte[])pbrsr.toByteArray());
        try {
            ZKUtil.setData(zookeeper, zookeeper.getZNodePaths().getZNodeForReplica(replicaId), data);
        }
        catch (KeeperException.NoNodeException nne) {
            if (replicaId == 0) {
                LOG.debug("hbase:meta region location doesn't exist, create it");
            } else {
                LOG.debug("hbase:meta region location doesn't exist for replicaId=" + replicaId + ", create it");
            }
            ZKUtil.createAndWatch(zookeeper, zookeeper.getZNodePaths().getZNodeForReplica(replicaId), data);
        }
    }

    @RestrictedApi(explanation="Should only be called in self or tests", link="", allowedOnPath=".*/src/test/.*|.*/MetaTableLocator\\.java")
    public static RegionState getMetaRegionState(ZKWatcher zkw) throws KeeperException {
        return MetaTableLocator.getMetaRegionState(zkw, 0);
    }

    public static RegionState getMetaRegionState(ZKWatcher zkw, int replicaId) throws KeeperException {
        RegionState regionState = null;
        try {
            byte[] data = ZKUtil.getData(zkw, zkw.getZNodePaths().getZNodeForReplica(replicaId));
            regionState = ProtobufUtil.parseMetaRegionStateFrom((byte[])data, (int)replicaId);
        }
        catch (DeserializationException e) {
            throw ZKUtil.convert(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return regionState;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    public static void deleteMetaLocation(ZKWatcher zookeeper) throws KeeperException {
        MetaTableLocator.deleteMetaLocation(zookeeper, 0);
    }

    public static void deleteMetaLocation(ZKWatcher zookeeper, int replicaId) throws KeeperException {
        if (replicaId == 0) {
            LOG.info("Deleting hbase:meta region location in ZooKeeper");
        } else {
            LOG.info("Deleting hbase:meta for {} region location in ZooKeeper", (Object)replicaId);
        }
        try {
            ZKUtil.deleteNode(zookeeper, zookeeper.getZNodePaths().getZNodeForReplica(replicaId));
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    private static ServerName blockUntilAvailable(ZKWatcher zkw, int replicaId, long timeout) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        if (zkw == null) {
            throw new IllegalArgumentException();
        }
        long startTime = EnvironmentEdgeManager.currentTime();
        ServerName sn = null;
        while ((sn = MetaTableLocator.getMetaRegionLocation(zkw, replicaId)) == null && EnvironmentEdgeManager.currentTime() - startTime <= timeout - 200L) {
            Thread.sleep(200L);
        }
        return sn;
    }
}

