/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.EmptyWatcher;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.proto.CreateRequest;
import org.apache.zookeeper.proto.DeleteRequest;
import org.apache.zookeeper.proto.SetDataRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ZKUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ZKUtil.class);
    private static boolean useMultiWarn = true;

    private ZKUtil() {
    }

    public static String getParent(String node) {
        int idx = node.lastIndexOf(47);
        return idx <= 0 ? null : node.substring(0, idx);
    }

    public static String getNodeName(String path) {
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public static boolean watchAndCheckExists(ZKWatcher zkw, String znode) throws KeeperException {
        try {
            boolean exists;
            Stat s = zkw.getRecoverableZooKeeper().exists(znode, zkw);
            boolean bl = exists = s != null;
            if (exists) {
                LOG.debug(zkw.prefix("Set watcher on existing znode=" + znode));
            } else {
                LOG.debug(zkw.prefix("Set watcher on znode that does not yet exist, " + znode));
            }
            return exists;
        }
        catch (KeeperException e) {
            LOG.warn(zkw.prefix("Unable to set watcher on znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return false;
        }
        catch (InterruptedException e) {
            LOG.warn(zkw.prefix("Unable to set watcher on znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return false;
        }
    }

    public static boolean setWatchIfNodeExists(ZKWatcher zkw, String znode) throws KeeperException {
        try {
            zkw.getRecoverableZooKeeper().getData(znode, true, null);
            return true;
        }
        catch (KeeperException.NoNodeException e) {
            return false;
        }
        catch (InterruptedException e) {
            LOG.warn(zkw.prefix("Unable to set watcher on znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return false;
        }
    }

    public static int checkExists(ZKWatcher zkw, String znode) throws KeeperException {
        try {
            Stat s = zkw.getRecoverableZooKeeper().exists(znode, null);
            return s != null ? s.getVersion() : -1;
        }
        catch (KeeperException e) {
            LOG.warn(zkw.prefix("Unable to set watcher on znode (" + znode + ")"), (Throwable)e);
            zkw.keeperException(e);
            return -1;
        }
        catch (InterruptedException e) {
            LOG.warn(zkw.prefix("Unable to set watcher on znode (" + znode + ")"), (Throwable)e);
            zkw.interruptedException(e);
            return -1;
        }
    }

    public static List<String> listChildrenAndWatchForNewChildren(ZKWatcher zkw, String znode) throws KeeperException {
        try {
            return zkw.getRecoverableZooKeeper().getChildren(znode, zkw);
        }
        catch (KeeperException.NoNodeException ke) {
            LOG.debug(zkw.prefix("Unable to list children of znode " + znode + " because node does not exist (not an error)"));
        }
        catch (KeeperException e) {
            LOG.warn(zkw.prefix("Unable to list children of znode " + znode + " "), (Throwable)e);
            zkw.keeperException(e);
        }
        catch (InterruptedException e) {
            LOG.warn(zkw.prefix("Unable to list children of znode " + znode + " "), (Throwable)e);
            zkw.interruptedException(e);
        }
        return null;
    }

    public static List<String> listChildrenAndWatchThem(ZKWatcher zkw, String znode) throws KeeperException {
        List<String> children = ZKUtil.listChildrenAndWatchForNewChildren(zkw, znode);
        if (children == null) {
            return null;
        }
        for (String child : children) {
            ZKUtil.watchAndCheckExists(zkw, ZNodePaths.joinZNode((String)znode, (String)child));
        }
        return children;
    }

    public static List<String> listChildrenNoWatch(ZKWatcher zkw, String znode) throws KeeperException {
        List<String> children = null;
        try {
            children = zkw.getRecoverableZooKeeper().getChildren(znode, null);
        }
        catch (KeeperException.NoNodeException nne) {
            return null;
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
        return children;
    }

    public static boolean nodeHasChildren(ZKWatcher zkw, String znode) throws KeeperException {
        try {
            return !zkw.getRecoverableZooKeeper().getChildren(znode, null).isEmpty();
        }
        catch (KeeperException.NoNodeException ke) {
            LOG.debug(zkw.prefix("Unable to list children of znode " + znode + " because node does not exist (not an error)"));
            return false;
        }
        catch (KeeperException e) {
            LOG.warn(zkw.prefix("Unable to list children of znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return false;
        }
        catch (InterruptedException e) {
            LOG.warn(zkw.prefix("Unable to list children of znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return false;
        }
    }

    public static int getNumberOfChildren(ZKWatcher zkw, String znode) throws KeeperException {
        try {
            Stat stat = zkw.getRecoverableZooKeeper().exists(znode, null);
            return stat == null ? 0 : stat.getNumChildren();
        }
        catch (KeeperException e) {
            LOG.warn(zkw.prefix("Unable to get children of node " + znode));
            zkw.keeperException(e);
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
        }
        return 0;
    }

    public static byte[] getData(ZKWatcher zkw, String znode) throws KeeperException, InterruptedException {
        try {
            byte[] data = zkw.getRecoverableZooKeeper().getData(znode, null, null);
            ZKUtil.logRetrievedMsg(zkw, znode, data, false);
            return data;
        }
        catch (KeeperException.NoNodeException e) {
            LOG.debug(zkw.prefix("Unable to get data of znode " + znode + " because node does not exist (not an error)"));
            return null;
        }
        catch (KeeperException e) {
            LOG.warn(zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return null;
        }
    }

    public static byte[] getDataAndWatch(ZKWatcher zkw, String znode) throws KeeperException {
        return ZKUtil.getDataInternal(zkw, znode, null, true, true);
    }

    public static byte[] getDataAndWatch(ZKWatcher zkw, String znode, boolean throwOnInterrupt) throws KeeperException {
        return ZKUtil.getDataInternal(zkw, znode, null, true, throwOnInterrupt);
    }

    public static byte[] getDataAndWatch(ZKWatcher zkw, String znode, Stat stat) throws KeeperException {
        return ZKUtil.getDataInternal(zkw, znode, stat, true, true);
    }

    private static byte[] getDataInternal(ZKWatcher zkw, String znode, Stat stat, boolean watcherSet, boolean throwOnInterrupt) throws KeeperException {
        try {
            byte[] data = zkw.getRecoverableZooKeeper().getData(znode, zkw, stat);
            ZKUtil.logRetrievedMsg(zkw, znode, data, watcherSet);
            return data;
        }
        catch (KeeperException.NoNodeException e) {
            LOG.trace(zkw.prefix("Unable to get data of znode " + znode + " because node does not exist (not an error)"));
            return null;
        }
        catch (KeeperException e) {
            LOG.warn(zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return null;
        }
        catch (InterruptedException e) {
            LOG.warn(zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            if (throwOnInterrupt) {
                zkw.interruptedException(e);
            } else {
                zkw.interruptedExceptionNoThrow(e, true);
            }
            return null;
        }
    }

    public static byte[] getDataNoWatch(ZKWatcher zkw, String znode, Stat stat) throws KeeperException {
        try {
            byte[] data = zkw.getRecoverableZooKeeper().getData(znode, null, stat);
            ZKUtil.logRetrievedMsg(zkw, znode, data, false);
            return data;
        }
        catch (KeeperException.NoNodeException e) {
            LOG.debug(zkw.prefix("Unable to get data of znode " + znode + " because node does not exist (not necessarily an error)"));
            return null;
        }
        catch (KeeperException e) {
            LOG.warn(zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return null;
        }
        catch (InterruptedException e) {
            LOG.warn(zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return null;
        }
    }

    @Deprecated
    public static List<NodeAndData> getChildDataAndWatchForNewChildren(ZKWatcher zkw, String baseNode) throws KeeperException {
        return ZKUtil.getChildDataAndWatchForNewChildren(zkw, baseNode, true);
    }

    @Deprecated
    public static List<NodeAndData> getChildDataAndWatchForNewChildren(ZKWatcher zkw, String baseNode, boolean throwOnInterrupt) throws KeeperException {
        List<String> nodes = ZKUtil.listChildrenAndWatchForNewChildren(zkw, baseNode);
        if (nodes != null) {
            ArrayList<NodeAndData> newNodes = new ArrayList<NodeAndData>();
            for (String node : nodes) {
                if (Thread.interrupted()) {
                    return Collections.emptyList();
                }
                String nodePath = ZNodePaths.joinZNode((String)baseNode, (String)node);
                byte[] data = ZKUtil.getDataAndWatch(zkw, nodePath, throwOnInterrupt);
                newNodes.add(new NodeAndData(nodePath, data));
            }
            return newNodes;
        }
        return null;
    }

    @Deprecated
    public static void updateExistingNodeData(ZKWatcher zkw, String znode, byte[] data, int expectedVersion) throws KeeperException {
        try {
            zkw.getRecoverableZooKeeper().setData(znode, data, expectedVersion);
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static boolean setData(ZKWatcher zkw, String znode, byte[] data, int expectedVersion) throws KeeperException, KeeperException.NoNodeException {
        try {
            return zkw.getRecoverableZooKeeper().setData(znode, data, expectedVersion) != null;
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return false;
        }
    }

    public static void createSetData(ZKWatcher zkw, String znode, byte[] data) throws KeeperException {
        if (ZKUtil.checkExists(zkw, znode) == -1) {
            ZKUtil.createWithParents(zkw, znode, data);
        } else {
            ZKUtil.setData(zkw, znode, data);
        }
    }

    public static void setData(ZKWatcher zkw, String znode, byte[] data) throws KeeperException, KeeperException.NoNodeException {
        ZKUtil.setData(zkw, (ZKUtilOp.SetData)ZKUtilOp.setData(znode, data));
    }

    private static void setData(ZKWatcher zkw, ZKUtilOp.SetData setData) throws KeeperException, KeeperException.NoNodeException {
        SetDataRequest sd = (SetDataRequest)ZKUtil.toZooKeeperOp(zkw, setData).toRequestRecord();
        ZKUtil.setData(zkw, sd.getPath(), sd.getData(), sd.getVersion());
    }

    public static boolean createEphemeralNodeAndWatch(ZKWatcher zkw, String znode, byte[] data) throws KeeperException {
        boolean ret = true;
        try {
            zkw.getRecoverableZooKeeper().create(znode, data, zkw.createACL(znode), CreateMode.EPHEMERAL);
        }
        catch (KeeperException.NodeExistsException nee) {
            ret = false;
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (!ZKUtil.watchAndCheckExists(zkw, znode)) {
            return ZKUtil.createEphemeralNodeAndWatch(zkw, znode, data);
        }
        return ret;
    }

    public static boolean createNodeIfNotExistsAndWatch(ZKWatcher zkw, String znode, byte[] data) throws KeeperException {
        boolean ret = true;
        try {
            zkw.getRecoverableZooKeeper().create(znode, data, zkw.createACL(znode), CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nee) {
            ret = false;
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return false;
        }
        try {
            zkw.getRecoverableZooKeeper().exists(znode, zkw);
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return false;
        }
        return ret;
    }

    public static String createNodeIfNotExistsNoWatch(ZKWatcher zkw, String znode, byte[] data, CreateMode createMode) throws KeeperException {
        try {
            return zkw.getRecoverableZooKeeper().create(znode, data, zkw.createACL(znode), createMode);
        }
        catch (KeeperException.NodeExistsException nee) {
            return znode;
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return null;
        }
    }

    public static int createAndWatch(ZKWatcher zkw, String znode, byte[] data) throws KeeperException, KeeperException.NodeExistsException {
        try {
            zkw.getRecoverableZooKeeper().create(znode, data, zkw.createACL(znode), CreateMode.PERSISTENT);
            Stat stat = zkw.getRecoverableZooKeeper().exists(znode, zkw);
            if (stat == null) {
                throw KeeperException.create((KeeperException.Code)KeeperException.Code.SYSTEMERROR, (String)("ZK.exists returned null (i.e.: znode does not exist) for znode=" + znode));
            }
            return stat.getVersion();
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return -1;
        }
    }

    public static void asyncCreate(ZKWatcher zkw, String znode, byte[] data, AsyncCallback.StringCallback cb, Object ctx) {
        zkw.getRecoverableZooKeeper().getZooKeeper().create(znode, data, zkw.createACL(znode), CreateMode.PERSISTENT, cb, ctx);
    }

    public static void createAndFailSilent(ZKWatcher zkw, String znode) throws KeeperException {
        ZKUtil.createAndFailSilent(zkw, znode, new byte[0]);
    }

    public static void createAndFailSilent(ZKWatcher zkw, String znode, byte[] data) throws KeeperException {
        ZKUtil.createAndFailSilent(zkw, (ZKUtilOp.CreateAndFailSilent)ZKUtilOp.createAndFailSilent(znode, data));
    }

    private static void createAndFailSilent(ZKWatcher zkw, ZKUtilOp.CreateAndFailSilent cafs) throws KeeperException {
        CreateRequest create = (CreateRequest)ZKUtil.toZooKeeperOp(zkw, cafs).toRequestRecord();
        String znode = create.getPath();
        RecoverableZooKeeper zk = zkw.getRecoverableZooKeeper();
        try {
            if (zk.exists(znode, false) == null) {
                zk.create(znode, create.getData(), create.getAcl(), CreateMode.fromFlag((int)create.getFlags()));
            }
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
        }
        catch (KeeperException.NoAuthException nee) {
            try {
                if (zk.exists(znode, false) == null) {
                    throw nee;
                }
            }
            catch (InterruptedException ie) {
                zkw.interruptedException(ie);
            }
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static void createWithParents(ZKWatcher zkw, String znode) throws KeeperException {
        ZKUtil.createWithParents(zkw, znode, new byte[0]);
    }

    public static void createWithParents(ZKWatcher zkw, String znode, byte[] data) throws KeeperException {
        try {
            if (znode == null) {
                return;
            }
            zkw.getRecoverableZooKeeper().create(znode, data, zkw.createACL(znode), CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nee) {
            return;
        }
        catch (KeeperException.NoNodeException nne) {
            ZKUtil.createWithParents(zkw, ZKUtil.getParent(znode));
            ZKUtil.createWithParents(zkw, znode, data);
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static void deleteNode(ZKWatcher zkw, String node) throws KeeperException {
        ZKUtil.deleteNode(zkw, node, -1);
    }

    public static boolean deleteNode(ZKWatcher zkw, String node, int version) throws KeeperException {
        try {
            zkw.getRecoverableZooKeeper().delete(node, version);
            return true;
        }
        catch (KeeperException.BadVersionException bve) {
            return false;
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
            return false;
        }
    }

    public static void deleteNodeFailSilent(ZKWatcher zkw, String node) throws KeeperException {
        ZKUtil.deleteNodeFailSilent(zkw, (ZKUtilOp.DeleteNodeFailSilent)ZKUtilOp.deleteNodeFailSilent(node));
    }

    private static void deleteNodeFailSilent(ZKWatcher zkw, ZKUtilOp.DeleteNodeFailSilent dnfs) throws KeeperException {
        DeleteRequest delete = (DeleteRequest)ZKUtil.toZooKeeperOp(zkw, dnfs).toRequestRecord();
        try {
            zkw.getRecoverableZooKeeper().delete(delete.getPath(), delete.getVersion());
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static void deleteNodeRecursively(ZKWatcher zkw, String node) throws KeeperException {
        ZKUtil.deleteNodeRecursivelyMultiOrSequential(zkw, true, node);
    }

    public static void deleteChildrenRecursively(ZKWatcher zkw, String node) throws KeeperException {
        ZKUtil.deleteChildrenRecursivelyMultiOrSequential(zkw, true, node);
    }

    public static void deleteChildrenRecursivelyMultiOrSequential(ZKWatcher zkw, boolean runSequentialOnMultiFailure, String ... pathRoots) throws KeeperException {
        if (pathRoots == null || pathRoots.length <= 0) {
            LOG.warn("Given path is not valid!");
            return;
        }
        ArrayList<ZKUtilOp> ops = new ArrayList<ZKUtilOp>();
        for (String eachRoot : pathRoots) {
            List<String> children = ZKUtil.listChildrenBFSNoWatch(zkw, eachRoot);
            for (int i = children.size() - 1; i >= 0; --i) {
                ops.add(ZKUtilOp.deleteNodeFailSilent(children.get(i)));
            }
        }
        ZKUtil.submitBatchedMultiOrSequential(zkw, runSequentialOnMultiFailure, ops);
    }

    public static void deleteNodeRecursivelyMultiOrSequential(ZKWatcher zkw, boolean runSequentialOnMultiFailure, String ... pathRoots) throws KeeperException {
        if (pathRoots == null || pathRoots.length <= 0) {
            LOG.warn("Given path is not valid!");
            return;
        }
        ArrayList<ZKUtilOp> ops = new ArrayList<ZKUtilOp>();
        for (String eachRoot : pathRoots) {
            List<String> children = ZKUtil.listChildrenBFSAndWatchThem(zkw, eachRoot);
            for (int i = children.size() - 1; i >= 0; --i) {
                ops.add(ZKUtilOp.deleteNodeFailSilent(children.get(i)));
            }
            try {
                if (zkw.getRecoverableZooKeeper().exists(eachRoot, zkw) == null) continue;
                ops.add(ZKUtilOp.deleteNodeFailSilent(eachRoot));
            }
            catch (InterruptedException e) {
                zkw.interruptedException(e);
            }
        }
        ZKUtil.submitBatchedMultiOrSequential(zkw, runSequentialOnMultiFailure, ops);
    }

    private static void submitBatchedMultiOrSequential(ZKWatcher zkw, boolean runSequentialOnMultiFailure, List<ZKUtilOp> ops) throws KeeperException {
        if (ops.isEmpty()) {
            return;
        }
        int maxMultiSize = zkw.getRecoverableZooKeeper().getMaxMultiSizeLimit();
        List<List<ZKUtilOp>> batchedOps = ZKUtil.partitionOps(ops, maxMultiSize);
        for (List<ZKUtilOp> batch : batchedOps) {
            ZKUtil.multiOrSequential(zkw, batch, runSequentialOnMultiFailure);
        }
    }

    static List<List<ZKUtilOp>> partitionOps(List<ZKUtilOp> ops, int maxPartitionSize) {
        ArrayList<List<ZKUtilOp>> partitionedOps = new ArrayList<List<ZKUtilOp>>();
        ArrayList<ZKUtilOp> currentPartition = new ArrayList<ZKUtilOp>();
        int currentPartitionSize = 0;
        partitionedOps.add(currentPartition);
        for (ZKUtilOp currentOp : ops) {
            int currentOpSize = ZKUtil.estimateSize(currentOp);
            if (!currentPartition.isEmpty() && currentOpSize + currentPartitionSize > maxPartitionSize) {
                currentPartition = new ArrayList();
                partitionedOps.add(currentPartition);
                currentPartitionSize = 0;
            }
            currentPartition.add(currentOp);
            currentPartitionSize += currentOpSize;
        }
        return partitionedOps;
    }

    static int estimateSize(ZKUtilOp op) {
        return Bytes.toBytes((String)op.getPath()).length;
    }

    private static List<String> listChildrenBFSNoWatch(ZKWatcher zkw, String znode) throws KeeperException {
        String node;
        LinkedList<String> queue = new LinkedList<String>();
        ArrayList<String> tree = new ArrayList<String>();
        queue.add(znode);
        while ((node = (String)queue.pollFirst()) != null) {
            List<String> children = ZKUtil.listChildrenNoWatch(zkw, node);
            if (children == null) continue;
            for (String child : children) {
                String childPath = node + "/" + child;
                queue.add(childPath);
                tree.add(childPath);
            }
        }
        return tree;
    }

    private static List<String> listChildrenBFSAndWatchThem(ZKWatcher zkw, String znode) throws KeeperException {
        String node;
        LinkedList<String> queue = new LinkedList<String>();
        ArrayList<String> tree = new ArrayList<String>();
        queue.add(znode);
        while ((node = (String)queue.pollFirst()) != null) {
            List<String> children = ZKUtil.listChildrenAndWatchThem(zkw, node);
            if (children == null) continue;
            for (String child : children) {
                String childPath = node + "/" + child;
                queue.add(childPath);
                tree.add(childPath);
            }
        }
        return tree;
    }

    private static Op toZooKeeperOp(ZKWatcher zkw, ZKUtilOp op) throws UnsupportedOperationException {
        if (op == null) {
            return null;
        }
        if (op instanceof ZKUtilOp.CreateAndFailSilent) {
            ZKUtilOp.CreateAndFailSilent cafs = (ZKUtilOp.CreateAndFailSilent)op;
            return Op.create((String)cafs.getPath(), (byte[])cafs.getData(), zkw.createACL(cafs.getPath()), (CreateMode)CreateMode.PERSISTENT);
        }
        if (op instanceof ZKUtilOp.DeleteNodeFailSilent) {
            ZKUtilOp.DeleteNodeFailSilent dnfs = (ZKUtilOp.DeleteNodeFailSilent)op;
            return Op.delete((String)dnfs.getPath(), (int)-1);
        }
        if (op instanceof ZKUtilOp.SetData) {
            ZKUtilOp.SetData sd = (ZKUtilOp.SetData)op;
            return Op.setData((String)sd.getPath(), (byte[])sd.getData(), (int)sd.getVersion());
        }
        throw new UnsupportedOperationException("Unexpected ZKUtilOp type: " + op.getClass().getName());
    }

    public static void multiOrSequential(ZKWatcher zkw, List<ZKUtilOp> ops, boolean runSequentialOnMultiFailure) throws KeeperException {
        if (ops == null) {
            return;
        }
        if (useMultiWarn) {
            if (zkw.getConfiguration().get("hbase.zookeeper.useMulti") != null) {
                LOG.warn("hbase.zookeeper.useMulti is deprecated. Default to true always.");
            }
            useMultiWarn = false;
        }
        LinkedList<Op> zkOps = new LinkedList<Op>();
        for (ZKUtilOp op : ops) {
            zkOps.add(ZKUtil.toZooKeeperOp(zkw, op));
        }
        try {
            zkw.getRecoverableZooKeeper().multi(zkOps);
        }
        catch (KeeperException ke) {
            switch (ke.code()) {
                case NODEEXISTS: 
                case NONODE: 
                case BADVERSION: 
                case NOAUTH: 
                case NOTEMPTY: {
                    if (runSequentialOnMultiFailure) {
                        LOG.info("multi exception: {}; running operations sequentially (runSequentialOnMultiFailure=true); {}", (Object)ke.toString(), (Object)ops.stream().map(o -> o.toString()).collect(Collectors.joining(",")));
                        ZKUtil.processSequentially(zkw, ops);
                        break;
                    }
                }
                default: {
                    throw ke;
                }
            }
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    private static void processSequentially(ZKWatcher zkw, List<ZKUtilOp> ops) throws KeeperException, KeeperException.NoNodeException {
        for (ZKUtilOp op : ops) {
            if (op instanceof ZKUtilOp.CreateAndFailSilent) {
                ZKUtil.createAndFailSilent(zkw, (ZKUtilOp.CreateAndFailSilent)op);
                continue;
            }
            if (op instanceof ZKUtilOp.DeleteNodeFailSilent) {
                ZKUtil.deleteNodeFailSilent(zkw, (ZKUtilOp.DeleteNodeFailSilent)op);
                continue;
            }
            if (op instanceof ZKUtilOp.SetData) {
                ZKUtil.setData(zkw, (ZKUtilOp.SetData)op);
                continue;
            }
            throw new UnsupportedOperationException("Unexpected ZKUtilOp type: " + op.getClass().getName());
        }
    }

    private static void logRetrievedMsg(ZKWatcher zkw, String znode, byte[] data, boolean watcherSet) {
        if (!LOG.isTraceEnabled()) {
            return;
        }
        LOG.trace(zkw.prefix("Retrieved " + (data == null ? 0 : data.length) + " byte(s) of data from znode " + znode + (watcherSet ? " and set watcher; " : "; data=") + (data == null ? "null" : (data.length == 0 ? "empty" : (zkw.getZNodePaths().isMetaZNodePath(znode) ? ZKUtil.getServerNameOrEmptyString(data) : (znode.startsWith(zkw.getZNodePaths().backupMasterAddressesZNode) ? ZKUtil.getServerNameOrEmptyString(data) : StringUtils.abbreviate((String)Bytes.toStringBinary((byte[])data), (int)32)))))));
    }

    private static String getServerNameOrEmptyString(byte[] data) {
        try {
            return ProtobufUtil.parseServerNameFrom((byte[])data).toString();
        }
        catch (DeserializationException e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForBaseZNode(Configuration conf) throws IOException {
        LOG.info("Waiting until the base znode is available");
        String parentZNode = conf.get("zookeeper.znode.parent", "/hbase");
        ZooKeeper zk = new ZooKeeper(ZKConfig.getZKQuorumServersString((Configuration)conf), conf.getInt("zookeeper.session.timeout", 90000), (Watcher)EmptyWatcher.instance);
        int maxTimeMs = 10000;
        int maxNumAttempts = 50;
        KeeperException keeperEx = null;
        try {
            try {
                for (int attempt = 0; attempt < 50; ++attempt) {
                    block9: {
                        try {
                            if (zk.exists(parentZNode, false) == null) break block9;
                            LOG.info("Parent znode exists: {}", (Object)parentZNode);
                            keeperEx = null;
                            break;
                        }
                        catch (KeeperException e) {
                            keeperEx = e;
                        }
                    }
                    Threads.sleepWithoutInterrupt((long)200L);
                }
            }
            finally {
                zk.close();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (keeperEx != null) {
            throw new IOException(keeperEx);
        }
    }

    public static KeeperException convert(DeserializationException e) {
        KeeperException.DataInconsistencyException ke = new KeeperException.DataInconsistencyException();
        ke.initCause((Throwable)e);
        return ke;
    }

    public static void logZKTree(ZKWatcher zkw, String root) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug("Current zk system:");
        String prefix = "|-";
        LOG.debug(prefix + root);
        try {
            ZKUtil.logZKTree(zkw, root, prefix);
        }
        catch (KeeperException e) {
            throw new RuntimeException(e);
        }
    }

    private static void logZKTree(ZKWatcher zkw, String root, String prefix) throws KeeperException {
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, root);
        if (children == null) {
            return;
        }
        for (String child : children) {
            LOG.debug(prefix + child);
            String node = ZNodePaths.joinZNode((String)(root.equals("/") ? "" : root), (String)child);
            ZKUtil.logZKTree(zkw, node, prefix + "---");
        }
    }

    public static byte[] positionToByteArray(long position) {
        byte[] bytes = ReplicationProtos.ReplicationHLogPosition.newBuilder().setPosition(position).build().toByteArray();
        return ProtobufUtil.prependPBMagic((byte[])bytes);
    }

    public static long parseWALPositionFrom(byte[] bytes) throws DeserializationException {
        if (bytes == null) {
            throw new DeserializationException("Unable to parse null WAL position.");
        }
        if (ProtobufUtil.isPBMagicPrefix((byte[])bytes)) {
            ReplicationProtos.ReplicationHLogPosition position;
            int pblen = ProtobufUtil.lengthOfPBMagic();
            ReplicationProtos.ReplicationHLogPosition.Builder builder = ReplicationProtos.ReplicationHLogPosition.newBuilder();
            try {
                ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])bytes, (int)pblen, (int)(bytes.length - pblen));
                position = builder.build();
            }
            catch (IOException e) {
                throw new DeserializationException((Throwable)e);
            }
            return position.getPosition();
        }
        if (bytes.length > 0) {
            return Bytes.toLong((byte[])bytes);
        }
        return 0L;
    }

    public static abstract class ZKUtilOp {
        private String path;

        public String toString() {
            return this.getClass().getSimpleName() + ", path=" + this.path;
        }

        private ZKUtilOp(String path) {
            this.path = path;
        }

        public static ZKUtilOp createAndFailSilent(String path, byte[] data) {
            return new CreateAndFailSilent(path, data);
        }

        public static ZKUtilOp deleteNodeFailSilent(String path) {
            return new DeleteNodeFailSilent(path);
        }

        public static ZKUtilOp setData(String path, byte[] data) {
            return new SetData(path, data);
        }

        public static ZKUtilOp setData(String path, byte[] data, int version) {
            return new SetData(path, data, version);
        }

        public String getPath() {
            return this.path;
        }

        public static final class SetData
        extends ZKUtilOp {
            private byte[] data;
            private int version = -1;

            private SetData(String path, byte[] data) {
                super(path);
                this.data = data;
            }

            private SetData(String path, byte[] data, int version) {
                super(path);
                this.data = data;
                this.version = version;
            }

            public byte[] getData() {
                return this.data;
            }

            public int getVersion() {
                return this.version;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof SetData)) {
                    return false;
                }
                SetData op = (SetData)o;
                return this.getPath().equals(op.getPath()) && Arrays.equals(this.data, op.data) && this.getVersion() == op.getVersion();
            }

            public int hashCode() {
                int ret = this.getPath().hashCode();
                ret = ret * 31 + Bytes.hashCode((byte[])this.data);
                return ret * 31 + Integer.hashCode(this.version);
            }
        }

        public static final class DeleteNodeFailSilent
        extends ZKUtilOp {
            private DeleteNodeFailSilent(String path) {
                super(path);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof DeleteNodeFailSilent)) {
                    return false;
                }
                return super.equals(o);
            }

            public int hashCode() {
                return this.getPath().hashCode();
            }
        }

        public static final class CreateAndFailSilent
        extends ZKUtilOp {
            private byte[] data;

            private CreateAndFailSilent(String path, byte[] data) {
                super(path);
                this.data = data;
            }

            public byte[] getData() {
                return this.data;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof CreateAndFailSilent)) {
                    return false;
                }
                CreateAndFailSilent op = (CreateAndFailSilent)o;
                return this.getPath().equals(op.getPath()) && Arrays.equals(this.data, op.data);
            }

            public int hashCode() {
                int ret = 17 + this.getPath().hashCode() * 31;
                return ret * 31 + Bytes.hashCode((byte[])this.data);
            }
        }
    }

    @Deprecated
    public static class NodeAndData {
        private String node;
        private byte[] data;

        public NodeAndData(String node, byte[] data) {
            this.node = node;
            this.data = data;
        }

        public String getNode() {
            return this.node;
        }

        public byte[] getData() {
            return this.data;
        }

        public String toString() {
            return this.node;
        }

        public boolean isEmpty() {
            return this.data == null || this.data.length == 0;
        }
    }
}

