/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ZKDump {
    private static final Logger LOG = LoggerFactory.getLogger(ZKDump.class);

    private ZKDump() {
    }

    public static String dump(ZKWatcher zkWatcher) {
        int zkDumpConnectionTimeOut = zkWatcher.getConfiguration().getInt("zookeeper.dump.connection.timeout", 1000);
        StringBuilder sb = new StringBuilder();
        try {
            String[] servers;
            sb.append("HBase is rooted at ").append(zkWatcher.getZNodePaths().baseZNode);
            sb.append("\nActive master address: ");
            try {
                sb.append("\n ").append(MasterAddressTracker.getMasterAddress(zkWatcher));
            }
            catch (IOException e) {
                sb.append("<<FAILED LOOKUP: ").append(e.getMessage()).append(">>");
            }
            sb.append("\nBackup master addresses:");
            List<String> backupMasterChildrenNoWatchList = ZKUtil.listChildrenNoWatch(zkWatcher, zkWatcher.getZNodePaths().backupMasterAddressesZNode);
            if (backupMasterChildrenNoWatchList != null) {
                for (String child : backupMasterChildrenNoWatchList) {
                    sb.append("\n ").append(child);
                }
            }
            sb.append("\nRegion server holding hbase:meta:");
            sb.append("\n ").append(MetaTableLocator.getMetaRegionLocation(zkWatcher));
            int numMetaReplicas = zkWatcher.getMetaReplicaNodes().size();
            for (int i = 1; i < numMetaReplicas; ++i) {
                sb.append("\n").append(" replica").append(i).append(": ").append(MetaTableLocator.getMetaRegionLocation(zkWatcher, i));
            }
            sb.append("\nRegion servers:");
            List<String> rsChildrenNoWatchList = ZKUtil.listChildrenNoWatch(zkWatcher, zkWatcher.getZNodePaths().rsZNode);
            if (rsChildrenNoWatchList != null) {
                for (String child : rsChildrenNoWatchList) {
                    sb.append("\n ").append(child);
                }
            }
            try {
                ZKDump.getReplicationZnodesDump(zkWatcher, sb);
            }
            catch (KeeperException ke) {
                LOG.warn("Couldn't get the replication znode dump", (Throwable)ke);
            }
            sb.append("\nQuorum Server Statistics:");
            for (String server : servers = zkWatcher.getQuorum().split(",")) {
                sb.append("\n ").append(server);
                try {
                    String[] stat = ZKDump.getServerStats(server, zkDumpConnectionTimeOut);
                    if (stat == null) {
                        sb.append("[Error] invalid quorum server: ").append(server);
                        break;
                    }
                    for (String s : stat) {
                        sb.append("\n  ").append(s);
                    }
                }
                catch (Exception e) {
                    sb.append("\n  ERROR: ").append(e.getMessage());
                }
            }
        }
        catch (KeeperException ke) {
            sb.append("\nFATAL ZooKeeper Exception!\n");
            sb.append("\n").append(ke.getMessage());
        }
        return sb.toString();
    }

    private static void getReplicationZnodesDump(ZKWatcher zkw, StringBuilder sb) throws KeeperException {
        String replicationZnode = zkw.getZNodePaths().replicationZNode;
        if (ZKUtil.checkExists(zkw, replicationZnode) == -1) {
            return;
        }
        sb.append("\n").append(replicationZnode).append(": ");
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, replicationZnode);
        if (children != null) {
            Collections.sort(children);
            for (String child : children) {
                String zNode = ZNodePaths.joinZNode((String)replicationZnode, (String[])new String[]{child});
                if (zNode.equals(zkw.getZNodePaths().peersZNode)) {
                    ZKDump.appendPeersZnodes(zkw, zNode, sb);
                    continue;
                }
                if (zNode.equals(zkw.getZNodePaths().queuesZNode)) {
                    ZKDump.appendRSZnodes(zkw, zNode, sb);
                    continue;
                }
                if (!zNode.equals(zkw.getZNodePaths().hfileRefsZNode)) continue;
                ZKDump.appendHFileRefsZNodes(zkw, zNode, sb);
            }
        }
    }

    private static void appendHFileRefsZNodes(ZKWatcher zkw, String hFileRefsZNode, StringBuilder sb) throws KeeperException {
        sb.append("\n").append(hFileRefsZNode).append(": ");
        List<String> hFileRefChildrenNoWatchList = ZKUtil.listChildrenNoWatch(zkw, hFileRefsZNode);
        if (hFileRefChildrenNoWatchList != null) {
            for (String peerIdZNode : hFileRefChildrenNoWatchList) {
                String zNodeToProcess = ZNodePaths.joinZNode((String)hFileRefsZNode, (String[])new String[]{peerIdZNode});
                sb.append("\n").append(zNodeToProcess).append(": ");
                List<String> peerHFileRefsZNodes = ZKUtil.listChildrenNoWatch(zkw, zNodeToProcess);
                if (peerHFileRefsZNodes == null) continue;
                sb.append(String.join((CharSequence)", ", peerHFileRefsZNodes));
            }
        }
    }

    public static String getReplicationZnodesDump(ZKWatcher zkw) throws KeeperException {
        StringBuilder sb = new StringBuilder();
        ZKDump.getReplicationZnodesDump(zkw, sb);
        return sb.toString();
    }

    private static void appendRSZnodes(ZKWatcher zkw, String znode, StringBuilder sb) throws KeeperException {
        LinkedList<String> stack = new LinkedList<String>();
        stack.add(znode);
        do {
            byte[] data;
            String znodeToProcess = (String)stack.remove(stack.size() - 1);
            sb.append("\n").append(znodeToProcess).append(": ");
            try {
                data = ZKUtil.getData(zkw, znodeToProcess);
            }
            catch (InterruptedException e) {
                zkw.interruptedException(e);
                return;
            }
            if (data != null && data.length > 0) {
                long position = 0L;
                try {
                    position = ZKUtil.parseWALPositionFrom(ZKUtil.getData(zkw, znodeToProcess));
                    sb.append(position);
                }
                catch (DeserializationException deserializationException) {
                }
                catch (InterruptedException e) {
                    zkw.interruptedException(e);
                    return;
                }
            }
            for (String zNodeChild : ZKUtil.listChildrenNoWatch(zkw, znodeToProcess)) {
                stack.add(ZNodePaths.joinZNode((String)znodeToProcess, (String[])new String[]{zNodeChild}));
            }
        } while (stack.size() > 0);
    }

    private static void appendPeersZnodes(ZKWatcher zkw, String peersZnode, StringBuilder sb) throws KeeperException {
        int pblen = ProtobufUtil.lengthOfPBMagic();
        sb.append("\n").append(peersZnode).append(": ");
        for (String peerIdZnode : ZKUtil.listChildrenNoWatch(zkw, peersZnode)) {
            byte[] data;
            String znodeToProcess = ZNodePaths.joinZNode((String)peersZnode, (String[])new String[]{peerIdZnode});
            try {
                data = ZKUtil.getData(zkw, znodeToProcess);
            }
            catch (InterruptedException e) {
                zkw.interruptedException(e);
                return;
            }
            try {
                ReplicationProtos.ReplicationPeer.Builder builder = ReplicationProtos.ReplicationPeer.newBuilder();
                ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])data, (int)pblen, (int)(data.length - pblen));
                String clusterKey = builder.getClusterkey();
                sb.append("\n").append(znodeToProcess).append(": ").append(clusterKey);
                ZKDump.appendPeerState(zkw, znodeToProcess, sb);
            }
            catch (IOException ipbe) {
                LOG.warn("Got Exception while parsing peer: " + znodeToProcess, (Throwable)ipbe);
            }
        }
    }

    private static void appendPeerState(ZKWatcher zkw, String znodeToProcess, StringBuilder sb) throws KeeperException, InvalidProtocolBufferException {
        String peerState = zkw.getConfiguration().get("zookeeper.znode.replication.peers.state", "peer-state");
        int pblen = ProtobufUtil.lengthOfPBMagic();
        for (String child : ZKUtil.listChildrenNoWatch(zkw, znodeToProcess)) {
            if (!child.equals(peerState)) continue;
            String peerStateZnode = ZNodePaths.joinZNode((String)znodeToProcess, (String[])new String[]{child});
            sb.append("\n").append(peerStateZnode).append(": ");
            try {
                byte[] peerStateData = ZKUtil.getData(zkw, peerStateZnode);
                ReplicationProtos.ReplicationState.Builder builder = ReplicationProtos.ReplicationState.newBuilder();
                ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])peerStateData, (int)pblen, (int)(peerStateData.length - pblen));
                sb.append(builder.getState().name());
            }
            catch (IOException ipbe) {
                LOG.warn("Got Exception while parsing peer: " + znodeToProcess, (Throwable)ipbe);
            }
            catch (InterruptedException e) {
                zkw.interruptedException(e);
                return;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static String[] getServerStats(String server, int timeout) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

