/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.impl.client;

import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.apache.helix.msdcommon.datamodel.MetadataStoreRoutingData;
import org.apache.helix.msdcommon.exception.InvalidRoutingDataException;
import org.apache.helix.zookeeper.api.client.ChildrenSubscribeResult;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.apache.helix.zookeeper.util.HttpRoutingDataReader;
import org.apache.helix.zookeeper.zkclient.DataUpdater;
import org.apache.helix.zookeeper.zkclient.IZkChildListener;
import org.apache.helix.zookeeper.zkclient.IZkDataListener;
import org.apache.helix.zookeeper.zkclient.ZkConnection;
import org.apache.helix.zookeeper.zkclient.callback.ZkAsyncCallbacks;
import org.apache.helix.zookeeper.zkclient.deprecated.IZkStateListener;
import org.apache.helix.zookeeper.zkclient.serialize.PathBasedZkSerializer;
import org.apache.helix.zookeeper.zkclient.serialize.ZkSerializer;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DedicatedZkClient
implements RealmAwareZkClient {
    private static Logger LOG = LoggerFactory.getLogger(DedicatedZkClient.class);
    private final ZkClient _rawZkClient;
    private final MetadataStoreRoutingData _metadataStoreRoutingData;
    private final String _zkRealmShardingKey;
    private final RealmAwareZkClient.RealmAwareZkConnectionConfig _connectionConfig;
    private final RealmAwareZkClient.RealmAwareZkClientConfig _clientConfig;

    public DedicatedZkClient(RealmAwareZkClient.RealmAwareZkConnectionConfig connectionConfig, RealmAwareZkClient.RealmAwareZkClientConfig clientConfig) throws IOException, InvalidRoutingDataException {
        if (connectionConfig == null) {
            throw new IllegalArgumentException("RealmAwareZkConnectionConfig cannot be null!");
        }
        if (clientConfig == null) {
            throw new IllegalArgumentException("RealmAwareZkClientConfig cannot be null!");
        }
        this._connectionConfig = connectionConfig;
        this._clientConfig = clientConfig;
        String msdsEndpoint = connectionConfig.getMsdsEndpoint();
        this._metadataStoreRoutingData = msdsEndpoint == null || msdsEndpoint.isEmpty() ? HttpRoutingDataReader.getMetadataStoreRoutingData() : HttpRoutingDataReader.getMetadataStoreRoutingData(msdsEndpoint);
        this._zkRealmShardingKey = connectionConfig.getZkRealmShardingKey();
        if (this._zkRealmShardingKey == null || this._zkRealmShardingKey.isEmpty()) {
            throw new IllegalArgumentException("RealmAwareZkConnectionConfig's ZK realm sharding key cannot be null or empty for DedicatedZkClient!");
        }
        String zkRealmAddress = this._metadataStoreRoutingData.getMetadataStoreRealm(this._zkRealmShardingKey);
        if (zkRealmAddress == null || zkRealmAddress.isEmpty()) {
            throw new IllegalArgumentException("ZK realm address for the given ZK realm sharding key is invalid! ZK realm address: " + zkRealmAddress + " ZK realm sharding key: " + this._zkRealmShardingKey);
        }
        ZkConnection zkConnection = new ZkConnection(zkRealmAddress, connectionConfig.getSessionTimeout());
        this._rawZkClient = new ZkClient(zkConnection, (int)clientConfig.getConnectInitTimeout(), clientConfig.getOperationRetryTimeout(), clientConfig.getZkSerializer(), clientConfig.getMonitorType(), clientConfig.getMonitorKey(), clientConfig.getMonitorInstanceName(), clientConfig.isMonitorRootPathOnly());
    }

    @Override
    public List<String> subscribeChildChanges(String path, IZkChildListener listener) {
        this.checkIfPathContainsShardingKey(path);
        return this._rawZkClient.subscribeChildChanges(path, listener);
    }

    @Override
    public ChildrenSubscribeResult subscribeChildChanges(String path, IZkChildListener listener, boolean skipWatchingNodeNotExist) {
        return this._rawZkClient.subscribeChildChanges(path, listener, skipWatchingNodeNotExist);
    }

    @Override
    public void unsubscribeChildChanges(String path, IZkChildListener listener) {
        this.checkIfPathContainsShardingKey(path);
        this._rawZkClient.unsubscribeChildChanges(path, listener);
    }

    @Override
    public void subscribeDataChanges(String path, IZkDataListener listener) {
        this.checkIfPathContainsShardingKey(path);
        this._rawZkClient.subscribeDataChanges(path, listener);
    }

    @Override
    public boolean subscribeDataChanges(String path, IZkDataListener listener, boolean skipWatchingNodeNotExist) {
        return this._rawZkClient.subscribeDataChanges(path, listener, skipWatchingNodeNotExist);
    }

    @Override
    public void unsubscribeDataChanges(String path, IZkDataListener listener) {
        this.checkIfPathContainsShardingKey(path);
        this._rawZkClient.unsubscribeDataChanges(path, listener);
    }

    @Override
    public void subscribeStateChanges(IZkStateListener listener) {
        this._rawZkClient.subscribeStateChanges(listener);
    }

    @Override
    public void unsubscribeStateChanges(IZkStateListener listener) {
        this._rawZkClient.unsubscribeStateChanges(listener);
    }

    @Override
    public void unsubscribeAll() {
        this._rawZkClient.unsubscribeAll();
    }

    @Override
    public void createPersistent(String path) {
        this.createPersistent(path, false);
    }

    @Override
    public void createPersistent(String path, boolean createParents) {
        this.createPersistent(path, createParents, (List<ACL>)ZooDefs.Ids.OPEN_ACL_UNSAFE);
    }

    @Override
    public void createPersistent(String path, boolean createParents, List<ACL> acl) {
        this.checkIfPathContainsShardingKey(path);
        this._rawZkClient.createPersistent(path, createParents, acl);
    }

    @Override
    public void createPersistent(String path, Object data) {
        this.create(path, data, CreateMode.PERSISTENT);
    }

    @Override
    public void createPersistent(String path, Object data, List<ACL> acl) {
        this.create(path, data, acl, CreateMode.PERSISTENT);
    }

    @Override
    public String createPersistentSequential(String path, Object data) {
        return this.create(path, data, CreateMode.PERSISTENT_SEQUENTIAL);
    }

    @Override
    public String createPersistentSequential(String path, Object data, List<ACL> acl) {
        return this.create(path, data, acl, CreateMode.PERSISTENT_SEQUENTIAL);
    }

    @Override
    public void createEphemeral(String path) {
        this.create(path, null, CreateMode.EPHEMERAL);
    }

    @Override
    public void createEphemeral(String path, String sessionId) {
        this.createEphemeral(path, null, sessionId);
    }

    @Override
    public void createEphemeral(String path, List<ACL> acl) {
        this.create(path, null, acl, CreateMode.EPHEMERAL);
    }

    @Override
    public void createEphemeral(String path, List<ACL> acl, String sessionId) {
        this.checkIfPathContainsShardingKey(path);
        this._rawZkClient.createEphemeral(path, acl, sessionId);
    }

    @Override
    public String create(String path, Object data, CreateMode mode) {
        return this.create(path, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, mode);
    }

    @Override
    public String create(String path, Object datat, List<ACL> acl, CreateMode mode) {
        this.checkIfPathContainsShardingKey(path);
        return this._rawZkClient.create(path, datat, acl, mode);
    }

    @Override
    public void createEphemeral(String path, Object data) {
        this.create(path, data, CreateMode.EPHEMERAL);
    }

    @Override
    public void createEphemeral(String path, Object data, String sessionId) {
        this.checkIfPathContainsShardingKey(path);
        this._rawZkClient.createEphemeral(path, data, sessionId);
    }

    @Override
    public void createEphemeral(String path, Object data, List<ACL> acl) {
        this.create(path, data, acl, CreateMode.EPHEMERAL);
    }

    @Override
    public void createEphemeral(String path, Object data, List<ACL> acl, String sessionId) {
        this.checkIfPathContainsShardingKey(path);
        this._rawZkClient.createEphemeral(path, data, acl, sessionId);
    }

    @Override
    public String createEphemeralSequential(String path, Object data) {
        return this.create(path, data, CreateMode.EPHEMERAL_SEQUENTIAL);
    }

    @Override
    public String createEphemeralSequential(String path, Object data, List<ACL> acl) {
        return this.create(path, data, acl, CreateMode.EPHEMERAL_SEQUENTIAL);
    }

    @Override
    public String createEphemeralSequential(String path, Object data, String sessionId) {
        this.checkIfPathContainsShardingKey(path);
        return this._rawZkClient.createEphemeralSequential(path, data, sessionId);
    }

    @Override
    public String createEphemeralSequential(String path, Object data, List<ACL> acl, String sessionId) {
        this.checkIfPathContainsShardingKey(path);
        return this._rawZkClient.createEphemeralSequential(path, data, acl, sessionId);
    }

    @Override
    public List<String> getChildren(String path) {
        this.checkIfPathContainsShardingKey(path);
        return this._rawZkClient.getChildren(path);
    }

    @Override
    public int countChildren(String path) {
        this.checkIfPathContainsShardingKey(path);
        return this._rawZkClient.countChildren(path);
    }

    @Override
    public boolean exists(String path) {
        this.checkIfPathContainsShardingKey(path);
        return this._rawZkClient.exists(path);
    }

    @Override
    public Stat getStat(String path) {
        this.checkIfPathContainsShardingKey(path);
        return this._rawZkClient.getStat(path);
    }

    @Override
    public boolean waitUntilExists(String path, TimeUnit timeUnit, long time) {
        this.checkIfPathContainsShardingKey(path);
        return this._rawZkClient.waitUntilExists(path, timeUnit, time);
    }

    @Override
    public void deleteRecursively(String path) {
        this.checkIfPathContainsShardingKey(path);
        this._rawZkClient.deleteRecursively(path);
    }

    @Override
    public boolean delete(String path) {
        this.checkIfPathContainsShardingKey(path);
        return this._rawZkClient.delete(path);
    }

    @Override
    public <T> T readData(String path) {
        return this.readData(path, false);
    }

    @Override
    public <T> T readData(String path, boolean returnNullIfPathNotExists) {
        this.checkIfPathContainsShardingKey(path);
        return this._rawZkClient.readData(path, returnNullIfPathNotExists);
    }

    @Override
    public <T> T readData(String path, Stat stat) {
        this.checkIfPathContainsShardingKey(path);
        return this._rawZkClient.readData(path, stat);
    }

    @Override
    public <T> T readData(String path, Stat stat, boolean watch) {
        this.checkIfPathContainsShardingKey(path);
        return this._rawZkClient.readData(path, stat, watch);
    }

    @Override
    public <T> T readDataAndStat(String path, Stat stat, boolean returnNullIfPathNotExists) {
        this.checkIfPathContainsShardingKey(path);
        return this._rawZkClient.readDataAndStat(path, stat, returnNullIfPathNotExists);
    }

    @Override
    public void writeData(String path, Object object) {
        this.writeData(path, object, -1);
    }

    @Override
    public <T> void updateDataSerialized(String path, DataUpdater<T> updater) {
        this.checkIfPathContainsShardingKey(path);
        this._rawZkClient.updateDataSerialized(path, updater);
    }

    @Override
    public void writeData(String path, Object datat, int expectedVersion) {
        this.writeDataReturnStat(path, datat, expectedVersion);
    }

    @Override
    public Stat writeDataReturnStat(String path, Object datat, int expectedVersion) {
        this.checkIfPathContainsShardingKey(path);
        return this._rawZkClient.writeDataReturnStat(path, datat, expectedVersion);
    }

    @Override
    public Stat writeDataGetStat(String path, Object datat, int expectedVersion) {
        return this.writeDataReturnStat(path, datat, expectedVersion);
    }

    @Override
    public void asyncCreate(String path, Object datat, CreateMode mode, ZkAsyncCallbacks.CreateCallbackHandler cb) {
        this.checkIfPathContainsShardingKey(path);
        this._rawZkClient.asyncCreate(path, datat, mode, cb);
    }

    @Override
    public void asyncSetData(String path, Object datat, int version, ZkAsyncCallbacks.SetDataCallbackHandler cb) {
        this.checkIfPathContainsShardingKey(path);
        this._rawZkClient.asyncSetData(path, datat, version, cb);
    }

    @Override
    public void asyncGetData(String path, ZkAsyncCallbacks.GetDataCallbackHandler cb) {
        this.checkIfPathContainsShardingKey(path);
        this._rawZkClient.asyncGetData(path, cb);
    }

    @Override
    public void asyncExists(String path, ZkAsyncCallbacks.ExistsCallbackHandler cb) {
        this.checkIfPathContainsShardingKey(path);
        this._rawZkClient.asyncExists(path, cb);
    }

    @Override
    public void asyncDelete(String path, ZkAsyncCallbacks.DeleteCallbackHandler cb) {
        this.checkIfPathContainsShardingKey(path);
        this._rawZkClient.asyncDelete(path, cb);
    }

    @Override
    public void watchForData(String path) {
        this.checkIfPathContainsShardingKey(path);
        this._rawZkClient.watchForData(path);
    }

    @Override
    public List<String> watchForChilds(String path) {
        this.checkIfPathContainsShardingKey(path);
        return this._rawZkClient.watchForChilds(path);
    }

    @Override
    public long getCreationTime(String path) {
        this.checkIfPathContainsShardingKey(path);
        return this._rawZkClient.getCreationTime(path);
    }

    @Override
    public List<OpResult> multi(Iterable<Op> ops) {
        return this._rawZkClient.multi(ops);
    }

    @Override
    public boolean waitUntilConnected(long time, TimeUnit timeUnit) {
        return this._rawZkClient.waitUntilConnected(time, timeUnit);
    }

    @Override
    public String getServers() {
        return this._rawZkClient.getServers();
    }

    @Override
    public long getSessionId() {
        return this._rawZkClient.getSessionId();
    }

    @Override
    public void close() {
        this._rawZkClient.close();
    }

    @Override
    public boolean isClosed() {
        return this._rawZkClient.isClosed();
    }

    @Override
    public byte[] serialize(Object data, String path) {
        this.checkIfPathContainsShardingKey(path);
        return this._rawZkClient.serialize(data, path);
    }

    @Override
    public <T> T deserialize(byte[] data, String path) {
        this.checkIfPathContainsShardingKey(path);
        return this._rawZkClient.deserialize(data, path);
    }

    @Override
    public void setZkSerializer(ZkSerializer zkSerializer) {
        this._rawZkClient.setZkSerializer(zkSerializer);
    }

    @Override
    public void setZkSerializer(PathBasedZkSerializer zkSerializer) {
        this._rawZkClient.setZkSerializer(zkSerializer);
    }

    @Override
    public PathBasedZkSerializer getZkSerializer() {
        return this._rawZkClient.getZkSerializer();
    }

    @Override
    public RealmAwareZkClient.RealmAwareZkConnectionConfig getRealmAwareZkConnectionConfig() {
        return this._connectionConfig;
    }

    @Override
    public RealmAwareZkClient.RealmAwareZkClientConfig getRealmAwareZkClientConfig() {
        return this._clientConfig;
    }

    private void checkIfPathContainsShardingKey(String path) {
        try {
            String targetShardingKey = this._metadataStoreRoutingData.getShardingKeyInPath(path);
            if (!this._zkRealmShardingKey.equals(targetShardingKey)) {
                throw new IllegalArgumentException("Given path: " + path + "'s ZK sharding key: " + targetShardingKey + " does not match the ZK sharding key: " + this._zkRealmShardingKey + " for this DedicatedZkClient!");
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Given path: " + path + " does not have a valid sharding key or its ZK sharding key is not found in the cached routing data!");
        }
    }
}

