/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.impl.factory;

import java.io.IOException;
import org.apache.helix.msdcommon.exception.InvalidRoutingDataException;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.impl.client.DedicatedZkClient;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.apache.helix.zookeeper.impl.factory.HelixZkClientFactory;

public class DedicatedZkClientFactory
extends HelixZkClientFactory {
    protected DedicatedZkClientFactory() {
    }

    @Override
    public RealmAwareZkClient buildZkClient(RealmAwareZkClient.RealmAwareZkConnectionConfig connectionConfig, RealmAwareZkClient.RealmAwareZkClientConfig clientConfig) throws IOException, InvalidRoutingDataException {
        return new DedicatedZkClient(connectionConfig, clientConfig);
    }

    public static DedicatedZkClientFactory getInstance() {
        return SingletonHelper.INSTANCE;
    }

    @Override
    public HelixZkClient buildZkClient(HelixZkClient.ZkConnectionConfig connectionConfig, HelixZkClient.ZkClientConfig clientConfig) {
        return new ZkClient(this.createZkConnection(connectionConfig), (int)clientConfig.getConnectInitTimeout(), clientConfig.getOperationRetryTimeout(), clientConfig.getZkSerializer(), clientConfig.getMonitorType(), clientConfig.getMonitorKey(), clientConfig.getMonitorInstanceName(), clientConfig.isMonitorRootPathOnly());
    }

    private static class SingletonHelper {
        private static final DedicatedZkClientFactory INSTANCE = new DedicatedZkClientFactory();

        private SingletonHelper() {
        }
    }
}

