/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.api;

import java.util.Map;
import java.util.UUID;
import org.apache.heron.api.Config;
import org.apache.heron.api.generated.TopologyAPI;
import org.apache.heron.api.utils.Utils;

public class HeronTopology {
    private TopologyAPI.Topology.Builder topologyBuilder;
    private String name;
    private TopologyAPI.TopologyState state;
    private Config heronConfig;

    public HeronTopology(TopologyAPI.Topology.Builder topologyBuilder) {
        this.topologyBuilder = topologyBuilder;
    }

    private static void addDefaultTopologyConfig(Map<String, Object> userConfig) {
        if (!userConfig.containsKey("topology.debug")) {
            userConfig.put("topology.debug", "false");
        }
        if (!userConfig.containsKey("topology.stmgrs")) {
            userConfig.put("topology.stmgrs", "1");
        }
        if (!userConfig.containsKey("topology.message.timeout.secs")) {
            userConfig.put("topology.message.timeout.secs", "30");
        }
        if (!userConfig.containsKey("topology.component.parallelism")) {
            userConfig.put("topology.component.parallelism", "1");
        }
        if (!userConfig.containsKey("topology.max.spout.pending")) {
            userConfig.put("topology.max.spout.pending", "100");
        }
        if (!userConfig.containsKey("topology.reliability.mode")) {
            userConfig.put("topology.reliability.mode", String.valueOf((Object)Config.TopologyReliabilityMode.ATMOST_ONCE));
        }
        if (!userConfig.containsKey("topology.enable.message.timeouts")) {
            userConfig.put("topology.enable.message.timeouts", "true");
        }
        if (!userConfig.containsKey("topology.stateful.spill.state")) {
            userConfig.put("topology.stateful.spill.state", "false");
            if (!userConfig.containsKey("topology.stateful.spill.state.location")) {
                userConfig.put("topology.stateful.spill.state.location", "./spilled-state/");
            }
        }
    }

    public TopologyAPI.Topology getTopology() {
        if (this.name == null || this.state == null || this.heronConfig == null) {
            throw new IllegalArgumentException("Failed to build topology; missing necessary info.");
        }
        String topologyId = this.name + UUID.randomUUID().toString();
        this.topologyBuilder.setId(topologyId);
        this.topologyBuilder.setName(this.name);
        this.topologyBuilder.setState(this.state);
        HeronTopology.addDefaultTopologyConfig(this.heronConfig);
        this.heronConfig.put("topology.name", this.name);
        this.topologyBuilder.setTopologyConfig(Utils.getConfigBuilder(this.heronConfig));
        return this.topologyBuilder.build();
    }

    public HeronTopology setName(String topologyName) {
        this.name = topologyName;
        return this;
    }

    public HeronTopology setState(TopologyAPI.TopologyState topologyState) {
        this.state = topologyState;
        return this;
    }

    public HeronTopology setConfig(Config hConfig) {
        this.heronConfig = hConfig;
        return this;
    }
}

