/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.simulator.grouping;

import java.util.List;
import org.apache.heron.api.generated.TopologyAPI;
import org.apache.heron.proto.system.HeronTuples;
import org.apache.heron.simulator.grouping.AllGrouping;
import org.apache.heron.simulator.grouping.CustomGrouping;
import org.apache.heron.simulator.grouping.FieldsGrouping;
import org.apache.heron.simulator.grouping.LowestGrouping;
import org.apache.heron.simulator.grouping.ShuffleGrouping;

public abstract class Grouping {
    protected List<Integer> taskIds;

    public Grouping(List<Integer> taskIds) {
        this.taskIds = taskIds;
    }

    public static Grouping create(TopologyAPI.Grouping grouping, TopologyAPI.InputStream inputStream, TopologyAPI.StreamSchema schema, List<Integer> taskIds) {
        switch (grouping) {
            case SHUFFLE: {
                return new ShuffleGrouping(taskIds);
            }
            case FIELDS: {
                return new FieldsGrouping(inputStream, schema, taskIds);
            }
            case ALL: {
                return new AllGrouping(taskIds);
            }
            case LOWEST: {
                return new LowestGrouping(taskIds);
            }
            case NONE: {
                return new ShuffleGrouping(taskIds);
            }
            case CUSTOM: {
                return new CustomGrouping(taskIds);
            }
            case DIRECT: {
                throw new IllegalArgumentException("Direct Grouping not supported");
            }
        }
        throw new IllegalArgumentException("Unknown Grouping");
    }

    public abstract List<Integer> getListToSend(HeronTuples.HeronDataTuple var1);
}

