/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.api.topology;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.heron.api.bolt.IRichBolt;
import org.apache.heron.api.generated.TopologyAPI;
import org.apache.heron.api.grouping.AllStreamGrouping;
import org.apache.heron.api.grouping.CustomStreamGrouping;
import org.apache.heron.api.grouping.DirectStreamGrouping;
import org.apache.heron.api.grouping.FieldsStreamGrouping;
import org.apache.heron.api.grouping.GlobalStreamGrouping;
import org.apache.heron.api.grouping.NoneStreamGrouping;
import org.apache.heron.api.grouping.ShuffleStreamGrouping;
import org.apache.heron.api.grouping.StreamGrouping;
import org.apache.heron.api.topology.BaseComponentDeclarer;
import org.apache.heron.api.topology.OutputFieldsGetter;
import org.apache.heron.api.tuple.Fields;

public class BoltDeclarer
extends BaseComponentDeclarer<BoltDeclarer> {
    private OutputFieldsGetter output;
    private List<TopologyAPI.InputStream.Builder> inputs = new LinkedList<TopologyAPI.InputStream.Builder>();

    public BoltDeclarer(String name, IRichBolt bolt, Number taskParallelism) {
        super(name, bolt, taskParallelism);
        this.output = new OutputFieldsGetter();
        bolt.declareOutputFields(this.output);
    }

    @Override
    public BoltDeclarer returnThis() {
        return this;
    }

    public void dump(TopologyAPI.Topology.Builder bldr) {
        TopologyAPI.Bolt.Builder boltBldr = TopologyAPI.Bolt.newBuilder();
        TopologyAPI.Component.Builder cbldr = TopologyAPI.Component.newBuilder();
        super.dump(cbldr);
        boltBldr.setComp(cbldr);
        for (TopologyAPI.InputStream.Builder iter : this.inputs) {
            boltBldr.addInputs(iter);
        }
        Map<String, TopologyAPI.StreamSchema.Builder> outs = this.output.getFieldsDeclaration();
        for (Map.Entry<String, TopologyAPI.StreamSchema.Builder> entry : outs.entrySet()) {
            TopologyAPI.OutputStream.Builder obldr = TopologyAPI.OutputStream.newBuilder();
            TopologyAPI.StreamId.Builder sbldr = TopologyAPI.StreamId.newBuilder();
            sbldr.setId(entry.getKey());
            sbldr.setComponentName(this.getName());
            obldr.setStream(sbldr);
            obldr.setSchema(entry.getValue());
            boltBldr.addOutputs(obldr);
        }
        bldr.addBolts(boltBldr);
    }

    public BoltDeclarer fieldsGrouping(String componentName, Fields fields) {
        return this.fieldsGrouping(componentName, "default", fields);
    }

    public BoltDeclarer fieldsGrouping(String componentName, String streamId, Fields fields) {
        return this.grouping(componentName, streamId, new FieldsStreamGrouping(fields));
    }

    public BoltDeclarer globalGrouping(String componentName) {
        return this.globalGrouping(componentName, "default");
    }

    public BoltDeclarer globalGrouping(String componentName, String streamId) {
        return this.grouping(componentName, streamId, new GlobalStreamGrouping());
    }

    public BoltDeclarer shuffleGrouping(String componentName) {
        return this.shuffleGrouping(componentName, "default");
    }

    public BoltDeclarer shuffleGrouping(String componentName, String streamId) {
        return this.grouping(componentName, streamId, new ShuffleStreamGrouping());
    }

    public BoltDeclarer localOrShuffleGrouping(String componentName) {
        return this.localOrShuffleGrouping(componentName, "default");
    }

    public BoltDeclarer localOrShuffleGrouping(String componentName, String streamId) {
        return this.shuffleGrouping(componentName, streamId);
    }

    public BoltDeclarer noneGrouping(String componentName) {
        return this.noneGrouping(componentName, "default");
    }

    public BoltDeclarer noneGrouping(String componentName, String streamId) {
        return this.grouping(componentName, streamId, new NoneStreamGrouping());
    }

    public BoltDeclarer allGrouping(String componentName) {
        return this.allGrouping(componentName, "default");
    }

    public BoltDeclarer allGrouping(String componentName, String streamId) {
        return this.grouping(componentName, streamId, new AllStreamGrouping());
    }

    public BoltDeclarer directGrouping(String componentName) {
        return this.directGrouping(componentName, "default");
    }

    public BoltDeclarer directGrouping(String componentName, String streamId) {
        return this.grouping(componentName, streamId, new DirectStreamGrouping());
    }

    public BoltDeclarer customGrouping(String componentName, CustomStreamGrouping grouper) {
        return this.customGrouping(componentName, "default", grouper);
    }

    public BoltDeclarer customGrouping(String componentName, String streamId, CustomStreamGrouping grouper) {
        return this.grouping(componentName, streamId, grouper);
    }

    public BoltDeclarer grouping(String componentName, StreamGrouping grouper) {
        return this.grouping(componentName, "default", grouper);
    }

    public BoltDeclarer grouping(String componentName, String streamId, StreamGrouping grouper) {
        this.inputs.add(grouper.buildStream(componentName, streamId));
        return this;
    }
}

