/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.api.utils;

public class DefaultMaxSpoutPendingTuner {
    static final long CONSERVATIVE_MAX_SPOUT_PENDING = 10L;
    static final int NOOP_THRESHOLD = 5;
    private Long adjustedMaxSpoutPending;
    private Long initialMaxSpoutPending;
    private Long prevProgress;
    private Long restoreAdjustedMaxSpoutPending;
    private Long restoreProgress;
    private int callsInNoop;
    private ACTION lastAction;
    private float autoTuneFactor;
    private double progressBound;
    private ACTION speculativeAction;

    public DefaultMaxSpoutPendingTuner(float autoTuneFactor, double progressBound) {
        this(null, autoTuneFactor, progressBound);
    }

    public DefaultMaxSpoutPendingTuner(Long maxSpoutPending, float autoTuneFactor, double progressBound) {
        this.adjustedMaxSpoutPending = maxSpoutPending == null ? Long.valueOf(10L) : maxSpoutPending;
        this.initialMaxSpoutPending = this.adjustedMaxSpoutPending;
        this.prevProgress = new Long(-1L);
        this.restoreAdjustedMaxSpoutPending = this.adjustedMaxSpoutPending;
        this.restoreProgress = new Long(-1L);
        this.lastAction = ACTION.NOOP;
        this.callsInNoop = 0;
        this.autoTuneFactor = autoTuneFactor;
        this.progressBound = progressBound;
        this.speculativeAction = ACTION.INCREASE;
    }

    public static boolean similarToNum(Long val, Long prevVal, double bound) {
        return (double)Math.abs(val - prevVal) / (double)prevVal.longValue() < bound;
    }

    public static boolean moreThanNum(Long val, Long prevVal, double bound) {
        if (!DefaultMaxSpoutPendingTuner.similarToNum(val, prevVal, bound)) {
            return val > prevVal;
        }
        return false;
    }

    public static boolean lessThanNum(Long val, Long prevVal, double bound) {
        if (!DefaultMaxSpoutPendingTuner.similarToNum(val, prevVal, bound)) {
            return val < prevVal;
        }
        return false;
    }

    public Long get() {
        return this.adjustedMaxSpoutPending;
    }

    public void autoTune(Long progress) {
        if (this.lastAction == ACTION.NOOP) {
            if (this.prevProgress == -1L) {
                this.doAction(ACTION.INCREASE, this.autoTuneFactor, progress);
            } else if (DefaultMaxSpoutPendingTuner.moreThanNum(progress, this.prevProgress, this.progressBound)) {
                this.doAction(ACTION.INCREASE, this.autoTuneFactor, progress);
            } else if (DefaultMaxSpoutPendingTuner.lessThanNum(progress, this.prevProgress, this.progressBound)) {
                this.doAction(ACTION.DECREASE, Math.max((float)(this.prevProgress - progress) / (float)this.prevProgress.longValue(), this.autoTuneFactor), progress);
            } else {
                ++this.callsInNoop;
                if (this.callsInNoop >= 5) {
                    this.doAction(this.speculativeAction, this.autoTuneFactor, progress);
                    this.speculativeAction = this.speculativeAction == ACTION.INCREASE ? ACTION.DECREASE : ACTION.INCREASE;
                }
            }
        } else if (this.lastAction == ACTION.INCREASE) {
            if (DefaultMaxSpoutPendingTuner.moreThanNum(progress, this.prevProgress, (double)this.autoTuneFactor - this.progressBound)) {
                this.doAction(ACTION.INCREASE, this.autoTuneFactor, progress);
            } else if (DefaultMaxSpoutPendingTuner.lessThanNum(progress, this.prevProgress, this.progressBound)) {
                float drop = Math.max((float)(this.prevProgress - progress) / (float)this.prevProgress.longValue(), this.autoTuneFactor);
                if (drop > this.autoTuneFactor) {
                    this.doAction(ACTION.DECREASE, drop, progress);
                } else {
                    this.doAction(ACTION.RESTORE, this.autoTuneFactor, progress);
                }
            } else {
                this.doAction(ACTION.RESTORE, this.autoTuneFactor, progress);
            }
        } else if (this.lastAction == ACTION.DECREASE) {
            if (DefaultMaxSpoutPendingTuner.moreThanNum(progress, this.prevProgress, this.progressBound)) {
                this.doAction(ACTION.DECREASE, this.autoTuneFactor, progress);
            } else {
                this.doAction(ACTION.NOOP, this.autoTuneFactor, progress);
            }
        } else if (this.lastAction == ACTION.RESTORE) {
            this.doAction(ACTION.NOOP, this.autoTuneFactor, progress);
        }
    }

    void doAction(ACTION action, float factor, Long currentProgress) {
        if (action == ACTION.INCREASE) {
            this.restoreAdjustedMaxSpoutPending = this.adjustedMaxSpoutPending;
            this.restoreProgress = this.prevProgress;
            this.adjustedMaxSpoutPending = this.adjustedMaxSpoutPending + (long)Math.max(1, Math.round(Float.valueOf(factor * (float)this.adjustedMaxSpoutPending.longValue()).floatValue()));
            this.callsInNoop = 0;
            this.prevProgress = currentProgress;
        } else if (action == ACTION.DECREASE) {
            this.restoreAdjustedMaxSpoutPending = this.adjustedMaxSpoutPending;
            this.restoreProgress = this.prevProgress;
            this.adjustedMaxSpoutPending = this.adjustedMaxSpoutPending - (long)Math.max(1, Math.round(Float.valueOf(factor * (float)this.adjustedMaxSpoutPending.longValue()).floatValue()));
            this.adjustedMaxSpoutPending = Math.max(Math.min(10L, this.initialMaxSpoutPending), this.adjustedMaxSpoutPending);
            this.callsInNoop = 0;
            this.prevProgress = currentProgress;
        } else if (action == ACTION.RESTORE) {
            this.adjustedMaxSpoutPending = this.restoreAdjustedMaxSpoutPending;
            this.prevProgress = this.restoreProgress;
            this.callsInNoop = 0;
        } else if (action == ACTION.NOOP) {
            this.prevProgress = currentProgress;
        }
        this.lastAction = action;
    }

    static enum ACTION {
        NOOP,
        INCREASE,
        DECREASE,
        RESTORE;

    }
}

