/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.basics;

import java.io.IOException;
import java.net.ServerSocket;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SysUtils {
    private static final Logger LOG = Logger.getLogger(SysUtils.class.getName());

    private SysUtils() {
    }

    public static void sleep(Duration duration) {
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getFreePort() {
        int n;
        ServerSocket socket = new ServerSocket(0);
        try {
            n = socket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                return -1;
            }
        }
        socket.close();
        return n;
    }

    public static void closeIgnoringExceptions(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, String.format("Failed to close %s", closeable), e);
            }
        }
    }
}

