/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.utils.logging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.heron.common.basics.ByteAmount;

public final class LoggingHelper {
    private static final String FORMAT_PROP_KEY = "java.util.logging.SimpleFormatter.format";
    private static final String DEFAULT_FORMAT = "[%1$tF %1$tT %1$tz] [%4$s] %3$s: %5$s %6$s %n";

    private LoggingHelper() {
    }

    public static void loggerInit(Level level, boolean isRedirectStdOutErr) throws IOException {
        LoggingHelper.loggerInit(level, isRedirectStdOutErr, DEFAULT_FORMAT);
    }

    public static void loggerInit(Level level, boolean isRedirectStdOutErr, String format) throws IOException {
        LoggingHelper.setLoggingFormat(format);
        Logger rootLogger = Logger.getLogger("");
        for (Handler handler : rootLogger.getHandlers()) {
            handler.setLevel(level);
        }
        rootLogger.setLevel(level);
        if (rootLogger.getLevel().intValue() < Level.WARNING.intValue()) {
            Logger.getLogger("org.apache.zookeeper").setLevel(Level.WARNING);
        }
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.log.httpclient.wire", "ERROR");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http", "ERROR");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.headers", "ERROR");
        if (isRedirectStdOutErr) {
            for (Handler handler : rootLogger.getHandlers()) {
                if (!(handler instanceof ConsoleHandler)) continue;
                rootLogger.removeHandler(handler);
            }
            Logger logger = Logger.getLogger("stdout");
            LoggingOutputStream los = new LoggingOutputStream(logger, StdOutErrLevel.STDOUT);
            System.setOut(new PrintStream(los, true));
            logger = Logger.getLogger("stderr");
            los = new LoggingOutputStream(logger, StdOutErrLevel.STDERR);
            System.setErr(new PrintStream(los, true));
        }
    }

    public static void setLoggingFormat(String format) {
        System.setProperty(FORMAT_PROP_KEY, format);
    }

    public static void addLoggingHandler(Handler handler) {
        Logger.getLogger("").addHandler(handler);
    }

    public static FileHandler getFileHandler(String processId, String loggingDir, boolean append, ByteAmount limit, int count) throws IOException, SecurityException {
        String pattern = loggingDir + "/" + processId + ".log.%g";
        FileHandler fileHandler = new FileHandler(pattern, (int)limit.asBytes(), count, append);
        fileHandler.setFormatter(new SimpleFormatter());
        fileHandler.setEncoding(StandardCharsets.UTF_8.toString());
        return fileHandler;
    }

    public static class LoggingOutputStream
    extends ByteArrayOutputStream {
        private String lineSeparator;
        private Logger logger;
        private Level level;

        public LoggingOutputStream(Logger logger, Level level) {
            this.logger = logger;
            this.level = level;
            this.lineSeparator = System.getProperty("line.separator");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            LoggingOutputStream loggingOutputStream = this;
            synchronized (loggingOutputStream) {
                super.flush();
                String record = this.toString();
                super.reset();
                if (record.length() == 0 || record.equals(this.lineSeparator)) {
                    return;
                }
                this.logger.logp(this.level, "", "", record);
            }
        }
    }

    public static final class StdOutErrLevel
    extends Level {
        private static final long serialVersionUID = -3442332825945855738L;
        public static final Level STDOUT = new StdOutErrLevel("STDOUT", Level.INFO.intValue() + 53);
        public static final Level STDERR = new StdOutErrLevel("STDERR", Level.INFO.intValue() + 54);

        private StdOutErrLevel(String name, int value) {
            super(name, value);
        }

        protected Object readResolve() throws ObjectStreamException {
            if (this.intValue() == STDOUT.intValue()) {
                return STDOUT;
            }
            if (this.intValue() == STDERR.intValue()) {
                return STDERR;
            }
            throw new InvalidObjectException("Unknown instance :" + this);
        }
    }
}

