/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.metrics;

import org.apache.heron.api.metric.CountMetric;
import org.apache.heron.api.metric.MeanReducer;
import org.apache.heron.api.metric.MeanReducerState;
import org.apache.heron.api.metric.ReducedMetric;
import org.apache.heron.common.basics.SingletonRegistry;
import org.apache.heron.common.config.SystemConfig;
import org.apache.heron.common.utils.metrics.MetricsCollector;

public class GatewayMetrics {
    private final CountMetric receivedPacketsCount = new CountMetric();
    private final CountMetric sentPacketsCount = new CountMetric();
    private final CountMetric receivedPacketsSize = new CountMetric();
    private final CountMetric sentPacketsSize = new CountMetric();
    private final CountMetric sentMetricsPacketsCount;
    private final CountMetric sentMetricsSize = new CountMetric();
    private final CountMetric sentMetricsCount;
    private final CountMetric sentExceptionsCount;
    private final ReducedMetric<MeanReducerState, Number, Double> inStreamQueueSize;
    private final ReducedMetric<MeanReducerState, Number, Double> outStreamQueueSize;
    private final ReducedMetric<MeanReducerState, Number, Double> inStreamQueueExpectedCapacity;
    private final ReducedMetric<MeanReducerState, Number, Double> outStreamQueueExpectedCapacity;
    private final CountMetric inQueueFullCount;

    public GatewayMetrics() {
        this.sentMetricsPacketsCount = new CountMetric();
        this.sentMetricsCount = new CountMetric();
        this.sentExceptionsCount = new CountMetric();
        this.inStreamQueueSize = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.outStreamQueueSize = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.inStreamQueueExpectedCapacity = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.outStreamQueueExpectedCapacity = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.inQueueFullCount = new CountMetric();
    }

    public void registerMetrics(MetricsCollector metricsCollector) {
        SystemConfig systemConfig = (SystemConfig)SingletonRegistry.INSTANCE.getSingleton(SystemConfig.HERON_SYSTEM_CONFIG);
        int interval = (int)systemConfig.getHeronMetricsExportInterval().getSeconds();
        metricsCollector.registerMetric("__gateway-received-packets-size", this.receivedPacketsSize, interval);
        metricsCollector.registerMetric("__gateway-sent-packets-size", this.sentPacketsSize, interval);
        metricsCollector.registerMetric("__gateway-received-packets-count", this.receivedPacketsCount, interval);
        metricsCollector.registerMetric("__gateway-sent-packets-count", this.sentPacketsCount, interval);
        metricsCollector.registerMetric("__gateway-sent-metrics-size", this.sentMetricsSize, interval);
        metricsCollector.registerMetric("__gateway-sent-metrics-packets-count", this.sentMetricsPacketsCount, interval);
        metricsCollector.registerMetric("__gateway-sent-metrics-count", this.sentMetricsCount, interval);
        metricsCollector.registerMetric("__gateway-sent-exceptions-count", this.sentExceptionsCount, interval);
        metricsCollector.registerMetric("__gateway-in-stream-queue-size", this.inStreamQueueSize, interval);
        metricsCollector.registerMetric("__gateway-out-stream-queue-size", this.outStreamQueueSize, interval);
        metricsCollector.registerMetric("__gateway-in-stream-queue-expected-capacity", this.inStreamQueueExpectedCapacity, interval);
        metricsCollector.registerMetric("__gateway-out-stream-queue-expected-capacity", this.outStreamQueueExpectedCapacity, interval);
        metricsCollector.registerMetric("__gateway-in-queue-full-count", this.inQueueFullCount, interval);
    }

    public void updateReceivedPacketsCount(long count) {
        this.receivedPacketsCount.incrBy(count);
    }

    public void updateSentPacketsCount(long count) {
        this.sentPacketsCount.incrBy(count);
    }

    public void updateReceivedPacketsSize(long size) {
        this.receivedPacketsSize.incrBy(size);
    }

    public void updateSentPacketsSize(long size) {
        this.sentPacketsSize.incrBy(size);
    }

    public void updateSentMetricsSize(long size) {
        this.sentMetricsSize.incrBy(size);
    }

    public void updateSentMetrics(long metricsCount, long exceptionsCount) {
        this.sentMetricsPacketsCount.incr();
        this.sentMetricsCount.incrBy(metricsCount);
        this.sentExceptionsCount.incrBy(exceptionsCount);
    }

    public void setInStreamQueueSize(long size) {
        this.inStreamQueueSize.update(size);
    }

    public void setOutStreamQueueSize(long size) {
        this.outStreamQueueSize.update(size);
    }

    public void setInStreamQueueExpectedCapacity(long capacity) {
        this.inStreamQueueExpectedCapacity.update(capacity);
    }

    public void setOutStreamQueueExpectedCapacity(long capacity) {
        this.outStreamQueueExpectedCapacity.update(capacity);
    }

    public void updateInQueueFullCount() {
        this.inQueueFullCount.incr();
    }
}

