/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet;

import java.time.Duration;
import org.apache.heron.api.bolt.BaseWindowedBolt;
import org.apache.heron.api.tuple.Tuple;
import org.apache.heron.api.windowing.EvictionPolicy;
import org.apache.heron.api.windowing.TriggerPolicy;
import org.apache.heron.streamlet.impl.windowings.CountWindowConfig;
import org.apache.heron.streamlet.impl.windowings.CustomWindowConfig;
import org.apache.heron.streamlet.impl.windowings.TimeWindowConfig;

public interface WindowConfig {
    public void applyTo(BaseWindowedBolt var1);

    public void Dummy();

    public static WindowConfig TumblingTimeWindow(Duration windowDuration) {
        return new TimeWindowConfig(windowDuration, windowDuration);
    }

    public static WindowConfig SlidingTimeWindow(Duration windowDuration, Duration slideInterval) {
        return new TimeWindowConfig(windowDuration, slideInterval);
    }

    public static WindowConfig TumblingCountWindow(int windowSize) {
        return new CountWindowConfig(windowSize, windowSize);
    }

    public static WindowConfig SlidingCountWindow(int windowSize, int slideSize) {
        return new CountWindowConfig(windowSize, slideSize);
    }

    public static WindowConfig CustomWindow(TriggerPolicy<Tuple, ?> triggerPolicy, EvictionPolicy<Tuple, ?> evictionPolicy) {
        return new CustomWindowConfig(triggerPolicy, evictionPolicy);
    }
}

