/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl.operators;

import java.util.HashMap;
import java.util.Map;
import org.apache.heron.api.tuple.Tuple;
import org.apache.heron.api.tuple.Values;
import org.apache.heron.streamlet.KeyValue;
import org.apache.heron.streamlet.SerializableBiFunction;
import org.apache.heron.streamlet.SerializableFunction;
import org.apache.heron.streamlet.impl.operators.StreamletOperator;

public class GeneralReduceByKeyOperator<R, K, T>
extends StreamletOperator<R, KeyValue<K, T>> {
    private SerializableFunction<R, K> keyExtractor;
    private T identity;
    private SerializableBiFunction<T, R, ? extends T> reduceFn;
    private Map<K, T> reduceMap;

    public GeneralReduceByKeyOperator(SerializableFunction<R, K> keyExtractor, T identity, SerializableBiFunction<T, R, ? extends T> reduceFn) {
        this.keyExtractor = keyExtractor;
        this.identity = identity;
        this.reduceFn = reduceFn;
        this.reduceMap = new HashMap<K, T>();
    }

    @Override
    public void execute(Tuple tuple) {
        Object obj = tuple.getValue(0);
        Object key = this.keyExtractor.apply(obj);
        T oldValue = this.reduceMap.getOrDefault(key, this.identity);
        Object newValue = this.reduceFn.apply(oldValue, obj);
        this.reduceMap.put(key, newValue);
        this.collector.emit(new Values(new KeyValue(key, newValue)));
        this.collector.ack(tuple);
    }
}

