/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl.streamlets;

import java.util.Set;
import org.apache.heron.api.topology.TopologyBuilder;
import org.apache.heron.streamlet.KeyValue;
import org.apache.heron.streamlet.SerializableBiFunction;
import org.apache.heron.streamlet.SerializableFunction;
import org.apache.heron.streamlet.impl.StreamletBaseImpl;
import org.apache.heron.streamlet.impl.StreamletImpl;
import org.apache.heron.streamlet.impl.groupings.ReduceByKeyAndWindowCustomGrouping;
import org.apache.heron.streamlet.impl.operators.GeneralReduceByKeyOperator;

public class GeneralReduceByKeyStreamlet<R, K, T>
extends StreamletImpl<KeyValue<K, T>> {
    private StreamletImpl<R> parent;
    private SerializableFunction<R, K> keyExtractor;
    private T identity;
    private SerializableBiFunction<T, R, ? extends T> reduceFn;

    public GeneralReduceByKeyStreamlet(StreamletImpl<R> parent, SerializableFunction<R, K> keyExtractor, T identity, SerializableBiFunction<T, R, ? extends T> reduceFn) {
        this.parent = parent;
        this.keyExtractor = keyExtractor;
        this.identity = identity;
        this.reduceFn = reduceFn;
        this.setNumPartitions(parent.getNumPartitions());
    }

    @Override
    public boolean doBuild(TopologyBuilder bldr, Set<String> stageNames) {
        this.setDefaultNameIfNone(StreamletBaseImpl.StreamletNamePrefix.REDUCE, stageNames);
        GeneralReduceByKeyOperator<R, K, ? extends T> bolt = new GeneralReduceByKeyOperator<R, K, T>(this.keyExtractor, this.identity, this.reduceFn);
        bldr.setBolt(this.getName(), bolt, (Number)this.getNumPartitions()).customGrouping(this.parent.getName(), this.parent.getStreamId(), new ReduceByKeyAndWindowCustomGrouping<R, K>(this.keyExtractor));
        return true;
    }
}

