/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl.streamlets;

import java.util.Set;
import org.apache.heron.api.topology.TopologyBuilder;
import org.apache.heron.streamlet.SerializableFunction;
import org.apache.heron.streamlet.impl.StreamletBaseImpl;
import org.apache.heron.streamlet.impl.StreamletImpl;
import org.apache.heron.streamlet.impl.operators.MapOperator;

public class MapStreamlet<R, T>
extends StreamletImpl<T> {
    private StreamletImpl<R> parent;
    private SerializableFunction<? super R, ? extends T> mapFn;

    public MapStreamlet(StreamletImpl<R> parent, SerializableFunction<? super R, ? extends T> mapFn) {
        this.parent = parent;
        this.mapFn = mapFn;
        this.setNumPartitions(parent.getNumPartitions());
    }

    public StreamletImpl<R> getParent() {
        return this.parent;
    }

    @Override
    public boolean doBuild(TopologyBuilder bldr, Set<String> stageNames) {
        this.setDefaultNameIfNone(StreamletBaseImpl.StreamletNamePrefix.MAP, stageNames);
        bldr.setBolt(this.getName(), new MapOperator<R, T>(this.mapFn), (Number)this.getNumPartitions()).shuffleGrouping(this.parent.getName(), this.parent.getStreamId());
        return true;
    }
}

