/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.serde;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.accumulo.core.data.Mutation;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.accumulo.AccumuloHiveRow;
import org.apache.hadoop.hive.accumulo.LazyAccumuloRow;
import org.apache.hadoop.hive.accumulo.columns.ColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloRowIdColumnMapping;
import org.apache.hadoop.hive.accumulo.serde.AccumuloRowIdFactory;
import org.apache.hadoop.hive.accumulo.serde.AccumuloRowSerializer;
import org.apache.hadoop.hive.accumulo.serde.AccumuloSerDeParameters;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloSerDe
extends AbstractSerDe {
    private AccumuloSerDeParameters accumuloSerDeParameters;
    private LazyAccumuloRow cachedRow;
    private ObjectInspector cachedObjectInspector;
    private AccumuloRowSerializer serializer;
    private static final Logger log = LoggerFactory.getLogger(AccumuloSerDe.class);

    public void initialize(Configuration conf, Properties properties) throws SerDeException {
        this.accumuloSerDeParameters = new AccumuloSerDeParameters(conf, properties, ((Object)((Object)this)).getClass().getName());
        LazySerDeParameters serDeParams = this.accumuloSerDeParameters.getSerDeParameters();
        List<ColumnMapping> mappings = this.accumuloSerDeParameters.getColumnMappings();
        List<TypeInfo> columnTypes = this.accumuloSerDeParameters.getHiveColumnTypes();
        AccumuloRowIdFactory factory = this.accumuloSerDeParameters.getRowIdFactory();
        ArrayList<ObjectInspector> columnObjectInspectors = this.getColumnObjectInspectors(columnTypes, serDeParams, mappings, factory);
        this.cachedObjectInspector = LazyObjectInspectorFactory.getLazySimpleStructObjectInspector((List)serDeParams.getColumnNames(), columnObjectInspectors, (byte)serDeParams.getSeparators()[0], (Text)serDeParams.getNullSequence(), (boolean)serDeParams.isLastColumnTakesRest(), (boolean)serDeParams.isEscaped(), (byte)serDeParams.getEscapeChar());
        this.cachedRow = new LazyAccumuloRow((LazySimpleStructObjectInspector)this.cachedObjectInspector);
        this.serializer = new AccumuloRowSerializer(this.accumuloSerDeParameters.getRowIdOffset(), this.accumuloSerDeParameters.getSerDeParameters(), this.accumuloSerDeParameters.getColumnMappings(), this.accumuloSerDeParameters.getTableVisibilityLabel(), this.accumuloSerDeParameters.getRowIdFactory());
        if (log.isInfoEnabled()) {
            log.info("Initialized with {} type: {}", (Object)this.accumuloSerDeParameters.getSerDeParameters().getColumnNames(), (Object)this.accumuloSerDeParameters.getSerDeParameters().getColumnTypes());
        }
    }

    protected ArrayList<ObjectInspector> getColumnObjectInspectors(List<TypeInfo> columnTypes, LazySerDeParameters serDeParams, List<ColumnMapping> mappings, AccumuloRowIdFactory factory) throws SerDeException {
        ArrayList<ObjectInspector> columnObjectInspectors = new ArrayList<ObjectInspector>(columnTypes.size());
        for (int i = 0; i < columnTypes.size(); ++i) {
            TypeInfo type = columnTypes.get(i);
            ColumnMapping mapping = mappings.get(i);
            if (mapping instanceof HiveAccumuloRowIdColumnMapping) {
                columnObjectInspectors.add(factory.createRowIdObjectInspector(type));
                continue;
            }
            columnObjectInspectors.add(LazyFactory.createLazyObjectInspector((TypeInfo)type, (byte[])serDeParams.getSeparators(), (int)1, (Text)serDeParams.getNullSequence(), (boolean)serDeParams.isEscaped(), (byte)serDeParams.getEscapeChar()));
        }
        return columnObjectInspectors;
    }

    public LazyAccumuloRow getCachedRow() {
        return this.cachedRow;
    }

    public Class<? extends Writable> getSerializedClass() {
        return Mutation.class;
    }

    public Writable serialize(Object o, ObjectInspector objectInspector) throws SerDeException {
        try {
            return this.serializer.serialize(o, objectInspector);
        }
        catch (IOException e) {
            throw new SerDeException((Throwable)e);
        }
    }

    public Object deserialize(Writable writable) throws SerDeException {
        if (!(writable instanceof AccumuloHiveRow)) {
            throw new SerDeException(((Object)((Object)this)).getClass().getName() + " : Expected AccumuloHiveRow. Got " + writable.getClass().getName());
        }
        this.cachedRow.init((AccumuloHiveRow)writable, this.accumuloSerDeParameters.getColumnMappings(), this.accumuloSerDeParameters.getRowIdFactory());
        return this.cachedRow;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.cachedObjectInspector;
    }

    public SerDeStats getSerDeStats() {
        throw new UnsupportedOperationException("SerdeStats not supported.");
    }

    public AccumuloSerDeParameters getParams() {
        return this.accumuloSerDeParameters;
    }

    public boolean getIteratorPushdown() {
        return this.accumuloSerDeParameters.getIteratorPushdown();
    }

    protected AccumuloRowSerializer getSerializer() {
        return this.serializer;
    }
}

