/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

public class HiveSchemaHelper {
    public static final String DB_DERBY = "derby";
    public static final String DB_MSSQL = "mssql";
    public static final String DB_MYSQL = "mysql";
    public static final String DB_POSTGRACE = "postgres";
    public static final String DB_ORACLE = "oracle";

    public static NestedScriptParser getDbCommandParser(String dbName) {
        if (dbName.equalsIgnoreCase(DB_DERBY)) {
            return new DerbyCommandParser();
        }
        if (dbName.equalsIgnoreCase(DB_MSSQL)) {
            return new MSSQLCommandParser();
        }
        if (dbName.equalsIgnoreCase(DB_MYSQL)) {
            return new MySqlCommandParser();
        }
        if (dbName.equalsIgnoreCase(DB_POSTGRACE)) {
            return new PostgresCommandParser();
        }
        if (dbName.equalsIgnoreCase(DB_ORACLE)) {
            return new OracleCommandParser();
        }
        throw new IllegalArgumentException("Unknown dbType " + dbName);
    }

    public static class MSSQLCommandParser
    extends AbstractCommandParser {
        private static String MSSQL_NESTING_TOKEN = ":r";

        @Override
        public String getScriptName(String dbCommand) throws IllegalArgumentException {
            String[] tokens = dbCommand.split(" ");
            if (tokens.length != 2) {
                throw new IllegalArgumentException("Couldn't parse line " + dbCommand);
            }
            return tokens[1];
        }

        @Override
        public boolean isNestedScript(String dbCommand) {
            return dbCommand.startsWith(MSSQL_NESTING_TOKEN);
        }
    }

    public static class OracleCommandParser
    extends AbstractCommandParser {
        private static String ORACLE_NESTING_TOKEN = "@";

        @Override
        public String getScriptName(String dbCommand) throws IllegalArgumentException {
            if (!this.isNestedScript(dbCommand)) {
                throw new IllegalArgumentException("Not a nested script format " + dbCommand);
            }
            return dbCommand.replace(";", "").replace(ORACLE_NESTING_TOKEN, "");
        }

        @Override
        public boolean isNestedScript(String dbCommand) {
            return dbCommand.startsWith(ORACLE_NESTING_TOKEN);
        }
    }

    public static class PostgresCommandParser
    extends AbstractCommandParser {
        private static String POSTGRES_NESTING_TOKEN = "\\i";

        @Override
        public String getScriptName(String dbCommand) throws IllegalArgumentException {
            String[] tokens = dbCommand.split(" ");
            if (tokens.length != 2) {
                throw new IllegalArgumentException("Couldn't parse line " + dbCommand);
            }
            return tokens[1].replace(";", "");
        }

        @Override
        public boolean isNestedScript(String dbCommand) {
            return dbCommand.startsWith(POSTGRES_NESTING_TOKEN);
        }

        @Override
        public boolean needsQuotedIdentifier() {
            return true;
        }
    }

    public static class MySqlCommandParser
    extends AbstractCommandParser {
        private static final String MYSQL_NESTING_TOKEN = "SOURCE";
        private static final String DELIMITER_TOKEN = "DELIMITER";
        private String delimiter = ";";

        @Override
        public boolean isPartialCommand(String dbCommand) throws IllegalArgumentException {
            boolean isPartial = super.isPartialCommand(dbCommand);
            if (dbCommand.startsWith(DELIMITER_TOKEN)) {
                String[] tokens = dbCommand.split(" ");
                if (tokens.length != 2) {
                    throw new IllegalArgumentException("Couldn't parse line " + dbCommand);
                }
                this.delimiter = tokens[1];
            }
            return isPartial;
        }

        @Override
        public String getScriptName(String dbCommand) throws IllegalArgumentException {
            String[] tokens = dbCommand.split(" ");
            if (tokens.length != 2) {
                throw new IllegalArgumentException("Couldn't parse line " + dbCommand);
            }
            return tokens[1].replace(";", "");
        }

        @Override
        public boolean isNestedScript(String dbCommand) {
            return dbCommand.startsWith(MYSQL_NESTING_TOKEN);
        }

        @Override
        public String getDelimiter() {
            return this.delimiter;
        }

        @Override
        public boolean isNonExecCommand(String dbCommand) {
            return super.isNonExecCommand(dbCommand) || dbCommand.startsWith("/*") && dbCommand.endsWith("*/") || dbCommand.startsWith(DELIMITER_TOKEN);
        }

        @Override
        public String cleanseCommand(String dbCommand) {
            return super.cleanseCommand(dbCommand).replaceAll("/\\*.*?\\*/[^;]", "");
        }
    }

    public static class DerbyCommandParser
    extends AbstractCommandParser {
        private static String DERBY_NESTING_TOKEN = "RUN";

        @Override
        public String getScriptName(String dbCommand) throws IllegalArgumentException {
            if (!this.isNestedScript(dbCommand)) {
                throw new IllegalArgumentException("Not a script format " + dbCommand);
            }
            String[] tokens = dbCommand.split(" ");
            if (tokens.length != 2) {
                throw new IllegalArgumentException("Couldn't parse line " + dbCommand);
            }
            return tokens[1].replace(";", "").replaceAll("'", "");
        }

        @Override
        public boolean isNestedScript(String dbCommand) {
            return dbCommand.startsWith(DERBY_NESTING_TOKEN);
        }
    }

    private static abstract class AbstractCommandParser
    implements NestedScriptParser {
        private AbstractCommandParser() {
        }

        @Override
        public boolean isPartialCommand(String dbCommand) throws IllegalArgumentException {
            if (dbCommand == null || dbCommand.isEmpty()) {
                throw new IllegalArgumentException("invalid command line " + dbCommand);
            }
            return !(dbCommand = dbCommand.trim()).endsWith(this.getDelimiter()) && !this.isNonExecCommand(dbCommand);
        }

        @Override
        public boolean isNonExecCommand(String dbCommand) {
            return dbCommand.startsWith("--") || dbCommand.startsWith("#");
        }

        @Override
        public String getDelimiter() {
            return ";";
        }

        @Override
        public String cleanseCommand(String dbCommand) {
            if (dbCommand.endsWith(this.getDelimiter())) {
                dbCommand = dbCommand.substring(0, dbCommand.length() - this.getDelimiter().length());
            }
            return dbCommand;
        }

        @Override
        public boolean needsQuotedIdentifier() {
            return false;
        }
    }

    public static interface NestedScriptParser {
        public static final String DEFAUTL_DELIMITER = ";";

        public boolean isPartialCommand(String var1) throws IllegalArgumentException;

        public String getScriptName(String var1) throws IllegalArgumentException;

        public boolean isNestedScript(String var1);

        public boolean isNonExecCommand(String var1);

        public String getDelimiter();

        public String cleanseCommand(String var1);

        public boolean needsQuotedIdentifier();

        public static enum CommandType {
            PARTIAL_STATEMENT,
            TERMINATED_STATEMENT,
            COMMENT;

        }
    }
}

