/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.ChoiceFormat;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jline.ClassNameCompletor;
import jline.Completor;
import jline.ConsoleReader;
import jline.FileNameCompletor;
import jline.History;
import jline.SimpleCompletor;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.io.IOUtils;
import org.apache.hive.beeline.BeeLineCommandCompletor;
import org.apache.hive.beeline.BeeLineCompletor;
import org.apache.hive.beeline.BeeLineOpts;
import org.apache.hive.beeline.BeeLineSignalHandler;
import org.apache.hive.beeline.BooleanCompletor;
import org.apache.hive.beeline.BufferedRows;
import org.apache.hive.beeline.ColorBuffer;
import org.apache.hive.beeline.CommandHandler;
import org.apache.hive.beeline.Commands;
import org.apache.hive.beeline.DatabaseConnection;
import org.apache.hive.beeline.DatabaseConnections;
import org.apache.hive.beeline.DeprecatedSeparatedValuesOutputFormat;
import org.apache.hive.beeline.IncrementalRows;
import org.apache.hive.beeline.OutputFile;
import org.apache.hive.beeline.OutputFormat;
import org.apache.hive.beeline.ReflectiveCommandHandler;
import org.apache.hive.beeline.Reflector;
import org.apache.hive.beeline.Rows;
import org.apache.hive.beeline.SeparatedValuesOutputFormat;
import org.apache.hive.beeline.TableNameCompletor;
import org.apache.hive.beeline.TableOutputFormat;
import org.apache.hive.beeline.VerticalOutputFormat;
import org.apache.hive.beeline.XMLAttributeOutputFormat;
import org.apache.hive.beeline.XMLElementOutputFormat;

public class BeeLine
implements Closeable {
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(BeeLine.class.getSimpleName());
    private final BeeLineSignalHandler signalHandler = null;
    private static final String separator = System.getProperty("line.separator");
    private boolean exit = false;
    private final DatabaseConnections connections = new DatabaseConnections();
    public static final String COMMAND_PREFIX = "!";
    private final Completor beeLineCommandCompletor;
    private Collection<Driver> drivers = null;
    private final BeeLineOpts opts = new BeeLineOpts(this, System.getProperties());
    private String lastProgress = null;
    private final Map<SQLWarning, Date> seenWarnings = new HashMap<SQLWarning, Date>();
    private final Commands commands = new Commands(this);
    private OutputFile scriptOutputFile = null;
    private OutputFile recordOutputFile = null;
    private PrintStream outputStream = new PrintStream(System.out, true);
    private PrintStream errorStream = new PrintStream(System.err, true);
    private ConsoleReader consoleReader;
    private List<String> batch = null;
    private final Reflector reflector;
    private History history;
    private static final Options options = new Options();
    public static final String BEELINE_DEFAULT_JDBC_DRIVER = "org.apache.hive.jdbc.HiveDriver";
    public static final String BEELINE_DEFAULT_JDBC_URL = "jdbc:hive2://";
    private static final String SCRIPT_OUTPUT_PREFIX = ">>>";
    private static final int SCRIPT_OUTPUT_PAD_SIZE = 5;
    private static final int ERRNO_OK = 0;
    private static final int ERRNO_ARGS = 1;
    private static final int ERRNO_OTHER = 2;
    private static final String HIVE_VAR_PREFIX = "--hivevar";
    private static final String HIVE_CONF_PREFIX = "--hiveconf";
    private final Map<Object, Object> formats = BeeLine.map(new Object[]{"vertical", new VerticalOutputFormat(this), "table", new TableOutputFormat(this), "csv2", new SeparatedValuesOutputFormat(this, ','), "tsv2", new SeparatedValuesOutputFormat(this, '\t'), "dsv", new SeparatedValuesOutputFormat(this, '|'), "csv", new DeprecatedSeparatedValuesOutputFormat(this, ','), "tsv", new DeprecatedSeparatedValuesOutputFormat(this, '\t'), "xmlattr", new XMLAttributeOutputFormat(this), "xmlelements", new XMLElementOutputFormat(this)});
    final CommandHandler[] commandHandlers = new CommandHandler[]{new ReflectiveCommandHandler(this, new String[]{"quit", "done", "exit"}, null), new ReflectiveCommandHandler(this, new String[]{"connect", "open"}, new Completor[]{new SimpleCompletor(this.getConnectionURLExamples())}), new ReflectiveCommandHandler(this, new String[]{"describe"}, new Completor[]{new TableNameCompletor(this)}), new ReflectiveCommandHandler(this, new String[]{"indexes"}, new Completor[]{new TableNameCompletor(this)}), new ReflectiveCommandHandler(this, new String[]{"primarykeys"}, new Completor[]{new TableNameCompletor(this)}), new ReflectiveCommandHandler(this, new String[]{"exportedkeys"}, new Completor[]{new TableNameCompletor(this)}), new ReflectiveCommandHandler(this, new String[]{"manual"}, null), new ReflectiveCommandHandler(this, new String[]{"importedkeys"}, new Completor[]{new TableNameCompletor(this)}), new ReflectiveCommandHandler(this, new String[]{"procedures"}, null), new ReflectiveCommandHandler(this, new String[]{"tables"}, null), new ReflectiveCommandHandler(this, new String[]{"typeinfo"}, null), new ReflectiveCommandHandler(this, new String[]{"columns"}, new Completor[]{new TableNameCompletor(this)}), new ReflectiveCommandHandler(this, new String[]{"reconnect"}, null), new ReflectiveCommandHandler(this, new String[]{"dropall"}, new Completor[]{new TableNameCompletor(this)}), new ReflectiveCommandHandler(this, new String[]{"history"}, null), new ReflectiveCommandHandler(this, new String[]{"metadata"}, new Completor[]{new SimpleCompletor(this.getMetadataMethodNames())}), new ReflectiveCommandHandler(this, new String[]{"nativesql"}, null), new ReflectiveCommandHandler(this, new String[]{"dbinfo"}, null), new ReflectiveCommandHandler(this, new String[]{"rehash"}, null), new ReflectiveCommandHandler(this, new String[]{"verbose"}, null), new ReflectiveCommandHandler(this, new String[]{"run"}, new Completor[]{new FileNameCompletor()}), new ReflectiveCommandHandler(this, new String[]{"batch"}, null), new ReflectiveCommandHandler(this, new String[]{"list"}, null), new ReflectiveCommandHandler(this, new String[]{"all"}, null), new ReflectiveCommandHandler(this, new String[]{"go", "#"}, null), new ReflectiveCommandHandler(this, new String[]{"script"}, new Completor[]{new FileNameCompletor()}), new ReflectiveCommandHandler(this, new String[]{"record"}, new Completor[]{new FileNameCompletor()}), new ReflectiveCommandHandler(this, new String[]{"brief"}, null), new ReflectiveCommandHandler(this, new String[]{"close"}, null), new ReflectiveCommandHandler(this, new String[]{"closeall"}, null), new ReflectiveCommandHandler(this, new String[]{"isolation"}, new Completor[]{new SimpleCompletor(this.getIsolationLevels())}), new ReflectiveCommandHandler(this, new String[]{"outputformat"}, new Completor[]{new SimpleCompletor(this.formats.keySet().toArray(new String[0]))}), new ReflectiveCommandHandler(this, new String[]{"autocommit"}, null), new ReflectiveCommandHandler(this, new String[]{"commit"}, null), new ReflectiveCommandHandler(this, new String[]{"properties"}, new Completor[]{new FileNameCompletor()}), new ReflectiveCommandHandler(this, new String[]{"rollback"}, null), new ReflectiveCommandHandler(this, new String[]{"help", "?"}, null), new ReflectiveCommandHandler(this, new String[]{"set"}, this.getOpts().optionCompletors()), new ReflectiveCommandHandler(this, new String[]{"save"}, null), new ReflectiveCommandHandler(this, new String[]{"scan"}, null), new ReflectiveCommandHandler(this, new String[]{"sql"}, null), new ReflectiveCommandHandler(this, new String[]{"sh"}, null), new ReflectiveCommandHandler(this, new String[]{"call"}, null), new ReflectiveCommandHandler(this, new String[]{"nullemptystring"}, new Completor[]{new BooleanCompletor()})};
    static final SortedSet<String> KNOWN_DRIVERS = new TreeSet<String>(Arrays.asList("org.apache.hive.jdbc.HiveDriver", "org.apache.hadoop.hive.jdbc.HiveDriver"));

    static Manifest getManifest() throws IOException {
        URL base = BeeLine.class.getResource("/META-INF/MANIFEST.MF");
        URLConnection c = base.openConnection();
        if (c instanceof JarURLConnection) {
            return ((JarURLConnection)c).getManifest();
        }
        return null;
    }

    String getManifestAttribute(String name) {
        try {
            Manifest m = BeeLine.getManifest();
            if (m == null) {
                return "??";
            }
            Attributes attrs = m.getAttributes("beeline");
            if (attrs == null) {
                return "???";
            }
            String val = attrs.getValue(name);
            if (val == null || "".equals(val)) {
                return "????";
            }
            return val;
        }
        catch (Exception e) {
            e.printStackTrace(this.errorStream);
            return "?????";
        }
    }

    String getApplicationTitle() {
        Package pack = BeeLine.class.getPackage();
        return this.loc("app-introduction", new Object[]{"Beeline", pack.getImplementationVersion() == null ? "???" : pack.getImplementationVersion(), "Apache Hive"});
    }

    String getApplicationContactInformation() {
        return this.getManifestAttribute("Implementation-Vendor");
    }

    String loc(String res) {
        return this.loc(res, new Object[0]);
    }

    String loc(String res, int param) {
        try {
            return MessageFormat.format(new ChoiceFormat(resourceBundle.getString(res)).format(param), new Integer(param));
        }
        catch (Exception e) {
            return res + ": " + param;
        }
    }

    String loc(String res, Object param1) {
        return this.loc(res, new Object[]{param1});
    }

    String loc(String res, Object param1, Object param2) {
        return this.loc(res, new Object[]{param1, param2});
    }

    String loc(String res, Object[] params) {
        try {
            return MessageFormat.format(resourceBundle.getString(res), params);
        }
        catch (Exception e) {
            e.printStackTrace(this.getErrorStream());
            try {
                return res + ": " + Arrays.asList(params);
            }
            catch (Exception e2) {
                return res;
            }
        }
    }

    protected String locElapsedTime(long milliseconds) {
        if (this.getOpts().getShowElapsedTime()) {
            return this.loc("time-ms", new Object[]{new Double((double)milliseconds / 1000.0)});
        }
        return "";
    }

    public static void main(String[] args) throws IOException {
        BeeLine.mainWithInputRedirection(args, null);
    }

    public static void mainWithInputRedirection(String[] args, InputStream inputStream) throws IOException {
        BeeLine beeLine = new BeeLine();
        int status = beeLine.begin(args, inputStream);
        if (!Boolean.getBoolean("beeline.system.exit")) {
            System.exit(status);
        }
    }

    public BeeLine() {
        this.beeLineCommandCompletor = new BeeLineCommandCompletor(this);
        this.reflector = new Reflector(this);
    }

    DatabaseConnection getDatabaseConnection() {
        return this.getDatabaseConnections().current();
    }

    Connection getConnection() throws SQLException {
        if (this.getDatabaseConnections().current() == null) {
            throw new IllegalArgumentException(this.loc("no-current-connection"));
        }
        if (this.getDatabaseConnections().current().getConnection() == null) {
            throw new IllegalArgumentException(this.loc("no-current-connection"));
        }
        return this.getDatabaseConnections().current().getConnection();
    }

    DatabaseMetaData getDatabaseMetaData() {
        if (this.getDatabaseConnections().current() == null) {
            throw new IllegalArgumentException(this.loc("no-current-connection"));
        }
        if (this.getDatabaseConnections().current().getDatabaseMetaData() == null) {
            throw new IllegalArgumentException(this.loc("no-current-connection"));
        }
        return this.getDatabaseConnections().current().getDatabaseMetaData();
    }

    public String[] getIsolationLevels() {
        return new String[]{"TRANSACTION_NONE", "TRANSACTION_READ_COMMITTED", "TRANSACTION_READ_UNCOMMITTED", "TRANSACTION_REPEATABLE_READ", "TRANSACTION_SERIALIZABLE"};
    }

    public String[] getMetadataMethodNames() {
        try {
            TreeSet<String> mnames = new TreeSet<String>();
            Method[] m = DatabaseMetaData.class.getDeclaredMethods();
            for (int i = 0; m != null && i < m.length; ++i) {
                mnames.add(m[i].getName());
            }
            return mnames.toArray(new String[0]);
        }
        catch (Throwable t) {
            return new String[0];
        }
    }

    public String[] getConnectionURLExamples() {
        return new String[]{"jdbc:JSQLConnect://<hostname>/database=<database>", "jdbc:cloudscape:<database>;create=true", "jdbc:twtds:sqlserver://<hostname>/<database>", "jdbc:daffodilDB_embedded:<database>;create=true", "jdbc:datadirect:db2://<hostname>:50000;databaseName=<database>", "jdbc:inetdae:<hostname>:1433", "jdbc:datadirect:oracle://<hostname>:1521;SID=<database>;MaxPooledStatements=0", "jdbc:datadirect:sqlserver://<hostname>:1433;SelectMethod=cursor;DatabaseName=<database>", "jdbc:datadirect:sybase://<hostname>:5000", "jdbc:db2://<hostname>/<database>", "jdbc:hive2://<hostname>", "jdbc:hsqldb:<database>", "jdbc:idb:<database>.properties", "jdbc:informix-sqli://<hostname>:1526/<database>:INFORMIXSERVER=<database>", "jdbc:interbase://<hostname>//<database>.gdb", "jdbc:microsoft:sqlserver://<hostname>:1433;DatabaseName=<database>;SelectMethod=cursor", "jdbc:mysql://<hostname>/<database>?autoReconnect=true", "jdbc:oracle:thin:@<hostname>:1521:<database>", "jdbc:pointbase:<database>,database.home=<database>,create=true", "jdbc:postgresql://<hostname>:5432/<database>", "jdbc:postgresql:net//<hostname>/<database>", "jdbc:sybase:Tds:<hostname>:4100/<database>?ServiceName=<database>", "jdbc:weblogic:mssqlserver4:<database>@<hostname>:1433", "jdbc:odbc:<database>", "jdbc:sequelink://<hostname>:4003/[Oracle]", "jdbc:sequelink://<hostname>:4004/[Informix];Database=<database>", "jdbc:sequelink://<hostname>:4005/[Sybase];Database=<database>", "jdbc:sequelink://<hostname>:4006/[SQLServer];Database=<database>", "jdbc:sequelink://<hostname>:4011/[ODBC MS Access];Database=<database>", "jdbc:openlink://<hostname>/DSN=SQLServerDB/UID=sa/PWD=", "jdbc:solid://<hostname>:<port>/<UID>/<PWD>", "jdbc:dbaw://<hostname>:8889/<database>"};
    }

    ColorBuffer getColorBuffer() {
        return new ColorBuffer(this.getOpts().getColor());
    }

    ColorBuffer getColorBuffer(String msg) {
        return new ColorBuffer(msg, this.getOpts().getColor());
    }

    int initArgs(String[] args) {
        CommandLine cl;
        List<Object> commands = Collections.emptyList();
        List files = Collections.emptyList();
        try {
            BeelineParser beelineParser = new BeelineParser();
            cl = beelineParser.parse(options, args);
        }
        catch (ParseException e1) {
            this.output(e1.getMessage());
            this.usage();
            return -1;
        }
        String driver = null;
        String user = null;
        String pass = null;
        String url = null;
        String auth = null;
        if (cl.hasOption("help")) {
            this.usage();
            return 0;
        }
        Properties hiveVars = cl.getOptionProperties("hivevar");
        for (String key : hiveVars.stringPropertyNames()) {
            this.getOpts().getHiveVariables().put(key, hiveVars.getProperty(key));
        }
        Properties hiveConfs = cl.getOptionProperties("hiveconf");
        for (String key : hiveConfs.stringPropertyNames()) {
            this.getOpts().getHiveConfVariables().put(key, hiveConfs.getProperty(key));
        }
        driver = cl.getOptionValue("d");
        auth = cl.getOptionValue("a");
        user = cl.getOptionValue("n");
        this.getOpts().setAuthType(auth);
        pass = cl.getOptionValue("p");
        url = cl.getOptionValue("u");
        this.getOpts().setInitFile(cl.getOptionValue("i"));
        this.getOpts().setScriptFile(cl.getOptionValue("f"));
        if (cl.getOptionValues('e') != null) {
            commands = Arrays.asList(cl.getOptionValues('e'));
        }
        if (url != null) {
            String com = "!connect " + url + " " + (user == null || user.length() == 0 ? "''" : user) + " " + (pass == null || pass.length() == 0 ? "''" : pass) + " " + (driver == null ? "" : driver);
            this.debug("issuing: " + com);
            this.dispatch(com);
        }
        Iterator i = files.iterator();
        while (i.hasNext()) {
            this.dispatch("!properties " + (String)i.next());
        }
        int code = 0;
        if (!commands.isEmpty()) {
            Iterator<Object> i2 = commands.iterator();
            while (i2.hasNext()) {
                String command = ((String)i2.next()).toString();
                this.debug(this.loc("executing-command", command));
                if (this.dispatch(command)) continue;
                ++code;
            }
            this.exit = true;
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int begin(String[] args, InputStream inputStream) throws IOException {
        try {
            this.getOpts().load();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            int code = this.initArgs(args);
            if (code != 0) {
                int n = code;
                return n;
            }
            if (this.getOpts().getScriptFile() != null) {
                int n = this.executeFile(this.getOpts().getScriptFile());
                return n;
            }
            try {
                this.info(this.getApplicationTitle());
            }
            catch (Exception e) {
                // empty catch block
            }
            ConsoleReader reader = this.getConsoleReader(inputStream);
            int n = this.execute(reader, false);
            return n;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int runInit() {
        String initFile = this.getOpts().getInitFile();
        if (initFile != null) {
            this.info("Running init script " + initFile);
            try {
                int n = this.executeFile(initFile);
                return n;
            }
            finally {
                this.exit = false;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeFile(String fileName) {
        int n;
        FileInputStream initStream = null;
        try {
            initStream = new FileInputStream(fileName);
            n = this.execute(this.getConsoleReader(initStream), true);
        }
        catch (Throwable t) {
            int n2;
            try {
                this.handleException(t);
                n2 = 2;
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(initStream);
                this.consoleReader = null;
                this.output("");
                throw throwable;
            }
            IOUtils.closeStream((Closeable)initStream);
            this.consoleReader = null;
            this.output("");
            return n2;
        }
        IOUtils.closeStream((Closeable)initStream);
        this.consoleReader = null;
        this.output("");
        return n;
    }

    private int execute(ConsoleReader reader, boolean exitOnError) {
        while (!this.exit) {
            try {
                if (this.dispatch(reader.readLine(this.getPrompt())) || !exitOnError) continue;
                return 2;
            }
            catch (Throwable t) {
                this.handleException(t);
                return 2;
            }
        }
        return 0;
    }

    @Override
    public void close() {
        this.commands.closeall(null);
    }

    public ConsoleReader getConsoleReader(InputStream inputStream) throws IOException {
        this.consoleReader = inputStream != null ? new ConsoleReader(inputStream, (Writer)new PrintWriter(this.getOutputStream(), true)) : new ConsoleReader();
        ByteArrayInputStream historyBuffer = null;
        if (new File(this.getOpts().getHistoryFile()).isFile()) {
            try {
                int n;
                FileInputStream historyIn = new FileInputStream(this.getOpts().getHistoryFile());
                ByteArrayOutputStream hist = new ByteArrayOutputStream();
                while ((n = historyIn.read()) != -1) {
                    hist.write(n);
                }
                historyIn.close();
                historyBuffer = new ByteArrayInputStream(hist.toByteArray());
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        try {
            PrintWriter historyOut = new PrintWriter((Writer)new FileWriter(this.getOpts().getHistoryFile()), true);
            this.consoleReader.getHistory().setOutput(historyOut);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (inputStream instanceof FileInputStream) {
            return this.consoleReader;
        }
        try {
            if (historyBuffer != null) {
                this.consoleReader.getHistory().load(historyBuffer);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.consoleReader.addCompletor((Completor)new BeeLineCompletor(this));
        return this.consoleReader;
    }

    void usage() {
        this.output(this.loc("cmd-usage"));
    }

    boolean dispatch(String line) {
        if (line == null) {
            this.exit = true;
            return true;
        }
        if (line.trim().length() == 0) {
            return true;
        }
        if (this.isComment(line)) {
            return true;
        }
        line = line.trim();
        if (this.scriptOutputFile != null) {
            this.scriptOutputFile.addLine(line);
        }
        if (this.isHelpRequest(line)) {
            line = "!help";
        }
        if (line.startsWith(COMMAND_PREFIX)) {
            TreeMap<String, CommandHandler> cmdMap = new TreeMap<String, CommandHandler>();
            line = line.substring(1);
            for (int i = 0; i < this.commandHandlers.length; ++i) {
                CommandHandler prev;
                String match = this.commandHandlers[i].matches(line);
                if (match == null || (prev = cmdMap.put(match, this.commandHandlers[i])) == null) continue;
                return this.error(this.loc("multiple-matches", Arrays.asList(prev.getName(), this.commandHandlers[i].getName())));
            }
            if (cmdMap.size() == 0) {
                return this.error(this.loc("unknown-command", line));
            }
            if (cmdMap.size() > 1) {
                CommandHandler handler = (CommandHandler)cmdMap.get(line);
                if (handler == null) {
                    return this.error(this.loc("multiple-matches", cmdMap.keySet().toString()));
                }
                return handler.execute(line);
            }
            return ((CommandHandler)cmdMap.values().iterator().next()).execute(line);
        }
        return this.commands.sql(line);
    }

    boolean needsContinuation(String line) {
        if (this.isHelpRequest(line)) {
            return false;
        }
        if (line.startsWith(COMMAND_PREFIX)) {
            return false;
        }
        if (this.isComment(line)) {
            return false;
        }
        String trimmed = line.trim();
        if (trimmed.length() == 0) {
            return false;
        }
        if (!this.getOpts().isAllowMultiLineCommand()) {
            return false;
        }
        return !trimmed.endsWith(";");
    }

    boolean isHelpRequest(String line) {
        return line.equals("?") || line.equalsIgnoreCase("help");
    }

    boolean isComment(String line) {
        String lineTrimmed = line.trim();
        return lineTrimmed.startsWith("#") || lineTrimmed.startsWith("--");
    }

    void output(String msg) {
        this.output(msg, true);
    }

    void info(String msg) {
        if (!this.getOpts().isSilent()) {
            this.output(msg, true, this.getErrorStream());
        }
    }

    void info(ColorBuffer msg) {
        if (!this.getOpts().isSilent()) {
            this.output(msg, true, this.getErrorStream());
        }
    }

    boolean error(String msg) {
        this.output(this.getColorBuffer().red(msg), true, this.getErrorStream());
        return false;
    }

    boolean error(Throwable t) {
        this.handleException(t);
        return false;
    }

    void debug(String msg) {
        if (this.getOpts().getVerbose()) {
            this.output(this.getColorBuffer().blue(msg), true, this.getErrorStream());
        }
    }

    void output(ColorBuffer msg) {
        this.output(msg, true);
    }

    void output(String msg, boolean newline, PrintStream out) {
        this.output(this.getColorBuffer(msg), newline, out);
    }

    void output(ColorBuffer msg, boolean newline) {
        this.output(msg, newline, this.getOutputStream());
    }

    void output(ColorBuffer msg, boolean newline, PrintStream out) {
        if (newline) {
            out.println(msg.getColor());
        } else {
            out.print(msg.getColor());
        }
        if (this.recordOutputFile == null) {
            return;
        }
        if (newline) {
            this.recordOutputFile.addLine(msg.getMono());
        } else {
            this.recordOutputFile.print(msg.getMono());
        }
    }

    void output(String msg, boolean newline) {
        this.output(this.getColorBuffer(msg), newline);
    }

    void autocommitStatus(Connection c) throws SQLException {
        this.info(this.loc("autocommit-status", c.getAutoCommit() + ""));
    }

    boolean assertAutoCommit() {
        if (!this.assertConnection()) {
            return false;
        }
        try {
            if (this.getDatabaseConnection().getConnection().getAutoCommit()) {
                return this.error(this.loc("autocommit-needs-off"));
            }
        }
        catch (Exception e) {
            return this.error(e);
        }
        return true;
    }

    boolean assertConnection() {
        try {
            if (this.getDatabaseConnection() == null || this.getDatabaseConnection().getConnection() == null) {
                return this.error(this.loc("no-current-connection"));
            }
            if (this.getDatabaseConnection().getConnection().isClosed()) {
                return this.error(this.loc("connection-is-closed"));
            }
        }
        catch (SQLException sqle) {
            return this.error(this.loc("no-current-connection"));
        }
        return true;
    }

    void showWarnings() {
        try {
            if (this.getDatabaseConnection().getConnection() == null || !this.getOpts().getVerbose()) {
                return;
            }
            this.showWarnings(this.getDatabaseConnection().getConnection().getWarnings());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    void showWarnings(SQLWarning warn) {
        SQLWarning next;
        if (warn == null) {
            return;
        }
        if (this.seenWarnings.get(warn) == null) {
            this.seenWarnings.put(warn, new Date());
            this.handleSQLException(warn);
        }
        if ((next = warn.getNextWarning()) != warn) {
            this.showWarnings(next);
        }
    }

    String getPrompt() {
        if (this.getDatabaseConnection() == null || this.getDatabaseConnection().getUrl() == null) {
            return "beeline> ";
        }
        String printClosed = this.getDatabaseConnection().isClosed() ? " (closed)" : "";
        return BeeLine.getPrompt(this.getDatabaseConnections().getIndex() + ": " + this.getDatabaseConnection().getUrl()) + printClosed + "> ";
    }

    static String getPrompt(String url) {
        if (url == null || url.length() == 0) {
            url = "beeline";
        }
        if (url.indexOf(";") > -1) {
            url = url.substring(0, url.indexOf(";"));
        }
        if (url.indexOf("?") > -1) {
            url = url.substring(0, url.indexOf("?"));
        }
        if (url.length() > 45) {
            url = url.substring(0, 45);
        }
        return url;
    }

    int getSize(ResultSet rs) {
        try {
            if (rs.getType() == 1003) {
                return -1;
            }
            rs.last();
            int total = rs.getRow();
            rs.beforeFirst();
            return total;
        }
        catch (SQLException sqle) {
            return -1;
        }
        catch (AbstractMethodError ame) {
            return -1;
        }
    }

    ResultSet getColumns(String table) throws SQLException {
        if (!this.assertConnection()) {
            return null;
        }
        return this.getDatabaseConnection().getDatabaseMetaData().getColumns(this.getDatabaseConnection().getDatabaseMetaData().getConnection().getCatalog(), null, table, "%");
    }

    ResultSet getTables() throws SQLException {
        if (!this.assertConnection()) {
            return null;
        }
        return this.getDatabaseConnection().getDatabaseMetaData().getTables(this.getDatabaseConnection().getDatabaseMetaData().getConnection().getCatalog(), null, "%", new String[]{"TABLE"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getColumnNames(DatabaseMetaData meta) throws SQLException {
        HashSet<String> names = new HashSet<String>();
        this.info(this.loc("building-tables"));
        try {
            ResultSet columns = this.getColumns("%");
            try {
                int total = this.getSize(columns);
                int index = 0;
                while (columns.next()) {
                    this.progress(index++, total);
                    String name = columns.getString("TABLE_NAME");
                    names.add(name);
                    names.add(columns.getString("COLUMN_NAME"));
                    names.add(columns.getString("TABLE_NAME") + "." + columns.getString("COLUMN_NAME"));
                }
                this.progress(index, index);
            }
            finally {
                columns.close();
            }
            this.info(this.loc("done"));
            return names.toArray(new String[0]);
        }
        catch (Throwable t) {
            this.handleException(t);
            return new String[0];
        }
    }

    String[] split(String line) {
        return this.split(line, " ");
    }

    String dequote(String str) {
        if (str == null) {
            return null;
        }
        while (str.startsWith("'") && str.endsWith("'") || str.startsWith("\"") && str.endsWith("\"")) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    String[] split(String line, String delim) {
        StringTokenizer tok = new StringTokenizer(line, delim);
        String[] ret = new String[tok.countTokens()];
        int index = 0;
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            t = this.dequote(t);
            ret[index++] = t;
        }
        return ret;
    }

    static Map<Object, Object> map(Object[] obs) {
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        for (int i = 0; i < obs.length - 1; i += 2) {
            m.put(obs[i], obs[i + 1]);
        }
        return Collections.unmodifiableMap(m);
    }

    static boolean getMoreResults(Statement stmnt) {
        try {
            return stmnt.getMoreResults();
        }
        catch (Throwable t) {
            return false;
        }
    }

    static String xmlattrencode(String str) {
        str = BeeLine.replace(str, "\"", "&quot;");
        str = BeeLine.replace(str, "<", "&lt;");
        return str;
    }

    static String replace(String source, String from, String to) {
        if (source == null) {
            return null;
        }
        if (from.equals(to)) {
            return source;
        }
        StringBuilder replaced = new StringBuilder();
        int index = -1;
        while ((index = source.indexOf(from)) != -1) {
            replaced.append(source.substring(0, index));
            replaced.append(to);
            source = source.substring(index + from.length());
        }
        replaced.append(source);
        return replaced.toString();
    }

    String[] split(String line, int assertLen, String usage) {
        String[] ret = this.split(line);
        if (ret.length != assertLen) {
            this.error(usage);
            return null;
        }
        return ret;
    }

    String wrap(String toWrap, int len, int start) {
        StringBuilder buff = new StringBuilder();
        StringBuilder line = new StringBuilder();
        char[] head = new char[start];
        Arrays.fill(head, ' ');
        StringTokenizer tok = new StringTokenizer(toWrap, " ");
        while (tok.hasMoreTokens()) {
            String next = tok.nextToken();
            if (line.length() + next.length() > len) {
                buff.append((CharSequence)line).append(separator).append(head);
                line.setLength(0);
            }
            line.append(line.length() == 0 ? "" : " ").append(next);
        }
        buff.append((CharSequence)line);
        return buff.toString();
    }

    void progress(int cur, int max) {
        StringBuilder out = new StringBuilder();
        if (this.lastProgress != null) {
            char[] back = new char[this.lastProgress.length()];
            Arrays.fill(back, '\b');
            out.append(back);
        }
        String progress = cur + "/" + (max == -1 ? "?" : "" + max) + " " + (max == -1 ? "(??%)" : "(" + cur * 100 / (max == 0 ? 1 : max) + "%)");
        if (cur >= max && max != -1) {
            progress = progress + " " + this.loc("done") + separator;
            this.lastProgress = null;
        } else {
            this.lastProgress = progress;
        }
        out.append(progress);
        this.outputStream.print(out.toString());
        this.outputStream.flush();
    }

    void handleException(Throwable e) {
        while (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        if (e instanceof SQLException) {
            this.handleSQLException((SQLException)e);
        } else if (e instanceof EOFException) {
            this.setExit(true);
        } else if (!this.getOpts().getVerbose()) {
            if (e.getMessage() == null) {
                this.error(e.getClass().getName());
            } else {
                this.error(e.getMessage());
            }
        } else {
            e.printStackTrace(this.getErrorStream());
        }
    }

    void handleSQLException(SQLException e) {
        if (e instanceof SQLWarning && !this.getOpts().getShowWarnings()) {
            return;
        }
        this.error(this.loc(e instanceof SQLWarning ? "Warning" : "Error", new Object[]{e.getMessage() == null ? "" : e.getMessage().trim(), e.getSQLState() == null ? "" : e.getSQLState().trim(), new Integer(e.getErrorCode())}));
        if (this.getOpts().getVerbose()) {
            e.printStackTrace(this.getErrorStream());
        }
        if (!this.getOpts().getShowNestedErrs()) {
            return;
        }
        for (SQLException nested = e.getNextException(); nested != null && nested != e; nested = nested.getNextException()) {
            this.handleSQLException(nested);
        }
    }

    boolean scanForDriver(String url) {
        try {
            if (this.findRegisteredDriver(url) != null) {
                return true;
            }
            this.scanDrivers(true);
            if (this.findRegisteredDriver(url) != null) {
                return true;
            }
            this.scanDrivers(false);
            return this.findRegisteredDriver(url) != null;
        }
        catch (Exception e) {
            this.debug(e.toString());
            return false;
        }
    }

    private Driver findRegisteredDriver(String url) {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers != null && drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                if (!driver.acceptsURL(url)) continue;
                return driver;
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    Driver[] scanDrivers(String line) throws IOException {
        return this.scanDrivers(false);
    }

    Driver[] scanDrivers(boolean knownOnly) throws IOException {
        long start = System.currentTimeMillis();
        HashSet<String> classNames = new HashSet<String>();
        if (!knownOnly) {
            classNames.addAll(Arrays.asList(ClassNameCompletor.getClassNames()));
        }
        classNames.addAll(KNOWN_DRIVERS);
        HashSet driverClasses = new HashSet();
        Iterator i = classNames.iterator();
        while (i.hasNext()) {
            String className = ((String)i.next()).toString();
            if (className.toLowerCase().indexOf("driver") == -1) continue;
            try {
                Class<?> c = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                if (!Driver.class.isAssignableFrom(c) || Modifier.isAbstract(c.getModifiers())) continue;
                driverClasses.add(c.newInstance());
            }
            catch (Throwable t) {}
        }
        this.info("scan complete in " + (System.currentTimeMillis() - start) + "ms");
        return driverClasses.toArray(new Driver[0]);
    }

    private Driver[] scanDriversOLD(String line) {
        long start = System.currentTimeMillis();
        HashSet<String> paths = new HashSet<String>();
        HashSet driverClasses = new HashSet();
        StringTokenizer tok = new StringTokenizer(System.getProperty("java.ext.dirs"), System.getProperty("path.separator"));
        while (tok.hasMoreTokens()) {
            File[] files = new File(tok.nextToken()).listFiles();
            for (int i = 0; files != null && i < files.length; ++i) {
                paths.add(files[i].getAbsolutePath());
            }
        }
        tok = new StringTokenizer(System.getProperty("java.class.path"), System.getProperty("path.separator"));
        while (tok.hasMoreTokens()) {
            paths.add(new File(tok.nextToken()).getAbsolutePath());
        }
        Iterator i = paths.iterator();
        while (i.hasNext()) {
            File f = new File((String)i.next());
            this.output(this.getColorBuffer().pad(this.loc("scanning", f.getAbsolutePath()), 60), false);
            try {
                ZipFile zf = new ZipFile(f);
                int total = zf.size();
                int index = 0;
                Enumeration<? extends ZipEntry> zfEnum = zf.entries();
                while (zfEnum.hasMoreElements()) {
                    ZipEntry entry = zfEnum.nextElement();
                    String name = entry.getName();
                    this.progress(index++, total);
                    if (!name.endsWith(".class")) continue;
                    name = name.replace('/', '.');
                    name = name.substring(0, name.length() - 6);
                    try {
                        Class<?> c;
                        if (name.toLowerCase().indexOf("driver") == -1 || !Driver.class.isAssignableFrom(c = Class.forName(name, false, this.getClass().getClassLoader())) || Modifier.isAbstract(c.getModifiers())) continue;
                        try {
                            Class.forName(name);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        driverClasses.add(c.newInstance());
                    }
                    catch (Throwable t) {}
                }
                this.progress(total, total);
            }
            catch (Exception e) {}
        }
        this.info("scan complete in " + (System.currentTimeMillis() - start) + "ms");
        return driverClasses.toArray(new Driver[0]);
    }

    int print(ResultSet rs) throws SQLException {
        String format = this.getOpts().getOutputFormat();
        OutputFormat f = (OutputFormat)this.formats.get(format);
        if (f == null) {
            this.error(this.loc("unknown-format", new Object[]{format, this.formats.keySet()}));
            f = new TableOutputFormat(this);
        }
        Rows rows = this.getOpts().getIncremental() ? new IncrementalRows(this, rs) : new BufferedRows(this, rs);
        return f.print(rows);
    }

    Statement createStatement() throws SQLException {
        Statement stmnt = this.getDatabaseConnection().getConnection().createStatement();
        if (this.getOpts().timeout > -1) {
            stmnt.setQueryTimeout(this.getOpts().timeout);
        }
        if (this.signalHandler != null) {
            this.signalHandler.setStatement(stmnt);
        }
        return stmnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runBatch(List<String> statements) {
        try {
            Statement stmnt = this.createStatement();
            try {
                Iterator<String> i = statements.iterator();
                while (i.hasNext()) {
                    stmnt.addBatch(i.next().toString());
                }
                int[] counts = stmnt.executeBatch();
                this.output(this.getColorBuffer().pad(this.getColorBuffer().bold("COUNT"), 8).append(this.getColorBuffer().bold("STATEMENT")));
                for (int i2 = 0; counts != null && i2 < counts.length; ++i2) {
                    this.output(this.getColorBuffer().pad(counts[i2] + "", 8).append(statements.get(i2).toString()));
                }
            }
            finally {
                try {
                    stmnt.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public int runCommands(String[] cmds) {
        return this.runCommands(Arrays.asList(cmds));
    }

    public int runCommands(List<String> cmds) {
        int successCount = 0;
        try {
            for (String cmd : cmds) {
                this.info(this.getColorBuffer().pad(SCRIPT_OUTPUT_PREFIX, 5).append(cmd));
                if (this.dispatch(cmd) || this.getOpts().getForce()) {
                    ++successCount;
                    continue;
                }
                this.error(this.loc("abort-on-error", cmd));
                return successCount;
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return successCount;
    }

    void setCompletions() throws SQLException, IOException {
        if (this.getDatabaseConnection() != null) {
            this.getDatabaseConnection().setCompletions(this.getOpts().getFastConnect());
        }
    }

    public BeeLineOpts getOpts() {
        return this.opts;
    }

    DatabaseConnections getDatabaseConnections() {
        return this.connections;
    }

    Completor getCommandCompletor() {
        return this.beeLineCommandCompletor;
    }

    public boolean isExit() {
        return this.exit;
    }

    public void setExit(boolean exit) {
        this.exit = exit;
    }

    Collection<Driver> getDrivers() {
        return this.drivers;
    }

    void setDrivers(Collection<Driver> drivers) {
        this.drivers = drivers;
    }

    public static String getSeparator() {
        return separator;
    }

    Commands getCommands() {
        return this.commands;
    }

    OutputFile getScriptOutputFile() {
        return this.scriptOutputFile;
    }

    void setScriptOutputFile(OutputFile script) {
        this.scriptOutputFile = script;
    }

    OutputFile getRecordOutputFile() {
        return this.recordOutputFile;
    }

    void setRecordOutputFile(OutputFile record) {
        this.recordOutputFile = record;
    }

    public void setOutputStream(PrintStream outputStream) {
        this.outputStream = new PrintStream(outputStream, true);
    }

    PrintStream getOutputStream() {
        return this.outputStream;
    }

    public void setErrorStream(PrintStream errorStream) {
        this.errorStream = new PrintStream(errorStream, true);
    }

    PrintStream getErrorStream() {
        return this.errorStream;
    }

    ConsoleReader getConsoleReader() {
        return this.consoleReader;
    }

    void setConsoleReader(ConsoleReader reader) {
        this.consoleReader = reader;
    }

    List<String> getBatch() {
        return this.batch;
    }

    void setBatch(List<String> batch) {
        this.batch = batch;
    }

    protected Reflector getReflector() {
        return this.reflector;
    }

    static {
        try {
            Class.forName("jline.ConsoleReader");
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError("jline-missing");
        }
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"driver class");
        OptionBuilder.withDescription((String)"the driver class to use");
        options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"database url");
        OptionBuilder.withDescription((String)"the JDBC URL to connect to");
        options.addOption(OptionBuilder.create((char)'u'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"username");
        OptionBuilder.withDescription((String)"the username to connect as");
        options.addOption(OptionBuilder.create((char)'n'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.withDescription((String)"the password to connect as");
        options.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"authType");
        OptionBuilder.withDescription((String)"the authentication type");
        options.addOption(OptionBuilder.create((char)'a'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"init");
        OptionBuilder.withDescription((String)"script file for initialization");
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"query");
        OptionBuilder.withDescription((String)"query that should be executed");
        options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.withDescription((String)"script file that should be executed");
        options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"display this message");
        options.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"key=value");
        OptionBuilder.withLongOpt((String)"hivevar");
        OptionBuilder.withDescription((String)"hive variable name and value");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withLongOpt((String)"hiveconf");
        OptionBuilder.withDescription((String)"Use value for given property");
        options.addOption(OptionBuilder.create());
    }

    public class BeelineParser
    extends GnuParser {
        protected void processOption(String arg, ListIterator iter) throws ParseException {
            if (arg.startsWith("--") && !arg.equals(BeeLine.HIVE_VAR_PREFIX) && !arg.equals(BeeLine.HIVE_CONF_PREFIX) && !arg.equals("--help")) {
                String stripped = arg.substring(2, arg.length());
                String[] parts = BeeLine.this.split(stripped, "=");
                BeeLine.this.debug(BeeLine.this.loc("setting-prop", Arrays.asList(parts)));
                if (parts.length >= 2) {
                    BeeLine.this.getOpts().set(parts[0], parts[1], true);
                } else {
                    BeeLine.this.getOpts().set(parts[0], "true", true);
                }
            } else {
                super.processOption(arg, iter);
            }
        }
    }
}

