/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.OutputFormat;
import org.apache.hive.beeline.Rows;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

class SeparatedValuesOutputFormat
implements OutputFormat {
    private final BeeLine beeLine;
    private CsvPreference csvPreference;

    SeparatedValuesOutputFormat(BeeLine beeLine, char separator) {
        this.beeLine = beeLine;
        this.csvPreference = new CsvPreference.Builder('\"', (int)separator, "").build();
    }

    private void updateCsvPreference() {
        if (this.beeLine.getOpts().getOutputFormat().equals("dsv")) {
            char curDel = (char)this.csvPreference.getDelimiterChar();
            char newDel = this.beeLine.getOpts().getDelimiterForDSV();
            if (newDel != curDel) {
                this.csvPreference = new CsvPreference.Builder('\"', (int)newDel, "").build();
            }
        }
    }

    @Override
    public int print(Rows rows) {
        this.updateCsvPreference();
        int count = 0;
        while (rows.hasNext()) {
            this.printRow(rows, (Rows.Row)rows.next());
            ++count;
        }
        return count - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFormattedStr(String[] vals) {
        StringWriter strWriter = new StringWriter();
        CsvListWriter writer = new CsvListWriter((Writer)strWriter, this.csvPreference);
        if (vals.length > 0) {
            try {
                writer.write(vals);
            }
            catch (IOException e) {
                this.beeLine.error(e);
            }
            finally {
                IOUtils.closeStream((Closeable)writer);
            }
        }
        return strWriter.toString();
    }

    public void printRow(Rows rows, Rows.Row row) {
        String[] vals = row.values;
        String formattedStr = this.getFormattedStr(vals);
        this.beeLine.output(formattedStr);
    }
}

