/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline.logs;

import java.io.PrintStream;
import java.util.List;
import org.apache.hadoop.hive.common.log.InPlaceUpdate;
import org.apache.hadoop.hive.common.log.ProgressMonitor;
import org.apache.hive.jdbc.logs.InPlaceUpdateStream;
import org.apache.hive.service.rpc.thrift.TJobExecutionStatus;
import org.apache.hive.service.rpc.thrift.TProgressUpdateResp;

public class BeelineInPlaceUpdateStream
implements InPlaceUpdateStream {
    private InPlaceUpdate inPlaceUpdate;

    public BeelineInPlaceUpdateStream(PrintStream out) {
        this.inPlaceUpdate = new InPlaceUpdate(out);
    }

    public void update(TProgressUpdateResp response) {
        if (response == null || response.getStatus().equals((Object)TJobExecutionStatus.NOT_AVAILABLE)) {
            return;
        }
        this.inPlaceUpdate.render((ProgressMonitor)new ProgressMonitorWrapper(response));
    }

    static class ProgressMonitorWrapper
    implements ProgressMonitor {
        private TProgressUpdateResp response;

        ProgressMonitorWrapper(TProgressUpdateResp response) {
            this.response = response;
        }

        public List<String> headers() {
            return this.response.getHeaderNames();
        }

        public List<List<String>> rows() {
            return this.response.getRows();
        }

        public String footerSummary() {
            return this.response.getFooterSummary();
        }

        public long startTime() {
            return this.response.getStartTime();
        }

        public String executionStatus() {
            throw new UnsupportedOperationException("This should never be used for anything. All the required data is available via other methods");
        }

        public double progressedPercentage() {
            return this.response.getProgressedPercentage();
        }
    }
}

