/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CliOptionsProcessor {
    private final Options options = new Options();
    private CommandLine commandLine;

    public CliOptionsProcessor() {
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"databasename");
        OptionBuilder.withLongOpt((String)"database");
        OptionBuilder.withDescription((String)"Specify the database to use");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"quoted-query-string");
        OptionBuilder.withDescription((String)"SQL from command line");
        this.options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"filename");
        OptionBuilder.withDescription((String)"SQL from files");
        this.options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"filename");
        OptionBuilder.withDescription((String)"Initialization SQL file");
        this.options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withLongOpt((String)"hiveconf");
        OptionBuilder.withDescription((String)"Use value for given property");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"key=value");
        OptionBuilder.withLongOpt((String)"define");
        OptionBuilder.withDescription((String)"Variable substitution to apply to Hive commands. e.g. -d A=B or --define A=B");
        this.options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"key=value");
        OptionBuilder.withLongOpt((String)"hivevar");
        OptionBuilder.withDescription((String)"Variable substitution to apply to Hive commands. e.g. --hivevar A=B");
        this.options.addOption(OptionBuilder.create());
        this.options.addOption(new Option("S", "silent", false, "Silent mode in interactive shell"));
        this.options.addOption(new Option("v", "verbose", false, "Verbose mode (echo executed SQL to the console)"));
        this.options.addOption(new Option("H", "help", false, "Print help information"));
    }

    public boolean process(String[] argv) {
        try {
            this.commandLine = new GnuParser().parse(this.options, argv);
            if (this.commandLine.hasOption("help")) {
                this.printCliUsage();
                return false;
            }
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            this.printCliUsage();
            return false;
        }
        return true;
    }

    public void printCliUsage() {
        new HelpFormatter().printHelp("hive", this.options);
    }

    public CommandLine getCommandLine() {
        return this.commandLine;
    }

    public void setCommandLine(CommandLine commandLine) {
        this.commandLine = commandLine;
    }
}

