/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cli;

import com.google.common.base.Splitter;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import jline.console.ConsoleReader;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.cli.OptionsProcessor;
import org.apache.hadoop.hive.common.HiveInterruptUtils;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.common.cli.ShellCmdExecutor;
import org.apache.hadoop.hive.common.io.CachingPrintStream;
import org.apache.hadoop.hive.common.io.FetchConverter;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveVariableSource;
import org.apache.hadoop.hive.conf.Validator;
import org.apache.hadoop.hive.conf.VariableSubstitution;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.mr.HadoopJobExecHelper;
import org.apache.hadoop.hive.ql.exec.tez.TezJobExecHelper;
import org.apache.hadoop.hive.ql.parse.HiveParser;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class CliDriver {
    public static String prompt = null;
    public static String prompt2 = null;
    public static final int LINES_TO_FETCH = 40;
    public static final int DELIMITED_CANDIDATE_THRESHOLD = 10;
    public static final String HIVERCFILE = ".hiverc";
    private final SessionState.LogHelper console;
    protected ConsoleReader reader;
    private Configuration conf;

    public CliDriver() {
        SessionState ss = SessionState.get();
        this.conf = ss != null ? ss.getConf() : new Configuration();
        Logger LOG = LoggerFactory.getLogger((String)"CliDriver");
        if (LOG.isDebugEnabled()) {
            LOG.debug("CliDriver inited with classpath {}", (Object)System.getProperty("java.class.path"));
        }
        this.console = new SessionState.LogHelper(LOG);
    }

    public int processCmd(String cmd) {
        CliSessionState ss = (CliSessionState)SessionState.get();
        ss.setLastCommand(cmd);
        ss.updateThreadName();
        ss.err.flush();
        String cmd_trimmed = cmd.trim();
        String[] tokens = this.tokenizeCmd(cmd_trimmed);
        int ret = 0;
        if (cmd_trimmed.toLowerCase().equals("quit") || cmd_trimmed.toLowerCase().equals("exit")) {
            ss.close();
            System.exit(0);
        } else if (tokens[0].equalsIgnoreCase("source")) {
            String cmd_1 = this.getFirstCmd(cmd_trimmed, tokens[0].length());
            cmd_1 = new VariableSubstitution(new HiveVariableSource(){

                public Map<String, String> getHiveVariable() {
                    return SessionState.get().getHiveVariables();
                }
            }).substitute(ss.getConf(), cmd_1);
            File sourceFile = new File(cmd_1);
            if (!sourceFile.isFile()) {
                this.console.printError("File: " + cmd_1 + " is not a file.");
                ret = 1;
            } else {
                try {
                    ret = this.processFile(cmd_1);
                }
                catch (IOException e) {
                    this.console.printError("Failed processing file " + cmd_1 + " " + e.getLocalizedMessage(), org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                    ret = 1;
                }
            }
        } else if (cmd_trimmed.startsWith("!")) {
            String shell_cmd = cmd_trimmed.substring(1);
            shell_cmd = new VariableSubstitution(new HiveVariableSource(){

                public Map<String, String> getHiveVariable() {
                    return SessionState.get().getHiveVariables();
                }
            }).substitute(ss.getConf(), shell_cmd);
            try {
                ShellCmdExecutor executor = new ShellCmdExecutor(shell_cmd, ss.out, ss.err);
                ret = executor.execute();
                if (ret != 0) {
                    this.console.printError("Command failed with exit code = " + ret);
                }
            }
            catch (Exception e) {
                this.console.printError("Exception raised from Shell command " + e.getLocalizedMessage(), org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                ret = 1;
            }
        } else {
            try {
                CommandProcessor proc = CommandProcessorFactory.get((String[])tokens, (HiveConf)((HiveConf)this.conf));
                ret = this.processLocalCmd(cmd, proc, ss);
            }
            catch (SQLException e) {
                this.console.printError("Failed processing command " + tokens[0] + " " + e.getLocalizedMessage(), org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                ret = 1;
            }
        }
        ss.resetThreadName();
        return ret;
    }

    void setConf(Configuration conf) {
        this.conf = conf;
    }

    private String getFirstCmd(String cmd, int length) {
        return cmd.substring(length).trim();
    }

    private String[] tokenizeCmd(String cmd) {
        return cmd.split("\\s+");
    }

    int processLocalCmd(String cmd, CommandProcessor proc, CliSessionState ss) {
        boolean needRetry;
        int tryCount = 0;
        int ret = 0;
        do {
            try {
                CommandProcessorResponse res;
                needRetry = false;
                if (proc == null) continue;
                if (proc instanceof Driver) {
                    Driver qp = (Driver)proc;
                    PrintStream out = ss.out;
                    long start = System.currentTimeMillis();
                    if (ss.getIsVerbose()) {
                        out.println(cmd);
                    }
                    qp.setTryCount(tryCount);
                    ret = qp.run(cmd).getResponseCode();
                    if (ret != 0) {
                        qp.close();
                        return ret;
                    }
                    long end = System.currentTimeMillis();
                    double timeTaken = (double)(end - start) / 1000.0;
                    ArrayList res2 = new ArrayList();
                    this.printHeader(qp, out);
                    int counter = 0;
                    try {
                        if (out instanceof FetchConverter) {
                            ((FetchConverter)out).fetchStarted();
                        }
                        while (qp.getResults(res2)) {
                            for (String r : res2) {
                                out.println(r);
                            }
                            counter += res2.size();
                            res2.clear();
                            if (!out.checkError()) continue;
                            break;
                        }
                    }
                    catch (IOException e) {
                        this.console.printError("Failed with exception " + e.getClass().getName() + ":" + e.getMessage(), "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                        ret = 1;
                    }
                    int cret = qp.close();
                    if (ret == 0) {
                        ret = cret;
                    }
                    if (out instanceof FetchConverter) {
                        ((FetchConverter)out).fetchFinished();
                    }
                    this.console.printInfo("Time taken: " + timeTaken + " seconds" + (counter == 0 ? "" : ", Fetched: " + counter + " row(s)"));
                    continue;
                }
                String firstToken = this.tokenizeCmd(cmd.trim())[0];
                String cmd_1 = this.getFirstCmd(cmd.trim(), firstToken.length());
                if (ss.getIsVerbose()) {
                    ss.out.println(firstToken + " " + cmd_1);
                }
                if ((res = proc.run(cmd_1)).getResponseCode() != 0) {
                    ss.out.println("Query returned non-zero code: " + res.getResponseCode() + ", cause: " + res.getErrorMessage());
                }
                if (res.getConsoleMessages() != null) {
                    for (String consoleMsg : res.getConsoleMessages()) {
                        this.console.printInfo(consoleMsg);
                    }
                }
                ret = res.getResponseCode();
            }
            catch (CommandNeedRetryException e) {
                this.console.printInfo("Retry query with a different approach...");
                ++tryCount;
                needRetry = true;
            }
        } while (needRetry);
        return ret;
    }

    private void printHeader(Driver qp, PrintStream out) {
        List fieldSchemas = qp.getSchema().getFieldSchemas();
        if (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CLI_PRINT_HEADER) && fieldSchemas != null) {
            boolean first_col = true;
            for (FieldSchema fs : fieldSchemas) {
                if (!first_col) {
                    out.print('\t');
                }
                out.print(fs.getName());
                first_col = false;
            }
            out.println();
        }
    }

    public int processLine(String line) {
        return this.processLine(line, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int processLine(String line, boolean allowInterrupting) {
        block10: {
            block8: {
                block9: {
                    oldSignal = null;
                    interruptSignal = null;
                    if (allowInterrupting) {
                        interruptSignal = new Signal("INT");
                        oldSignal = Signal.handle(interruptSignal, new SignalHandler(){
                            private boolean interruptRequested;

                            @Override
                            public void handle(Signal signal) {
                                boolean initialRequest = !this.interruptRequested;
                                this.interruptRequested = true;
                                if (!initialRequest) {
                                    CliDriver.this.console.printInfo("Exiting the JVM");
                                    System.exit(127);
                                }
                                CliDriver.this.console.printInfo("Interrupting... Be patient, this might take some time.");
                                CliDriver.this.console.printInfo("Press Ctrl+C again to kill JVM");
                                HadoopJobExecHelper.killRunningJobs();
                                TezJobExecHelper.killRunningJobs();
                                HiveInterruptUtils.interrupt();
                            }
                        });
                    }
                    try {
                        lastRet = 0;
                        ret = 0;
                        command = "";
                        arr$ = line.split(";");
                        len$ = arr$.length;
                        i$ = 0;
lbl13:
                        // 2 sources

                        while (i$ < len$) {
                            block11: {
                                oneCmd = arr$[i$];
                                if (!StringUtils.endsWith((String)oneCmd, (String)"\\")) break block11;
                                command = command + StringUtils.chop((String)oneCmd) + ";";
                                ** GOTO lbl-1000
                            }
                            if (!StringUtils.isBlank((String)(command = command + oneCmd))) {
                                ret = this.processCmd(command);
                                command = "";
                                lastRet = ret;
                                ignoreErrors = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.CLIIGNOREERRORS);
                                if (ret != 0 && !ignoreErrors) {
                                    CommandProcessorFactory.clean((HiveConf)((HiveConf)this.conf));
                                    var13_14 = ret;
                                    if (oldSignal == null || interruptSignal == null) break block8;
                                    break block9;
                                }
                            }
                            ** GOTO lbl-1000
                        }
                        ** GOTO lbl44
                    }
                    catch (Throwable var14_15) {
                        if (oldSignal != null && interruptSignal != null) {
                            Signal.handle(interruptSignal, oldSignal);
                        }
                        throw var14_15;
                    }
                }
                Signal.handle(interruptSignal, oldSignal);
            }
            return var13_14;
lbl-1000:
            // 2 sources

            {
                ++i$;
                ** GOTO lbl13
lbl44:
                // 1 sources

                CommandProcessorFactory.clean((HiveConf)((HiveConf)this.conf));
                var8_9 = lastRet;
                if (oldSignal == null || interruptSignal == null) break block10;
            }
            Signal.handle(interruptSignal, oldSignal);
        }
        return var8_9;
    }

    public int processReader(BufferedReader r) throws IOException {
        String line;
        StringBuilder qsb = new StringBuilder();
        while ((line = r.readLine()) != null) {
            if (line.startsWith("--")) continue;
            qsb.append(line + "\n");
        }
        return this.processLine(qsb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processFile(String fileName) throws IOException {
        LocalFileSystem fs;
        Path path = new Path(fileName);
        if (!path.toUri().isAbsolute()) {
            fs = FileSystem.getLocal((Configuration)this.conf);
            path = fs.makeQualified(path);
        } else {
            fs = FileSystem.get((URI)path.toUri(), (Configuration)this.conf);
        }
        BufferedReader bufferReader = null;
        int rc = 0;
        try {
            bufferReader = new BufferedReader(new InputStreamReader((InputStream)fs.open(path)));
            rc = this.processReader(bufferReader);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(bufferReader);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)bufferReader);
        return rc;
    }

    public void processInitFiles(CliSessionState ss) throws IOException {
        boolean saveSilent = ss.getIsSilent();
        ss.setIsSilent(true);
        for (String initFile : ss.initFiles) {
            int rc = this.processFile(initFile);
            if (rc == 0) continue;
            System.exit(rc);
        }
        if (ss.initFiles.size() == 0) {
            String hivercUser;
            int rc;
            String hivercDefault;
            if (System.getenv("HIVE_HOME") != null && new File(hivercDefault = System.getenv("HIVE_HOME") + File.separator + "bin" + File.separator + HIVERCFILE).exists()) {
                int rc2 = this.processFile(hivercDefault);
                if (rc2 != 0) {
                    System.exit(rc2);
                }
                this.console.printError("Putting the global hiverc in $HIVE_HOME/bin/.hiverc is deprecated. Please use $HIVE_CONF_DIR/.hiverc instead.");
            }
            if (System.getenv("HIVE_CONF_DIR") != null && new File(hivercDefault = System.getenv("HIVE_CONF_DIR") + File.separator + HIVERCFILE).exists() && (rc = this.processFile(hivercDefault)) != 0) {
                System.exit(rc);
            }
            if (System.getProperty("user.home") != null && new File(hivercUser = System.getProperty("user.home") + File.separator + HIVERCFILE).exists() && (rc = this.processFile(hivercUser)) != 0) {
                System.exit(rc);
            }
        }
        ss.setIsSilent(saveSilent);
    }

    public void processSelectDatabase(CliSessionState ss) throws IOException {
        int rc;
        String database = ss.database;
        if (database != null && (rc = this.processLine("use " + database + ";")) != 0) {
            System.exit(rc);
        }
    }

    public static Completer[] getCommandCompleter() {
        ArrayList<String> candidateStrings = new ArrayList<String>();
        for (String s : FunctionRegistry.getFunctionNames()) {
            if (s.matches("[a-z_]+")) {
                candidateStrings.add(s + "(");
                continue;
            }
            candidateStrings.add(s);
        }
        for (String s : HiveParser.getKeywords()) {
            candidateStrings.add(s);
            candidateStrings.add(s.toLowerCase());
        }
        StringsCompleter strCompleter = new StringsCompleter(candidateStrings);
        ArgumentCompleter.AbstractArgumentDelimiter delim = new ArgumentCompleter.AbstractArgumentDelimiter(){

            public boolean isDelimiterChar(CharSequence buffer, int pos) {
                char c = buffer.charAt(pos);
                return Character.isWhitespace(c) || c == '(' || c == ')' || c == '[' || c == ']';
            }
        };
        final ArgumentCompleter argCompleter = new ArgumentCompleter((ArgumentCompleter.ArgumentDelimiter)delim, new Completer[]{strCompleter});
        argCompleter.setStrict(false);
        Completer customCompletor = new Completer(){

            public int complete(String buffer, int offset, List completions) {
                List comp = completions;
                int ret = argCompleter.complete(buffer, offset, completions);
                if (completions.size() == 1 && ((String)comp.get(0)).endsWith("( ")) {
                    comp.set(0, ((String)comp.get(0)).trim());
                }
                return ret;
            }
        };
        ArrayList<String> vars = new ArrayList<String>();
        for (HiveConf.ConfVars conf : HiveConf.ConfVars.values()) {
            vars.add(conf.varname);
        }
        StringsCompleter confCompleter = new StringsCompleter(vars){

            public int complete(String buffer, int cursor, List<CharSequence> clist) {
                int result = super.complete(buffer, cursor, clist);
                if (clist.isEmpty() && cursor > 1 && buffer.charAt(cursor - 1) == '=') {
                    HiveConf.ConfVars var = HiveConf.getConfVars((String)buffer.substring(0, cursor - 1));
                    if (var == null) {
                        return result;
                    }
                    if (var.getValidator() instanceof Validator.StringSet) {
                        Validator.StringSet validator = (Validator.StringSet)var.getValidator();
                        clist.addAll(validator.getExpected());
                    } else if (var.getValidator() != null) {
                        clist.addAll(Arrays.asList(var.getValidator().toDescription(), ""));
                    } else {
                        clist.addAll(Arrays.asList("Expects " + var.typeString() + " type value", ""));
                    }
                    return cursor;
                }
                if (clist.size() > 10) {
                    LinkedHashSet<CharSequence> delimited = new LinkedHashSet<CharSequence>();
                    for (CharSequence candidate : clist) {
                        Iterator it = Splitter.on((String)".").split(candidate.subSequence(cursor, candidate.length())).iterator();
                        if (it.hasNext()) {
                            String next = (String)it.next();
                            if (next.isEmpty()) {
                                next = ".";
                            }
                            candidate = buffer != null ? buffer.substring(0, cursor) + next : next;
                        }
                        delimited.add(candidate);
                    }
                    clist.clear();
                    clist.addAll(delimited);
                }
                return result;
            }
        };
        StringsCompleter setCompleter = new StringsCompleter(new String[]{"set"}){

            public int complete(String buffer, int cursor, List<CharSequence> clist) {
                return buffer != null && buffer.equals("set") ? super.complete(buffer, cursor, clist) : -1;
            }
        };
        ArgumentCompleter propCompleter = new ArgumentCompleter(new Completer[]{setCompleter, confCompleter}){

            public int complete(String buffer, int offset, List<CharSequence> completions) {
                int ret = super.complete(buffer, offset, completions);
                if (completions.size() == 1) {
                    completions.set(0, ((String)completions.get(0)).trim());
                }
                return ret;
            }
        };
        return new Completer[]{propCompleter, customCompletor};
    }

    public static void main(String[] args) throws Exception {
        int ret = new CliDriver().run(args);
        System.exit(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        String logInitDetailMessage;
        OptionsProcessor oproc = new OptionsProcessor();
        if (!oproc.process_stage1(args)) {
            return 1;
        }
        boolean logInitFailed = false;
        try {
            logInitDetailMessage = LogUtils.initHiveLog4j();
        }
        catch (LogUtils.LogInitializationException e) {
            logInitFailed = true;
            logInitDetailMessage = e.getMessage();
        }
        CliSessionState ss = new CliSessionState(new HiveConf(SessionState.class));
        ss.in = System.in;
        try {
            ss.out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            ss.info = new PrintStream((OutputStream)System.err, true, "UTF-8");
            ss.err = new CachingPrintStream((OutputStream)System.err, true, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return 3;
        }
        if (!oproc.process_stage2(ss)) {
            return 2;
        }
        if (!ss.getIsSilent()) {
            if (logInitFailed) {
                System.err.println(logInitDetailMessage);
            } else {
                SessionState.getConsole().printInfo(logInitDetailMessage);
            }
        }
        HiveConf conf = ss.getConf();
        for (Map.Entry<Object, Object> item : ss.cmdProperties.entrySet()) {
            conf.set((String)item.getKey(), (String)item.getValue());
            ss.getOverriddenConfigurations().put((String)item.getKey(), (String)item.getValue());
        }
        prompt = conf.getVar(HiveConf.ConfVars.CLIPROMPT);
        prompt = new VariableSubstitution(new HiveVariableSource(){

            public Map<String, String> getHiveVariable() {
                return SessionState.get().getHiveVariables();
            }
        }).substitute(conf, prompt);
        prompt2 = CliDriver.spacesForString(prompt);
        if (HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CLI_TEZ_SESSION_ASYNC)) {
            SessionState.beginStart((SessionState)ss, (SessionState.LogHelper)this.console);
        } else {
            SessionState.start((SessionState)ss);
        }
        ss.updateThreadName();
        try {
            int n = this.executeDriver(ss, conf, oproc);
            return n;
        }
        finally {
            ss.resetThreadName();
            ss.close();
        }
    }

    private int executeDriver(CliSessionState ss, HiveConf conf, OptionsProcessor oproc) throws Exception {
        String line;
        CliDriver cli = new CliDriver();
        cli.setHiveVariables(oproc.getHiveVariables());
        cli.processSelectDatabase(ss);
        cli.processInitFiles(ss);
        if (ss.execString != null) {
            int cmdProcessStatus = cli.processLine(ss.execString);
            return cmdProcessStatus;
        }
        try {
            if (ss.fileName != null) {
                return cli.processFile(ss.fileName);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not open input file for reading. (" + e.getMessage() + ")");
            return 3;
        }
        if ("mr".equals(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE))) {
            this.console.printInfo(HiveConf.generateMrDeprecationWarning());
        }
        this.setupConsoleReader();
        int ret = 0;
        String prefix = "";
        String curDB = CliDriver.getFormattedDb(conf, ss);
        String curPrompt = prompt + curDB;
        String dbSpaces = CliDriver.spacesForString(curDB);
        while ((line = this.reader.readLine(curPrompt + "> ")) != null) {
            if (!prefix.equals("")) {
                prefix = prefix + '\n';
            }
            if (line.trim().startsWith("--")) continue;
            if (line.trim().endsWith(";") && !line.trim().endsWith("\\;")) {
                line = prefix + line;
                ret = cli.processLine(line, true);
                prefix = "";
                curDB = CliDriver.getFormattedDb(conf, ss);
                curPrompt = prompt + curDB;
                dbSpaces = dbSpaces.length() == curDB.length() ? dbSpaces : CliDriver.spacesForString(curDB);
                continue;
            }
            prefix = prefix + line;
            curPrompt = prompt2 + dbSpaces;
        }
        return ret;
    }

    private void setupCmdHistory() {
        String HISTORYFILE = ".hivehistory";
        String historyDirectory = System.getProperty("user.home");
        FileHistory history = null;
        try {
            if (new File(historyDirectory).exists()) {
                String historyFile = historyDirectory + File.separator + ".hivehistory";
                history = new FileHistory(new File(historyFile));
                this.reader.setHistory((History)history);
            } else {
                System.err.println("WARNING: Directory for Hive history file: " + historyDirectory + " does not exist.   History will not be available during this session.");
            }
        }
        catch (Exception e) {
            System.err.println("WARNING: Encountered an error while trying to initialize Hive's history file.  History will not be available during this session.");
            System.err.println(e.getMessage());
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                History h = CliDriver.this.reader.getHistory();
                if (h instanceof FileHistory) {
                    try {
                        ((FileHistory)h).flush();
                    }
                    catch (IOException e) {
                        System.err.println("WARNING: Failed to write command history file: " + e.getMessage());
                    }
                }
            }
        }));
    }

    protected void setupConsoleReader() throws IOException {
        this.reader = new ConsoleReader();
        this.reader.setExpandEvents(false);
        this.reader.setBellEnabled(false);
        for (Completer completer : CliDriver.getCommandCompleter()) {
            this.reader.addCompleter(completer);
        }
        this.setupCmdHistory();
    }

    private static String getFormattedDb(HiveConf conf, CliSessionState ss) {
        if (!HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.CLIPRINTCURRENTDB)) {
            return "";
        }
        String currDb = SessionState.get().getCurrentDatabase();
        if (currDb == null) {
            return "";
        }
        return " (" + currDb + ")";
    }

    private static String spacesForString(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        return String.format("%1$-" + s.length() + "s", "");
    }

    public void setHiveVariables(Map<String, String> hiveVariables) {
        SessionState.get().setHiveVariables(hiveVariables);
    }
}

