/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.metrics.metrics2;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.common.metrics.MetricsTestUtils;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.common.metrics.common.MetricsVariable;
import org.apache.hadoop.hive.common.metrics.metrics2.CodahaleMetrics;
import org.apache.hadoop.hive.common.metrics.metrics2.MetricsReporting;
import org.apache.hadoop.hive.conf.HiveConf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCodahaleMetrics {
    private static File workDir = new File(System.getProperty("test.tmp.dir"));
    private static File jsonReportFile;
    public static MetricRegistry metricRegistry;

    @Before
    public void before() throws Exception {
        HiveConf conf = new HiveConf();
        jsonReportFile = new File(workDir, "json_reporting");
        jsonReportFile.delete();
        conf.set("fs.defaultFS", "local");
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_CLASS, CodahaleMetrics.class.getCanonicalName());
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_REPORTER, MetricsReporting.JSON_FILE.name() + "," + MetricsReporting.JMX.name());
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_JSON_FILE_LOCATION, jsonReportFile.toString());
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_JSON_FILE_INTERVAL, "100ms");
        MetricsFactory.init((HiveConf)conf);
        metricRegistry = ((CodahaleMetrics)MetricsFactory.getInstance()).getMetricRegistry();
    }

    @After
    public void after() throws Exception {
        MetricsFactory.close();
    }

    @Test
    public void testScope() throws Exception {
        int runs = 5;
        for (int i = 0; i < runs; ++i) {
            MetricsFactory.getInstance().startStoredScope("method1");
            MetricsFactory.getInstance().endStoredScope("method1");
        }
        Timer timer = (Timer)metricRegistry.getTimers().get("api_method1");
        Assert.assertEquals((long)5L, (long)timer.getCount());
        Assert.assertTrue((timer.getMeanRate() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testCount() throws Exception {
        int runs = 5;
        for (int i = 0; i < runs; ++i) {
            MetricsFactory.getInstance().incrementCounter("count1");
        }
        Counter counter = (Counter)metricRegistry.getCounters().get("count1");
        Assert.assertEquals((long)5L, (long)counter.getCount());
    }

    @Test
    public void testConcurrency() throws Exception {
        int threads = 4;
        ExecutorService executorService = Executors.newFixedThreadPool(threads);
        int i = 0;
        while (i < threads) {
            int n = i++;
            executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    MetricsFactory.getInstance().startStoredScope("method2");
                    MetricsFactory.getInstance().endStoredScope("method2");
                    return null;
                }
            });
        }
        executorService.shutdown();
        Assert.assertTrue((boolean)executorService.awaitTermination(10000L, TimeUnit.MILLISECONDS));
        Timer timer = (Timer)metricRegistry.getTimers().get("api_method2");
        Assert.assertEquals((long)4L, (long)timer.getCount());
        Assert.assertTrue((timer.getMeanRate() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testFileReporting() throws Exception {
        int runs = 5;
        for (int i = 0; i < runs; ++i) {
            MetricsFactory.getInstance().incrementCounter("count2");
        }
        byte[] jsonData = MetricsTestUtils.getFileData(jsonReportFile.getAbsolutePath(), 2000, 3);
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode rootNode = objectMapper.readTree(jsonData);
        JsonNode countersNode = rootNode.path("counters");
        JsonNode methodCounterNode = countersNode.path("count2");
        JsonNode countNode = methodCounterNode.path("count");
        Assert.assertEquals((long)countNode.asInt(), (long)5L);
    }

    @Test
    public void testGauge() throws Exception {
        TestMetricsVariable testVar = new TestMetricsVariable();
        testVar.setValue(20);
        MetricsFactory.getInstance().addGauge("gauge1", (MetricsVariable)testVar);
        String json = ((CodahaleMetrics)MetricsFactory.getInstance()).dumpJson();
        MetricsTestUtils.verifyMetricsJson(json, MetricsTestUtils.GAUGE, "gauge1", testVar.getValue());
        testVar.setValue(40);
        json = ((CodahaleMetrics)MetricsFactory.getInstance()).dumpJson();
        MetricsTestUtils.verifyMetricsJson(json, MetricsTestUtils.GAUGE, "gauge1", testVar.getValue());
    }

    class TestMetricsVariable
    implements MetricsVariable {
        private int gaugeVal;

        TestMetricsVariable() {
        }

        public Object getValue() {
            return this.gaugeVal;
        }

        public void setValue(int gaugeVal) {
            this.gaugeVal = gaugeVal;
        }
    }
}

