/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.type;

import java.math.BigInteger;
import org.apache.hadoop.hive.common.type.SignedInt128;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSignedInt128 {
    private SignedInt128 zero;
    private SignedInt128 one;
    private SignedInt128 two;
    private SignedInt128 negativeOne;
    private SignedInt128 negativeTwo;

    @Before
    public void setUp() throws Exception {
        this.zero = new SignedInt128(0L);
        this.one = new SignedInt128(1L);
        this.two = new SignedInt128(2L);
        this.negativeOne = new SignedInt128(-1L);
        this.negativeTwo = new SignedInt128(-2L);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testHashCode() {
        Assert.assertTrue((this.one.hashCode() != this.two.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((this.zero.hashCode() != this.one.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((this.zero.hashCode() != this.two.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((this.one.hashCode() != this.negativeOne.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((this.two.hashCode() != this.negativeTwo.hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((long)this.zero.hashCode(), (long)new SignedInt128(0L).hashCode());
        Assert.assertEquals((long)this.zero.hashCode(), (long)new SignedInt128(0L).hashCode());
        Assert.assertEquals((long)this.one.hashCode(), (long)new SignedInt128(1L).hashCode());
        Assert.assertEquals((long)this.two.hashCode(), (long)new SignedInt128(2L).hashCode());
    }

    @Test
    public void testEquals() {
        Assert.assertTrue((!this.one.equals(this.two) ? 1 : 0) != 0);
        Assert.assertTrue((!this.zero.equals(this.one) ? 1 : 0) != 0);
        Assert.assertTrue((!this.zero.equals(this.two) ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.zero, (Object)new SignedInt128(0L));
        Assert.assertEquals((Object)this.one, (Object)new SignedInt128(1L));
        Assert.assertEquals((Object)this.two, (Object)new SignedInt128(2L));
        Assert.assertTrue((!this.one.equals(this.negativeOne) ? 1 : 0) != 0);
        Assert.assertTrue((!this.two.equals(this.negativeTwo) ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.zero, (Object)new SignedInt128(0L));
    }

    @Test
    public void testCompareTo() {
        Assert.assertTrue((this.one.compareTo(this.two) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.two.compareTo(this.one) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.one.compareTo(this.zero) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.zero.compareTo(this.two) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.zero.compareTo(this.negativeOne) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.zero.compareTo(this.negativeTwo) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.one.compareTo(this.negativeOne) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.one.compareTo(this.negativeTwo) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.two.compareTo(this.negativeOne) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.two.compareTo(this.negativeTwo) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.negativeOne.compareTo(this.negativeTwo) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.negativeTwo.compareTo(this.negativeOne) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testToFormalString() {
        Assert.assertEquals((Object)"0", (Object)this.zero.toFormalString());
        Assert.assertEquals((Object)"1", (Object)this.one.toFormalString());
        Assert.assertEquals((Object)"-1", (Object)this.negativeOne.toFormalString());
        Assert.assertEquals((Object)"-2", (Object)this.negativeTwo.toFormalString());
        Assert.assertEquals((Object)"30", (Object)new SignedInt128(30L).toFormalString());
        Assert.assertEquals((Object)"680000000000", (Object)new SignedInt128(680000000000L).toFormalString());
        Assert.assertEquals((Object)"6800000000000", (Object)new SignedInt128(6800000000000L).toFormalString());
        Assert.assertEquals((Object)"68", (Object)new SignedInt128(68L).toFormalString());
        Assert.assertEquals((Object)"-30", (Object)new SignedInt128(-30L).toFormalString());
        Assert.assertEquals((Object)"-680000000000", (Object)new SignedInt128(-680000000000L).toFormalString());
        Assert.assertEquals((Object)"-6800000000000", (Object)new SignedInt128(-6800000000000L).toFormalString());
        Assert.assertEquals((Object)"-68", (Object)new SignedInt128(-68L).toFormalString());
        Assert.assertEquals((Object)this.zero, (Object)new SignedInt128("0"));
        Assert.assertEquals((Object)this.one, (Object)new SignedInt128("1"));
        Assert.assertEquals((Object)this.zero, (Object)new SignedInt128("-0"));
        Assert.assertEquals((Object)this.negativeOne, (Object)new SignedInt128("-1"));
        Assert.assertEquals((Object)this.negativeTwo, (Object)new SignedInt128("-2"));
        Assert.assertEquals((Object)new SignedInt128(30L), (Object)new SignedInt128("30"));
        Assert.assertEquals((Object)new SignedInt128(680000000000L), (Object)new SignedInt128("680000000000"));
        Assert.assertEquals((Object)new SignedInt128(6800000000000L), (Object)new SignedInt128("6800000000000"));
        Assert.assertEquals((Object)new SignedInt128(68L), (Object)new SignedInt128("68"));
        Assert.assertEquals((Object)new SignedInt128(-30L), (Object)new SignedInt128("-30"));
        Assert.assertEquals((Object)new SignedInt128(-680000000000L), (Object)new SignedInt128("-680000000000"));
        Assert.assertEquals((Object)new SignedInt128(-6800000000000L), (Object)new SignedInt128("-6800000000000"));
        Assert.assertEquals((Object)new SignedInt128(-68L), (Object)new SignedInt128("-68"));
    }

    @Test
    public void testSignedInt128() {
        Assert.assertEquals((long)0L, (long)new SignedInt128().longValue());
    }

    @Test
    public void testSignedInt128SignedInt128() {
        Assert.assertEquals((long)1L, (long)new SignedInt128(this.one).longValue());
        Assert.assertEquals((long)2L, (long)new SignedInt128(this.two).longValue());
    }

    @Test
    public void testSignedInt128IntIntIntInt() {
        Assert.assertEquals((long)47244640279L, (long)new SignedInt128(23, 11, 0, 0).longValue());
    }

    @Test
    public void testZeroClear() {
        Assert.assertFalse((boolean)this.one.isZero());
        Assert.assertFalse((boolean)this.two.isZero());
        Assert.assertTrue((0L != this.one.longValue() ? 1 : 0) != 0);
        Assert.assertTrue((0L != this.two.longValue() ? 1 : 0) != 0);
        this.two.zeroClear();
        Assert.assertTrue((0L != this.one.longValue() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.two.longValue());
        Assert.assertFalse((boolean)this.one.isZero());
        Assert.assertTrue((boolean)this.two.isZero());
        this.one.zeroClear();
        Assert.assertEquals((long)0L, (long)this.one.longValue());
        Assert.assertEquals((long)0L, (long)this.two.longValue());
        Assert.assertTrue((boolean)this.one.isZero());
        Assert.assertTrue((boolean)this.two.isZero());
    }

    @Test
    public void testAddDestructive() {
        this.one.addDestructive(this.two);
        Assert.assertEquals((long)3L, (long)this.one.longValue());
        Assert.assertEquals((long)2L, (long)this.two.longValue());
        SignedInt128 big = new SignedInt128(0x4000000000000003L);
        SignedInt128 tmp = new SignedInt128(0L);
        for (int i = 0; i < 54; ++i) {
            tmp.addDestructive(big);
        }
        Assert.assertEquals((long)162L, (long)tmp.getV0());
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)tmp.getV1());
        Assert.assertEquals((long)13L, (long)tmp.getV2());
        Assert.assertEquals((long)0L, (long)tmp.getV3());
        Assert.assertEquals((long)0x4000000000000003L, (long)big.longValue());
        SignedInt128 huge = new SignedInt128(this.one);
        huge.shiftLeftDestructive(125);
        SignedInt128 huge2 = new SignedInt128(this.one);
        huge2.shiftLeftDestructive(125);
        try {
            huge2.addDestructive(huge);
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testSubtractDestructive() {
        this.two.subtractDestructive(this.one);
        Assert.assertEquals((long)1L, (long)this.one.longValue());
        Assert.assertEquals((long)1L, (long)this.one.longValue());
        this.one.subtractDestructive(new SignedInt128(10L));
        Assert.assertEquals((long)-9L, (long)this.one.longValue());
        SignedInt128 big = new SignedInt128(4611686069966995459L);
        big.shiftLeftDestructive(6);
        SignedInt128 tmp = new SignedInt128(0x2000000000000005L);
        tmp.shiftLeftDestructive(6);
        big.subtractDestructive(tmp);
        big.subtractDestructive(tmp);
        Assert.assertEquals((long)-448L, (long)big.getV0());
        Assert.assertEquals((long)767L, (long)big.getV1());
        Assert.assertEquals((long)0L, (long)big.getV2());
        Assert.assertEquals((long)0L, (long)big.getV3());
    }

    @Test
    public void testMultiplyDestructiveInt() {
        this.two.multiplyDestructive(1);
        Assert.assertEquals((long)2L, (long)this.two.longValue());
        Assert.assertEquals((long)1L, (long)this.one.longValue());
        this.two.multiplyDestructive(2);
        Assert.assertEquals((long)4L, (long)this.two.longValue());
        SignedInt128 five = new SignedInt128(5L);
        five.multiplyDestructive(6432346);
        Assert.assertEquals((long)32161730L, (long)five.getV0());
        Assert.assertEquals((long)0L, (long)five.getV1());
        Assert.assertEquals((long)0L, (long)five.getV2());
        Assert.assertEquals((long)0L, (long)five.getV3());
        SignedInt128 big = new SignedInt128(4611686069966995459L);
        big.multiplyDestructive(96);
        Assert.assertEquals((long)288L, (long)big.getV0());
        Assert.assertEquals((long)1152L, (long)big.getV1());
        Assert.assertEquals((long)24L, (long)big.getV2());
        Assert.assertEquals((long)0L, (long)big.getV3());
        SignedInt128 tmp = new SignedInt128(1L);
        tmp.shiftLeftDestructive(126);
        try {
            tmp.multiplyDestructive(2);
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testShiftDestructive() {
        SignedInt128 big = new SignedInt128(4611686117211635801L);
        big.shiftLeftDestructive(2);
        Assert.assertEquals((long)356L, (long)big.getV0());
        Assert.assertEquals((long)92L, (long)big.getV1());
        Assert.assertEquals((long)1L, (long)big.getV2());
        Assert.assertEquals((long)0L, (long)big.getV3());
        big.shiftLeftDestructive(32);
        Assert.assertEquals((long)0L, (long)big.getV0());
        Assert.assertEquals((long)356L, (long)big.getV1());
        Assert.assertEquals((long)92L, (long)big.getV2());
        Assert.assertEquals((long)1L, (long)big.getV3());
        big.shiftRightDestructive(2, true);
        Assert.assertEquals((long)0L, (long)big.getV0());
        Assert.assertEquals((long)89L, (long)big.getV1());
        Assert.assertEquals((long)1073741847L, (long)big.getV2());
        Assert.assertEquals((long)0L, (long)big.getV3());
        big.shiftRightDestructive(32, true);
        Assert.assertEquals((long)89L, (long)big.getV0());
        Assert.assertEquals((long)1073741847L, (long)big.getV1());
        Assert.assertEquals((long)0L, (long)big.getV2());
        Assert.assertEquals((long)0L, (long)big.getV3());
        SignedInt128 tmp = new SignedInt128(17L);
        Assert.assertEquals((long)17L, (long)tmp.getV0());
        tmp.shiftRightDestructive(1, true);
        Assert.assertEquals((long)9L, (long)tmp.getV0());
        tmp.shiftRightDestructive(1, false);
        Assert.assertEquals((long)4L, (long)tmp.getV0());
        tmp.shiftRightDestructive(1, true);
        Assert.assertEquals((long)2L, (long)tmp.getV0());
        tmp.shiftRightDestructive(1, true);
        Assert.assertEquals((long)1L, (long)tmp.getV0());
        tmp.shiftRightDestructive(1, true);
        Assert.assertEquals((long)1L, (long)tmp.getV0());
        tmp.shiftRightDestructive(1, false);
        Assert.assertEquals((long)0L, (long)tmp.getV0());
    }

    @Test
    public void testMultiplyDestructiveSignedInt128() {
        this.two.multiplyDestructive(this.one);
        Assert.assertEquals((long)2L, (long)this.two.longValue());
        Assert.assertEquals((long)1L, (long)this.one.longValue());
        this.two.multiplyDestructive(this.two);
        Assert.assertEquals((long)4L, (long)this.two.longValue());
        SignedInt128 five = new SignedInt128(5L);
        five.multiplyDestructive(new SignedInt128(6432346L));
        Assert.assertEquals((long)32161730L, (long)five.getV0());
        Assert.assertEquals((long)0L, (long)five.getV1());
        Assert.assertEquals((long)0L, (long)five.getV2());
        Assert.assertEquals((long)0L, (long)five.getV3());
        SignedInt128 big = new SignedInt128(4611686069966995459L);
        big.multiplyDestructive(new SignedInt128(96L));
        Assert.assertEquals((long)288L, (long)big.getV0());
        Assert.assertEquals((long)1152L, (long)big.getV1());
        Assert.assertEquals((long)24L, (long)big.getV2());
        Assert.assertEquals((long)0L, (long)big.getV3());
        SignedInt128 tmp = new SignedInt128(1L);
        tmp.shiftLeftDestructive(126);
        try {
            tmp.multiplyDestructive(new SignedInt128(2L));
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        SignedInt128 complicated1 = new SignedInt128(-108449846, 1506871725, 87337804, 0);
        BigInteger bigInteger1 = complicated1.toBigIntegerSlow();
        SignedInt128 complicated2 = new SignedInt128(54234234, 9, 0, 0);
        BigInteger bigInteger2 = complicated2.toBigIntegerSlow();
        complicated1.multiplyDestructive(complicated2);
        BigInteger ans = bigInteger1.multiply(bigInteger2);
        Assert.assertEquals((Object)ans, (Object)complicated1.toBigIntegerSlow());
        try {
            SignedInt128 complicated3 = new SignedInt128(-108449846, 1506871725, 87337804, 0);
            complicated3.multiplyDestructive(new SignedInt128(54234234, 9845, 0, 0));
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testDivideDestructiveInt() {
        this.two.divideDestructive(1);
        Assert.assertEquals((long)1L, (long)this.one.longValue());
        Assert.assertEquals((long)2L, (long)this.two.longValue());
        this.one.divideDestructive(2);
        Assert.assertEquals((long)0L, (long)this.one.longValue());
        Assert.assertEquals((long)2L, (long)this.two.longValue());
        SignedInt128 var1 = new SignedInt128(1234234662345L);
        var1.divideDestructive(642337);
        Assert.assertEquals((long)1921475L, (long)var1.longValue());
        SignedInt128 complicated1 = new SignedInt128(-108449846, 1506871725, 87337804, 0);
        BigInteger bigInteger1 = complicated1.toBigIntegerSlow();
        complicated1.divideDestructive(1534223465);
        BigInteger bigInteger2 = BigInteger.valueOf(1534223465L);
        BigInteger ans = bigInteger1.divide(bigInteger2);
        Assert.assertEquals((Object)ans, (Object)complicated1.toBigIntegerSlow());
        try {
            complicated1.divideDestructive(0);
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testDivideDestructiveSignedInt128() {
        SignedInt128 remainder = new SignedInt128();
        this.two.divideDestructive(this.one, remainder);
        Assert.assertEquals((long)1L, (long)this.one.longValue());
        Assert.assertEquals((long)2L, (long)this.two.longValue());
        Assert.assertEquals((Object)this.zero, (Object)remainder);
        this.one.divideDestructive(this.two, remainder);
        Assert.assertEquals((long)0L, (long)this.one.longValue());
        Assert.assertEquals((long)2L, (long)this.two.longValue());
        Assert.assertEquals((Object)new SignedInt128(1L), (Object)remainder);
        SignedInt128 var1 = new SignedInt128(1234234662345L);
        var1.divideDestructive(new SignedInt128(642337L), remainder);
        Assert.assertEquals((long)1921475L, (long)var1.longValue());
        Assert.assertEquals((long)175270L, (long)remainder.longValue());
        SignedInt128 complicated1 = new SignedInt128(-108449846, 1506871725, 87337804, 1111055068);
        SignedInt128 complicated2 = new SignedInt128(-258096742, 4660, 0, 0);
        BigInteger bigInteger1 = complicated1.toBigIntegerSlow();
        BigInteger bigInteger2 = complicated2.toBigIntegerSlow();
        complicated1.divideDestructive(complicated2, remainder);
        BigInteger ans = bigInteger1.divide(bigInteger2);
        Assert.assertEquals((Object)ans, (Object)complicated1.toBigIntegerSlow());
        try {
            complicated1.divideDestructive(this.zero, remainder);
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testDivideDestructiveSignedInt128Again() {
        SignedInt128 complicated1 = new SignedInt128(-108449846, 1506871725, 0, 0);
        SignedInt128 complicated2 = new SignedInt128(-258096742, 3, 0, 0);
        BigInteger bigInteger1 = complicated1.toBigIntegerSlow();
        BigInteger bigInteger2 = complicated2.toBigIntegerSlow();
        complicated1.divideDestructive(complicated2, new SignedInt128());
        BigInteger ans = bigInteger1.divide(bigInteger2);
        Assert.assertEquals((Object)ans, (Object)complicated1.toBigIntegerSlow());
    }
}

