/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.type;

import com.google.code.tempusfugit.concurrency.ConcurrentRule;
import com.google.code.tempusfugit.concurrency.RepeatingRule;
import com.google.code.tempusfugit.concurrency.annotations.Concurrent;
import com.google.code.tempusfugit.concurrency.annotations.Repeating;
import java.util.Random;
import org.apache.hadoop.hive.common.type.HiveBaseChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestHiveVarchar {
    @Rule
    public ConcurrentRule concurrentRule = new ConcurrentRule();
    @Rule
    public RepeatingRule repeatingRule = new RepeatingRule();
    static Random rnd = new Random();

    public static int getRandomSupplementaryChar() {
        int lowSurrogate = 56320 + rnd.nextInt(1024);
        int highSurrogate = 55296;
        return Character.toCodePoint((char)highSurrogate, (char)lowSurrogate);
    }

    public static int getRandomCodePoint() {
        int codePoint = rnd.nextDouble() < 0.5 ? 32 + rnd.nextInt(90) : TestHiveVarchar.getRandomSupplementaryChar();
        if (!Character.isValidCodePoint(codePoint)) {
            System.out.println(Integer.toHexString(codePoint) + " is not a valid code point");
        }
        return codePoint;
    }

    public static int getRandomCodePoint(int excludeChar) {
        int codePoint;
        while ((codePoint = TestHiveVarchar.getRandomCodePoint()) == excludeChar) {
        }
        return codePoint;
    }

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testStringLength() throws Exception {
        String[] testStrings;
        int strLen = 20;
        int[] lengths = new int[]{15, 20, 25};
        for (int idx1 = 0; idx1 < lengths.length; ++idx1) {
            String[] sb = new StringBuilder();
            int curLen = lengths[idx1];
            for (int idx2 = 0; idx2 < curLen; ++idx2) {
                sb.appendCodePoint(TestHiveVarchar.getRandomCodePoint(32));
            }
            String testString = sb.toString();
            Assert.assertEquals((long)curLen, (long)testString.codePointCount(0, testString.length()));
            String enforcedString = HiveBaseChar.enforceMaxLength((String)testString, (int)strLen);
            if (curLen <= strLen) {
                Assert.assertEquals((Object)testString, (Object)enforcedString);
                continue;
            }
            Assert.assertEquals((long)strLen, (long)enforcedString.codePointCount(0, enforcedString.length()));
        }
        for (String testString : testStrings = new String[]{"abcdefg", "abcdefghijklmnopqrst", "abcdefghijklmnopqrstuvwxyz"}) {
            int curLen = testString.length();
            Assert.assertEquals((long)curLen, (long)testString.codePointCount(0, testString.length()));
            String enforcedString = HiveBaseChar.enforceMaxLength((String)testString, (int)strLen);
            if (curLen <= strLen) {
                Assert.assertEquals((Object)testString, (Object)enforcedString);
                continue;
            }
            Assert.assertEquals((long)strLen, (long)enforcedString.codePointCount(0, enforcedString.length()));
        }
        HiveVarchar vc1 = new HiveVarchar("0123456789", 10);
        Assert.assertEquals((long)10L, (long)vc1.getCharacterLength());
        vc1.setValue("012345678901234");
        Assert.assertEquals((long)15L, (long)vc1.getCharacterLength());
        vc1.setValue("01234", -1);
        Assert.assertEquals((long)5L, (long)vc1.getCharacterLength());
        vc1.setValue(new HiveVarchar("0123456789", -1));
        Assert.assertEquals((long)10L, (long)vc1.getCharacterLength());
        vc1.setValue((HiveBaseChar)new HiveVarchar("01234", -1), -1);
        Assert.assertEquals((long)5L, (long)vc1.getCharacterLength());
    }

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testComparison() throws Exception {
        HiveVarchar hc1 = new HiveVarchar("abcd", 20);
        HiveVarchar hc2 = new HiveVarchar("abcd", 20);
        Assert.assertTrue((boolean)hc1.equals((Object)hc2));
        Assert.assertTrue((boolean)hc2.equals((Object)hc1));
        Assert.assertEquals((long)0L, (long)hc1.compareTo(hc2));
        Assert.assertEquals((long)0L, (long)hc2.compareTo(hc1));
        hc2 = new HiveVarchar("abcde", 20);
        Assert.assertFalse((boolean)hc1.equals((Object)hc2));
        Assert.assertFalse((boolean)hc2.equals((Object)hc1));
        Assert.assertFalse((0 == hc1.compareTo(hc2) ? 1 : 0) != 0);
        Assert.assertFalse((0 == hc2.compareTo(hc1) ? 1 : 0) != 0);
        hc2 = new HiveVarchar("abcd  ", 30);
        Assert.assertFalse((boolean)hc1.equals((Object)hc2));
        Assert.assertFalse((boolean)hc2.equals((Object)hc1));
        Assert.assertFalse((0 == hc1.compareTo(hc2) ? 1 : 0) != 0);
        Assert.assertFalse((0 == hc2.compareTo(hc1) ? 1 : 0) != 0);
        hc2 = new HiveVarchar("  abcd", 20);
        Assert.assertFalse((boolean)hc1.equals((Object)hc2));
        Assert.assertFalse((boolean)hc2.equals((Object)hc1));
        Assert.assertFalse((0 == hc1.compareTo(hc2) ? 1 : 0) != 0);
        Assert.assertFalse((0 == hc2.compareTo(hc1) ? 1 : 0) != 0);
    }
}

