/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import java.util.Arrays;
import org.apache.hive.common.util.HiveStringUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveStringUtils {
    @Test
    public void testSplitAndUnEscape() throws Exception {
        this.splitAndUnEscapeTestCase(null, null);
        this.splitAndUnEscapeTestCase("'single element'", new String[]{"'single element'"});
        this.splitAndUnEscapeTestCase("yyyy-MM-dd'T'HH:mm:ss,yyyy-MM-dd'T'HH:mm:ss.S", new String[]{"yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.S"});
        this.splitAndUnEscapeTestCase("single\\,element", new String[]{"single,element"});
        this.splitAndUnEscapeTestCase("element\\,one\\\\,element\\\\two\\\\\\,", new String[]{"element,one\\", "element\\two\\,"});
    }

    public void splitAndUnEscapeTestCase(String testValue, String[] expectedResults) throws Exception {
        Object[] testResults = HiveStringUtils.splitAndUnEscape((String)testValue);
        Assert.assertTrue((String)(Arrays.toString(expectedResults) + " == " + Arrays.toString(testResults)), (boolean)Arrays.equals(expectedResults, testResults));
    }
}

