/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.contrib.udaf.example;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;

@Description(name="example_group_concat", value="_FUNC_(col) - Example UDAF that concatenates all arguments from different rows into a single string")
public class UDAFExampleGroupConcat
extends UDAF {

    public static class UDAFExampleGroupConcatEvaluator
    implements UDAFEvaluator {
        ArrayList<String> data = new ArrayList();

        public void init() {
            this.data.clear();
        }

        public boolean iterate(String[] o) {
            if (o != null) {
                StringBuilder sb = new StringBuilder();
                for (String element : o) {
                    sb.append(element);
                }
                this.data.add(sb.toString());
            }
            return true;
        }

        public ArrayList<String> terminatePartial() {
            return this.data;
        }

        public boolean merge(ArrayList<String> o) {
            if (o != null) {
                this.data.addAll(o);
            }
            return true;
        }

        public String terminate() {
            Collections.sort(this.data);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.data.size(); ++i) {
                sb.append(this.data.get(i));
            }
            return sb.toString();
        }
    }
}

